/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.matcher;

import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.matcher.AmbiguousElementMatcherException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DomMatchers {
    private DomMatchers() {
    }

    public static Matcher<Document> containingTextInBody(String string) {
        Preconditions.checkNotNull(string);
        return DomMatchers.withBody(DomMatchers.withTextContent((Matcher<String>)Matchers.containsString((String)string)));
    }

    public static Matcher<Document> withBody(Matcher<Element> matcher) {
        return new WithBodyMatcher(matcher);
    }

    public static Matcher<Document> hasElementWithId(String string) {
        return new HasElementWithIdMatcher(string);
    }

    public static Matcher<Document> elementById(String string, Matcher<Element> matcher) {
        return new ElementByIdMatcher(string, matcher);
    }

    public static Matcher<Document> hasElementWithXpath(String string) {
        return new HasElementWithXPathMatcher(string);
    }

    public static Matcher<Document> elementByXPath(String string, Matcher<Element> matcher) {
        return new ElementByXPathMatcher(string, matcher);
    }

    private static NodeList extractNodeListForXPath(String string, Document document) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            return (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static Matcher<Element> withTextContent(String string) {
        return DomMatchers.withTextContent((Matcher<String>)Matchers.is((Object)string));
    }

    public static Matcher<Element> withTextContent(Matcher<String> matcher) {
        return new WithTextContentMatcher(matcher);
    }

    static final class WithTextContentMatcher
    extends TypeSafeMatcher<Element> {
        @RemoteMsgField(order=0)
        private final Matcher<String> textContentMatcher;

        @RemoteMsgConstructor
        WithTextContentMatcher(Matcher<String> matcher) {
            this.textContentMatcher = Preconditions.checkNotNull(matcher, "textContentMatcher cannot be null");
        }

        protected boolean matchesSafely(Element element) {
            return this.textContentMatcher.matches((Object)element.getTextContent());
        }

        public void describeTo(Description description) {
            description.appendText("with text content: ");
            this.textContentMatcher.describeTo(description);
        }
    }

    static final class ElementByXPathMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String xpath;
        @RemoteMsgField(order=1)
        private final Matcher<Element> elementMatcher;

        @RemoteMsgConstructor
        ElementByXPathMatcher(String string, Matcher<Element> matcher) {
            this.xpath = Preconditions.checkNotNull(string);
            this.elementMatcher = Preconditions.checkNotNull(matcher);
        }

        public void describeTo(Description description) {
            description.appendText(String.format("element with xpath '%s' matches: ", this.xpath));
            this.elementMatcher.describeTo(description);
        }

        public boolean matchesSafely(Document document) {
            NodeList nodeList = DomMatchers.extractNodeListForXPath(this.xpath, document);
            if (nodeList == null || nodeList.getLength() == 0) {
                return false;
            }
            if (nodeList.getLength() > 1) {
                throw new AmbiguousElementMatcherException(this.xpath);
            }
            if (nodeList.item(0).getNodeType() != 1) {
                return false;
            }
            Element element = (Element)nodeList.item(0);
            return this.elementMatcher.matches((Object)element);
        }
    }

    static final class HasElementWithXPathMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String xpath;

        @RemoteMsgConstructor
        HasElementWithXPathMatcher(String string) {
            this.xpath = Preconditions.checkNotNull(string);
        }

        public void describeTo(Description description) {
            String string = String.valueOf(this.xpath);
            description.appendText(string.length() != 0 ? "has element with xpath: ".concat(string) : new String("has element with xpath: "));
        }

        public boolean matchesSafely(Document document) {
            NodeList nodeList = DomMatchers.extractNodeListForXPath(this.xpath, document);
            return nodeList != null && nodeList.getLength() != 0;
        }
    }

    static final class ElementByIdMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String elementId;
        @RemoteMsgField(order=1)
        private final Matcher<Element> elementMatcher;

        @RemoteMsgConstructor
        ElementByIdMatcher(String string, Matcher<Element> matcher) {
            this.elementId = Preconditions.checkNotNull(string);
            this.elementMatcher = Preconditions.checkNotNull(matcher);
        }

        public void describeTo(Description description) {
            description.appendText(String.format("element with id '%s' matches: ", this.elementId));
            this.elementMatcher.describeTo(description);
        }

        public boolean matchesSafely(Document document) {
            return this.elementMatcher.matches((Object)document.getElementById(this.elementId));
        }
    }

    static final class HasElementWithIdMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String elementId;

        @RemoteMsgConstructor
        HasElementWithIdMatcher(String string) {
            this.elementId = Preconditions.checkNotNull(string);
        }

        public void describeTo(Description description) {
            String string = String.valueOf(this.elementId);
            description.appendText(string.length() != 0 ? "has element with id: ".concat(string) : new String("has element with id: "));
        }

        public boolean matchesSafely(Document document) {
            return document.getElementById(this.elementId) != null;
        }
    }

    static final class WithBodyMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final Matcher<Element> bodyMatcher;

        @RemoteMsgConstructor
        WithBodyMatcher(Matcher<Element> matcher) {
            this.bodyMatcher = Preconditions.checkNotNull(matcher, "bodyMatcher cannot be null");
        }

        public void describeTo(Description description) {
            description.appendText("with body: ");
            this.bodyMatcher.describeTo(description);
        }

        public boolean matchesSafely(Document document) {
            NodeList nodeList = document.getElementsByTagName("body");
            if (nodeList.getLength() == 0) {
                return false;
            }
            return this.bodyMatcher.matches((Object)nodeList.item(0));
        }
    }
}

