/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.SimpleAtom;
import androidx.test.espresso.web.model.TransformingAtom;
import java.util.List;

public final class Atoms {
    private Atoms() {
    }

    public static <I, O> Atom<O> transform(Atom<I> atom, TransformingAtom.Transformer<I, O> transformer) {
        return new TransformingAtom<I, O>(atom, transformer);
    }

    public static <O> Atom<O> script(String string, TransformingAtom.Transformer<Evaluation, O> transformer) {
        return Atoms.transform(Atoms.script(string), transformer);
    }

    public static <E> TransformingAtom.Transformer<Evaluation, E> castOrDie(Class<E> clazz) {
        return new CastOrDieAtom(Preconditions.checkNotNull(clazz));
    }

    public static Atom<Evaluation> script(String string) {
        return new ScriptWithArgsSimpleAtom(string, Lists.newArrayList());
    }

    public static Atom<String> getCurrentUrl() {
        return Atoms.script("return document.location.href;", Atoms.castOrDie(String.class));
    }

    public static Atom<String> getTitle() {
        return Atoms.script("return document.title;", Atoms.castOrDie(String.class));
    }

    public static Atom<Evaluation> scriptWithArgs(String string, List<Object> list) {
        return new ScriptWithArgsSimpleAtom(string, list);
    }

    static final class ScriptWithArgsSimpleAtom
    extends SimpleAtom {
        private final String script;
        private final List<Object> args;

        public ScriptWithArgsSimpleAtom(String string, List<Object> list) {
            super(string);
            this.script = Preconditions.checkNotNull(string);
            this.args = Preconditions.checkNotNull(list);
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return this.args;
        }
    }

    static final class CastOrDieAtom<E>
    implements TransformingAtom.Transformer<Evaluation, E> {
        @RemoteMsgField(order=0)
        private final Class<E> clazz;

        @RemoteMsgConstructor
        private CastOrDieAtom(Class<E> clazz) {
            this.clazz = clazz;
        }

        @Override
        public E apply(Evaluation evaluation) {
            if (null == evaluation.getValue()) {
                throw new RuntimeException("Atom evaluation returned null!");
            }
            if (this.clazz.isInstance(evaluation.getValue())) {
                return this.clazz.cast(evaluation.getValue());
            }
            throw new RuntimeException(String.format("%s: is not compatible with Evaluation: %s", this.clazz.getName(), evaluation.getValue().getClass().getName()));
        }
    }
}

