/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.test.espresso.web.internal.deps.guava.base.Objects;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.JSONAble;
import androidx.test.espresso.web.model.ModelCodec;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public final class Evaluation
implements Parcelable,
JSONAble {
    private static final String STATUS_KEY = "status";
    private static final String MESSAGE_KEY = "message";
    private static final String VALUE_KEY = "value";
    private int status;
    private boolean hasMessage;
    private String message;
    private Object value;
    static final JSONAble.DeJSONFactory DEJSONIZER = new JSONAble.DeJSONFactory(){

        @Override
        public Object attemptDeJSONize(Map<String, Object> map) {
            Object object;
            Object object2;
            if (map.size() == 2 && (object2 = map.get(Evaluation.STATUS_KEY)) instanceof Integer && null != (object = map.get(Evaluation.VALUE_KEY))) {
                Map map2;
                Builder builder = new Builder().setStatus((Integer)object2).setValue(object == JSONObject.NULL ? null : object);
                if (object instanceof Map && (map2 = (Map)object).size() == 1) {
                    Object v = map2.get(Evaluation.MESSAGE_KEY);
                    if (v instanceof String) {
                        builder.setMessage((String)v);
                    } else if (v == JSONObject.NULL) {
                        builder.setMessage(null);
                    }
                }
                return builder.build();
            }
            return null;
        }
    };
    public static final Parcelable.Creator<Evaluation> CREATOR = new Parcelable.Creator<Evaluation>(){

        public Evaluation createFromParcel(Parcel parcel) {
            return new Evaluation(parcel);
        }

        public Evaluation[] newArray(int n) {
            return new Evaluation[n];
        }
    };

    private Evaluation(Builder builder) {
        this.status = builder.status;
        this.value = builder.value;
        this.hasMessage = builder.hasMessage;
        this.message = builder.message;
    }

    protected Evaluation(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public int hashCode() {
        return Objects.hashCode(this.status, this.value, this.hasMessage, this.message);
    }

    public boolean equals(Object object) {
        if (object instanceof Evaluation) {
            Evaluation evaluation = (Evaluation)object;
            if (evaluation.status == this.status && this.hasMessage == evaluation.hasMessage) {
                if (this.hasMessage) {
                    return this.message.equals(evaluation.message);
                }
                if (this.value == null) {
                    return evaluation.value == null;
                }
                return this.value.equals(evaluation.value);
            }
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasMessage() {
        return this.hasMessage;
    }

    public String getMessage() {
        Preconditions.checkState(this.hasMessage);
        return this.message;
    }

    @Override
    public String toJSONString() {
        try {
            JSONStringer jSONStringer = new JSONStringer().object().key(STATUS_KEY).value((long)this.status).key(VALUE_KEY);
            if (this.value instanceof String || this.value instanceof Number || this.value instanceof Boolean || this.value == null) {
                jSONStringer.value(this.value);
            } else {
                String string = ModelCodec.encode(this.value);
                jSONStringer.value(new JSONTokener(string).nextValue());
            }
            jSONStringer.endObject();
            return jSONStringer.toString();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public String toString() {
        return String.format("Evaluation: status: %d value: %s hasMessage: %s message: %s", this.status, this.value, this.hasMessage, this.message);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(ModelCodec.encode(this));
    }

    public void readFromParcel(Parcel parcel) {
        Evaluation evaluation = ModelCodec.decodeEvaluation(parcel.readString());
        this.status = evaluation.status;
        this.hasMessage = evaluation.hasMessage;
        this.message = evaluation.message;
        this.value = evaluation.value;
    }

    static class Builder {
        private Object value;
        private int status;
        private boolean hasMessage;
        private String message;

        Builder() {
        }

        public Builder setMessage(String string) {
            this.message = string;
            this.hasMessage = true;
            return this;
        }

        public Builder setValue(Object object) {
            this.value = object;
            return this;
        }

        public Builder setStatus(int n) {
            this.status = n;
            return this;
        }

        public Evaluation build() {
            return new Evaluation(this);
        }
    }
}

