/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import android.os.Build;
import android.util.JsonReader;
import android.util.Log;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.internal.deps.guava.collect.Maps;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.JSONAble;
import androidx.test.espresso.web.model.WindowReference;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public final class ModelCodec {
    private static final String TAG = "JS_CODEC";
    private static final ImmutableSet<Class<?>> VALUEABLE_CLASSES = ImmutableSet.of(Boolean.class, Number.class, String.class, JSONObject.class, JSONArray.class);
    private static final ImmutableSet<Class<?>> TOP_LEVEL_CLASSES = ImmutableSet.of(JSONObject.class, JSONArray.class, Iterable.class, Object[].class, Map.class, JSONAble.class, new Class[0]);
    private static final CopyOnWriteArrayList<JSONAble.DeJSONFactory> DEJSONIZERS = new CopyOnWriteArrayList<JSONAble.DeJSONFactory>(Lists.newArrayList(Evaluation.DEJSONIZER, WindowReference.DEJSONIZER, ElementReference.DEJSONIZER));

    private ModelCodec() {
    }

    public static Evaluation decodeEvaluation(String string) {
        Object object = ModelCodec.decode(string);
        if (object instanceof Evaluation) {
            return (Evaluation)object;
        }
        throw new IllegalArgumentException(String.format("Document: \"%s\" did not decode to an evaluation. Instead: \"%s\"", string, object));
    }

    public static String encode(Object object) {
        Preconditions.checkNotNull(object);
        try {
            if (object instanceof JSONObject) {
                return object.toString();
            }
            if (object instanceof JSONArray) {
                return object.toString();
            }
            if (object instanceof JSONAble) {
                return new JSONObject(((JSONAble)object).toJSONString()).toString();
            }
            if (object instanceof Iterable || object instanceof Map || object instanceof Object[]) {
                JSONStringer jSONStringer = new JSONStringer();
                return ModelCodec.encodeHelper(object, jSONStringer).toString();
            }
            throw new IllegalArgumentException(String.format("%s: not a valid top level class. Want one of: %s", object.getClass(), TOP_LEVEL_CLASSES));
        }
        catch (JSONException jSONException) {
            String string = String.valueOf(object);
            throw new RuntimeException(new StringBuilder(15 + String.valueOf(string).length()).append("Encode failed: ").append(string).toString(), jSONException);
        }
    }

    public static void removeDeJSONFactory(JSONAble.DeJSONFactory deJSONFactory) {
        DEJSONIZERS.remove(deJSONFactory);
    }

    public static void addDeJSONFactory(JSONAble.DeJSONFactory deJSONFactory) {
        DEJSONIZERS.add(Preconditions.checkNotNull(deJSONFactory));
    }

    static Object decode(String string) {
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(!"".equals(string), "Empty docs not supported.");
        try {
            if (Build.VERSION.SDK_INT < 13) {
                return ModelCodec.decodeViaJSONObject(string);
            }
            return ModelCodec.decodeViaJSONReader(string);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(String.format("Could not parse: %s", string), jSONException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Could not parse: %s", string), iOException);
        }
    }

    private static Object decodeViaJSONObject(String string) throws JSONException {
        JSONTokener jSONTokener = new JSONTokener(string);
        Object object = jSONTokener.nextValue();
        if (object instanceof JSONArray) {
            return ModelCodec.decodeArray((JSONArray)object);
        }
        if (object instanceof JSONObject) {
            return ModelCodec.decodeObject((JSONObject)object);
        }
        String string2 = String.valueOf(string);
        throw new IllegalArgumentException(string2.length() != 0 ? "No top level object or array: ".concat(string2) : new String("No top level object or array: "));
    }

    private static List<Object> decodeArray(JSONArray jSONArray) throws JSONException {
        ArrayList<Object> arrayList = Lists.newArrayList();
        for (int i = 0; i < jSONArray.length(); ++i) {
            if (jSONArray.isNull(i)) {
                arrayList.add(null);
                continue;
            }
            Object object = jSONArray.get(i);
            if (object instanceof JSONObject) {
                arrayList.add(ModelCodec.decodeObject((JSONObject)object));
                continue;
            }
            if (object instanceof JSONArray) {
                arrayList.add(ModelCodec.decodeArray((JSONArray)object));
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private static Object decodeObject(JSONObject jSONObject) throws JSONException {
        Object object;
        ArrayList<Object> arrayList = Lists.newArrayList();
        HashMap<String, Object> hashMap = Maps.newHashMap();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (jSONObject.isNull((String)object)) {
                arrayList.add(object);
                hashMap.put((String)object, JSONObject.NULL);
                continue;
            }
            Object object2 = jSONObject.get((String)object);
            if (object2 instanceof JSONObject) {
                hashMap.put((String)object, ModelCodec.decodeObject((JSONObject)object2));
                continue;
            }
            if (object2 instanceof JSONArray) {
                hashMap.put((String)object, ModelCodec.decodeArray((JSONArray)object2));
                continue;
            }
            hashMap.put((String)object, object2);
        }
        object = ModelCodec.maybeReplaceMap(hashMap);
        if (object != null) {
            return object;
        }
        for (String string : arrayList) {
            hashMap.remove(string);
        }
        return hashMap;
    }

    private static Object decodeViaJSONReader(String string) throws IOException {
        JsonReader jsonReader = null;
        try {
            jsonReader = new JsonReader((Reader)new StringReader(string));
            switch (jsonReader.peek()) {
                case BEGIN_OBJECT: {
                    Object object = ModelCodec.decodeObject(jsonReader);
                    return object;
                }
                case BEGIN_ARRAY: {
                    List<Object> list = ModelCodec.decodeArray(jsonReader);
                    return list;
                }
            }
            String string2 = String.valueOf(string);
            throw new IllegalStateException(string2.length() != 0 ? "Bogus document: ".concat(string2) : new String("Bogus document: "));
        }
        finally {
            if (null != jsonReader) {
                try {
                    jsonReader.close();
                }
                catch (IOException iOException) {
                    Log.i((String)TAG, (String)"json reader - close exception", (Throwable)iOException);
                }
            }
        }
    }

    private static List<Object> decodeArray(JsonReader jsonReader) throws IOException {
        ArrayList<Object> arrayList = Lists.newArrayList();
        jsonReader.beginArray();
        block8: while (jsonReader.hasNext()) {
            switch (jsonReader.peek()) {
                case BEGIN_OBJECT: {
                    arrayList.add(ModelCodec.decodeObject(jsonReader));
                    continue block8;
                }
                case NULL: {
                    jsonReader.nextNull();
                    arrayList.add(null);
                    continue block8;
                }
                case STRING: {
                    arrayList.add(jsonReader.nextString());
                    continue block8;
                }
                case BOOLEAN: {
                    arrayList.add(jsonReader.nextBoolean());
                    continue block8;
                }
                case BEGIN_ARRAY: {
                    arrayList.add(ModelCodec.decodeArray(jsonReader));
                    continue block8;
                }
                case NUMBER: {
                    arrayList.add(ModelCodec.decodeNumber(jsonReader.nextString()));
                    continue block8;
                }
            }
            throw new IllegalStateException(String.format("%s: bogus token", jsonReader.peek()));
        }
        jsonReader.endArray();
        return arrayList;
    }

    private static Number decodeNumber(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return new BigInteger(string);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        return new BigDecimal(string);
                    }
                }
            }
        }
    }

    private static Object decodeObject(JsonReader jsonReader) throws IOException {
        Object object;
        HashMap<String, Object> hashMap = Maps.newHashMap();
        ArrayList<Object> arrayList = Lists.newArrayList();
        jsonReader.beginObject();
        block8: while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            Iterator iterator = null;
            switch (jsonReader.peek()) {
                case BEGIN_OBJECT: {
                    hashMap.put((String)object, ModelCodec.decodeObject(jsonReader));
                    continue block8;
                }
                case NULL: {
                    jsonReader.nextNull();
                    arrayList.add(object);
                    hashMap.put((String)object, JSONObject.NULL);
                    continue block8;
                }
                case STRING: {
                    hashMap.put((String)object, jsonReader.nextString());
                    continue block8;
                }
                case BOOLEAN: {
                    hashMap.put((String)object, jsonReader.nextBoolean());
                    continue block8;
                }
                case NUMBER: {
                    hashMap.put((String)object, ModelCodec.decodeNumber(jsonReader.nextString()));
                    continue block8;
                }
                case BEGIN_ARRAY: {
                    hashMap.put((String)object, ModelCodec.decodeArray(jsonReader));
                    continue block8;
                }
            }
            throw new IllegalStateException(String.format("%s: bogus token.", jsonReader.peek()));
        }
        jsonReader.endObject();
        object = ModelCodec.maybeReplaceMap(hashMap);
        if (null != object) {
            return object;
        }
        for (String string : arrayList) {
            hashMap.remove(string);
        }
        return hashMap;
    }

    private static Object maybeReplaceMap(Map<String, Object> map) {
        for (JSONAble.DeJSONFactory deJSONFactory : DEJSONIZERS) {
            Object object = deJSONFactory.attemptDeJSONize(map);
            if (null == object) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static JSONStringer encodeHelper(Object object, JSONStringer jSONStringer) throws JSONException {
        if (null == object) {
            jSONStringer.value(object);
        } else if (object instanceof Map) {
            jSONStringer.object();
            Set set = ((Map)object).entrySet();
            for (Map.Entry entry : set) {
                jSONStringer.key(entry.getKey().toString());
                ModelCodec.encodeHelper(entry.getValue(), jSONStringer);
            }
            jSONStringer.endObject();
        } else if (object instanceof Iterable) {
            jSONStringer.array();
            for (Object t : (Iterable)object) {
                ModelCodec.encodeHelper(t, jSONStringer);
            }
            jSONStringer.endArray();
        } else if (object instanceof Object[]) {
            void clazz;
            jSONStringer.array();
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            boolean bl = false;
            while (clazz < n) {
                Object object2 = objectArray[clazz];
                ModelCodec.encodeHelper(object2, jSONStringer);
                ++clazz;
            }
            jSONStringer.endArray();
        } else if (object instanceof JSONAble) {
            JSONObject jSONObject = new JSONObject(((JSONAble)object).toJSONString());
            jSONStringer.value((Object)jSONObject);
        } else {
            boolean bl = false;
            for (Class clazz : VALUEABLE_CLASSES) {
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                bl = true;
                jSONStringer.value(object);
            }
            Preconditions.checkState(bl, "%s: not encodable. Want one of: %s", object.getClass(), VALUEABLE_CLASSES);
        }
        return jSONStringer;
    }
}

