/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleAtom
implements Atom<Evaluation> {
    private final String script;
    private final ElementReferencePlacement elementPlacement;

    public SimpleAtom(String string) {
        this(string, ElementReferencePlacement.FIRST);
    }

    public SimpleAtom(String string, ElementReferencePlacement elementReferencePlacement) {
        this.script = Preconditions.checkNotNull(string);
        this.elementPlacement = Preconditions.checkNotNull(elementReferencePlacement);
    }

    @Override
    public final String getScript() {
        return this.script;
    }

    @Override
    public final Evaluation transform(Evaluation evaluation) {
        if (evaluation.getStatus() != 0) {
            String string = String.valueOf(evaluation);
            return Preconditions.checkNotNull(this.handleBadEvaluation(evaluation), new StringBuilder(42 + String.valueOf(string).length()).append("Evaluation bad and handler returned null! ").append(string).toString());
        }
        return evaluation;
    }

    @Override
    public final List<Object> getArguments(ElementReference elementReference) {
        List<Object> list = Preconditions.checkNotNull(this.getNonContextualArguments());
        if (null == elementReference) {
            this.handleNoElementReference();
        }
        if (list.size() == 0 && null == elementReference) {
            return Collections.EMPTY_LIST;
        }
        if (null == elementReference) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + 1);
        if (this.elementPlacement == ElementReferencePlacement.FIRST) {
            arrayList.add(elementReference);
            arrayList.addAll(list);
        } else {
            arrayList.addAll(list);
            arrayList.add(elementReference);
        }
        return arrayList;
    }

    protected void handleNoElementReference() {
    }

    protected List<Object> getNonContextualArguments() {
        return Collections.EMPTY_LIST;
    }

    protected Evaluation handleBadEvaluation(Evaluation evaluation) {
        String string = String.valueOf(evaluation);
        throw new RuntimeException(new StringBuilder(19 + String.valueOf(string).length()).append("Error in evaluation").append(string).toString());
    }

    public static enum ElementReferencePlacement {
        FIRST,
        LAST;

    }
}

