/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.sugar;

import android.view.View;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.action.AtomAction;
import androidx.test.espresso.web.action.EnableJavascriptAction;
import androidx.test.espresso.web.assertion.WebAssertion;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.internal.runner.tracker.UsageTrackerRegistry;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class Web {
    public static WebInteraction<Void> onWebView() {
        return Web.onWebView((Matcher<View>)ViewMatchers.isJavascriptEnabled());
    }

    public static WebInteraction<Void> onWebView(Matcher<View> matcher) {
        return new WebInteraction<Void>(matcher);
    }

    static {
        UsageTrackerRegistry.getInstance().trackUsage("Espresso-Web", "3.1.0-alpha3");
    }

    public static class WebInteraction<R> {
        private final Matcher<View> viewMatcher;
        private final boolean brandNew;
        private final R result;
        private final WindowReference window;
        private final ElementReference element;
        private final Timeout timeout;

        private WebInteraction(Matcher<View> matcher) {
            this(matcher, null, null, null, true, new Timeout(10L, TimeUnit.SECONDS, true));
        }

        private WebInteraction(Matcher<View> matcher, R r, WindowReference windowReference, ElementReference elementReference, boolean bl, Timeout timeout) {
            this.viewMatcher = Preconditions.checkNotNull(matcher);
            this.result = r;
            this.window = windowReference;
            this.element = elementReference;
            this.brandNew = bl;
            this.timeout = timeout;
        }

        public WebInteraction<R> reset() {
            return new WebInteraction<R>(this.viewMatcher, this.result, null, null, this.brandNew, this.timeout);
        }

        public WebInteraction<R> forceJavascriptEnabled() {
            Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new EnableJavascriptAction()});
            return this;
        }

        public WebInteraction<R> withNoTimeout() {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.element, this.brandNew, Timeout.NONE);
        }

        public WebInteraction<R> withTimeout(long l, TimeUnit timeUnit) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.element, this.brandNew, new Timeout(l, timeUnit, true));
        }

        public WebInteraction<R> inWindow(WindowReference windowReference) {
            return new WebInteraction<R>(this.viewMatcher, this.result, windowReference, this.element, this.brandNew, this.timeout);
        }

        public WebInteraction<R> inWindow(Atom<WindowReference> atom) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.doEval(atom, null, null), this.element, this.brandNew, this.timeout);
        }

        public WebInteraction<R> withElement(ElementReference elementReference) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, elementReference, this.brandNew, this.timeout);
        }

        public WebInteraction<R> withElement(Atom<ElementReference> atom) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.doEval(atom, this.window, null), this.brandNew, this.timeout);
        }

        public WebInteraction<R> withContextualElement(Atom<ElementReference> atom) {
            return new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.doEval(atom, this.window, this.element), this.brandNew, this.timeout);
        }

        public <E> WebInteraction<E> perform(Atom<E> atom) {
            E e = this.doEval(atom, this.window, this.element);
            return new WebInteraction<E>(this.viewMatcher, e, this.window, this.element, false, this.timeout);
        }

        public <E> WebInteraction<E> check(WebAssertion<E> webAssertion) {
            E e = this.doEval(webAssertion.getAtom(), this.window, this.element);
            Espresso.onView(this.viewMatcher).check(webAssertion.toViewAssertion(e));
            return new WebInteraction<E>(this.viewMatcher, e, this.window, this.element, false, this.timeout);
        }

        private <E> E doEval(Atom<E> atom, WindowReference windowReference, ElementReference elementReference) {
            Preconditions.checkNotNull(atom, "Need an atom!");
            AtomAction<E> atomAction = new AtomAction<E>(atom, windowReference, elementReference);
            Espresso.onView(this.viewMatcher).perform(new ViewAction[]{atomAction});
            try {
                if (this.timeout == Timeout.NONE) {
                    return atomAction.get();
                }
                return atomAction.get(this.timeout.timeout, this.timeout.unit);
            }
            catch (ExecutionException executionException) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(executionException.getCause())});
                return null;
            }
            catch (InterruptedException interruptedException) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(interruptedException)});
                return null;
            }
            catch (TimeoutException timeoutException) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(timeoutException)});
                return null;
            }
            catch (RuntimeException runtimeException) {
                Espresso.onView(this.viewMatcher).perform(new ViewAction[]{new ExceptionPropagator(runtimeException)});
                return null;
            }
        }

        public R get() {
            Preconditions.checkState(!this.brandNew, "Perform or Check never called on this WebInteraction!");
            return this.result;
        }

        static class ExceptionPropagator
        implements ViewAction {
            @RemoteMsgField(order=0)
            private final RuntimeException error;

            @RemoteMsgConstructor
            public ExceptionPropagator(RuntimeException runtimeException) {
                this.error = Preconditions.checkNotNull(runtimeException);
            }

            public ExceptionPropagator(Throwable throwable) {
                this(new RuntimeException(throwable));
            }

            public String getDescription() {
                String string = String.valueOf(this.error);
                return new StringBuilder(11 + String.valueOf(string).length()).append("Propagate: ").append(string).toString();
            }

            public void perform(UiController uiController, View view) {
                throw this.error;
            }

            public Matcher<View> getConstraints() {
                return Matchers.any(View.class);
            }
        }
    }

    private static class Timeout {
        private final long timeout;
        private final TimeUnit unit;
        static final Timeout NONE = new Timeout(-1L, TimeUnit.MILLISECONDS, false);

        private Timeout(long l, TimeUnit timeUnit, boolean bl) {
            this.timeout = l;
            this.unit = timeUnit;
            if (bl) {
                Preconditions.checkArgument(l > 0L);
                Preconditions.checkNotNull(timeUnit);
            }
        }
    }
}

