/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.webdriver;

import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.internal.deps.guava.collect.Maps;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Atoms;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.SimpleAtom;
import androidx.test.espresso.web.model.TransformingAtom;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.espresso.web.webdriver.Locator;
import androidx.test.espresso.web.webdriver.WebDriverAtomScriptsLsc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DriverAtoms {
    private DriverAtoms() {
    }

    public static Atom<Evaluation> webClick() {
        return new WebClickSimpleAtom();
    }

    public static Atom<Evaluation> clearElement() {
        return new ClearElementSimpleAtom();
    }

    public static Atom<Evaluation> webKeys(String string) {
        return new WebKeysSimpleAtom(Preconditions.checkNotNull(string));
    }

    public static Atom<ElementReference> findElement(Locator locator, String string) {
        return new FindElementTransformingAtom(new FindElementSimpleAtom(locator.getType(), string), Atoms.castOrDie(ElementReference.class));
    }

    public static Atom<ElementReference> selectActiveElement() {
        return new SelectActiveElementTransformingAtom(new ActiveElementSimpleAtom(), Atoms.castOrDie(ElementReference.class));
    }

    public static Atom<WindowReference> selectFrameByIndex(int n) {
        return new SelectFrameByIndexTransformingAtom(new FrameByIndexSimpleAtom(n), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<WindowReference> selectFrameByIndex(int n, WindowReference windowReference) {
        return new SelectFrameByIndexTransformingAtom(new FrameByIndexWithRootSimpleAtom(n, Preconditions.checkNotNull(windowReference)), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<WindowReference> selectFrameByIdOrName(String string, WindowReference windowReference) {
        return new SelectFrameByIdOrNameTransformingAtom(new FrameByIdOrNameWithRootSimpleAtom(Preconditions.checkNotNull(string), Preconditions.checkNotNull(windowReference)), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<WindowReference> selectFrameByIdOrName(String string) {
        return new SelectFrameByIdOrNameTransformingAtom(new FrameByIdOrNameSimpleAtom(Preconditions.checkNotNull(string)), Atoms.castOrDie(WindowReference.class));
    }

    public static Atom<String> getText() {
        return new GetTextTransformingAtom(new GetVisibleTextSimpleAtom(), Atoms.castOrDie(String.class));
    }

    public static Atom<Boolean> webScrollIntoView() {
        return new WebScrollIntoViewAtom(new WebScrollIntoViewSimpleAtom(), Atoms.castOrDie(Boolean.class));
    }

    public static Atom<List<ElementReference>> findMultipleElements(Locator locator, String string) {
        FindElementsScriptSimpleAtom findElementsScriptSimpleAtom = new FindElementsScriptSimpleAtom(locator.getType(), string);
        ElementReferenceListAtom elementReferenceListAtom = new ElementReferenceListAtom(locator.getType(), string);
        return new FindMultipleElementsTransformingAtom(findElementsScriptSimpleAtom, elementReferenceListAtom);
    }

    private static Map<String, String> makeLocatorJSON(Locator locator, String string) {
        Preconditions.checkNotNull(locator);
        Preconditions.checkNotNull(string);
        HashMap<String, String> hashMap = Maps.newHashMap();
        hashMap.put(locator.getType(), string);
        return hashMap;
    }

    static final class ElementReferenceListAtom
    implements TransformingAtom.Transformer<Evaluation, List<ElementReference>> {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @RemoteMsgConstructor
        private ElementReferenceListAtom(String string, String string2) {
            this.locatorType = string;
            this.value = string2;
        }

        @Override
        public List<ElementReference> apply(Evaluation evaluation) {
            Object object = evaluation.getValue();
            if (null == object) {
                return Lists.newArrayList();
            }
            if (object instanceof Iterable) {
                ArrayList<ElementReference> arrayList = Lists.newArrayList();
                for (Object t : (Iterable)object) {
                    if (t instanceof ElementReference) {
                        arrayList.add((ElementReference)t);
                        continue;
                    }
                    throw new RuntimeException(String.format("Unexpected non-elementReference in findMultipleElements(%s, %s): (%s) all: %s ", Locator.forType(this.locatorType).name(), this.value, t, evaluation));
                }
                return arrayList;
            }
            throw new RuntimeException(String.format("Unexpected non-iterableType in findMultipleElements(%s, %s): return evaluation: %s ", Locator.forType(this.locatorType).name(), this.value, evaluation));
        }
    }

    static final class FindMultipleElementsTransformingAtom
    extends TransformingAtom<Evaluation, List<ElementReference>> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> findElementsScriptSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, List<ElementReference>> elementReferenceListAtom;

        @RemoteMsgConstructor
        private FindMultipleElementsTransformingAtom(Atom<Evaluation> atom, TransformingAtom.Transformer<Evaluation, List<ElementReference>> transformer) {
            super(atom, transformer);
            this.findElementsScriptSimpleAtom = atom;
            this.elementReferenceListAtom = transformer;
        }
    }

    static final class FindElementsScriptSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @RemoteMsgConstructor
        private FindElementsScriptSimpleAtom(String string, String string2) {
            super(WebDriverAtomScriptsLsc.FIND_ELEMENTS_ANDROID);
            this.locatorType = string;
            this.value = string2;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Lists.newArrayList(DriverAtoms.makeLocatorJSON(Locator.forType(this.locatorType), this.value));
        }
    }

    static final class SelectFrameByIdOrNameTransformingAtom
    extends TransformingAtom<Evaluation, WindowReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> frameByIndexOrNameSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom;

        @RemoteMsgConstructor
        private SelectFrameByIdOrNameTransformingAtom(Atom<Evaluation> atom, TransformingAtom.Transformer<Evaluation, WindowReference> transformer) {
            super(atom, transformer);
            this.frameByIndexOrNameSimpleAtom = atom;
            this.castOrDieAtom = transformer;
        }
    }

    static final class FrameByIdOrNameWithRootSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String idOrName;
        @RemoteMsgField(order=1)
        private final WindowReference root;

        @RemoteMsgConstructor
        private FrameByIdOrNameWithRootSimpleAtom(String string, WindowReference windowReference) {
            super(WebDriverAtomScriptsLsc.FRAME_BY_ID_OR_NAME_ANDROID);
            this.idOrName = string;
            this.root = windowReference;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            ArrayList<Object> arrayList = Lists.newArrayList(this.idOrName);
            arrayList.add(this.root);
            return arrayList;
        }
    }

    static final class FrameByIdOrNameSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String idOrName;

        @RemoteMsgConstructor
        private FrameByIdOrNameSimpleAtom(String string) {
            super(WebDriverAtomScriptsLsc.FRAME_BY_ID_OR_NAME_ANDROID);
            this.idOrName = string;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Lists.newArrayList(this.idOrName);
        }
    }

    static final class SelectFrameByIndexTransformingAtom
    extends TransformingAtom<Evaluation, WindowReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> frameByIndexSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom;

        @RemoteMsgConstructor
        private SelectFrameByIndexTransformingAtom(Atom<Evaluation> atom, TransformingAtom.Transformer<Evaluation, WindowReference> transformer) {
            super(atom, transformer);
            this.frameByIndexSimpleAtom = atom;
            this.castOrDieAtom = transformer;
        }
    }

    static final class FrameByIndexWithRootSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final int index;
        @RemoteMsgField(order=1)
        private final WindowReference root;

        @RemoteMsgConstructor
        private FrameByIndexWithRootSimpleAtom(int n, WindowReference windowReference) {
            super("function(){return(function(){function h(a){return function(){return this[a]}}function k(a){return function(){return a}}var l=this;function m(a){return\"string\"==typeof a}function aa(a,b){a=a.split(\".\");var c=l;a[0]in c||\"undefined\"==typeof c.execScript||c.execScript(\"var \"+a[0]);for(var d;a.length&&(d=a.shift());)a.length||void 0===b?c[d]&&c[d]!==Object.prototype[d]?c=c[d]:c=c[d]={}:c[d]=b}\nfunction ba(a){var b=typeof a;if(\"object\"==b)if(a){if(a instanceof Array)return\"array\";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(\"[object Window]\"==c)return\"object\";if(\"[object Array]\"==c||\"number\"==typeof a.length&&\"undefined\"!=typeof a.splice&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"splice\"))return\"array\";if(\"[object Function]\"==c||\"undefined\"!=typeof a.call&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"call\"))return\"function\"}else return\"null\";\nelse if(\"function\"==b&&\"undefined\"==typeof a.call)return\"object\";return b}function ca(a,b,c){return a.call.apply(a.bind,arguments)}function da(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}\nfunction p(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf(\"native code\")?p=ca:p=da;return p.apply(null,arguments)}function ea(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}}\nfunction q(a,b){function c(){}c.prototype=b.prototype;a.K=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.J=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};function r(a){if(Error.captureStackTrace)Error.captureStackTrace(this,r);else{var b=Error().stack;b&&(this.stack=b)}a&&(this.message=String(a))}q(r,Error);r.prototype.name=\"CustomError\";function fa(a,b){a=a.split(\"%s\");for(var c=\"\",d=a.length-1,e=0;e<d;e++)c+=a[e]+(e<b.length?b[e]:\"%s\");r.call(this,c+a[d])}q(fa,r);fa.prototype.name=\"AssertionError\";function ha(a,b,c){if(!a){var d=\"Assertion failed\";if(b){d+=\": \"+b;var e=Array.prototype.slice.call(arguments,2)}throw new fa(\"\"+d,e||[]);}};function t(a,b){for(var c=a.length,d=m(a)?a.split(\"\"):a,e=0;e<c;e++)e in d&&b.call(void 0,d[e],e,a)}function u(a,b,c){var d=c;t(a,function(c,f){d=b.call(void 0,d,c,f,a)});return d}function w(a,b){for(var c=a.length,d=m(a)?a.split(\"\"):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a))return!0;return!1}function ia(a){return Array.prototype.concat.apply([],arguments)}function ja(a,b,c){ha(null!=a.length);return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};var ka=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(a)[1]};function la(a,b){return a<b?-1:a>b?1:0};var x;a:{var ma=l.navigator;if(ma){var na=ma.userAgent;if(na){x=na;break a}}x=\"\"};function oa(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if(\"undefined\"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}\nfunction pa(a,b){if(a==b)return 0;if(a.compareDocumentPosition)return a.compareDocumentPosition(b)&2?1:-1;if(\"sourceIndex\"in a||a.parentNode&&\"sourceIndex\"in a.parentNode){var c=1==a.nodeType,d=1==b.nodeType;if(c&&d)return a.sourceIndex-b.sourceIndex;var e=a.parentNode,f=b.parentNode;return e==f?qa(a,b):!c&&oa(e,b)?-1*ra(a,b):!d&&oa(f,a)?ra(b,a):(c?a.sourceIndex:e.sourceIndex)-(d?b.sourceIndex:f.sourceIndex)}ha(a,\"Node cannot be null or undefined.\");d=9==a.nodeType?a:a.ownerDocument||a.document;c=\nd.createRange();c.selectNode(a);c.collapse(!0);a=d.createRange();a.selectNode(b);a.collapse(!0);return c.compareBoundaryPoints(l.Range.START_TO_END,a)}function ra(a,b){var c=a.parentNode;if(c==b)return-1;for(;b.parentNode!=c;)b=b.parentNode;return qa(b,a)}function qa(a,b){for(;b=b.previousSibling;)if(b==a)return-1;return 1};/*xxx_rpl_lic*/\nvar sa=window;function ta(a){return(a=a.exec(x))?a[1]:\"\"}ta(/Android\\s+([0-9.]+)/)||ta(/Version\\/([0-9.]+)/);function ua(a){var b=0,c=ka(String(va)).split(\".\");a=ka(String(a)).split(\".\");for(var d=Math.max(c.length,a.length),e=0;0==b&&e<d;e++){var f=c[e]||\"\",g=a[e]||\"\";do{f=/(\\d*)(\\D*)(.*)/.exec(f)||[\"\",\"\",\"\",\"\"];g=/(\\d*)(\\D*)(.*)/.exec(g)||[\"\",\"\",\"\",\"\"];if(0==f[0].length&&0==g[0].length)break;b=la(0==f[1].length?0:parseInt(f[1],10),0==g[1].length?0:parseInt(g[1],10))||la(0==f[2].length,0==g[2].length)||la(f[2],g[2]);f=f[3];g=g[3]}while(0==b)}}var wa=/Android\\s+([0-9\\.]+)/.exec(x),va=wa?wa[1]:\"0\";ua(2.3);\nua(4);/*\n\n The MIT License\n\n Copyright (c) 2007 Cybozu Labs, Inc.\n Copyright (c) 2012 Google Inc.\n\n Permission is hereby granted, free of charge, to any person obtaining a copy\n of this software and associated documentation files (the \"Software\"), to\n deal in the Software without restriction, including without limitation the\n rights to use, copy, modify, merge, publish, distribute, sublicense, and/or\n sell copies of the Software, and to permit persons to whom the Software is\n furnished to do so, subject to the following conditions:\n\n The above copyright notice and this permission notice shall be included in\n all copies or substantial portions of the Software.\n\n THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS\n IN THE SOFTWARE.\n*/\nfunction y(a,b,c){this.a=a;this.b=b||1;this.f=c||1};function xa(a){this.b=a;this.a=0}function ya(a){a=a.match(za);for(var b=0;b<a.length;b++)Aa.test(a[b])&&a.splice(b,1);return new xa(a)}var za=/\\$?(?:(?![0-9-])[\\w-]+:)?(?![0-9-])[\\w-]+|\\/\\/|\\.\\.|::|\\d+(?:\\.\\d*)?|\\.\\d+|\"[^\"]*\"|'[^']*'|[!<>]=|\\s+|./g,Aa=/^\\s/;function z(a,b){return a.b[a.a+(b||0)]}function B(a){return a.b[a.a++]}function C(a){return a.b.length<=a.a};function D(a){var b=null,c=a.nodeType;1==c&&(b=a.textContent,b=void 0==b||null==b?a.innerText:b,b=void 0==b||null==b?\"\":b);if(\"string\"!=typeof b)if(9==c||1==c){a=9==c?a.documentElement:a.firstChild;c=0;var d=[];for(b=\"\";a;){do 1!=a.nodeType&&(b+=a.nodeValue),d[c++]=a;while(a=a.firstChild);for(;c&&!(a=d[--c].nextSibling););}}else b=a.nodeValue;return\"\"+b}\nfunction E(a,b,c){if(null===b)return!0;try{if(!a.getAttribute)return!1}catch(d){return!1}return null==c?!!a.getAttribute(b):a.getAttribute(b,2)==c}function F(a,b,c,d,e){return Ba.call(null,a,b,m(c)?c:null,m(d)?d:null,e||new G)}\nfunction Ba(a,b,c,d,e){b.getElementsByName&&d&&\"name\"==c?(b=b.getElementsByName(d),t(b,function(b){a.a(b)&&e.add(b)})):b.getElementsByClassName&&d&&\"class\"==c?(b=b.getElementsByClassName(d),t(b,function(b){b.className==d&&a.a(b)&&e.add(b)})):a instanceof H?Ca(a,b,c,d,e):b.getElementsByTagName&&(b=b.getElementsByTagName(a.f()),t(b,function(a){E(a,c,d)&&e.add(a)}));return e}function Ca(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&e.add(b),Ca(a,b,c,d,e)};function G(){this.b=this.a=null;this.l=0}function Da(a){this.f=a;this.a=this.b=null}function Ea(a,b){if(!a.a)return b;if(!b.a)return a;var c=a.a;b=b.a;for(var d=null,e,f=0;c&&b;)c.f==b.f?(e=c,c=c.a,b=b.a):0<pa(c.f,b.f)?(e=b,b=b.a):(e=c,c=c.a),(e.b=d)?d.a=e:a.a=e,d=e,f++;for(e=c||b;e;)e.b=d,d=d.a=e,f++,e=e.a;a.b=d;a.l=f;return a}function Fa(a,b){b=new Da(b);b.a=a.a;a.b?a.a.b=b:a.a=a.b=b;a.a=b;a.l++}G.prototype.add=function(a){a=new Da(a);a.b=this.b;this.a?this.b.a=a:this.a=this.b=a;this.b=a;this.l++};\nfunction Ga(a){return(a=a.a)?a.f:null}function Ha(a){return(a=Ga(a))?D(a):\"\"}function I(a,b){return new Ia(a,!!b)}function Ia(a,b){this.f=a;this.b=(this.s=b)?a.b:a.a;this.a=null}function J(a){var b=a.b;if(null==b)return null;var c=a.a=b;a.b=a.s?b.b:b.a;return c.f};function Ja(a){switch(a.nodeType){case 1:return ea(Ka,a);case 9:return Ja(a.documentElement);case 11:case 10:case 6:case 12:return La;default:return a.parentNode?Ja(a.parentNode):La}}function La(){return null}function Ka(a,b){if(a.prefix==b)return a.namespaceURI||\"http://www.w3.org/1999/xhtml\";var c=a.getAttributeNode(\"xmlns:\"+b);return c&&c.specified?c.value||null:a.parentNode&&9!=a.parentNode.nodeType?Ka(a.parentNode,b):null};function K(a){this.i=a;this.b=this.g=!1;this.f=null}function L(a){return\"\\n  \"+a.toString().split(\"\\n\").join(\"\\n  \")}function Ma(a,b){a.g=b}function Na(a,b){a.b=b}function M(a,b){a=a.a(b);return a instanceof G?+Ha(a):+a}function N(a,b){a=a.a(b);return a instanceof G?Ha(a):\"\"+a}function O(a,b){a=a.a(b);return a instanceof G?!!a.l:!!a};function Q(a,b,c){K.call(this,a.i);this.c=a;this.h=b;this.o=c;this.g=b.g||c.g;this.b=b.b||c.b;this.c==Oa&&(c.b||c.g||4==c.i||0==c.i||!b.f?b.b||b.g||4==b.i||0==b.i||!c.f||(this.f={name:c.f.name,u:b}):this.f={name:b.f.name,u:c})}q(Q,K);\nfunction R(a,b,c,d,e){b=b.a(d);c=c.a(d);var f;if(b instanceof G&&c instanceof G){b=I(b);for(d=J(b);d;d=J(b))for(e=I(c),f=J(e);f;f=J(e))if(a(D(d),D(f)))return!0;return!1}if(b instanceof G||c instanceof G){b instanceof G?(e=b,d=c):(e=c,d=b);f=I(e);for(var g=typeof d,n=J(f);n;n=J(f)){switch(g){case \"number\":n=+D(n);break;case \"boolean\":n=!!D(n);break;case \"string\":n=D(n);break;default:throw Error(\"Illegal primitive type for comparison.\");}if(e==b&&a(n,d)||e==c&&a(d,n))return!0}return!1}return e?\"boolean\"==\ntypeof b||\"boolean\"==typeof c?a(!!b,!!c):\"number\"==typeof b||\"number\"==typeof c?a(+b,+c):a(b,c):a(+b,+c)}Q.prototype.a=function(a){return this.c.m(this.h,this.o,a)};Q.prototype.toString=function(){var a=\"Binary Expression: \"+this.c;a+=L(this.h);return a+=L(this.o)};function Pa(a,b,c,d){this.H=a;this.C=b;this.i=c;this.m=d}Pa.prototype.toString=h(\"H\");var Qa={};\nfunction S(a,b,c,d){if(Qa.hasOwnProperty(a))throw Error(\"Binary operator already created: \"+a);a=new Pa(a,b,c,d);return Qa[a.toString()]=a}S(\"div\",6,1,function(a,b,c){return M(a,c)/M(b,c)});S(\"mod\",6,1,function(a,b,c){return M(a,c)%M(b,c)});S(\"*\",6,1,function(a,b,c){return M(a,c)*M(b,c)});S(\"+\",5,1,function(a,b,c){return M(a,c)+M(b,c)});S(\"-\",5,1,function(a,b,c){return M(a,c)-M(b,c)});S(\"<\",4,2,function(a,b,c){return R(function(a,b){return a<b},a,b,c)});\nS(\">\",4,2,function(a,b,c){return R(function(a,b){return a>b},a,b,c)});S(\"<=\",4,2,function(a,b,c){return R(function(a,b){return a<=b},a,b,c)});S(\">=\",4,2,function(a,b,c){return R(function(a,b){return a>=b},a,b,c)});var Oa=S(\"=\",3,2,function(a,b,c){return R(function(a,b){return a==b},a,b,c,!0)});S(\"!=\",3,2,function(a,b,c){return R(function(a,b){return a!=b},a,b,c,!0)});S(\"and\",2,2,function(a,b,c){return O(a,c)&&O(b,c)});S(\"or\",1,2,function(a,b,c){return O(a,c)||O(b,c)});function Ra(a,b){if(b.a.length&&4!=a.i)throw Error(\"Primary expression must evaluate to nodeset if filter has predicate(s).\");K.call(this,a.i);this.c=a;this.h=b;this.g=a.g;this.b=a.b}q(Ra,K);Ra.prototype.a=function(a){a=this.c.a(a);return Sa(this.h,a)};Ra.prototype.toString=function(){var a=\"Filter:\"+L(this.c);return a+=L(this.h)};function Ta(a,b){if(b.length<a.B)throw Error(\"Function \"+a.j+\" expects at least\"+a.B+\" arguments, \"+b.length+\" given\");if(null!==a.A&&b.length>a.A)throw Error(\"Function \"+a.j+\" expects at most \"+a.A+\" arguments, \"+b.length+\" given\");a.G&&t(b,function(b,d){if(4!=b.i)throw Error(\"Argument \"+d+\" to function \"+a.j+\" is not of type Nodeset: \"+b);});K.call(this,a.i);this.v=a;this.c=b;Ma(this,a.g||w(b,function(a){return a.g}));Na(this,a.F&&!b.length||a.D&&!!b.length||w(b,function(a){return a.b}))}q(Ta,K);\nTa.prototype.a=function(a){return this.v.m.apply(null,ia(a,this.c))};Ta.prototype.toString=function(){var a=\"Function: \"+this.v;if(this.c.length){var b=u(this.c,function(a,b){return a+L(b)},\"Arguments:\");a+=L(b)}return a};function Ua(a,b,c,d,e,f,g,n){this.j=a;this.i=b;this.g=c;this.F=d;this.D=!1;this.m=e;this.B=f;this.A=void 0!==g?g:f;this.G=!!n}Ua.prototype.toString=h(\"j\");var Va={};\nfunction T(a,b,c,d,e,f,g,n){if(Va.hasOwnProperty(a))throw Error(\"Function already created: \"+a+\".\");Va[a]=new Ua(a,b,c,d,e,f,g,n)}T(\"boolean\",2,!1,!1,function(a,b){return O(b,a)},1);T(\"ceiling\",1,!1,!1,function(a,b){return Math.ceil(M(b,a))},1);T(\"concat\",3,!1,!1,function(a,b){var c=ja(arguments,1);return u(c,function(b,c){return b+N(c,a)},\"\")},2,null);T(\"contains\",2,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);return-1!=b.indexOf(a)},2);T(\"count\",1,!1,!1,function(a,b){return b.a(a).l},1,1,!0);\nT(\"false\",2,!1,!1,k(!1),0);T(\"floor\",1,!1,!1,function(a,b){return Math.floor(M(b,a))},1);T(\"id\",4,!1,!1,function(a,b){var c=a.a,d=9==c.nodeType?c:c.ownerDocument;a=N(b,a).split(/\\s+/);var e=[];t(a,function(a){a=d.getElementById(a);var b;if(!(b=!a)){a:if(m(e))b=m(a)&&1==a.length?e.indexOf(a,0):-1;else{for(b=0;b<e.length;b++)if(b in e&&e[b]===a)break a;b=-1}b=0<=b}b||e.push(a)});e.sort(pa);var f=new G;t(e,function(a){f.add(a)});return f},1);T(\"lang\",2,!1,!1,k(!1),1);\nT(\"last\",1,!0,!1,function(a){if(1!=arguments.length)throw Error(\"Function last expects ()\");return a.f},0);T(\"local-name\",3,!1,!0,function(a,b){return(a=b?Ga(b.a(a)):a.a)?a.localName||a.nodeName.toLowerCase():\"\"},0,1,!0);T(\"name\",3,!1,!0,function(a,b){return(a=b?Ga(b.a(a)):a.a)?a.nodeName.toLowerCase():\"\"},0,1,!0);T(\"namespace-uri\",3,!0,!1,k(\"\"),0,1,!0);T(\"normalize-space\",3,!1,!0,function(a,b){return(b?N(b,a):D(a.a)).replace(/[\\s\\xa0]+/g,\" \").replace(/^\\s+|\\s+$/g,\"\")},0,1);\nT(\"not\",2,!1,!1,function(a,b){return!O(b,a)},1);T(\"number\",1,!1,!0,function(a,b){return b?M(b,a):+D(a.a)},0,1);T(\"position\",1,!0,!1,function(a){return a.b},0);T(\"round\",1,!1,!1,function(a,b){return Math.round(M(b,a))},1);T(\"starts-with\",2,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);return 0==b.lastIndexOf(a,0)},2);T(\"string\",3,!1,!0,function(a,b){return b?N(b,a):D(a.a)},0,1);T(\"string-length\",1,!1,!0,function(a,b){return(b?N(b,a):D(a.a)).length},0,1);\nT(\"substring\",3,!1,!1,function(a,b,c,d){c=M(c,a);if(isNaN(c)||Infinity==c||-Infinity==c)return\"\";d=d?M(d,a):Infinity;if(isNaN(d)||-Infinity===d)return\"\";c=Math.round(c)-1;var e=Math.max(c,0);a=N(b,a);return Infinity==d?a.substring(e):a.substring(e,c+Math.round(d))},2,3);T(\"substring-after\",3,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);c=b.indexOf(a);return-1==c?\"\":b.substring(c+a.length)},2);\nT(\"substring-before\",3,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);a=b.indexOf(a);return-1==a?\"\":b.substring(0,a)},2);T(\"sum\",1,!1,!1,function(a,b){a=I(b.a(a));b=0;for(var c=J(a);c;c=J(a))b+=+D(c);return b},1,1,!0);T(\"translate\",3,!1,!1,function(a,b,c,d){b=N(b,a);c=N(c,a);var e=N(d,a);a={};for(d=0;d<c.length;d++){var f=c.charAt(d);f in a||(a[f]=e.charAt(d))}c=\"\";for(d=0;d<b.length;d++)f=b.charAt(d),c+=f in a?a[f]:f;return c},3);T(\"true\",2,!1,!1,k(!0),0);function H(a,b){this.h=a;this.c=void 0!==b?b:null;this.b=null;switch(a){case \"comment\":this.b=8;break;case \"text\":this.b=3;break;case \"processing-instruction\":this.b=7;break;case \"node\":break;default:throw Error(\"Unexpected argument\");}}function Wa(a){return\"comment\"==a||\"text\"==a||\"processing-instruction\"==a||\"node\"==a}H.prototype.a=function(a){return null===this.b||this.b==a.nodeType};H.prototype.f=h(\"h\");H.prototype.toString=function(){var a=\"Kind Test: \"+this.h;null===this.c||(a+=L(this.c));return a};function Xa(a){K.call(this,3);this.c=a.substring(1,a.length-1)}q(Xa,K);Xa.prototype.a=h(\"c\");Xa.prototype.toString=function(){return\"Literal: \"+this.c};function U(a,b){this.j=a.toLowerCase();this.b=b?b.toLowerCase():\"http://www.w3.org/1999/xhtml\"}U.prototype.a=function(a){var b=a.nodeType;return 1!=b&&2!=b?!1:\"*\"!=this.j&&this.j!=a.nodeName.toLowerCase()?!1:this.b==(a.namespaceURI?a.namespaceURI.toLowerCase():\"http://www.w3.org/1999/xhtml\")};U.prototype.f=h(\"j\");U.prototype.toString=function(){return\"Name Test: \"+(\"http://www.w3.org/1999/xhtml\"==this.b?\"\":this.b+\":\")+this.j};function Ya(a){K.call(this,1);this.c=a}q(Ya,K);Ya.prototype.a=h(\"c\");Ya.prototype.toString=function(){return\"Number: \"+this.c};function Za(a,b){K.call(this,a.i);this.h=a;this.c=b;this.g=a.g;this.b=a.b;1==this.c.length&&(a=this.c[0],a.w||a.c!=$a||(a=a.o,\"*\"!=a.f()&&(this.f={name:a.f(),u:null})))}q(Za,K);function V(){K.call(this,4)}q(V,K);V.prototype.a=function(a){var b=new G;a=a.a;9==a.nodeType?b.add(a):b.add(a.ownerDocument);return b};V.prototype.toString=k(\"Root Helper Expression\");function ab(){K.call(this,4)}q(ab,K);ab.prototype.a=function(a){var b=new G;b.add(a.a);return b};ab.prototype.toString=k(\"Context Helper Expression\");\nfunction bb(a){return\"/\"==a||\"//\"==a}Za.prototype.a=function(a){var b=this.h.a(a);if(!(b instanceof G))throw Error(\"Filter expression must evaluate to nodeset.\");a=this.c;for(var c=0,d=a.length;c<d&&b.l;c++){var e=a[c],f=I(b,e.c.s);if(e.g||e.c!=cb)if(e.g||e.c!=db){var g=J(f);for(b=e.a(new y(g));null!=(g=J(f));)g=e.a(new y(g)),b=Ea(b,g)}else g=J(f),b=e.a(new y(g));else{for(g=J(f);(b=J(f))&&(!g.contains||g.contains(b))&&b.compareDocumentPosition(g)&8;g=b);b=e.a(new y(g))}}return b};\nZa.prototype.toString=function(){var a=\"Path Expression:\"+L(this.h);if(this.c.length){var b=u(this.c,function(a,b){return a+L(b)},\"Steps:\");a+=L(b)}return a};function eb(a,b){this.a=a;this.s=!!b}\nfunction Sa(a,b,c){for(c=c||0;c<a.a.length;c++)for(var d=a.a[c],e=I(b),f=b.l,g,n=0;g=J(e);n++){var v=a.s?f-n:n+1;g=d.a(new y(g,v,f));if(\"number\"==typeof g)v=v==g;else if(\"string\"==typeof g||\"boolean\"==typeof g)v=!!g;else if(g instanceof G)v=0<g.l;else throw Error(\"Predicate.evaluate returned an unexpected type.\");if(!v){v=e;g=v.f;var A=v.a;if(!A)throw Error(\"Next must be called at least once before remove.\");var P=A.b;A=A.a;P?P.a=A:g.a=A;A?A.b=P:g.b=P;g.l--;v.a=null}}return b}\neb.prototype.toString=function(){return u(this.a,function(a,b){return a+L(b)},\"Predicates:\")};function W(a,b,c,d){K.call(this,4);this.c=a;this.o=b;this.h=c||new eb([]);this.w=!!d;b=this.h;b=0<b.a.length?b.a[0].f:null;a.I&&b&&(this.f={name:b.name,u:b.u});a:{a=this.h;for(b=0;b<a.a.length;b++)if(c=a.a[b],c.g||1==c.i||0==c.i){a=!0;break a}a=!1}this.g=a}q(W,K);\nW.prototype.a=function(a){var b=a.a,c=this.f,d=null,e=null,f=0;c&&(d=c.name,e=c.u?N(c.u,a):null,f=1);if(this.w)if(this.g||this.c!=fb)if(b=I((new W(gb,new H(\"node\"))).a(a)),c=J(b))for(a=this.m(c,d,e,f);null!=(c=J(b));)a=Ea(a,this.m(c,d,e,f));else a=new G;else a=F(this.o,b,d,e),a=Sa(this.h,a,f);else a=this.m(a.a,d,e,f);return a};W.prototype.m=function(a,b,c,d){a=this.c.v(this.o,a,b,c);return a=Sa(this.h,a,d)};\nW.prototype.toString=function(){var a=\"Step:\"+L(\"Operator: \"+(this.w?\"//\":\"/\"));this.c.j&&(a+=L(\"Axis: \"+this.c));a+=L(this.o);if(this.h.a.length){var b=u(this.h.a,function(a,b){return a+L(b)},\"Predicates:\");a+=L(b)}return a};function hb(a,b,c,d){this.j=a;this.v=b;this.s=c;this.I=d}hb.prototype.toString=h(\"j\");var ib={};function X(a,b,c,d){if(ib.hasOwnProperty(a))throw Error(\"Axis already created: \"+a);b=new hb(a,b,c,!!d);return ib[a]=b}\nX(\"ancestor\",function(a,b){for(var c=new G;b=b.parentNode;)a.a(b)&&Fa(c,b);return c},!0);X(\"ancestor-or-self\",function(a,b){var c=new G;do a.a(b)&&Fa(c,b);while(b=b.parentNode);return c},!0);\nvar $a=X(\"attribute\",function(a,b){var c=new G,d=a.f();if(b=b.attributes)if(a instanceof H&&null===a.b||\"*\"==d)for(a=0;d=b[a];a++)c.add(d);else(d=b.getNamedItem(d))&&c.add(d);return c},!1),fb=X(\"child\",function(a,b,c,d,e){c=m(c)?c:null;d=m(d)?d:null;e=e||new G;for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&e.add(b);return e},!1,!0);X(\"descendant\",F,!1,!0);\nvar gb=X(\"descendant-or-self\",function(a,b,c,d){var e=new G;E(b,c,d)&&a.a(b)&&e.add(b);return F(a,b,c,d,e)},!1,!0),cb=X(\"following\",function(a,b,c,d){var e=new G;do for(var f=b;f=f.nextSibling;)E(f,c,d)&&a.a(f)&&e.add(f),e=F(a,f,c,d,e);while(b=b.parentNode);return e},!1,!0);X(\"following-sibling\",function(a,b){for(var c=new G;b=b.nextSibling;)a.a(b)&&c.add(b);return c},!1);X(\"namespace\",function(){return new G},!1);\nvar jb=X(\"parent\",function(a,b){var c=new G;if(9==b.nodeType)return c;if(2==b.nodeType)return c.add(b.ownerElement),c;b=b.parentNode;a.a(b)&&c.add(b);return c},!1),db=X(\"preceding\",function(a,b,c,d){var e=new G,f=[];do f.unshift(b);while(b=b.parentNode);for(var g=1,n=f.length;g<n;g++){var v=[];for(b=f[g];b=b.previousSibling;)v.unshift(b);for(var A=0,P=v.length;A<P;A++)b=v[A],E(b,c,d)&&a.a(b)&&e.add(b),e=F(a,b,c,d,e)}return e},!0,!0);\nX(\"preceding-sibling\",function(a,b){for(var c=new G;b=b.previousSibling;)a.a(b)&&Fa(c,b);return c},!0);var kb=X(\"self\",function(a,b){var c=new G;a.a(b)&&c.add(b);return c},!1);function lb(a){K.call(this,1);this.c=a;this.g=a.g;this.b=a.b}q(lb,K);lb.prototype.a=function(a){return-M(this.c,a)};lb.prototype.toString=function(){return\"Unary Expression: -\"+L(this.c)};function mb(a){K.call(this,4);this.c=a;Ma(this,w(this.c,function(a){return a.g}));Na(this,w(this.c,function(a){return a.b}))}q(mb,K);mb.prototype.a=function(a){var b=new G;t(this.c,function(c){c=c.a(a);if(!(c instanceof G))throw Error(\"Path expression must evaluate to NodeSet.\");b=Ea(b,c)});return b};mb.prototype.toString=function(){return u(this.c,function(a,b){return a+L(b)},\"Union Expression:\")};function nb(a,b){this.a=a;this.b=b}function ob(a){for(var b,c=[];;){Y(a,\"Missing right hand side of binary expression.\");b=pb(a);var d=B(a.a);if(!d)break;var e=(d=Qa[d]||null)&&d.C;if(!e){a.a.a--;break}for(;c.length&&e<=c[c.length-1].C;)b=new Q(c.pop(),c.pop(),b);c.push(b,d)}for(;c.length;)b=new Q(c.pop(),c.pop(),b);return b}function Y(a,b){if(C(a.a))throw Error(b);}function qb(a,b){a=B(a.a);if(a!=b)throw Error(\"Bad token, expected: \"+b+\" got: \"+a);}\nfunction rb(a){a=B(a.a);if(\")\"!=a)throw Error(\"Bad token: \"+a);}function sb(a){a=B(a.a);if(2>a.length)throw Error(\"Unclosed literal string\");return new Xa(a)}function tb(a){var b=B(a.a),c=b.indexOf(\":\");if(-1==c)return new U(b);var d=b.substring(0,c);a=a.b(d);if(!a)throw Error(\"Namespace prefix not declared: \"+d);b=b.substr(c+1);return new U(b,a)}\nfunction ub(a){var b=[];if(bb(z(a.a))){var c=B(a.a);var d=z(a.a);if(\"/\"==c&&(C(a.a)||\".\"!=d&&\"..\"!=d&&\"@\"!=d&&\"*\"!=d&&!/(?![0-9])[\\w]/.test(d)))return new V;d=new V;Y(a,\"Missing next location step.\");c=vb(a,c);b.push(c)}else{a:{c=z(a.a);d=c.charAt(0);switch(d){case \"$\":throw Error(\"Variable reference not allowed in HTML XPath\");case \"(\":B(a.a);c=ob(a);Y(a,'unclosed \"(\"');qb(a,\")\");break;case '\"':case \"'\":c=sb(a);break;default:if(isNaN(+c))if(!Wa(c)&&/(?![0-9])[\\w]/.test(d)&&\"(\"==z(a.a,1)){c=B(a.a);\nc=Va[c]||null;B(a.a);for(d=[];\")\"!=z(a.a);){Y(a,\"Missing function argument list.\");d.push(ob(a));if(\",\"!=z(a.a))break;B(a.a)}Y(a,\"Unclosed function argument list.\");rb(a);c=new Ta(c,d)}else{c=null;break a}else c=new Ya(+B(a.a))}\"[\"==z(a.a)&&(d=new eb(wb(a)),c=new Ra(c,d))}if(c)if(bb(z(a.a)))d=c;else return c;else c=vb(a,\"/\"),d=new ab,b.push(c)}for(;bb(z(a.a));)c=B(a.a),Y(a,\"Missing next location step.\"),c=vb(a,c),b.push(c);return new Za(d,b)}\nfunction vb(a,b){if(\"/\"!=b&&\"//\"!=b)throw Error('Step op should be \"/\" or \"//\"');if(\".\"==z(a.a)){var c=new W(kb,new H(\"node\"));B(a.a);return c}if(\"..\"==z(a.a))return c=new W(jb,new H(\"node\")),B(a.a),c;if(\"@\"==z(a.a)){var d=$a;B(a.a);Y(a,\"Missing attribute name\")}else if(\"::\"==z(a.a,1)){if(!/(?![0-9])[\\w]/.test(z(a.a).charAt(0)))throw Error(\"Bad token: \"+B(a.a));var e=B(a.a);d=ib[e]||null;if(!d)throw Error(\"No axis with name: \"+e);B(a.a);Y(a,\"Missing node name\")}else d=fb;e=z(a.a);if(/(?![0-9])[\\w]/.test(e.charAt(0)))if(\"(\"==\nz(a.a,1)){if(!Wa(e))throw Error(\"Invalid node type: \"+e);e=B(a.a);if(!Wa(e))throw Error(\"Invalid type name: \"+e);qb(a,\"(\");Y(a,\"Bad nodetype\");var f=z(a.a).charAt(0),g=null;if('\"'==f||\"'\"==f)g=sb(a);Y(a,\"Bad nodetype\");rb(a);e=new H(e,g)}else e=tb(a);else if(\"*\"==e)e=tb(a);else throw Error(\"Bad token: \"+B(a.a));a=new eb(wb(a),d.s);return c||new W(d,e,a,\"//\"==b)}\nfunction wb(a){for(var b=[];\"[\"==z(a.a);){B(a.a);Y(a,\"Missing predicate expression.\");var c=ob(a);b.push(c);Y(a,\"Unclosed predicate expression.\");qb(a,\"]\")}return b}function pb(a){if(\"-\"==z(a.a))return B(a.a),new lb(pb(a));var b=ub(a);if(\"|\"!=z(a.a))a=b;else{for(b=[b];\"|\"==B(a.a);)Y(a,\"Missing next union location path.\"),b.push(ub(a));a.a.a--;a=new mb(b)}return a};function xb(a,b){if(!a.length)throw Error(\"Empty XPath expression.\");a=ya(a);if(C(a))throw Error(\"Invalid XPath expression.\");b?\"function\"==ba(b)||(b=p(b.lookupNamespaceURI,b)):b=k(null);var c=ob(new nb(a,b));if(!C(a))throw Error(\"Bad token: \"+B(a));this.evaluate=function(a,b){a=c.a(new y(a));return new Z(a,b)}}\nfunction Z(a,b){if(0==b)if(a instanceof G)b=4;else if(\"string\"==typeof a)b=2;else if(\"number\"==typeof a)b=1;else if(\"boolean\"==typeof a)b=3;else throw Error(\"Unexpected evaluation result.\");if(2!=b&&1!=b&&3!=b&&!(a instanceof G))throw Error(\"value could not be converted to the specified type\");this.resultType=b;switch(b){case 2:this.stringValue=a instanceof G?Ha(a):\"\"+a;break;case 1:this.numberValue=a instanceof G?+Ha(a):+a;break;case 3:this.booleanValue=a instanceof G?0<a.l:!!a;break;case 4:case 5:case 6:case 7:var c=\nI(a);var d=[];for(var e=J(c);e;e=J(c))d.push(e);this.snapshotLength=a.l;this.invalidIteratorState=!1;break;case 8:case 9:this.singleNodeValue=Ga(a);break;default:throw Error(\"Unknown XPathResult type.\");}var f=0;this.iterateNext=function(){if(4!=b&&5!=b)throw Error(\"iterateNext called with wrong result type\");return f>=d.length?null:d[f++]};this.snapshotItem=function(a){if(6!=b&&7!=b)throw Error(\"snapshotItem called with wrong result type\");return a>=d.length||0>a?null:d[a]}}Z.ANY_TYPE=0;\nZ.NUMBER_TYPE=1;Z.STRING_TYPE=2;Z.BOOLEAN_TYPE=3;Z.UNORDERED_NODE_ITERATOR_TYPE=4;Z.ORDERED_NODE_ITERATOR_TYPE=5;Z.UNORDERED_NODE_SNAPSHOT_TYPE=6;Z.ORDERED_NODE_SNAPSHOT_TYPE=7;Z.ANY_UNORDERED_NODE_TYPE=8;Z.FIRST_ORDERED_NODE_TYPE=9;function yb(a){this.lookupNamespaceURI=Ja(a)}\naa(\"wgxpath.install\",function(a,b){a=a||l;var c=a.document;if(!c.evaluate||b)a.XPathResult=Z,c.evaluate=function(a,b,c,g){return(new xb(a,c)).evaluate(b,g)},c.createExpression=function(a,b){return new xb(a,b)},c.createNSResolver=function(a){return new yb(a)}});aa(\"_\",function(a,b){return(b||sa).frames[a]||null});;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n");
            this.index = n;
            this.root = windowReference;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            ArrayList<Object> arrayList = Lists.newArrayList(this.index);
            arrayList.add(this.root);
            return arrayList;
        }
    }

    static final class FrameByIndexSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final int index;

        @RemoteMsgConstructor
        private FrameByIndexSimpleAtom(int n) {
            super("function(){return(function(){function h(a){return function(){return this[a]}}function k(a){return function(){return a}}var l=this;function m(a){return\"string\"==typeof a}function aa(a,b){a=a.split(\".\");var c=l;a[0]in c||\"undefined\"==typeof c.execScript||c.execScript(\"var \"+a[0]);for(var d;a.length&&(d=a.shift());)a.length||void 0===b?c[d]&&c[d]!==Object.prototype[d]?c=c[d]:c=c[d]={}:c[d]=b}\nfunction ba(a){var b=typeof a;if(\"object\"==b)if(a){if(a instanceof Array)return\"array\";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(\"[object Window]\"==c)return\"object\";if(\"[object Array]\"==c||\"number\"==typeof a.length&&\"undefined\"!=typeof a.splice&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"splice\"))return\"array\";if(\"[object Function]\"==c||\"undefined\"!=typeof a.call&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"call\"))return\"function\"}else return\"null\";\nelse if(\"function\"==b&&\"undefined\"==typeof a.call)return\"object\";return b}function ca(a,b,c){return a.call.apply(a.bind,arguments)}function da(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}\nfunction p(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf(\"native code\")?p=ca:p=da;return p.apply(null,arguments)}function ea(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}}\nfunction q(a,b){function c(){}c.prototype=b.prototype;a.K=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.J=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};function r(a){if(Error.captureStackTrace)Error.captureStackTrace(this,r);else{var b=Error().stack;b&&(this.stack=b)}a&&(this.message=String(a))}q(r,Error);r.prototype.name=\"CustomError\";function fa(a,b){a=a.split(\"%s\");for(var c=\"\",d=a.length-1,e=0;e<d;e++)c+=a[e]+(e<b.length?b[e]:\"%s\");r.call(this,c+a[d])}q(fa,r);fa.prototype.name=\"AssertionError\";function ha(a,b,c){if(!a){var d=\"Assertion failed\";if(b){d+=\": \"+b;var e=Array.prototype.slice.call(arguments,2)}throw new fa(\"\"+d,e||[]);}};function t(a,b){for(var c=a.length,d=m(a)?a.split(\"\"):a,e=0;e<c;e++)e in d&&b.call(void 0,d[e],e,a)}function u(a,b,c){var d=c;t(a,function(c,f){d=b.call(void 0,d,c,f,a)});return d}function w(a,b){for(var c=a.length,d=m(a)?a.split(\"\"):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a))return!0;return!1}function ia(a){return Array.prototype.concat.apply([],arguments)}function ja(a,b,c){ha(null!=a.length);return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};var ka=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(a)[1]};function la(a,b){return a<b?-1:a>b?1:0};var x;a:{var ma=l.navigator;if(ma){var na=ma.userAgent;if(na){x=na;break a}}x=\"\"};function oa(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if(\"undefined\"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}\nfunction pa(a,b){if(a==b)return 0;if(a.compareDocumentPosition)return a.compareDocumentPosition(b)&2?1:-1;if(\"sourceIndex\"in a||a.parentNode&&\"sourceIndex\"in a.parentNode){var c=1==a.nodeType,d=1==b.nodeType;if(c&&d)return a.sourceIndex-b.sourceIndex;var e=a.parentNode,f=b.parentNode;return e==f?qa(a,b):!c&&oa(e,b)?-1*ra(a,b):!d&&oa(f,a)?ra(b,a):(c?a.sourceIndex:e.sourceIndex)-(d?b.sourceIndex:f.sourceIndex)}ha(a,\"Node cannot be null or undefined.\");d=9==a.nodeType?a:a.ownerDocument||a.document;c=\nd.createRange();c.selectNode(a);c.collapse(!0);a=d.createRange();a.selectNode(b);a.collapse(!0);return c.compareBoundaryPoints(l.Range.START_TO_END,a)}function ra(a,b){var c=a.parentNode;if(c==b)return-1;for(;b.parentNode!=c;)b=b.parentNode;return qa(b,a)}function qa(a,b){for(;b=b.previousSibling;)if(b==a)return-1;return 1};/*xxx_rpl_lic*/\nvar sa=window;function ta(a){return(a=a.exec(x))?a[1]:\"\"}ta(/Android\\s+([0-9.]+)/)||ta(/Version\\/([0-9.]+)/);function ua(a){var b=0,c=ka(String(va)).split(\".\");a=ka(String(a)).split(\".\");for(var d=Math.max(c.length,a.length),e=0;0==b&&e<d;e++){var f=c[e]||\"\",g=a[e]||\"\";do{f=/(\\d*)(\\D*)(.*)/.exec(f)||[\"\",\"\",\"\",\"\"];g=/(\\d*)(\\D*)(.*)/.exec(g)||[\"\",\"\",\"\",\"\"];if(0==f[0].length&&0==g[0].length)break;b=la(0==f[1].length?0:parseInt(f[1],10),0==g[1].length?0:parseInt(g[1],10))||la(0==f[2].length,0==g[2].length)||la(f[2],g[2]);f=f[3];g=g[3]}while(0==b)}}var wa=/Android\\s+([0-9\\.]+)/.exec(x),va=wa?wa[1]:\"0\";ua(2.3);\nua(4);/*\n\n The MIT License\n\n Copyright (c) 2007 Cybozu Labs, Inc.\n Copyright (c) 2012 Google Inc.\n\n Permission is hereby granted, free of charge, to any person obtaining a copy\n of this software and associated documentation files (the \"Software\"), to\n deal in the Software without restriction, including without limitation the\n rights to use, copy, modify, merge, publish, distribute, sublicense, and/or\n sell copies of the Software, and to permit persons to whom the Software is\n furnished to do so, subject to the following conditions:\n\n The above copyright notice and this permission notice shall be included in\n all copies or substantial portions of the Software.\n\n THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS\n IN THE SOFTWARE.\n*/\nfunction y(a,b,c){this.a=a;this.b=b||1;this.f=c||1};function xa(a){this.b=a;this.a=0}function ya(a){a=a.match(za);for(var b=0;b<a.length;b++)Aa.test(a[b])&&a.splice(b,1);return new xa(a)}var za=/\\$?(?:(?![0-9-])[\\w-]+:)?(?![0-9-])[\\w-]+|\\/\\/|\\.\\.|::|\\d+(?:\\.\\d*)?|\\.\\d+|\"[^\"]*\"|'[^']*'|[!<>]=|\\s+|./g,Aa=/^\\s/;function z(a,b){return a.b[a.a+(b||0)]}function B(a){return a.b[a.a++]}function C(a){return a.b.length<=a.a};function D(a){var b=null,c=a.nodeType;1==c&&(b=a.textContent,b=void 0==b||null==b?a.innerText:b,b=void 0==b||null==b?\"\":b);if(\"string\"!=typeof b)if(9==c||1==c){a=9==c?a.documentElement:a.firstChild;c=0;var d=[];for(b=\"\";a;){do 1!=a.nodeType&&(b+=a.nodeValue),d[c++]=a;while(a=a.firstChild);for(;c&&!(a=d[--c].nextSibling););}}else b=a.nodeValue;return\"\"+b}\nfunction E(a,b,c){if(null===b)return!0;try{if(!a.getAttribute)return!1}catch(d){return!1}return null==c?!!a.getAttribute(b):a.getAttribute(b,2)==c}function F(a,b,c,d,e){return Ba.call(null,a,b,m(c)?c:null,m(d)?d:null,e||new G)}\nfunction Ba(a,b,c,d,e){b.getElementsByName&&d&&\"name\"==c?(b=b.getElementsByName(d),t(b,function(b){a.a(b)&&e.add(b)})):b.getElementsByClassName&&d&&\"class\"==c?(b=b.getElementsByClassName(d),t(b,function(b){b.className==d&&a.a(b)&&e.add(b)})):a instanceof H?Ca(a,b,c,d,e):b.getElementsByTagName&&(b=b.getElementsByTagName(a.f()),t(b,function(a){E(a,c,d)&&e.add(a)}));return e}function Ca(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&e.add(b),Ca(a,b,c,d,e)};function G(){this.b=this.a=null;this.l=0}function Da(a){this.f=a;this.a=this.b=null}function Ea(a,b){if(!a.a)return b;if(!b.a)return a;var c=a.a;b=b.a;for(var d=null,e,f=0;c&&b;)c.f==b.f?(e=c,c=c.a,b=b.a):0<pa(c.f,b.f)?(e=b,b=b.a):(e=c,c=c.a),(e.b=d)?d.a=e:a.a=e,d=e,f++;for(e=c||b;e;)e.b=d,d=d.a=e,f++,e=e.a;a.b=d;a.l=f;return a}function Fa(a,b){b=new Da(b);b.a=a.a;a.b?a.a.b=b:a.a=a.b=b;a.a=b;a.l++}G.prototype.add=function(a){a=new Da(a);a.b=this.b;this.a?this.b.a=a:this.a=this.b=a;this.b=a;this.l++};\nfunction Ga(a){return(a=a.a)?a.f:null}function Ha(a){return(a=Ga(a))?D(a):\"\"}function I(a,b){return new Ia(a,!!b)}function Ia(a,b){this.f=a;this.b=(this.s=b)?a.b:a.a;this.a=null}function J(a){var b=a.b;if(null==b)return null;var c=a.a=b;a.b=a.s?b.b:b.a;return c.f};function Ja(a){switch(a.nodeType){case 1:return ea(Ka,a);case 9:return Ja(a.documentElement);case 11:case 10:case 6:case 12:return La;default:return a.parentNode?Ja(a.parentNode):La}}function La(){return null}function Ka(a,b){if(a.prefix==b)return a.namespaceURI||\"http://www.w3.org/1999/xhtml\";var c=a.getAttributeNode(\"xmlns:\"+b);return c&&c.specified?c.value||null:a.parentNode&&9!=a.parentNode.nodeType?Ka(a.parentNode,b):null};function K(a){this.i=a;this.b=this.g=!1;this.f=null}function L(a){return\"\\n  \"+a.toString().split(\"\\n\").join(\"\\n  \")}function Ma(a,b){a.g=b}function Na(a,b){a.b=b}function M(a,b){a=a.a(b);return a instanceof G?+Ha(a):+a}function N(a,b){a=a.a(b);return a instanceof G?Ha(a):\"\"+a}function O(a,b){a=a.a(b);return a instanceof G?!!a.l:!!a};function Q(a,b,c){K.call(this,a.i);this.c=a;this.h=b;this.o=c;this.g=b.g||c.g;this.b=b.b||c.b;this.c==Oa&&(c.b||c.g||4==c.i||0==c.i||!b.f?b.b||b.g||4==b.i||0==b.i||!c.f||(this.f={name:c.f.name,u:b}):this.f={name:b.f.name,u:c})}q(Q,K);\nfunction R(a,b,c,d,e){b=b.a(d);c=c.a(d);var f;if(b instanceof G&&c instanceof G){b=I(b);for(d=J(b);d;d=J(b))for(e=I(c),f=J(e);f;f=J(e))if(a(D(d),D(f)))return!0;return!1}if(b instanceof G||c instanceof G){b instanceof G?(e=b,d=c):(e=c,d=b);f=I(e);for(var g=typeof d,n=J(f);n;n=J(f)){switch(g){case \"number\":n=+D(n);break;case \"boolean\":n=!!D(n);break;case \"string\":n=D(n);break;default:throw Error(\"Illegal primitive type for comparison.\");}if(e==b&&a(n,d)||e==c&&a(d,n))return!0}return!1}return e?\"boolean\"==\ntypeof b||\"boolean\"==typeof c?a(!!b,!!c):\"number\"==typeof b||\"number\"==typeof c?a(+b,+c):a(b,c):a(+b,+c)}Q.prototype.a=function(a){return this.c.m(this.h,this.o,a)};Q.prototype.toString=function(){var a=\"Binary Expression: \"+this.c;a+=L(this.h);return a+=L(this.o)};function Pa(a,b,c,d){this.H=a;this.C=b;this.i=c;this.m=d}Pa.prototype.toString=h(\"H\");var Qa={};\nfunction S(a,b,c,d){if(Qa.hasOwnProperty(a))throw Error(\"Binary operator already created: \"+a);a=new Pa(a,b,c,d);return Qa[a.toString()]=a}S(\"div\",6,1,function(a,b,c){return M(a,c)/M(b,c)});S(\"mod\",6,1,function(a,b,c){return M(a,c)%M(b,c)});S(\"*\",6,1,function(a,b,c){return M(a,c)*M(b,c)});S(\"+\",5,1,function(a,b,c){return M(a,c)+M(b,c)});S(\"-\",5,1,function(a,b,c){return M(a,c)-M(b,c)});S(\"<\",4,2,function(a,b,c){return R(function(a,b){return a<b},a,b,c)});\nS(\">\",4,2,function(a,b,c){return R(function(a,b){return a>b},a,b,c)});S(\"<=\",4,2,function(a,b,c){return R(function(a,b){return a<=b},a,b,c)});S(\">=\",4,2,function(a,b,c){return R(function(a,b){return a>=b},a,b,c)});var Oa=S(\"=\",3,2,function(a,b,c){return R(function(a,b){return a==b},a,b,c,!0)});S(\"!=\",3,2,function(a,b,c){return R(function(a,b){return a!=b},a,b,c,!0)});S(\"and\",2,2,function(a,b,c){return O(a,c)&&O(b,c)});S(\"or\",1,2,function(a,b,c){return O(a,c)||O(b,c)});function Ra(a,b){if(b.a.length&&4!=a.i)throw Error(\"Primary expression must evaluate to nodeset if filter has predicate(s).\");K.call(this,a.i);this.c=a;this.h=b;this.g=a.g;this.b=a.b}q(Ra,K);Ra.prototype.a=function(a){a=this.c.a(a);return Sa(this.h,a)};Ra.prototype.toString=function(){var a=\"Filter:\"+L(this.c);return a+=L(this.h)};function Ta(a,b){if(b.length<a.B)throw Error(\"Function \"+a.j+\" expects at least\"+a.B+\" arguments, \"+b.length+\" given\");if(null!==a.A&&b.length>a.A)throw Error(\"Function \"+a.j+\" expects at most \"+a.A+\" arguments, \"+b.length+\" given\");a.G&&t(b,function(b,d){if(4!=b.i)throw Error(\"Argument \"+d+\" to function \"+a.j+\" is not of type Nodeset: \"+b);});K.call(this,a.i);this.v=a;this.c=b;Ma(this,a.g||w(b,function(a){return a.g}));Na(this,a.F&&!b.length||a.D&&!!b.length||w(b,function(a){return a.b}))}q(Ta,K);\nTa.prototype.a=function(a){return this.v.m.apply(null,ia(a,this.c))};Ta.prototype.toString=function(){var a=\"Function: \"+this.v;if(this.c.length){var b=u(this.c,function(a,b){return a+L(b)},\"Arguments:\");a+=L(b)}return a};function Ua(a,b,c,d,e,f,g,n){this.j=a;this.i=b;this.g=c;this.F=d;this.D=!1;this.m=e;this.B=f;this.A=void 0!==g?g:f;this.G=!!n}Ua.prototype.toString=h(\"j\");var Va={};\nfunction T(a,b,c,d,e,f,g,n){if(Va.hasOwnProperty(a))throw Error(\"Function already created: \"+a+\".\");Va[a]=new Ua(a,b,c,d,e,f,g,n)}T(\"boolean\",2,!1,!1,function(a,b){return O(b,a)},1);T(\"ceiling\",1,!1,!1,function(a,b){return Math.ceil(M(b,a))},1);T(\"concat\",3,!1,!1,function(a,b){var c=ja(arguments,1);return u(c,function(b,c){return b+N(c,a)},\"\")},2,null);T(\"contains\",2,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);return-1!=b.indexOf(a)},2);T(\"count\",1,!1,!1,function(a,b){return b.a(a).l},1,1,!0);\nT(\"false\",2,!1,!1,k(!1),0);T(\"floor\",1,!1,!1,function(a,b){return Math.floor(M(b,a))},1);T(\"id\",4,!1,!1,function(a,b){var c=a.a,d=9==c.nodeType?c:c.ownerDocument;a=N(b,a).split(/\\s+/);var e=[];t(a,function(a){a=d.getElementById(a);var b;if(!(b=!a)){a:if(m(e))b=m(a)&&1==a.length?e.indexOf(a,0):-1;else{for(b=0;b<e.length;b++)if(b in e&&e[b]===a)break a;b=-1}b=0<=b}b||e.push(a)});e.sort(pa);var f=new G;t(e,function(a){f.add(a)});return f},1);T(\"lang\",2,!1,!1,k(!1),1);\nT(\"last\",1,!0,!1,function(a){if(1!=arguments.length)throw Error(\"Function last expects ()\");return a.f},0);T(\"local-name\",3,!1,!0,function(a,b){return(a=b?Ga(b.a(a)):a.a)?a.localName||a.nodeName.toLowerCase():\"\"},0,1,!0);T(\"name\",3,!1,!0,function(a,b){return(a=b?Ga(b.a(a)):a.a)?a.nodeName.toLowerCase():\"\"},0,1,!0);T(\"namespace-uri\",3,!0,!1,k(\"\"),0,1,!0);T(\"normalize-space\",3,!1,!0,function(a,b){return(b?N(b,a):D(a.a)).replace(/[\\s\\xa0]+/g,\" \").replace(/^\\s+|\\s+$/g,\"\")},0,1);\nT(\"not\",2,!1,!1,function(a,b){return!O(b,a)},1);T(\"number\",1,!1,!0,function(a,b){return b?M(b,a):+D(a.a)},0,1);T(\"position\",1,!0,!1,function(a){return a.b},0);T(\"round\",1,!1,!1,function(a,b){return Math.round(M(b,a))},1);T(\"starts-with\",2,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);return 0==b.lastIndexOf(a,0)},2);T(\"string\",3,!1,!0,function(a,b){return b?N(b,a):D(a.a)},0,1);T(\"string-length\",1,!1,!0,function(a,b){return(b?N(b,a):D(a.a)).length},0,1);\nT(\"substring\",3,!1,!1,function(a,b,c,d){c=M(c,a);if(isNaN(c)||Infinity==c||-Infinity==c)return\"\";d=d?M(d,a):Infinity;if(isNaN(d)||-Infinity===d)return\"\";c=Math.round(c)-1;var e=Math.max(c,0);a=N(b,a);return Infinity==d?a.substring(e):a.substring(e,c+Math.round(d))},2,3);T(\"substring-after\",3,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);c=b.indexOf(a);return-1==c?\"\":b.substring(c+a.length)},2);\nT(\"substring-before\",3,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);a=b.indexOf(a);return-1==a?\"\":b.substring(0,a)},2);T(\"sum\",1,!1,!1,function(a,b){a=I(b.a(a));b=0;for(var c=J(a);c;c=J(a))b+=+D(c);return b},1,1,!0);T(\"translate\",3,!1,!1,function(a,b,c,d){b=N(b,a);c=N(c,a);var e=N(d,a);a={};for(d=0;d<c.length;d++){var f=c.charAt(d);f in a||(a[f]=e.charAt(d))}c=\"\";for(d=0;d<b.length;d++)f=b.charAt(d),c+=f in a?a[f]:f;return c},3);T(\"true\",2,!1,!1,k(!0),0);function H(a,b){this.h=a;this.c=void 0!==b?b:null;this.b=null;switch(a){case \"comment\":this.b=8;break;case \"text\":this.b=3;break;case \"processing-instruction\":this.b=7;break;case \"node\":break;default:throw Error(\"Unexpected argument\");}}function Wa(a){return\"comment\"==a||\"text\"==a||\"processing-instruction\"==a||\"node\"==a}H.prototype.a=function(a){return null===this.b||this.b==a.nodeType};H.prototype.f=h(\"h\");H.prototype.toString=function(){var a=\"Kind Test: \"+this.h;null===this.c||(a+=L(this.c));return a};function Xa(a){K.call(this,3);this.c=a.substring(1,a.length-1)}q(Xa,K);Xa.prototype.a=h(\"c\");Xa.prototype.toString=function(){return\"Literal: \"+this.c};function U(a,b){this.j=a.toLowerCase();this.b=b?b.toLowerCase():\"http://www.w3.org/1999/xhtml\"}U.prototype.a=function(a){var b=a.nodeType;return 1!=b&&2!=b?!1:\"*\"!=this.j&&this.j!=a.nodeName.toLowerCase()?!1:this.b==(a.namespaceURI?a.namespaceURI.toLowerCase():\"http://www.w3.org/1999/xhtml\")};U.prototype.f=h(\"j\");U.prototype.toString=function(){return\"Name Test: \"+(\"http://www.w3.org/1999/xhtml\"==this.b?\"\":this.b+\":\")+this.j};function Ya(a){K.call(this,1);this.c=a}q(Ya,K);Ya.prototype.a=h(\"c\");Ya.prototype.toString=function(){return\"Number: \"+this.c};function Za(a,b){K.call(this,a.i);this.h=a;this.c=b;this.g=a.g;this.b=a.b;1==this.c.length&&(a=this.c[0],a.w||a.c!=$a||(a=a.o,\"*\"!=a.f()&&(this.f={name:a.f(),u:null})))}q(Za,K);function V(){K.call(this,4)}q(V,K);V.prototype.a=function(a){var b=new G;a=a.a;9==a.nodeType?b.add(a):b.add(a.ownerDocument);return b};V.prototype.toString=k(\"Root Helper Expression\");function ab(){K.call(this,4)}q(ab,K);ab.prototype.a=function(a){var b=new G;b.add(a.a);return b};ab.prototype.toString=k(\"Context Helper Expression\");\nfunction bb(a){return\"/\"==a||\"//\"==a}Za.prototype.a=function(a){var b=this.h.a(a);if(!(b instanceof G))throw Error(\"Filter expression must evaluate to nodeset.\");a=this.c;for(var c=0,d=a.length;c<d&&b.l;c++){var e=a[c],f=I(b,e.c.s);if(e.g||e.c!=cb)if(e.g||e.c!=db){var g=J(f);for(b=e.a(new y(g));null!=(g=J(f));)g=e.a(new y(g)),b=Ea(b,g)}else g=J(f),b=e.a(new y(g));else{for(g=J(f);(b=J(f))&&(!g.contains||g.contains(b))&&b.compareDocumentPosition(g)&8;g=b);b=e.a(new y(g))}}return b};\nZa.prototype.toString=function(){var a=\"Path Expression:\"+L(this.h);if(this.c.length){var b=u(this.c,function(a,b){return a+L(b)},\"Steps:\");a+=L(b)}return a};function eb(a,b){this.a=a;this.s=!!b}\nfunction Sa(a,b,c){for(c=c||0;c<a.a.length;c++)for(var d=a.a[c],e=I(b),f=b.l,g,n=0;g=J(e);n++){var v=a.s?f-n:n+1;g=d.a(new y(g,v,f));if(\"number\"==typeof g)v=v==g;else if(\"string\"==typeof g||\"boolean\"==typeof g)v=!!g;else if(g instanceof G)v=0<g.l;else throw Error(\"Predicate.evaluate returned an unexpected type.\");if(!v){v=e;g=v.f;var A=v.a;if(!A)throw Error(\"Next must be called at least once before remove.\");var P=A.b;A=A.a;P?P.a=A:g.a=A;A?A.b=P:g.b=P;g.l--;v.a=null}}return b}\neb.prototype.toString=function(){return u(this.a,function(a,b){return a+L(b)},\"Predicates:\")};function W(a,b,c,d){K.call(this,4);this.c=a;this.o=b;this.h=c||new eb([]);this.w=!!d;b=this.h;b=0<b.a.length?b.a[0].f:null;a.I&&b&&(this.f={name:b.name,u:b.u});a:{a=this.h;for(b=0;b<a.a.length;b++)if(c=a.a[b],c.g||1==c.i||0==c.i){a=!0;break a}a=!1}this.g=a}q(W,K);\nW.prototype.a=function(a){var b=a.a,c=this.f,d=null,e=null,f=0;c&&(d=c.name,e=c.u?N(c.u,a):null,f=1);if(this.w)if(this.g||this.c!=fb)if(b=I((new W(gb,new H(\"node\"))).a(a)),c=J(b))for(a=this.m(c,d,e,f);null!=(c=J(b));)a=Ea(a,this.m(c,d,e,f));else a=new G;else a=F(this.o,b,d,e),a=Sa(this.h,a,f);else a=this.m(a.a,d,e,f);return a};W.prototype.m=function(a,b,c,d){a=this.c.v(this.o,a,b,c);return a=Sa(this.h,a,d)};\nW.prototype.toString=function(){var a=\"Step:\"+L(\"Operator: \"+(this.w?\"//\":\"/\"));this.c.j&&(a+=L(\"Axis: \"+this.c));a+=L(this.o);if(this.h.a.length){var b=u(this.h.a,function(a,b){return a+L(b)},\"Predicates:\");a+=L(b)}return a};function hb(a,b,c,d){this.j=a;this.v=b;this.s=c;this.I=d}hb.prototype.toString=h(\"j\");var ib={};function X(a,b,c,d){if(ib.hasOwnProperty(a))throw Error(\"Axis already created: \"+a);b=new hb(a,b,c,!!d);return ib[a]=b}\nX(\"ancestor\",function(a,b){for(var c=new G;b=b.parentNode;)a.a(b)&&Fa(c,b);return c},!0);X(\"ancestor-or-self\",function(a,b){var c=new G;do a.a(b)&&Fa(c,b);while(b=b.parentNode);return c},!0);\nvar $a=X(\"attribute\",function(a,b){var c=new G,d=a.f();if(b=b.attributes)if(a instanceof H&&null===a.b||\"*\"==d)for(a=0;d=b[a];a++)c.add(d);else(d=b.getNamedItem(d))&&c.add(d);return c},!1),fb=X(\"child\",function(a,b,c,d,e){c=m(c)?c:null;d=m(d)?d:null;e=e||new G;for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&e.add(b);return e},!1,!0);X(\"descendant\",F,!1,!0);\nvar gb=X(\"descendant-or-self\",function(a,b,c,d){var e=new G;E(b,c,d)&&a.a(b)&&e.add(b);return F(a,b,c,d,e)},!1,!0),cb=X(\"following\",function(a,b,c,d){var e=new G;do for(var f=b;f=f.nextSibling;)E(f,c,d)&&a.a(f)&&e.add(f),e=F(a,f,c,d,e);while(b=b.parentNode);return e},!1,!0);X(\"following-sibling\",function(a,b){for(var c=new G;b=b.nextSibling;)a.a(b)&&c.add(b);return c},!1);X(\"namespace\",function(){return new G},!1);\nvar jb=X(\"parent\",function(a,b){var c=new G;if(9==b.nodeType)return c;if(2==b.nodeType)return c.add(b.ownerElement),c;b=b.parentNode;a.a(b)&&c.add(b);return c},!1),db=X(\"preceding\",function(a,b,c,d){var e=new G,f=[];do f.unshift(b);while(b=b.parentNode);for(var g=1,n=f.length;g<n;g++){var v=[];for(b=f[g];b=b.previousSibling;)v.unshift(b);for(var A=0,P=v.length;A<P;A++)b=v[A],E(b,c,d)&&a.a(b)&&e.add(b),e=F(a,b,c,d,e)}return e},!0,!0);\nX(\"preceding-sibling\",function(a,b){for(var c=new G;b=b.previousSibling;)a.a(b)&&Fa(c,b);return c},!0);var kb=X(\"self\",function(a,b){var c=new G;a.a(b)&&c.add(b);return c},!1);function lb(a){K.call(this,1);this.c=a;this.g=a.g;this.b=a.b}q(lb,K);lb.prototype.a=function(a){return-M(this.c,a)};lb.prototype.toString=function(){return\"Unary Expression: -\"+L(this.c)};function mb(a){K.call(this,4);this.c=a;Ma(this,w(this.c,function(a){return a.g}));Na(this,w(this.c,function(a){return a.b}))}q(mb,K);mb.prototype.a=function(a){var b=new G;t(this.c,function(c){c=c.a(a);if(!(c instanceof G))throw Error(\"Path expression must evaluate to NodeSet.\");b=Ea(b,c)});return b};mb.prototype.toString=function(){return u(this.c,function(a,b){return a+L(b)},\"Union Expression:\")};function nb(a,b){this.a=a;this.b=b}function ob(a){for(var b,c=[];;){Y(a,\"Missing right hand side of binary expression.\");b=pb(a);var d=B(a.a);if(!d)break;var e=(d=Qa[d]||null)&&d.C;if(!e){a.a.a--;break}for(;c.length&&e<=c[c.length-1].C;)b=new Q(c.pop(),c.pop(),b);c.push(b,d)}for(;c.length;)b=new Q(c.pop(),c.pop(),b);return b}function Y(a,b){if(C(a.a))throw Error(b);}function qb(a,b){a=B(a.a);if(a!=b)throw Error(\"Bad token, expected: \"+b+\" got: \"+a);}\nfunction rb(a){a=B(a.a);if(\")\"!=a)throw Error(\"Bad token: \"+a);}function sb(a){a=B(a.a);if(2>a.length)throw Error(\"Unclosed literal string\");return new Xa(a)}function tb(a){var b=B(a.a),c=b.indexOf(\":\");if(-1==c)return new U(b);var d=b.substring(0,c);a=a.b(d);if(!a)throw Error(\"Namespace prefix not declared: \"+d);b=b.substr(c+1);return new U(b,a)}\nfunction ub(a){var b=[];if(bb(z(a.a))){var c=B(a.a);var d=z(a.a);if(\"/\"==c&&(C(a.a)||\".\"!=d&&\"..\"!=d&&\"@\"!=d&&\"*\"!=d&&!/(?![0-9])[\\w]/.test(d)))return new V;d=new V;Y(a,\"Missing next location step.\");c=vb(a,c);b.push(c)}else{a:{c=z(a.a);d=c.charAt(0);switch(d){case \"$\":throw Error(\"Variable reference not allowed in HTML XPath\");case \"(\":B(a.a);c=ob(a);Y(a,'unclosed \"(\"');qb(a,\")\");break;case '\"':case \"'\":c=sb(a);break;default:if(isNaN(+c))if(!Wa(c)&&/(?![0-9])[\\w]/.test(d)&&\"(\"==z(a.a,1)){c=B(a.a);\nc=Va[c]||null;B(a.a);for(d=[];\")\"!=z(a.a);){Y(a,\"Missing function argument list.\");d.push(ob(a));if(\",\"!=z(a.a))break;B(a.a)}Y(a,\"Unclosed function argument list.\");rb(a);c=new Ta(c,d)}else{c=null;break a}else c=new Ya(+B(a.a))}\"[\"==z(a.a)&&(d=new eb(wb(a)),c=new Ra(c,d))}if(c)if(bb(z(a.a)))d=c;else return c;else c=vb(a,\"/\"),d=new ab,b.push(c)}for(;bb(z(a.a));)c=B(a.a),Y(a,\"Missing next location step.\"),c=vb(a,c),b.push(c);return new Za(d,b)}\nfunction vb(a,b){if(\"/\"!=b&&\"//\"!=b)throw Error('Step op should be \"/\" or \"//\"');if(\".\"==z(a.a)){var c=new W(kb,new H(\"node\"));B(a.a);return c}if(\"..\"==z(a.a))return c=new W(jb,new H(\"node\")),B(a.a),c;if(\"@\"==z(a.a)){var d=$a;B(a.a);Y(a,\"Missing attribute name\")}else if(\"::\"==z(a.a,1)){if(!/(?![0-9])[\\w]/.test(z(a.a).charAt(0)))throw Error(\"Bad token: \"+B(a.a));var e=B(a.a);d=ib[e]||null;if(!d)throw Error(\"No axis with name: \"+e);B(a.a);Y(a,\"Missing node name\")}else d=fb;e=z(a.a);if(/(?![0-9])[\\w]/.test(e.charAt(0)))if(\"(\"==\nz(a.a,1)){if(!Wa(e))throw Error(\"Invalid node type: \"+e);e=B(a.a);if(!Wa(e))throw Error(\"Invalid type name: \"+e);qb(a,\"(\");Y(a,\"Bad nodetype\");var f=z(a.a).charAt(0),g=null;if('\"'==f||\"'\"==f)g=sb(a);Y(a,\"Bad nodetype\");rb(a);e=new H(e,g)}else e=tb(a);else if(\"*\"==e)e=tb(a);else throw Error(\"Bad token: \"+B(a.a));a=new eb(wb(a),d.s);return c||new W(d,e,a,\"//\"==b)}\nfunction wb(a){for(var b=[];\"[\"==z(a.a);){B(a.a);Y(a,\"Missing predicate expression.\");var c=ob(a);b.push(c);Y(a,\"Unclosed predicate expression.\");qb(a,\"]\")}return b}function pb(a){if(\"-\"==z(a.a))return B(a.a),new lb(pb(a));var b=ub(a);if(\"|\"!=z(a.a))a=b;else{for(b=[b];\"|\"==B(a.a);)Y(a,\"Missing next union location path.\"),b.push(ub(a));a.a.a--;a=new mb(b)}return a};function xb(a,b){if(!a.length)throw Error(\"Empty XPath expression.\");a=ya(a);if(C(a))throw Error(\"Invalid XPath expression.\");b?\"function\"==ba(b)||(b=p(b.lookupNamespaceURI,b)):b=k(null);var c=ob(new nb(a,b));if(!C(a))throw Error(\"Bad token: \"+B(a));this.evaluate=function(a,b){a=c.a(new y(a));return new Z(a,b)}}\nfunction Z(a,b){if(0==b)if(a instanceof G)b=4;else if(\"string\"==typeof a)b=2;else if(\"number\"==typeof a)b=1;else if(\"boolean\"==typeof a)b=3;else throw Error(\"Unexpected evaluation result.\");if(2!=b&&1!=b&&3!=b&&!(a instanceof G))throw Error(\"value could not be converted to the specified type\");this.resultType=b;switch(b){case 2:this.stringValue=a instanceof G?Ha(a):\"\"+a;break;case 1:this.numberValue=a instanceof G?+Ha(a):+a;break;case 3:this.booleanValue=a instanceof G?0<a.l:!!a;break;case 4:case 5:case 6:case 7:var c=\nI(a);var d=[];for(var e=J(c);e;e=J(c))d.push(e);this.snapshotLength=a.l;this.invalidIteratorState=!1;break;case 8:case 9:this.singleNodeValue=Ga(a);break;default:throw Error(\"Unknown XPathResult type.\");}var f=0;this.iterateNext=function(){if(4!=b&&5!=b)throw Error(\"iterateNext called with wrong result type\");return f>=d.length?null:d[f++]};this.snapshotItem=function(a){if(6!=b&&7!=b)throw Error(\"snapshotItem called with wrong result type\");return a>=d.length||0>a?null:d[a]}}Z.ANY_TYPE=0;\nZ.NUMBER_TYPE=1;Z.STRING_TYPE=2;Z.BOOLEAN_TYPE=3;Z.UNORDERED_NODE_ITERATOR_TYPE=4;Z.ORDERED_NODE_ITERATOR_TYPE=5;Z.UNORDERED_NODE_SNAPSHOT_TYPE=6;Z.ORDERED_NODE_SNAPSHOT_TYPE=7;Z.ANY_UNORDERED_NODE_TYPE=8;Z.FIRST_ORDERED_NODE_TYPE=9;function yb(a){this.lookupNamespaceURI=Ja(a)}\naa(\"wgxpath.install\",function(a,b){a=a||l;var c=a.document;if(!c.evaluate||b)a.XPathResult=Z,c.evaluate=function(a,b,c,g){return(new xb(a,c)).evaluate(b,g)},c.createExpression=function(a,b){return new xb(a,b)},c.createNSResolver=function(a){return new yb(a)}});aa(\"_\",function(a,b){return(b||sa).frames[a]||null});;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n");
            this.index = n;
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Lists.newArrayList(this.index);
        }
    }

    static final class SelectActiveElementTransformingAtom
    extends TransformingAtom<Evaluation, ElementReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> selectActiveElementSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom;

        @RemoteMsgConstructor
        private SelectActiveElementTransformingAtom(Atom<Evaluation> atom, TransformingAtom.Transformer<Evaluation, ElementReference> transformer) {
            super(atom, transformer);
            this.selectActiveElementSimpleAtom = atom;
            this.castOrDieAtom = transformer;
        }
    }

    static final class ActiveElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private ActiveElementSimpleAtom() {
            super("function(){return(function(){function h(a){return function(){return this[a]}}function k(a){return function(){return a}}var l=this;function m(a){return\"string\"==typeof a}function aa(a,b){a=a.split(\".\");var c=l;a[0]in c||\"undefined\"==typeof c.execScript||c.execScript(\"var \"+a[0]);for(var d;a.length&&(d=a.shift());)a.length||void 0===b?c[d]&&c[d]!==Object.prototype[d]?c=c[d]:c=c[d]={}:c[d]=b}\nfunction ba(a){var b=typeof a;if(\"object\"==b)if(a){if(a instanceof Array)return\"array\";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(\"[object Window]\"==c)return\"object\";if(\"[object Array]\"==c||\"number\"==typeof a.length&&\"undefined\"!=typeof a.splice&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"splice\"))return\"array\";if(\"[object Function]\"==c||\"undefined\"!=typeof a.call&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"call\"))return\"function\"}else return\"null\";\nelse if(\"function\"==b&&\"undefined\"==typeof a.call)return\"object\";return b}function ca(a,b,c){return a.call.apply(a.bind,arguments)}function da(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}\nfunction p(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf(\"native code\")?p=ca:p=da;return p.apply(null,arguments)}function ea(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}}\nfunction q(a,b){function c(){}c.prototype=b.prototype;a.K=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.J=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};function r(a){if(Error.captureStackTrace)Error.captureStackTrace(this,r);else{var b=Error().stack;b&&(this.stack=b)}a&&(this.message=String(a))}q(r,Error);r.prototype.name=\"CustomError\";function fa(a,b){a=a.split(\"%s\");for(var c=\"\",d=a.length-1,e=0;e<d;e++)c+=a[e]+(e<b.length?b[e]:\"%s\");r.call(this,c+a[d])}q(fa,r);fa.prototype.name=\"AssertionError\";function ha(a,b,c){if(!a){var d=\"Assertion failed\";if(b){d+=\": \"+b;var e=Array.prototype.slice.call(arguments,2)}throw new fa(\"\"+d,e||[]);}};function t(a,b){for(var c=a.length,d=m(a)?a.split(\"\"):a,e=0;e<c;e++)e in d&&b.call(void 0,d[e],e,a)}function u(a,b,c){var d=c;t(a,function(c,f){d=b.call(void 0,d,c,f,a)});return d}function w(a,b){for(var c=a.length,d=m(a)?a.split(\"\"):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a))return!0;return!1}function ia(a){return Array.prototype.concat.apply([],arguments)}function ja(a,b,c){ha(null!=a.length);return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};var ka=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(a)[1]};function la(a,b){return a<b?-1:a>b?1:0};var x;a:{var ma=l.navigator;if(ma){var na=ma.userAgent;if(na){x=na;break a}}x=\"\"};function oa(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if(\"undefined\"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}\nfunction pa(a,b){if(a==b)return 0;if(a.compareDocumentPosition)return a.compareDocumentPosition(b)&2?1:-1;if(\"sourceIndex\"in a||a.parentNode&&\"sourceIndex\"in a.parentNode){var c=1==a.nodeType,d=1==b.nodeType;if(c&&d)return a.sourceIndex-b.sourceIndex;var e=a.parentNode,f=b.parentNode;return e==f?qa(a,b):!c&&oa(e,b)?-1*ra(a,b):!d&&oa(f,a)?ra(b,a):(c?a.sourceIndex:e.sourceIndex)-(d?b.sourceIndex:f.sourceIndex)}ha(a,\"Node cannot be null or undefined.\");d=9==a.nodeType?a:a.ownerDocument||a.document;c=\nd.createRange();c.selectNode(a);c.collapse(!0);a=d.createRange();a.selectNode(b);a.collapse(!0);return c.compareBoundaryPoints(l.Range.START_TO_END,a)}function ra(a,b){var c=a.parentNode;if(c==b)return-1;for(;b.parentNode!=c;)b=b.parentNode;return qa(b,a)}function qa(a,b){for(;b=b.previousSibling;)if(b==a)return-1;return 1};/*xxx_rpl_lic*/\nfunction sa(a){return(a=a.exec(x))?a[1]:\"\"}sa(/Android\\s+([0-9.]+)/)||sa(/Version\\/([0-9.]+)/);function ta(a){var b=0,c=ka(String(ua)).split(\".\");a=ka(String(a)).split(\".\");for(var d=Math.max(c.length,a.length),e=0;0==b&&e<d;e++){var f=c[e]||\"\",g=a[e]||\"\";do{f=/(\\d*)(\\D*)(.*)/.exec(f)||[\"\",\"\",\"\",\"\"];g=/(\\d*)(\\D*)(.*)/.exec(g)||[\"\",\"\",\"\",\"\"];if(0==f[0].length&&0==g[0].length)break;b=la(0==f[1].length?0:parseInt(f[1],10),0==g[1].length?0:parseInt(g[1],10))||la(0==f[2].length,0==g[2].length)||la(f[2],g[2]);f=f[3];g=g[3]}while(0==b)}}var va=/Android\\s+([0-9\\.]+)/.exec(x),ua=va?va[1]:\"0\";ta(2.3);\nta(4);/*\n\n The MIT License\n\n Copyright (c) 2007 Cybozu Labs, Inc.\n Copyright (c) 2012 Google Inc.\n\n Permission is hereby granted, free of charge, to any person obtaining a copy\n of this software and associated documentation files (the \"Software\"), to\n deal in the Software without restriction, including without limitation the\n rights to use, copy, modify, merge, publish, distribute, sublicense, and/or\n sell copies of the Software, and to permit persons to whom the Software is\n furnished to do so, subject to the following conditions:\n\n The above copyright notice and this permission notice shall be included in\n all copies or substantial portions of the Software.\n\n THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS\n IN THE SOFTWARE.\n*/\nfunction y(a,b,c){this.a=a;this.b=b||1;this.f=c||1};function wa(a){this.b=a;this.a=0}function xa(a){a=a.match(ya);for(var b=0;b<a.length;b++)za.test(a[b])&&a.splice(b,1);return new wa(a)}var ya=/\\$?(?:(?![0-9-])[\\w-]+:)?(?![0-9-])[\\w-]+|\\/\\/|\\.\\.|::|\\d+(?:\\.\\d*)?|\\.\\d+|\"[^\"]*\"|'[^']*'|[!<>]=|\\s+|./g,za=/^\\s/;function z(a,b){return a.b[a.a+(b||0)]}function B(a){return a.b[a.a++]}function C(a){return a.b.length<=a.a};function D(a){var b=null,c=a.nodeType;1==c&&(b=a.textContent,b=void 0==b||null==b?a.innerText:b,b=void 0==b||null==b?\"\":b);if(\"string\"!=typeof b)if(9==c||1==c){a=9==c?a.documentElement:a.firstChild;c=0;var d=[];for(b=\"\";a;){do 1!=a.nodeType&&(b+=a.nodeValue),d[c++]=a;while(a=a.firstChild);for(;c&&!(a=d[--c].nextSibling););}}else b=a.nodeValue;return\"\"+b}\nfunction E(a,b,c){if(null===b)return!0;try{if(!a.getAttribute)return!1}catch(d){return!1}return null==c?!!a.getAttribute(b):a.getAttribute(b,2)==c}function F(a,b,c,d,e){return Aa.call(null,a,b,m(c)?c:null,m(d)?d:null,e||new G)}\nfunction Aa(a,b,c,d,e){b.getElementsByName&&d&&\"name\"==c?(b=b.getElementsByName(d),t(b,function(b){a.a(b)&&e.add(b)})):b.getElementsByClassName&&d&&\"class\"==c?(b=b.getElementsByClassName(d),t(b,function(b){b.className==d&&a.a(b)&&e.add(b)})):a instanceof H?Ba(a,b,c,d,e):b.getElementsByTagName&&(b=b.getElementsByTagName(a.f()),t(b,function(a){E(a,c,d)&&e.add(a)}));return e}function Ba(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&e.add(b),Ba(a,b,c,d,e)};function G(){this.b=this.a=null;this.l=0}function Ca(a){this.f=a;this.a=this.b=null}function Da(a,b){if(!a.a)return b;if(!b.a)return a;var c=a.a;b=b.a;for(var d=null,e,f=0;c&&b;)c.f==b.f?(e=c,c=c.a,b=b.a):0<pa(c.f,b.f)?(e=b,b=b.a):(e=c,c=c.a),(e.b=d)?d.a=e:a.a=e,d=e,f++;for(e=c||b;e;)e.b=d,d=d.a=e,f++,e=e.a;a.b=d;a.l=f;return a}function Ea(a,b){b=new Ca(b);b.a=a.a;a.b?a.a.b=b:a.a=a.b=b;a.a=b;a.l++}G.prototype.add=function(a){a=new Ca(a);a.b=this.b;this.a?this.b.a=a:this.a=this.b=a;this.b=a;this.l++};\nfunction Fa(a){return(a=a.a)?a.f:null}function Ga(a){return(a=Fa(a))?D(a):\"\"}function I(a,b){return new Ha(a,!!b)}function Ha(a,b){this.f=a;this.b=(this.s=b)?a.b:a.a;this.a=null}function J(a){var b=a.b;if(null==b)return null;var c=a.a=b;a.b=a.s?b.b:b.a;return c.f};function Ia(a){switch(a.nodeType){case 1:return ea(Ja,a);case 9:return Ia(a.documentElement);case 11:case 10:case 6:case 12:return Ka;default:return a.parentNode?Ia(a.parentNode):Ka}}function Ka(){return null}function Ja(a,b){if(a.prefix==b)return a.namespaceURI||\"http://www.w3.org/1999/xhtml\";var c=a.getAttributeNode(\"xmlns:\"+b);return c&&c.specified?c.value||null:a.parentNode&&9!=a.parentNode.nodeType?Ja(a.parentNode,b):null};function K(a){this.i=a;this.b=this.g=!1;this.f=null}function L(a){return\"\\n  \"+a.toString().split(\"\\n\").join(\"\\n  \")}function La(a,b){a.g=b}function Ma(a,b){a.b=b}function M(a,b){a=a.a(b);return a instanceof G?+Ga(a):+a}function N(a,b){a=a.a(b);return a instanceof G?Ga(a):\"\"+a}function O(a,b){a=a.a(b);return a instanceof G?!!a.l:!!a};function Q(a,b,c){K.call(this,a.i);this.c=a;this.h=b;this.o=c;this.g=b.g||c.g;this.b=b.b||c.b;this.c==Na&&(c.b||c.g||4==c.i||0==c.i||!b.f?b.b||b.g||4==b.i||0==b.i||!c.f||(this.f={name:c.f.name,u:b}):this.f={name:b.f.name,u:c})}q(Q,K);\nfunction R(a,b,c,d,e){b=b.a(d);c=c.a(d);var f;if(b instanceof G&&c instanceof G){b=I(b);for(d=J(b);d;d=J(b))for(e=I(c),f=J(e);f;f=J(e))if(a(D(d),D(f)))return!0;return!1}if(b instanceof G||c instanceof G){b instanceof G?(e=b,d=c):(e=c,d=b);f=I(e);for(var g=typeof d,n=J(f);n;n=J(f)){switch(g){case \"number\":n=+D(n);break;case \"boolean\":n=!!D(n);break;case \"string\":n=D(n);break;default:throw Error(\"Illegal primitive type for comparison.\");}if(e==b&&a(n,d)||e==c&&a(d,n))return!0}return!1}return e?\"boolean\"==\ntypeof b||\"boolean\"==typeof c?a(!!b,!!c):\"number\"==typeof b||\"number\"==typeof c?a(+b,+c):a(b,c):a(+b,+c)}Q.prototype.a=function(a){return this.c.m(this.h,this.o,a)};Q.prototype.toString=function(){var a=\"Binary Expression: \"+this.c;a+=L(this.h);return a+=L(this.o)};function Oa(a,b,c,d){this.H=a;this.C=b;this.i=c;this.m=d}Oa.prototype.toString=h(\"H\");var Pa={};\nfunction S(a,b,c,d){if(Pa.hasOwnProperty(a))throw Error(\"Binary operator already created: \"+a);a=new Oa(a,b,c,d);return Pa[a.toString()]=a}S(\"div\",6,1,function(a,b,c){return M(a,c)/M(b,c)});S(\"mod\",6,1,function(a,b,c){return M(a,c)%M(b,c)});S(\"*\",6,1,function(a,b,c){return M(a,c)*M(b,c)});S(\"+\",5,1,function(a,b,c){return M(a,c)+M(b,c)});S(\"-\",5,1,function(a,b,c){return M(a,c)-M(b,c)});S(\"<\",4,2,function(a,b,c){return R(function(a,b){return a<b},a,b,c)});\nS(\">\",4,2,function(a,b,c){return R(function(a,b){return a>b},a,b,c)});S(\"<=\",4,2,function(a,b,c){return R(function(a,b){return a<=b},a,b,c)});S(\">=\",4,2,function(a,b,c){return R(function(a,b){return a>=b},a,b,c)});var Na=S(\"=\",3,2,function(a,b,c){return R(function(a,b){return a==b},a,b,c,!0)});S(\"!=\",3,2,function(a,b,c){return R(function(a,b){return a!=b},a,b,c,!0)});S(\"and\",2,2,function(a,b,c){return O(a,c)&&O(b,c)});S(\"or\",1,2,function(a,b,c){return O(a,c)||O(b,c)});function Qa(a,b){if(b.a.length&&4!=a.i)throw Error(\"Primary expression must evaluate to nodeset if filter has predicate(s).\");K.call(this,a.i);this.c=a;this.h=b;this.g=a.g;this.b=a.b}q(Qa,K);Qa.prototype.a=function(a){a=this.c.a(a);return Ra(this.h,a)};Qa.prototype.toString=function(){var a=\"Filter:\"+L(this.c);return a+=L(this.h)};function Sa(a,b){if(b.length<a.B)throw Error(\"Function \"+a.j+\" expects at least\"+a.B+\" arguments, \"+b.length+\" given\");if(null!==a.A&&b.length>a.A)throw Error(\"Function \"+a.j+\" expects at most \"+a.A+\" arguments, \"+b.length+\" given\");a.G&&t(b,function(b,d){if(4!=b.i)throw Error(\"Argument \"+d+\" to function \"+a.j+\" is not of type Nodeset: \"+b);});K.call(this,a.i);this.v=a;this.c=b;La(this,a.g||w(b,function(a){return a.g}));Ma(this,a.F&&!b.length||a.D&&!!b.length||w(b,function(a){return a.b}))}q(Sa,K);\nSa.prototype.a=function(a){return this.v.m.apply(null,ia(a,this.c))};Sa.prototype.toString=function(){var a=\"Function: \"+this.v;if(this.c.length){var b=u(this.c,function(a,b){return a+L(b)},\"Arguments:\");a+=L(b)}return a};function Ta(a,b,c,d,e,f,g,n){this.j=a;this.i=b;this.g=c;this.F=d;this.D=!1;this.m=e;this.B=f;this.A=void 0!==g?g:f;this.G=!!n}Ta.prototype.toString=h(\"j\");var Ua={};\nfunction T(a,b,c,d,e,f,g,n){if(Ua.hasOwnProperty(a))throw Error(\"Function already created: \"+a+\".\");Ua[a]=new Ta(a,b,c,d,e,f,g,n)}T(\"boolean\",2,!1,!1,function(a,b){return O(b,a)},1);T(\"ceiling\",1,!1,!1,function(a,b){return Math.ceil(M(b,a))},1);T(\"concat\",3,!1,!1,function(a,b){var c=ja(arguments,1);return u(c,function(b,c){return b+N(c,a)},\"\")},2,null);T(\"contains\",2,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);return-1!=b.indexOf(a)},2);T(\"count\",1,!1,!1,function(a,b){return b.a(a).l},1,1,!0);\nT(\"false\",2,!1,!1,k(!1),0);T(\"floor\",1,!1,!1,function(a,b){return Math.floor(M(b,a))},1);T(\"id\",4,!1,!1,function(a,b){var c=a.a,d=9==c.nodeType?c:c.ownerDocument;a=N(b,a).split(/\\s+/);var e=[];t(a,function(a){a=d.getElementById(a);var b;if(!(b=!a)){a:if(m(e))b=m(a)&&1==a.length?e.indexOf(a,0):-1;else{for(b=0;b<e.length;b++)if(b in e&&e[b]===a)break a;b=-1}b=0<=b}b||e.push(a)});e.sort(pa);var f=new G;t(e,function(a){f.add(a)});return f},1);T(\"lang\",2,!1,!1,k(!1),1);\nT(\"last\",1,!0,!1,function(a){if(1!=arguments.length)throw Error(\"Function last expects ()\");return a.f},0);T(\"local-name\",3,!1,!0,function(a,b){return(a=b?Fa(b.a(a)):a.a)?a.localName||a.nodeName.toLowerCase():\"\"},0,1,!0);T(\"name\",3,!1,!0,function(a,b){return(a=b?Fa(b.a(a)):a.a)?a.nodeName.toLowerCase():\"\"},0,1,!0);T(\"namespace-uri\",3,!0,!1,k(\"\"),0,1,!0);T(\"normalize-space\",3,!1,!0,function(a,b){return(b?N(b,a):D(a.a)).replace(/[\\s\\xa0]+/g,\" \").replace(/^\\s+|\\s+$/g,\"\")},0,1);\nT(\"not\",2,!1,!1,function(a,b){return!O(b,a)},1);T(\"number\",1,!1,!0,function(a,b){return b?M(b,a):+D(a.a)},0,1);T(\"position\",1,!0,!1,function(a){return a.b},0);T(\"round\",1,!1,!1,function(a,b){return Math.round(M(b,a))},1);T(\"starts-with\",2,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);return 0==b.lastIndexOf(a,0)},2);T(\"string\",3,!1,!0,function(a,b){return b?N(b,a):D(a.a)},0,1);T(\"string-length\",1,!1,!0,function(a,b){return(b?N(b,a):D(a.a)).length},0,1);\nT(\"substring\",3,!1,!1,function(a,b,c,d){c=M(c,a);if(isNaN(c)||Infinity==c||-Infinity==c)return\"\";d=d?M(d,a):Infinity;if(isNaN(d)||-Infinity===d)return\"\";c=Math.round(c)-1;var e=Math.max(c,0);a=N(b,a);return Infinity==d?a.substring(e):a.substring(e,c+Math.round(d))},2,3);T(\"substring-after\",3,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);c=b.indexOf(a);return-1==c?\"\":b.substring(c+a.length)},2);\nT(\"substring-before\",3,!1,!1,function(a,b,c){b=N(b,a);a=N(c,a);a=b.indexOf(a);return-1==a?\"\":b.substring(0,a)},2);T(\"sum\",1,!1,!1,function(a,b){a=I(b.a(a));b=0;for(var c=J(a);c;c=J(a))b+=+D(c);return b},1,1,!0);T(\"translate\",3,!1,!1,function(a,b,c,d){b=N(b,a);c=N(c,a);var e=N(d,a);a={};for(d=0;d<c.length;d++){var f=c.charAt(d);f in a||(a[f]=e.charAt(d))}c=\"\";for(d=0;d<b.length;d++)f=b.charAt(d),c+=f in a?a[f]:f;return c},3);T(\"true\",2,!1,!1,k(!0),0);function H(a,b){this.h=a;this.c=void 0!==b?b:null;this.b=null;switch(a){case \"comment\":this.b=8;break;case \"text\":this.b=3;break;case \"processing-instruction\":this.b=7;break;case \"node\":break;default:throw Error(\"Unexpected argument\");}}function Va(a){return\"comment\"==a||\"text\"==a||\"processing-instruction\"==a||\"node\"==a}H.prototype.a=function(a){return null===this.b||this.b==a.nodeType};H.prototype.f=h(\"h\");H.prototype.toString=function(){var a=\"Kind Test: \"+this.h;null===this.c||(a+=L(this.c));return a};function Wa(a){K.call(this,3);this.c=a.substring(1,a.length-1)}q(Wa,K);Wa.prototype.a=h(\"c\");Wa.prototype.toString=function(){return\"Literal: \"+this.c};function U(a,b){this.j=a.toLowerCase();this.b=b?b.toLowerCase():\"http://www.w3.org/1999/xhtml\"}U.prototype.a=function(a){var b=a.nodeType;return 1!=b&&2!=b?!1:\"*\"!=this.j&&this.j!=a.nodeName.toLowerCase()?!1:this.b==(a.namespaceURI?a.namespaceURI.toLowerCase():\"http://www.w3.org/1999/xhtml\")};U.prototype.f=h(\"j\");U.prototype.toString=function(){return\"Name Test: \"+(\"http://www.w3.org/1999/xhtml\"==this.b?\"\":this.b+\":\")+this.j};function Xa(a){K.call(this,1);this.c=a}q(Xa,K);Xa.prototype.a=h(\"c\");Xa.prototype.toString=function(){return\"Number: \"+this.c};function Ya(a,b){K.call(this,a.i);this.h=a;this.c=b;this.g=a.g;this.b=a.b;1==this.c.length&&(a=this.c[0],a.w||a.c!=Za||(a=a.o,\"*\"!=a.f()&&(this.f={name:a.f(),u:null})))}q(Ya,K);function V(){K.call(this,4)}q(V,K);V.prototype.a=function(a){var b=new G;a=a.a;9==a.nodeType?b.add(a):b.add(a.ownerDocument);return b};V.prototype.toString=k(\"Root Helper Expression\");function $a(){K.call(this,4)}q($a,K);$a.prototype.a=function(a){var b=new G;b.add(a.a);return b};$a.prototype.toString=k(\"Context Helper Expression\");\nfunction ab(a){return\"/\"==a||\"//\"==a}Ya.prototype.a=function(a){var b=this.h.a(a);if(!(b instanceof G))throw Error(\"Filter expression must evaluate to nodeset.\");a=this.c;for(var c=0,d=a.length;c<d&&b.l;c++){var e=a[c],f=I(b,e.c.s);if(e.g||e.c!=bb)if(e.g||e.c!=cb){var g=J(f);for(b=e.a(new y(g));null!=(g=J(f));)g=e.a(new y(g)),b=Da(b,g)}else g=J(f),b=e.a(new y(g));else{for(g=J(f);(b=J(f))&&(!g.contains||g.contains(b))&&b.compareDocumentPosition(g)&8;g=b);b=e.a(new y(g))}}return b};\nYa.prototype.toString=function(){var a=\"Path Expression:\"+L(this.h);if(this.c.length){var b=u(this.c,function(a,b){return a+L(b)},\"Steps:\");a+=L(b)}return a};function db(a,b){this.a=a;this.s=!!b}\nfunction Ra(a,b,c){for(c=c||0;c<a.a.length;c++)for(var d=a.a[c],e=I(b),f=b.l,g,n=0;g=J(e);n++){var v=a.s?f-n:n+1;g=d.a(new y(g,v,f));if(\"number\"==typeof g)v=v==g;else if(\"string\"==typeof g||\"boolean\"==typeof g)v=!!g;else if(g instanceof G)v=0<g.l;else throw Error(\"Predicate.evaluate returned an unexpected type.\");if(!v){v=e;g=v.f;var A=v.a;if(!A)throw Error(\"Next must be called at least once before remove.\");var P=A.b;A=A.a;P?P.a=A:g.a=A;A?A.b=P:g.b=P;g.l--;v.a=null}}return b}\ndb.prototype.toString=function(){return u(this.a,function(a,b){return a+L(b)},\"Predicates:\")};function W(a,b,c,d){K.call(this,4);this.c=a;this.o=b;this.h=c||new db([]);this.w=!!d;b=this.h;b=0<b.a.length?b.a[0].f:null;a.I&&b&&(this.f={name:b.name,u:b.u});a:{a=this.h;for(b=0;b<a.a.length;b++)if(c=a.a[b],c.g||1==c.i||0==c.i){a=!0;break a}a=!1}this.g=a}q(W,K);\nW.prototype.a=function(a){var b=a.a,c=this.f,d=null,e=null,f=0;c&&(d=c.name,e=c.u?N(c.u,a):null,f=1);if(this.w)if(this.g||this.c!=eb)if(b=I((new W(fb,new H(\"node\"))).a(a)),c=J(b))for(a=this.m(c,d,e,f);null!=(c=J(b));)a=Da(a,this.m(c,d,e,f));else a=new G;else a=F(this.o,b,d,e),a=Ra(this.h,a,f);else a=this.m(a.a,d,e,f);return a};W.prototype.m=function(a,b,c,d){a=this.c.v(this.o,a,b,c);return a=Ra(this.h,a,d)};\nW.prototype.toString=function(){var a=\"Step:\"+L(\"Operator: \"+(this.w?\"//\":\"/\"));this.c.j&&(a+=L(\"Axis: \"+this.c));a+=L(this.o);if(this.h.a.length){var b=u(this.h.a,function(a,b){return a+L(b)},\"Predicates:\");a+=L(b)}return a};function gb(a,b,c,d){this.j=a;this.v=b;this.s=c;this.I=d}gb.prototype.toString=h(\"j\");var hb={};function X(a,b,c,d){if(hb.hasOwnProperty(a))throw Error(\"Axis already created: \"+a);b=new gb(a,b,c,!!d);return hb[a]=b}\nX(\"ancestor\",function(a,b){for(var c=new G;b=b.parentNode;)a.a(b)&&Ea(c,b);return c},!0);X(\"ancestor-or-self\",function(a,b){var c=new G;do a.a(b)&&Ea(c,b);while(b=b.parentNode);return c},!0);\nvar Za=X(\"attribute\",function(a,b){var c=new G,d=a.f();if(b=b.attributes)if(a instanceof H&&null===a.b||\"*\"==d)for(a=0;d=b[a];a++)c.add(d);else(d=b.getNamedItem(d))&&c.add(d);return c},!1),eb=X(\"child\",function(a,b,c,d,e){c=m(c)?c:null;d=m(d)?d:null;e=e||new G;for(b=b.firstChild;b;b=b.nextSibling)E(b,c,d)&&a.a(b)&&e.add(b);return e},!1,!0);X(\"descendant\",F,!1,!0);\nvar fb=X(\"descendant-or-self\",function(a,b,c,d){var e=new G;E(b,c,d)&&a.a(b)&&e.add(b);return F(a,b,c,d,e)},!1,!0),bb=X(\"following\",function(a,b,c,d){var e=new G;do for(var f=b;f=f.nextSibling;)E(f,c,d)&&a.a(f)&&e.add(f),e=F(a,f,c,d,e);while(b=b.parentNode);return e},!1,!0);X(\"following-sibling\",function(a,b){for(var c=new G;b=b.nextSibling;)a.a(b)&&c.add(b);return c},!1);X(\"namespace\",function(){return new G},!1);\nvar ib=X(\"parent\",function(a,b){var c=new G;if(9==b.nodeType)return c;if(2==b.nodeType)return c.add(b.ownerElement),c;b=b.parentNode;a.a(b)&&c.add(b);return c},!1),cb=X(\"preceding\",function(a,b,c,d){var e=new G,f=[];do f.unshift(b);while(b=b.parentNode);for(var g=1,n=f.length;g<n;g++){var v=[];for(b=f[g];b=b.previousSibling;)v.unshift(b);for(var A=0,P=v.length;A<P;A++)b=v[A],E(b,c,d)&&a.a(b)&&e.add(b),e=F(a,b,c,d,e)}return e},!0,!0);\nX(\"preceding-sibling\",function(a,b){for(var c=new G;b=b.previousSibling;)a.a(b)&&Ea(c,b);return c},!0);var jb=X(\"self\",function(a,b){var c=new G;a.a(b)&&c.add(b);return c},!1);function kb(a){K.call(this,1);this.c=a;this.g=a.g;this.b=a.b}q(kb,K);kb.prototype.a=function(a){return-M(this.c,a)};kb.prototype.toString=function(){return\"Unary Expression: -\"+L(this.c)};function lb(a){K.call(this,4);this.c=a;La(this,w(this.c,function(a){return a.g}));Ma(this,w(this.c,function(a){return a.b}))}q(lb,K);lb.prototype.a=function(a){var b=new G;t(this.c,function(c){c=c.a(a);if(!(c instanceof G))throw Error(\"Path expression must evaluate to NodeSet.\");b=Da(b,c)});return b};lb.prototype.toString=function(){return u(this.c,function(a,b){return a+L(b)},\"Union Expression:\")};function mb(a,b){this.a=a;this.b=b}function nb(a){for(var b,c=[];;){Y(a,\"Missing right hand side of binary expression.\");b=ob(a);var d=B(a.a);if(!d)break;var e=(d=Pa[d]||null)&&d.C;if(!e){a.a.a--;break}for(;c.length&&e<=c[c.length-1].C;)b=new Q(c.pop(),c.pop(),b);c.push(b,d)}for(;c.length;)b=new Q(c.pop(),c.pop(),b);return b}function Y(a,b){if(C(a.a))throw Error(b);}function pb(a,b){a=B(a.a);if(a!=b)throw Error(\"Bad token, expected: \"+b+\" got: \"+a);}\nfunction qb(a){a=B(a.a);if(\")\"!=a)throw Error(\"Bad token: \"+a);}function rb(a){a=B(a.a);if(2>a.length)throw Error(\"Unclosed literal string\");return new Wa(a)}function sb(a){var b=B(a.a),c=b.indexOf(\":\");if(-1==c)return new U(b);var d=b.substring(0,c);a=a.b(d);if(!a)throw Error(\"Namespace prefix not declared: \"+d);b=b.substr(c+1);return new U(b,a)}\nfunction tb(a){var b=[];if(ab(z(a.a))){var c=B(a.a);var d=z(a.a);if(\"/\"==c&&(C(a.a)||\".\"!=d&&\"..\"!=d&&\"@\"!=d&&\"*\"!=d&&!/(?![0-9])[\\w]/.test(d)))return new V;d=new V;Y(a,\"Missing next location step.\");c=ub(a,c);b.push(c)}else{a:{c=z(a.a);d=c.charAt(0);switch(d){case \"$\":throw Error(\"Variable reference not allowed in HTML XPath\");case \"(\":B(a.a);c=nb(a);Y(a,'unclosed \"(\"');pb(a,\")\");break;case '\"':case \"'\":c=rb(a);break;default:if(isNaN(+c))if(!Va(c)&&/(?![0-9])[\\w]/.test(d)&&\"(\"==z(a.a,1)){c=B(a.a);\nc=Ua[c]||null;B(a.a);for(d=[];\")\"!=z(a.a);){Y(a,\"Missing function argument list.\");d.push(nb(a));if(\",\"!=z(a.a))break;B(a.a)}Y(a,\"Unclosed function argument list.\");qb(a);c=new Sa(c,d)}else{c=null;break a}else c=new Xa(+B(a.a))}\"[\"==z(a.a)&&(d=new db(vb(a)),c=new Qa(c,d))}if(c)if(ab(z(a.a)))d=c;else return c;else c=ub(a,\"/\"),d=new $a,b.push(c)}for(;ab(z(a.a));)c=B(a.a),Y(a,\"Missing next location step.\"),c=ub(a,c),b.push(c);return new Ya(d,b)}\nfunction ub(a,b){if(\"/\"!=b&&\"//\"!=b)throw Error('Step op should be \"/\" or \"//\"');if(\".\"==z(a.a)){var c=new W(jb,new H(\"node\"));B(a.a);return c}if(\"..\"==z(a.a))return c=new W(ib,new H(\"node\")),B(a.a),c;if(\"@\"==z(a.a)){var d=Za;B(a.a);Y(a,\"Missing attribute name\")}else if(\"::\"==z(a.a,1)){if(!/(?![0-9])[\\w]/.test(z(a.a).charAt(0)))throw Error(\"Bad token: \"+B(a.a));var e=B(a.a);d=hb[e]||null;if(!d)throw Error(\"No axis with name: \"+e);B(a.a);Y(a,\"Missing node name\")}else d=eb;e=z(a.a);if(/(?![0-9])[\\w]/.test(e.charAt(0)))if(\"(\"==\nz(a.a,1)){if(!Va(e))throw Error(\"Invalid node type: \"+e);e=B(a.a);if(!Va(e))throw Error(\"Invalid type name: \"+e);pb(a,\"(\");Y(a,\"Bad nodetype\");var f=z(a.a).charAt(0),g=null;if('\"'==f||\"'\"==f)g=rb(a);Y(a,\"Bad nodetype\");qb(a);e=new H(e,g)}else e=sb(a);else if(\"*\"==e)e=sb(a);else throw Error(\"Bad token: \"+B(a.a));a=new db(vb(a),d.s);return c||new W(d,e,a,\"//\"==b)}\nfunction vb(a){for(var b=[];\"[\"==z(a.a);){B(a.a);Y(a,\"Missing predicate expression.\");var c=nb(a);b.push(c);Y(a,\"Unclosed predicate expression.\");pb(a,\"]\")}return b}function ob(a){if(\"-\"==z(a.a))return B(a.a),new kb(ob(a));var b=tb(a);if(\"|\"!=z(a.a))a=b;else{for(b=[b];\"|\"==B(a.a);)Y(a,\"Missing next union location path.\"),b.push(tb(a));a.a.a--;a=new lb(b)}return a};function wb(a,b){if(!a.length)throw Error(\"Empty XPath expression.\");a=xa(a);if(C(a))throw Error(\"Invalid XPath expression.\");b?\"function\"==ba(b)||(b=p(b.lookupNamespaceURI,b)):b=k(null);var c=nb(new mb(a,b));if(!C(a))throw Error(\"Bad token: \"+B(a));this.evaluate=function(a,b){a=c.a(new y(a));return new Z(a,b)}}\nfunction Z(a,b){if(0==b)if(a instanceof G)b=4;else if(\"string\"==typeof a)b=2;else if(\"number\"==typeof a)b=1;else if(\"boolean\"==typeof a)b=3;else throw Error(\"Unexpected evaluation result.\");if(2!=b&&1!=b&&3!=b&&!(a instanceof G))throw Error(\"value could not be converted to the specified type\");this.resultType=b;switch(b){case 2:this.stringValue=a instanceof G?Ga(a):\"\"+a;break;case 1:this.numberValue=a instanceof G?+Ga(a):+a;break;case 3:this.booleanValue=a instanceof G?0<a.l:!!a;break;case 4:case 5:case 6:case 7:var c=\nI(a);var d=[];for(var e=J(c);e;e=J(c))d.push(e);this.snapshotLength=a.l;this.invalidIteratorState=!1;break;case 8:case 9:this.singleNodeValue=Fa(a);break;default:throw Error(\"Unknown XPathResult type.\");}var f=0;this.iterateNext=function(){if(4!=b&&5!=b)throw Error(\"iterateNext called with wrong result type\");return f>=d.length?null:d[f++]};this.snapshotItem=function(a){if(6!=b&&7!=b)throw Error(\"snapshotItem called with wrong result type\");return a>=d.length||0>a?null:d[a]}}Z.ANY_TYPE=0;\nZ.NUMBER_TYPE=1;Z.STRING_TYPE=2;Z.BOOLEAN_TYPE=3;Z.UNORDERED_NODE_ITERATOR_TYPE=4;Z.ORDERED_NODE_ITERATOR_TYPE=5;Z.UNORDERED_NODE_SNAPSHOT_TYPE=6;Z.ORDERED_NODE_SNAPSHOT_TYPE=7;Z.ANY_UNORDERED_NODE_TYPE=8;Z.FIRST_ORDERED_NODE_TYPE=9;function xb(a){this.lookupNamespaceURI=Ia(a)}\naa(\"wgxpath.install\",function(a,b){a=a||l;var c=a.document;if(!c.evaluate||b)a.XPathResult=Z,c.evaluate=function(a,b,c,g){return(new wb(a,c)).evaluate(b,g)},c.createExpression=function(a,b){return new wb(a,b)},c.createNSResolver=function(a){return new xb(a)}});aa(\"_\",function(){return document.activeElement||document.body});;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n");
        }
    }

    static final class GetVisibleTextSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private GetVisibleTextSimpleAtom() {
            super(WebDriverAtomScriptsLsc.GET_VISIBLE_TEXT_ANDROID);
        }
    }

    static final class GetTextTransformingAtom
    extends TransformingAtom<Evaluation, String> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> getTextSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, String> castOrDieAtom;

        @RemoteMsgConstructor
        private GetTextTransformingAtom(Atom<Evaluation> atom, TransformingAtom.Transformer<Evaluation, String> transformer) {
            super(atom, transformer);
            this.getTextSimpleAtom = atom;
            this.castOrDieAtom = transformer;
        }
    }

    static final class WebClickSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private WebClickSimpleAtom() {
            super(WebDriverAtomScriptsLsc.CLICK_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("webClick: Need an element to click on!");
        }
    }

    static final class WebScrollIntoViewSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private WebScrollIntoViewSimpleAtom() {
            super(WebDriverAtomScriptsLsc.SCROLL_INTO_VIEW_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("scrollIntoView: need an element to scroll to");
        }
    }

    static final class WebScrollIntoViewAtom
    extends TransformingAtom<Evaluation, Boolean> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> scrollIntoViewSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, Boolean> castOrDieAtom;

        @RemoteMsgConstructor
        private WebScrollIntoViewAtom(Atom<Evaluation> atom, TransformingAtom.Transformer<Evaluation, Boolean> transformer) {
            super(atom, transformer);
            this.scrollIntoViewSimpleAtom = atom;
            this.castOrDieAtom = transformer;
        }
    }

    static final class WebKeysSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String text;

        @RemoteMsgConstructor
        private WebKeysSimpleAtom(String string) {
            super(WebDriverAtomScriptsLsc.SEND_KEYS_ANDROID);
            this.text = string;
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("webKeys: Need an element to type on!");
        }

        @Override
        public List<Object> getNonContextualArguments() {
            return Lists.newArrayList(this.text);
        }
    }

    static final class ClearElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private ClearElementSimpleAtom() {
            super(WebDriverAtomScriptsLsc.CLEAR_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            throw new RuntimeException("clearElement: Need an element to clear!");
        }
    }

    static final class FindElementTransformingAtom
    extends TransformingAtom<Evaluation, ElementReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> findElementSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom;

        @RemoteMsgConstructor
        private FindElementTransformingAtom(Atom<Evaluation> atom, TransformingAtom.Transformer<Evaluation, ElementReference> transformer) {
            super(atom, transformer);
            this.findElementSimpleAtom = atom;
            this.castOrDieAtom = transformer;
        }
    }

    static final class FindElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @RemoteMsgConstructor
        FindElementSimpleAtom(String string, String string2) {
            super(WebDriverAtomScriptsLsc.FIND_ELEMENT_ANDROID, SimpleAtom.ElementReferencePlacement.LAST);
            this.locatorType = string;
            this.value = string2;
        }

        @Override
        protected List<Object> getNonContextualArguments() {
            Map map = DriverAtoms.makeLocatorJSON(Locator.forType(this.locatorType), this.value);
            return Lists.newArrayList(map);
        }
    }
}

