/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.action;

import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.web.action.IAtomActionResultPropagator;
import androidx.test.espresso.web.action.JavascriptEvaluation;
import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.SettableFuture;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.WindowReference;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class AtomAction<E>
implements ViewAction,
Bindable {
    private static final String TAG = "AtomAction";
    private static final String ID = "AtomAction";
    private static final String EVALUATION_ERROR_KEY = "evaluation_error_key";
    private final SettableFuture<Evaluation> futureEval = SettableFuture.create();
    final Atom<E> atom;
    final WindowReference window;
    final ElementReference element;
    private IAtomActionResultPropagator atomActionResultPropagator;

    public IBinder getIBinder() {
        return this.atomActionResultPropagator.asBinder();
    }

    /*
     * Enabled aggressive block sorting
     */
    public E get() throws ExecutionException, InterruptedException {
        boolean bl = Looper.myLooper() != Looper.getMainLooper();
        Preconditions.checkState(bl, "On main thread!");
        return this.getFuture().get();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public E get(long val, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        void var3_2;
        void var1_1;
        boolean bl = Looper.myLooper() != Looper.getMainLooper();
        Preconditions.checkState(bl, "On main thread!");
        return this.getFuture().get((long)var1_1, (TimeUnit)var3_2);
    }

    public String getDescription() {
        Object[] objectArray = new Object[]{this.atom, this.window, this.element};
        return String.format("Evaluate Atom: %s in window: %s with element: %s", objectArray);
    }

    public String getId() {
        return "AtomAction";
    }

    public Future<E> getFuture() {
        SettableFuture<Evaluation> settableFuture = this.futureEval;
        Function function = new Function<Evaluation, E>(this){
            final /* synthetic */ AtomAction this$0;

            /*
             * WARNING - void declaration
             */
            @Override
            public E apply(Evaluation e) {
                void var1_1;
                return this.this$0.atom.transform((Evaluation)var1_1);
            }
            {
                void var1_1;
                this.this$0 = var1_1;
            }
        };
        return Futures.transform(settableFuture, function, MoreExecutors.directExecutor());
    }

    public Matcher<View> getConstraints() {
        return ViewMatchers.isJavascriptEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public AtomAction(Atom<E> atom, WindowReference window, ElementReference element) {
        void var3_3;
        void var2_2;
        void var1_1;
        IAtomActionResultPropagator.Stub stub = new IAtomActionResultPropagator.Stub(this){
            final /* synthetic */ AtomAction this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void setError(Bundle bundle) throws RemoteException {
                Serializable serializable = bundle.getSerializable(AtomAction.EVALUATION_ERROR_KEY);
                serializable = (Throwable)serializable;
                this.this$0.futureEval.setException((Throwable)serializable);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setResult(Evaluation evaluation) throws RemoteException {
                void var1_1;
                this.this$0.futureEval.set(var1_1);
            }
        };
        this.atomActionResultPropagator = stub;
        this.atom = (Atom)Preconditions.checkNotNull(var1_1);
        this.window = var2_2;
        this.element = var3_3;
    }

    public void perform(UiController object, View view) {
        object = (WebView)view;
        if (Build.VERSION.SDK_INT >= 23 && !object.isHardwareAccelerated()) {
            AtomAction atomAction = new PerformException.Builder();
            object = object.toString();
            atomAction = atomAction.withViewDescription((String)object);
            object = new RuntimeException("Hardware acceleration is not supported on current device");
            throw atomAction.withCause((Throwable)object).build();
        }
        Runnable runnable = atomAction.atom;
        ElementReference elementReference = atomAction.element;
        runnable = runnable.getArguments(elementReference);
        runnable = Preconditions.checkNotNull(runnable);
        runnable = (List)((Object)runnable);
        object = JavascriptEvaluation.evaluate((WebView)object, (String)Preconditions.checkNotNull(atomAction.atom.getScript()), (List<Object>)((Object)runnable), atomAction.window);
        if (atomAction.window != null && Build.VERSION.SDK_INT == 19) {
            Log.w((String)"AtomAction", (String)"WARNING: KitKat does not report when an iframe is loading new content. If you are interacting with content within an iframe and that content is changing (eg: you have just pressed a submit button). Espresso will not be able to block you until the new content has loaded (which it can do on all other API levels). You will need to have some custom polling / synchronization with the iframe in that case.");
        }
        runnable = new Runnable(){
            final /* synthetic */ ListenableFuture val$localEval;
            final /* synthetic */ AtomAction this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$localEval = listenableFuture;
            }

            @Override
            public void run() {
                try {
                    this.this$0.atomActionResultPropagator.setResult((Evaluation)this.val$localEval.get());
                    return;
                }
                catch (ExecutionException executionException) {
                    this.this$0.reportException(executionException.getCause());
                    return;
                }
                catch (InterruptedException interruptedException) {
                    this.this$0.reportException(interruptedException);
                    return;
                }
                catch (RemoteException remoteException) {
                    this.this$0.reportException(remoteException);
                    return;
                }
            }
        };
        object.addListener(runnable, MoreExecutors.directExecutor());
    }

    /*
     * WARNING - void declaration
     */
    private void reportException(Throwable throwable) {
        void var1_2;
        Bundle bundle = new Bundle();
        bundle.putSerializable(EVALUATION_ERROR_KEY, (Serializable)var1_2);
        try {
            this.atomActionResultPropagator.setError(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AtomAction", (String)"Cannot report error to result propagator", (Throwable)remoteException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setIBinder(IBinder binder) {
        void var1_1;
        this.atomActionResultPropagator = IAtomActionResultPropagator.Stub.asInterface((IBinder)var1_1);
    }
}

