/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import java.io.IOException;
import java.io.StringBufferInputStream;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.ccil.cowan.tagsoup.Parser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class TagSoupDocumentParser {
    private static final ThreadLocal<TransformerFactory> transformerFactory;
    private final Parser parser;

    public static TagSoupDocumentParser newInstance() throws SAXNotRecognizedException, SAXNotSupportedException {
        TagSoupDocumentParser tagSoupDocumentParser = new TagSoupDocumentParser();
        return tagSoupDocumentParser;
    }

    public Document parse(String html) throws SAXException, IOException {
        SAXException sAXException;
        Preconditions.checkNotNull(html);
        Object object = ((TagSoupDocumentParser)object).parser;
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream((String)((Object)sAXException));
        InputSource inputSource = new InputSource(stringBufferInputStream);
        SAXSource sAXSource = new SAXSource((XMLReader)object, inputSource);
        object = new DOMResult();
        try {
            transformerFactory.get().newTransformer().transform(sAXSource, (Result)object);
        }
        catch (TransformerException transformerException) {
            sAXException = new SAXException(transformerException);
            throw sAXException;
        }
        return (Document)((DOMResult)object).getNode();
    }

    static {
        ThreadLocal<TransformerFactory> threadLocal;
        transformerFactory = threadLocal = new ThreadLocal<TransformerFactory>(){

            @Override
            protected TransformerFactory initialValue() {
                return TransformerFactory.newInstance();
            }
        };
    }

    private TagSoupDocumentParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Parser parser;
        this.parser = parser = new Parser();
        this.parser.setFeature("http://xml.org/sax/features/namespaces", false);
    }
}

