/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import android.webkit.WebView;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.assertion.TagSoupDocumentParser;
import androidx.test.espresso.web.assertion.WebAssertion;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Atoms;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.TransformingAtom;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class WebViewAssertions {
    private static final ResultDescriber<Object> TO_STRING_DESCRIBER;

    public static WebAssertion<Document> webContent(Matcher<Document> domMatcher) {
        Matcher<Document> matcher;
        Preconditions.checkNotNull(domMatcher);
        Atom<Object> atom = Atoms.script("function getHtml() {return document.documentElement.outerHTML;}");
        Object object = new DocumentParserAtom();
        atom = Atoms.transform(atom, object);
        object = new WebContentResultDescriber();
        return WebViewAssertions.webMatches(atom, matcher, object);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> WebAssertion<E> webMatches(Atom<E> atom, Matcher<E> resultMatcher) {
        void var1_1;
        return WebViewAssertions.webMatches(atom, var1_1, TO_STRING_DESCRIBER);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> WebAssertion<E> webMatches(Atom<E> atom, Matcher<E> resultMatcher, ResultDescriber<? super E> resultDescriber) {
        void var1_1;
        Atom<E> atom2;
        void var2_2;
        Preconditions.checkNotNull(resultMatcher);
        Preconditions.checkNotNull(var2_2);
        Preconditions.checkNotNull(atom2);
        ResultCheckingWebAssertion<E> resultCheckingWebAssertion = new ResultCheckingWebAssertion<E>(atom2, var1_1, var2_2);
        return resultCheckingWebAssertion;
    }

    static {
        ToStringResultDescriber toStringResultDescriber;
        TO_STRING_DESCRIBER = toStringResultDescriber = new ToStringResultDescriber();
    }

    private WebViewAssertions() {
    }

    static final class ResultCheckingWebAssertion<E>
    extends WebAssertion<E> {
        @RemoteMsgField(order=0)
        private final Atom<E> atom;
        @RemoteMsgField(order=1)
        private final Matcher<E> resultMatcher;
        @RemoteMsgField(order=2)
        private final ResultDescriber<? super E> resultDescriber;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        ResultCheckingWebAssertion(Atom<E> atom, Matcher<E> resultMatcher, ResultDescriber<? super E> resultDescriber) {
            super(var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.atom = var1_1;
            this.resultMatcher = var2_2;
            this.resultDescriber = var3_3;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        protected void checkResult(WebView object, E result) {
            void var1_3;
            void var2_5;
            StringDescription stringDescription = new StringDescription();
            stringDescription.appendText("'");
            this.resultMatcher.describeTo((Description)stringDescription);
            stringDescription.appendText("' doesn't match: ");
            if (var2_5 == null) {
                String string = "null";
            } else {
                String string = this.resultDescriber.apply(var2_5);
            }
            stringDescription.appendText((String)var1_3);
            ViewMatchers.assertThat((String)stringDescription.toString(), (Object)var2_5, this.resultMatcher);
        }
    }

    public static interface ResultDescriber<E> {
        public String apply(E var1);
    }

    static final class DocumentParserAtom
    implements TransformingAtom.Transformer<Evaluation, Document> {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Document apply(Evaluation eval) {
            Object object2;
            if (!(eval.getValue() instanceof String)) {
                object2 = String.valueOf(object2);
                StringBuilder stringBuilder = new StringBuilder();
                Object object = new RuntimeException(stringBuilder.append("Value should have been a string: ").append((String)object2).toString());
                throw object;
            }
            try {
                return TagSoupDocumentParser.newInstance().parse((String)((Evaluation)object2).getValue());
            }
            catch (IOException iOException) {
                object2 = ((Evaluation)object2).getValue();
                object2 = String.valueOf(object2);
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeException runtimeException = new RuntimeException(stringBuilder.append("Parse failed: ").append((String)object2).toString(), iOException);
                throw runtimeException;
            }
            catch (SAXException sAXException) {
                object2 = ((Evaluation)object2).getValue();
                object2 = String.valueOf(object2);
                StringBuilder stringBuilder2 = new StringBuilder();
                RuntimeException runtimeException = new RuntimeException(stringBuilder2.append("Parse failed: ").append((String)object2).toString(), sAXException);
                throw runtimeException;
            }
        }

        @RemoteMsgConstructor
        public DocumentParserAtom() {
        }
    }

    static final class WebContentResultDescriber
    implements ResultDescriber<Document> {
        @Override
        public String apply(Document document) {
            Object object;
            try {
                Object object2 = new DOMSource((Node)object);
                object = TransformerFactory.newInstance().newTransformer();
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                ((Transformer)object).transform((Source)object2, streamResult);
                object2 = stringWriter.toString();
                return object2;
            }
            catch (TransformerException transformerException) {
                String string = String.valueOf(transformerException);
                object = new StringBuilder();
                return ((StringBuilder)object).append("Could not transform!!!").append(string).toString();
            }
        }

        @RemoteMsgConstructor
        public WebContentResultDescriber() {
        }
    }

    static final class ToStringResultDescriber
    implements ResultDescriber<Object> {
        @Override
        public String apply(Object input) {
            return input.toString();
        }

        @RemoteMsgConstructor
        public ToStringResultDescriber() {
        }
    }
}

