/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.bridge;

import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.test.espresso.web.bridge.AndroidJavaScriptBridgeInstaller;
import androidx.test.espresso.web.bridge.Conduit;
import androidx.test.espresso.web.bridge.JavaScriptBoundBridge;
import androidx.test.espresso.web.bridge.JavaScriptBridgeInstallException;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.SettableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public final class JavaScriptBridge {
    private static final AtomicInteger tokenGenerator;
    static final String TAG = "JS_BRIDGE";
    static final String JS_BRIDGE_NAME = "__g_wd_jsb";
    private static volatile boolean initialized;
    private static JavaScriptBoundBridge boundBridge;

    /*
     * Enabled aggressive block sorting
     */
    public static Conduit makeConduit() {
        Preconditions.checkState(initialized, "Install bridge not called!");
        boolean bl = boundBridge != null;
        Preconditions.checkState(bl, "Bridge not configured; chromium webviews do not need bridge");
        Object object = new Conduit.Builder();
        object = ((Conduit.Builder)object).withBridgeName(JS_BRIDGE_NAME).withToken(String.valueOf(tokenGenerator.incrementAndGet())).withSuccessMethod("setResult").withErrorMethod("setError").withJsResult(SettableFuture.create()).build();
        boundBridge.addConduit((Conduit)object);
        return object;
    }

    static {
        AtomicInteger atomicInteger;
        tokenGenerator = atomicInteger = new AtomicInteger(0);
        initialized = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void installBridge() {
        int n = Looper.getMainLooper() == Looper.myLooper() ? 1 : 0;
        Preconditions.checkState(n != 0, "Must be on main thread!");
        if (initialized) {
            return;
        }
        try {
            n = Build.VERSION.SDK_INT;
            if (n < 19) {
                AndroidJavaScriptBridgeInstaller androidJavaScriptBridgeInstaller = new AndroidJavaScriptBridgeInstaller();
                boundBridge = androidJavaScriptBridgeInstaller.install();
            }
        }
        catch (JavaScriptBridgeInstallException javaScriptBridgeInstallException) {
            Log.e((String)TAG, (String)"Unable to bridge web views!", (Throwable)javaScriptBridgeInstallException);
        }
        initialized = true;
    }
}

