/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.base;

import androidx.test.espresso.web.internal.deps.guava.base.Absent;
import androidx.test.espresso.web.internal.deps.guava.base.AbstractIterator;
import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.base.Present;
import androidx.test.espresso.web.internal.deps.guava.base.Supplier;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public abstract int hashCode();

    public static Optional absent() {
        return Absent.withType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional fromNullable(Object object) {
        if (object == null) {
            return Optional.absent();
        }
        Present present = new Present(object);
        return present;
    }

    public static Optional of(Object object) {
        Present present = new Present(Preconditions.checkNotNull(object));
        return present;
    }

    public abstract Optional or(Optional var1);

    public abstract Optional transform(Function var1);

    public static <T> Iterable<T> presentInstances(final Iterable<? extends Optional<? extends T>> iterable) {
        Preconditions.checkNotNull(iterable);
        Iterable iterable2 = new Iterable(){

            @Override
            public Iterator<T> iterator() {
                AbstractIterator abstractIterator = new AbstractIterator(){
                    private final Iterator iterator;

                    @Override
                    protected Object computeNext() {
                        while (this.iterator.hasNext()) {
                            Optional optional = (Optional)this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                    {
                        this.iterator = (Iterator)Preconditions.checkNotNull(iterable.iterator());
                    }
                };
                return abstractIterator;
            }
        };
        return iterable2;
    }

    public abstract Object get();

    public abstract Object or(Supplier var1);

    public abstract Object or(Object var1);

    public abstract Object orNull();

    public abstract String toString();

    public abstract Set asSet();

    Optional() {
    }

    public abstract boolean equals(Object var1);

    public abstract boolean isPresent();
}

