/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.base;

import androidx.test.espresso.web.internal.deps.guava.base.Platform;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Strings {
    public static String emptyToNull(String string) {
        return Platform.emptyToNull(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String lenientFormat(String objectArray, Object ... objectArray2) {
        String string = String.valueOf(objectArray);
        if (objectArray2 == null) {
            objectArray = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = Strings.lenientToString(objectArray2[i]);
            }
            objectArray = objectArray2;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + objectArray.length * 16);
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= objectArray.length || (n3 = string.indexOf("%s", n)) == -1) {
                stringBuilder.append(string, n, string.length());
                if (n2 < objectArray.length) {
                    stringBuilder.append(" [");
                    n = n2 + 1;
                    stringBuilder.append(objectArray[n2]);
                    while (n < objectArray.length) {
                        stringBuilder.append(", ");
                        n2 = n + 1;
                        stringBuilder.append(objectArray[n]);
                        n = n2;
                    }
                    stringBuilder.append(']');
                }
                return stringBuilder.toString();
            }
            stringBuilder.append(string, n, n3);
            int n4 = n2 + 1;
            stringBuilder.append(objectArray[n2]);
            n = n3 + 2;
            n2 = n4;
        }
    }

    private static String lenientToString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            String string = object.toString();
            return string;
        }
        catch (Exception exception) {
            Object object2 = new StringBuilder();
            object = ((StringBuilder)object2).append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object))).toString();
            object2 = Logger.getLogger("androidx.test.espresso.web.internal.deps.guava.base.Strings");
            Level level = Level.WARNING;
            StringBuilder stringBuilder = new StringBuilder();
            ((Logger)object2).logp(level, "androidx.test.espresso.web.internal.deps.guava.base.Strings", "lenientToString", stringBuilder.append("Exception during lenientFormat for ").append((String)object).toString(), exception);
            object2 = new StringBuilder();
            return ((StringBuilder)object2).append("<").append((String)object).append(" threw ").append(exception.getClass().getName()).append(">").toString();
        }
    }

    public static String nullToEmpty(String string) {
        return Platform.nullToEmpty(string);
    }

    public static String padStart(String string, int n, char c) {
        Preconditions.checkNotNull(string);
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return Platform.stringIsNullOrEmpty(string);
    }
}

