/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.cache;

import androidx.test.espresso.web.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.web.internal.deps.guava.base.Objects;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;

public final class CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadExceptionCount;
    private final long totalLoadTime;
    private final long evictionCount;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.hitCount, this.missCount, this.loadSuccessCount, this.loadExceptionCount, this.totalLoadTime, this.evictionCount};
        return Objects.hashCode(objectArray);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("hitCount", this.hitCount).add("missCount", this.missCount).add("loadSuccessCount", this.loadSuccessCount).add("loadExceptionCount", this.loadExceptionCount).add("totalLoadTime", this.totalLoadTime).add("evictionCount", this.evictionCount).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public CacheStats(long l, long l2, long l3, long l4, long l5, long l6) {
        boolean bl = l >= 0L;
        Preconditions.checkArgument(bl);
        bl = l2 >= 0L;
        Preconditions.checkArgument(bl);
        bl = l3 >= 0L;
        Preconditions.checkArgument(bl);
        bl = l4 >= 0L;
        Preconditions.checkArgument(bl);
        bl = l5 >= 0L;
        Preconditions.checkArgument(bl);
        bl = l6 >= 0L;
        Preconditions.checkArgument(bl);
        this.hitCount = l;
        this.missCount = l2;
        this.loadSuccessCount = l3;
        this.loadExceptionCount = l4;
        this.totalLoadTime = l5;
        this.evictionCount = l6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof CacheStats)) return false;
        object = (CacheStats)object;
        if (this.hitCount != ((CacheStats)object).hitCount) return false;
        if (this.missCount != ((CacheStats)object).missCount) return false;
        if (this.loadSuccessCount != ((CacheStats)object).loadSuccessCount) return false;
        if (this.loadExceptionCount != ((CacheStats)object).loadExceptionCount) return false;
        if (this.totalLoadTime != ((CacheStats)object).totalLoadTime) return false;
        if (this.evictionCount != ((CacheStats)object).evictionCount) return false;
        return true;
    }
}

