/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.cache;

import androidx.test.espresso.web.internal.deps.guava.base.Equivalence;
import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.base.Stopwatch;
import androidx.test.espresso.web.internal.deps.guava.base.Ticker;
import androidx.test.espresso.web.internal.deps.guava.cache.AbstractCache$StatsCounter;
import androidx.test.espresso.web.internal.deps.guava.cache.Cache;
import androidx.test.espresso.web.internal.deps.guava.cache.CacheBuilder;
import androidx.test.espresso.web.internal.deps.guava.cache.CacheLoader;
import androidx.test.espresso.web.internal.deps.guava.cache.ForwardingCache;
import androidx.test.espresso.web.internal.deps.guava.cache.LocalCache$LoadingValueReference$$ExternalSyntheticLambda0;
import androidx.test.espresso.web.internal.deps.guava.cache.LocalCache$Segment$$ExternalSyntheticLambda0;
import androidx.test.espresso.web.internal.deps.guava.cache.ReferenceEntry;
import androidx.test.espresso.web.internal.deps.guava.cache.RemovalCause;
import androidx.test.espresso.web.internal.deps.guava.cache.RemovalListener;
import androidx.test.espresso.web.internal.deps.guava.cache.RemovalNotification;
import androidx.test.espresso.web.internal.deps.guava.cache.Weigher;
import androidx.test.espresso.web.internal.deps.guava.collect.AbstractSequentialIterator;
import androidx.test.espresso.web.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.web.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.web.internal.deps.guava.primitives.Ints;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.SettableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class LocalCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final Logger logger = Logger.getLogger(LocalCache.class.getName());
    static final ValueReference UNSET;
    static final Queue DISCARDING_QUEUE;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    final int concurrencyLevel;
    final Equivalence keyEquivalence;
    final Equivalence valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final long maxWeight;
    final Weigher weigher;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final long refreshNanos;
    final Queue removalNotificationQueue;
    final RemovalListener removalListener;
    final Ticker ticker;
    final EntryFactory entryFactory;
    final AbstractCache$StatsCounter globalStatsCounter;
    final CacheLoader defaultLoader;
    Set keySet;
    Collection values;
    Set entrySet;

    int hash(Object object) {
        return LocalCache.rehash(this.keyEquivalence.hash(object));
    }

    static int rehash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    long longSize() {
        Segment[] segmentArray = this.segments;
        int n = segmentArray.length;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += (long)Math.max(0, segmentArray[i].count);
        }
        return l;
    }

    Segment createSegment(int n, long l, AbstractCache$StatsCounter abstractCache$StatsCounter) {
        Segment segment = new Segment(this, n, l, abstractCache$StatsCounter);
        return segment;
    }

    Segment segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    static ValueReference unset() {
        return UNSET;
    }

    static ReferenceEntry nullEntry() {
        return NullEntry.INSTANCE;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return (V)this.segmentFor(n).get(object, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getIfPresent(Object object) {
        int n = this.hash(Preconditions.checkNotNull(object));
        if ((object = this.segmentFor(n).get(object, n)) == null) {
            this.globalStatsCounter.recordMisses(1);
            return object;
        }
        this.globalStatsCounter.recordHits(1);
        return object;
    }

    Object getLiveValue(ReferenceEntry referenceEntry, long l) {
        if (referenceEntry.getKey() == null) {
            return null;
        }
        Object object = referenceEntry.getValueReference().get();
        if (object == null) {
            return null;
        }
        if (this.isExpired(referenceEntry, l)) {
            return null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getOrDefault(Object object, Object object2) {
        void var2_3;
        void var1_2;
        V v = this.get(var1_2);
        if (v != null) {
            return v;
        }
        return var2_3;
    }

    @Override
    public V put(K k, V v) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(v);
        int n = this.hash(k);
        return (V)this.segmentFor(n).put(k, n, v, false);
    }

    @Override
    public Object putIfAbsent(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).put(object, n, object2, true);
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        int n = this.hash(object);
        return (V)this.segmentFor(n).remove(object, n);
    }

    @Override
    public Object replace(Object object, Object object2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2);
    }

    private static ArrayList toArrayList(Collection collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterators.addAll(arrayList, collection.iterator());
        return arrayList;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = collection = new Values();
        return collection;
    }

    static Queue discardingQueue() {
        return DISCARDING_QUEUE;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = set = new EntrySet();
        return set;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = set = new KeySet();
        return set;
    }

    static {
        AbstractQueue abstractQueue = new ValueReference(){

            @Override
            public int getWeight() {
                return 0;
            }

            @Override
            public ValueReference copyFor(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
                return this;
            }

            @Override
            public ReferenceEntry getEntry() {
                return null;
            }

            @Override
            public Object get() {
                return null;
            }

            @Override
            public void notifyNewValue(Object object) {
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public boolean isLoading() {
                return false;
            }
        };
        UNSET = abstractQueue;
        abstractQueue = new AbstractQueue(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public Object peek() {
                return null;
            }

            @Override
            public Object poll() {
                return null;
            }

            @Override
            public Iterator<Object> iterator() {
                return ImmutableSet.of().iterator();
            }

            @Override
            public boolean offer(Object object) {
                return true;
            }
        };
        DISCARDING_QUEUE = abstractQueue;
    }

    /*
     * Enabled aggressive block sorting
     */
    LocalCache(CacheBuilder cacheBuilder, CacheLoader cacheLoader) {
        int n;
        Queue queue;
        this.concurrencyLevel = Math.min(cacheBuilder.getConcurrencyLevel(), 65536);
        this.keyStrength = cacheBuilder.getKeyStrength();
        this.valueStrength = cacheBuilder.getValueStrength();
        this.keyEquivalence = cacheBuilder.getKeyEquivalence();
        this.valueEquivalence = cacheBuilder.getValueEquivalence();
        this.maxWeight = cacheBuilder.getMaximumWeight();
        this.weigher = cacheBuilder.getWeigher();
        this.expireAfterAccessNanos = cacheBuilder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = cacheBuilder.getExpireAfterWriteNanos();
        this.refreshNanos = cacheBuilder.getRefreshNanos();
        this.removalListener = cacheBuilder.getRemovalListener();
        if (this.removalListener == CacheBuilder.NullListener.INSTANCE) {
            queue = LocalCache.discardingQueue();
        } else {
        }
        this.removalNotificationQueue = queue;
        this.ticker = cacheBuilder.getTicker(this.recordsTime());
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.usesAccessEntries(), this.usesWriteEntries());
        this.globalStatsCounter = (AbstractCache$StatsCounter)cacheBuilder.getStatsCounterSupplier().get();
        this.defaultLoader = cacheLoader;
        int n2 = Math.min(cacheBuilder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize() && !this.customWeigher()) {
            n2 = (int)Math.min((long)n2, this.maxWeight);
        }
        int n3 = 0;
        for (n = 1; !(n >= this.concurrencyLevel || this.evictsBySize() && (long)(n * 20) > this.maxWeight); ++n3, n += n) {
        }
        this.segmentShift = 32 - n3;
        this.segmentMask = n + -1;
        this.segments = this.newSegmentArray(n);
        n3 = n2 / n;
        n2 = n3 * n < n2 ? n3 + 1 : n3;
        for (n3 = 1; n3 < n2; n3 += n3) {
        }
        if (this.evictsBySize()) {
            long l = this.maxWeight / (long)n + 1L;
            long l2 = this.maxWeight % (long)n;
            for (n2 = 0; n2 < this.segments.length; ++n2) {
                long l3 = (long)n2 == l2 ? l + -1L : l;
                this.segments[n2] = this.createSegment(n3, l3, (AbstractCache$StatsCounter)cacheBuilder.getStatsCounterSupplier().get());
                l = l3;
            }
            return;
        }
        for (n2 = 0; n2 < this.segments.length; ++n2) {
            this.segments[n2] = this.createSegment(n3, -1L, (AbstractCache$StatsCounter)cacheBuilder.getStatsCounterSupplier().get());
        }
    }

    @Override
    public void clear() {
        Segment[] segmentArray = this.segments;
        int n = segmentArray.length;
        for (int i = 0; i < n; ++i) {
            segmentArray[i].clear();
        }
    }

    static void connectAccessOrder(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry2.setPreviousInAccessQueue(referenceEntry);
    }

    static void connectWriteOrder(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry2.setPreviousInWriteQueue(referenceEntry);
    }

    static void nullifyAccessOrder(ReferenceEntry referenceEntry) {
        ReferenceEntry referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry.setPreviousInAccessQueue(referenceEntry2);
    }

    static void nullifyWriteOrder(ReferenceEntry referenceEntry) {
        ReferenceEntry referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry.setPreviousInWriteQueue(referenceEntry2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void processPendingNotifications() {
        RemovalNotification removalNotification;
        while ((removalNotification = (RemovalNotification)this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(removalNotification);
            }
            catch (Throwable throwable) {
                logger.logp(Level.WARNING, "androidx.test.espresso.web.internal.deps.guava.cache.LocalCache", "processPendingNotifications", "Exception thrown by removal listener", throwable);
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object) {
        for (Map.Entry entry : object.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    void reclaimKey(ReferenceEntry referenceEntry) {
        int n = referenceEntry.getHash();
        this.segmentFor(n).reclaimKey(referenceEntry, n);
    }

    void reclaimValue(ValueReference valueReference) {
        ReferenceEntry referenceEntry = valueReference.getEntry();
        int n = referenceEntry.getHash();
        this.segmentFor(n).reclaimValue(referenceEntry.getKey(), n, valueReference);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        long l = this.ticker.read();
        Segment[] segmentArray = this.segments;
        long l2 = -1L;
        int n = 0;
        while (true) {
            long l3;
            block9: {
                block8: {
                    if (n >= 3) break block8;
                    int n2 = segmentArray.length;
                    l3 = 0L;
                    for (int i = 0; i < n2; ++i) {
                        Segment segment = segmentArray[i];
                        int cfr_ignored_0 = segment.count;
                        AtomicReferenceArray atomicReferenceArray = segment.table;
                        for (int j = 0; j < atomicReferenceArray.length(); ++j) {
                            for (ReferenceEntry referenceEntry = (ReferenceEntry)atomicReferenceArray.get(j); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                                Object object2 = segment.getLiveValue(referenceEntry, l);
                                if (object2 == null || !this.valueEquivalence.equivalent(object, object2)) continue;
                                return true;
                            }
                        }
                        l3 += (long)segment.modCount;
                    }
                    if (l3 != l2) break block9;
                }
                return false;
            }
            ++n;
            l2 = l3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean customWeigher() {
        if (this.weigher == CacheBuilder.OneWeigher.INSTANCE) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean evictsBySize() {
        if (this.maxWeight < 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean expiresAfterAccess() {
        if (this.expireAfterAccessNanos <= 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean expiresAfterWrite() {
        if (this.expireAfterWriteNanos <= 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        int n;
        Segment[] segmentArray = this.segments;
        int n2 = segmentArray.length;
        long l = 0L;
        for (n = 0; n < n2; ++n) {
            Segment segment = segmentArray[n];
            if (segment.count != 0) {
                return false;
            }
            l += (long)segment.modCount;
        }
        if (l == 0L) return true;
        int n3 = segmentArray.length;
        long l2 = l;
        for (n = 0; n < n3; ++n) {
            Segment segment = segmentArray[n];
            if (segment.count != 0) {
                return false;
            }
            l = l2 - (long)segment.modCount;
            l2 = l;
        }
        if (l2 != 0L) return 0 != 0;
        return 1 != 0;
    }

    boolean isExpired(ReferenceEntry referenceEntry, long l) {
        Preconditions.checkNotNull(referenceEntry);
        if (this.expiresAfterAccess() && l - referenceEntry.getAccessTime() >= this.expireAfterAccessNanos) {
            return true;
        }
        return this.expiresAfterWrite() && l - referenceEntry.getWriteTime() >= this.expireAfterWriteNanos;
    }

    boolean recordsAccess() {
        return this.expiresAfterAccess();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean recordsTime() {
        if (this.recordsWrite()) return true;
        if (!this.recordsAccess()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean recordsWrite() {
        if (this.expiresAfterWrite()) return true;
        if (!this.refreshes()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean refreshes() {
        if (this.refreshNanos <= 0L) return false;
        return true;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n, object2);
    }

    @Override
    public boolean replace(Object object, Object object2, Object object3) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object3);
        if (object2 == null) {
            return false;
        }
        int n = this.hash(object);
        return this.segmentFor(n).replace(object, n, object2, object3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesAccessEntries() {
        if (this.usesAccessQueue()) return true;
        if (!this.recordsAccess()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesAccessQueue() {
        if (this.expiresAfterAccess()) return true;
        if (!this.evictsBySize()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesKeyReferences() {
        if (this.keyStrength == Strength.STRONG) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesValueReferences() {
        if (this.valueStrength == Strength.STRONG) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usesWriteEntries() {
        if (this.usesWriteQueue()) return true;
        if (!this.recordsWrite()) return false;
        return true;
    }

    boolean usesWriteQueue() {
        return this.expiresAfterWrite();
    }

    final Segment[] newSegmentArray(int n) {
        return new Segment[n];
    }

    static abstract class Strength
    extends Enum {
        public static final /* enum */ Strength STRONG;
        public static final /* enum */ Strength SOFT;
        public static final /* enum */ Strength WEAK;
        private static final /* synthetic */ Strength[] $VALUES;

        abstract Equivalence defaultEquivalence();

        abstract ValueReference referenceValue(Segment var1, ReferenceEntry var2, Object var3, int var4);

        static {
            Strength strength = new Strength(){

                @Override
                Equivalence defaultEquivalence() {
                    return Equivalence.equals();
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                ValueReference referenceValue(Segment segment, ReferenceEntry referenceEntry, Object object, int n) {
                    void var0_2;
                    void var3_6;
                    void var4_7;
                    if (var4_7 == true) {
                        StrongValueReference strongValueReference = new StrongValueReference(var3_6);
                        return var0_2;
                    }
                    WeightedStrongValueReference weightedStrongValueReference = new WeightedStrongValueReference(var3_6, (int)var4_7);
                    return var0_2;
                }
            };
            STRONG = strength;
            strength = new Strength(){

                @Override
                Equivalence defaultEquivalence() {
                    return Equivalence.identity();
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                ValueReference referenceValue(Segment segment, ReferenceEntry referenceEntry, Object object, int n) {
                    void var0_2;
                    void var2_5;
                    void var3_6;
                    void var1_4;
                    void var4_7;
                    if (var4_7 == true) {
                        SoftValueReference softValueReference = new SoftValueReference(var1_4.valueReferenceQueue, var3_6, (ReferenceEntry)var2_5);
                        return var0_2;
                    }
                    WeightedSoftValueReference weightedSoftValueReference = new WeightedSoftValueReference(var1_4.valueReferenceQueue, var3_6, (ReferenceEntry)var2_5, (int)var4_7);
                    return var0_2;
                }
            };
            SOFT = strength;
            strength = new Strength(){

                @Override
                Equivalence defaultEquivalence() {
                    return Equivalence.identity();
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                ValueReference referenceValue(Segment segment, ReferenceEntry referenceEntry, Object object, int n) {
                    void var0_2;
                    void var2_5;
                    void var3_6;
                    void var1_4;
                    void var4_7;
                    if (var4_7 == true) {
                        WeakValueReference weakValueReference = new WeakValueReference(var1_4.valueReferenceQueue, var3_6, (ReferenceEntry)var2_5);
                        return var0_2;
                    }
                    WeightedWeakValueReference weightedWeakValueReference = new WeightedWeakValueReference(var1_4.valueReferenceQueue, var3_6, (ReferenceEntry)var2_5, (int)var4_7);
                    return var0_2;
                }
            };
            WEAK = strength;
            $VALUES = strengthArray = new Strength[]{Strength.STRONG, Strength.SOFT, Strength.WEAK};
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Strength() {
            void var2_-1;
            void var1_-1;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        /* synthetic */ Strength(1 varnull) {
            this((String)var1_-1, (int)var2_1);
            void var2_1;
            void var1_-1;
        }

        public static Strength[] values() {
            return (Strength[])$VALUES.clone();
        }
    }

    static abstract class EntryFactory
    extends Enum {
        public static final /* enum */ EntryFactory STRONG;
        public static final /* enum */ EntryFactory STRONG_ACCESS;
        public static final /* enum */ EntryFactory STRONG_WRITE;
        public static final /* enum */ EntryFactory STRONG_ACCESS_WRITE;
        public static final /* enum */ EntryFactory WEAK;
        public static final /* enum */ EntryFactory WEAK_ACCESS;
        public static final /* enum */ EntryFactory WEAK_WRITE;
        public static final /* enum */ EntryFactory WEAK_ACCESS_WRITE;
        static final EntryFactory[] factories;
        private static final /* synthetic */ EntryFactory[] $VALUES;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        static EntryFactory getFactory(Strength strength, boolean bl, boolean bl2) {
            void var2_7;
            void var1_4;
            int n = strength == Strength.WEAK ? 4 : 0;
            if (bl) {
                boolean bl3 = true;
            } else {
                boolean bl4 = false;
            }
            int n2 = n | var1_4;
            if (var2_7 != false) {
                n = 2;
                return factories[n2 | n];
            }
            n = 0;
            return factories[n2 | n];
        }

        ReferenceEntry copyEntry(Segment segment, ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
            return this.newEntry(segment, referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry2);
        }

        abstract ReferenceEntry newEntry(Segment var1, Object var2, int var3, ReferenceEntry var4);

        static {
            EntryFactory entryFactory;
            STRONG = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new StrongEntry(object, n, referenceEntry);
                    return object2;
                }
            };
            STRONG_ACCESS = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry copyEntry(Segment object, ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
                    object = super.copyEntry((Segment)object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, (ReferenceEntry)object);
                    return object;
                }

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new StrongAccessEntry(object, n, referenceEntry);
                    return object2;
                }
            };
            STRONG_WRITE = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry copyEntry(Segment object, ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
                    object = super.copyEntry((Segment)object, referenceEntry, referenceEntry2);
                    this.copyWriteEntry(referenceEntry, (ReferenceEntry)object);
                    return object;
                }

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new StrongWriteEntry(object, n, referenceEntry);
                    return object2;
                }
            };
            STRONG_ACCESS_WRITE = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry copyEntry(Segment object, ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
                    object = super.copyEntry((Segment)object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, (ReferenceEntry)object);
                    this.copyWriteEntry(referenceEntry, (ReferenceEntry)object);
                    return object;
                }

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new StrongAccessWriteEntry(object, n, referenceEntry);
                    return object2;
                }
            };
            WEAK = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new WeakEntry(segment.keyReferenceQueue, object, n, referenceEntry);
                    return object2;
                }
            };
            WEAK_ACCESS = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry copyEntry(Segment object, ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
                    object = super.copyEntry((Segment)object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, (ReferenceEntry)object);
                    return object;
                }

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new WeakAccessEntry(segment.keyReferenceQueue, object, n, referenceEntry);
                    return object2;
                }
            };
            WEAK_WRITE = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry copyEntry(Segment object, ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
                    object = super.copyEntry((Segment)object, referenceEntry, referenceEntry2);
                    this.copyWriteEntry(referenceEntry, (ReferenceEntry)object);
                    return object;
                }

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new WeakWriteEntry(segment.keyReferenceQueue, object, n, referenceEntry);
                    return object2;
                }
            };
            WEAK_ACCESS_WRITE = entryFactory = new EntryFactory(){

                @Override
                ReferenceEntry copyEntry(Segment object, ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
                    object = super.copyEntry((Segment)object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, (ReferenceEntry)object);
                    this.copyWriteEntry(referenceEntry, (ReferenceEntry)object);
                    return object;
                }

                @Override
                ReferenceEntry newEntry(Segment segment, Object object, int n, ReferenceEntry referenceEntry) {
                    Object object2 = new WeakAccessWriteEntry(segment.keyReferenceQueue, object, n, referenceEntry);
                    return object2;
                }
            };
            $VALUES = entryFactoryArray = new EntryFactory[]{EntryFactory.STRONG, EntryFactory.STRONG_ACCESS, EntryFactory.STRONG_WRITE, EntryFactory.STRONG_ACCESS_WRITE, EntryFactory.WEAK, EntryFactory.WEAK_ACCESS, EntryFactory.WEAK_WRITE, EntryFactory.WEAK_ACCESS_WRITE};
            entryFactory = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
            factories = entryFactory;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EntryFactory() {
            void var2_-1;
            void var1_-1;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        /* synthetic */ EntryFactory(1 varnull) {
            this((String)var1_-1, (int)var2_1);
            void var2_1;
            void var1_-1;
        }

        void copyAccessEntry(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
            referenceEntry2.setAccessTime(referenceEntry.getAccessTime());
            LocalCache.connectAccessOrder(referenceEntry.getPreviousInAccessQueue(), referenceEntry2);
            LocalCache.connectAccessOrder(referenceEntry2, referenceEntry.getNextInAccessQueue());
            LocalCache.nullifyAccessOrder(referenceEntry);
        }

        void copyWriteEntry(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
            referenceEntry2.setWriteTime(referenceEntry.getWriteTime());
            LocalCache.connectWriteOrder(referenceEntry.getPreviousInWriteQueue(), referenceEntry2);
            LocalCache.connectWriteOrder(referenceEntry2, referenceEntry.getNextInWriteQueue());
            LocalCache.nullifyWriteOrder(referenceEntry);
        }

        public static EntryFactory[] values() {
            return (EntryFactory[])$VALUES.clone();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Segment
    extends ReentrantLock {
        final LocalCache map;
        volatile int count;
        long totalWeight;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray table;
        final long maxSegmentWeight;
        final ReferenceQueue keyReferenceQueue;
        final ReferenceQueue valueReferenceQueue;
        final Queue recencyQueue;
        final AtomicInteger readCount;
        final Queue writeQueue;
        final Queue accessQueue;
        final AbstractCache$StatsCounter statsCounter;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        LoadingValueReference insertLoadingValueReference(Object var1_1, int var2_3, boolean var3_5) {
            block9: {
                block8: {
                    block7: {
                        this.lock();
                        var5_7 = this.map.ticker.read();
                        this.preWriteCleanup(var5_7);
                        var7_8 = this.table;
                        var4_9 = var7_8.length();
                        var8_11 = var2_3 & var4_9 + -1;
                        var4_10 = var9_12 = (ReferenceEntry)var7_8.get(var8_11);
lbl9:
                        // 2 sources

                        while (var4_10 != null) {
                            var10_13 = var4_10.getKey();
                            var11_15 = var4_10.getHash();
                            if (var11_15 != var2_3 || var10_13 == null || !(var10_14 = this.map.keyEquivalence.equivalent(var1_1, var10_13))) ** GOTO lbl-1000
                            var1_1 = var4_10.getValueReference();
                            var2_3 = (int)var1_1.isLoading();
                            if (var2_3 != 0) break block7;
                            if (!var3_5) break block8;
                            var12_16 = var4_10.getWriteTime();
                            var14_17 = var5_7 - var12_16;
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl37
lbl-1000:
                        // 1 sources

                        {
                            var16_18 = this.map.refreshNanos;
                            if (var14_17 >= var16_18) break block8;
                        }
                    }
                    this.unlock();
                    this.postWriteCleanup();
                    return null;
                }
                ** try [egrp 2[TRYBLOCK] [7 : 179->206)] { 
lbl31:
                // 1 sources

                ++this.modCount;
                var2_4 = new LoadingValueReference((ValueReference)var1_1);
                var4_10.setValueReference(var2_4);
                return var2_4;
lbl-1000:
                // 1 sources

                {
                    var4_10 = var4_10.getNext();
                    ** GOTO lbl9
lbl37:
                    // 1 sources

                    ++this.modCount;
                    var3_6 = new LoadingValueReference();
                    var1_1 = this.newEntry(var1_1, var2_3, var9_12);
                    var1_1.setValueReference(var3_6);
                    var7_8.set(var8_11, var1_1);
                    break block9;
                }
lbl43:
                // 1 sources

                finally {
                    this.unlock();
                    this.postWriteCleanup();
                }
            }
            this.unlock();
            this.postWriteCleanup();
            return var3_6;
        }

        ReferenceEntry copyEntry(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
            if (referenceEntry.getKey() == null) {
                return null;
            }
            ValueReference valueReference = referenceEntry.getValueReference();
            Object object = valueReference.get();
            if (object == null && valueReference.isActive()) {
                return null;
            }
            referenceEntry = this.map.entryFactory.copyEntry(this, referenceEntry, referenceEntry2);
            referenceEntry.setValueReference(valueReference.copyFor(this.valueReferenceQueue, object, referenceEntry));
            return referenceEntry;
        }

        /*
         * Enabled aggressive block sorting
         */
        ReferenceEntry getEntry(Object object, int n) {
            ReferenceEntry referenceEntry = this.getFirst(n);
            while (referenceEntry != null) {
                if (referenceEntry.getHash() == n) {
                    Object object2 = referenceEntry.getKey();
                    if (object2 == null) {
                        this.tryDrainReferenceQueues();
                    } else if (this.map.keyEquivalence.equivalent(object, object2)) {
                        return referenceEntry;
                    }
                }
                referenceEntry = referenceEntry.getNext();
            }
            return null;
        }

        ReferenceEntry getFirst(int n) {
            Serializable serializable = ((Segment)serializable).table;
            return (ReferenceEntry)((AtomicReferenceArray)serializable).get(n & ((AtomicReferenceArray)serializable).length() + -1);
        }

        ReferenceEntry getLiveEntry(Object object, int n, long l) {
            if ((object = this.getEntry(object, n)) == null) {
                return null;
            }
            if (this.map.isExpired((ReferenceEntry)object, l)) {
                this.tryExpireEntries(l);
                return null;
            }
            return object;
        }

        ReferenceEntry getNextEvictable() {
            ReferenceEntry referenceEntry2;
            block1: {
                for (ReferenceEntry referenceEntry2 : ((Segment)object).accessQueue) {
                    if (referenceEntry2.getValueReference().getWeight() <= 0) continue;
                    break block1;
                }
                Object object = new AssertionError();
                throw object;
            }
            return referenceEntry2;
        }

        ReferenceEntry newEntry(Object object, int n, ReferenceEntry referenceEntry) {
            return this.map.entryFactory.newEntry(this, Preconditions.checkNotNull(object), n, referenceEntry);
        }

        ReferenceEntry removeEntryFromChain(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2) {
            int n = this.count;
            ReferenceEntry referenceEntry3 = referenceEntry2.getNext();
            for (ReferenceEntry referenceEntry4 = referenceEntry; referenceEntry4 != referenceEntry2; referenceEntry4 = referenceEntry4.getNext()) {
                referenceEntry = this.copyEntry(referenceEntry4, referenceEntry3);
                if (referenceEntry == null) {
                    this.removeCollectedEntry(referenceEntry4);
                    --n;
                    referenceEntry = referenceEntry3;
                }
                referenceEntry3 = referenceEntry;
            }
            this.count = n;
            return referenceEntry3;
        }

        ReferenceEntry removeValueFromChain(ReferenceEntry referenceEntry, ReferenceEntry referenceEntry2, Object object, int n, Object object2, ValueReference valueReference, RemovalCause removalCause) {
            this.enqueueNotification(object, n, object2, valueReference.getWeight(), removalCause);
            this.writeQueue.remove(referenceEntry2);
            this.accessQueue.remove(referenceEntry2);
            if (valueReference.isLoading()) {
                valueReference.notifyNewValue(null);
                return referenceEntry;
            }
            return this.removeEntryFromChain(referenceEntry, referenceEntry2);
        }

        ListenableFuture loadAsync(Object object, int n, LoadingValueReference loadingValueReference, CacheLoader object2) {
            object2 = loadingValueReference.loadFuture(object, (CacheLoader)object2);
            LocalCache$Segment$$ExternalSyntheticLambda0 localCache$Segment$$ExternalSyntheticLambda0 = new LocalCache$Segment$$ExternalSyntheticLambda0(this, object, n, loadingValueReference, (ListenableFuture)object2);
            object2.addListener(localCache$Segment$$ExternalSyntheticLambda0, MoreExecutors.directExecutor());
            return object2;
        }

        Object get(Object object, int n) {
            block8: {
                long l;
                block9: {
                    int n2 = this.count;
                    if (n2 == 0) break block8;
                    l = this.map.ticker.read();
                    object = this.getLiveEntry(object, n, l);
                    if (object != null) break block9;
                    this.postReadCleanup();
                    return null;
                }
                try {
                    Object object2 = object.getValueReference().get();
                    if (object2 != null) {
                        this.recordRead((ReferenceEntry)object, l);
                        object = this.scheduleRefresh((ReferenceEntry)object, object.getKey(), n, object2, l, this.map.defaultLoader);
                        return object;
                    }
                    this.tryDrainReferenceQueues();
                }
                finally {
                    this.postReadCleanup();
                }
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        Object getAndRecordStats(Object var1_1, int var2_2, LoadingValueReference var3_3, ListenableFuture var4_4) throws ExecutionException {
            block6: {
                try {
                    var5_8 = Uninterruptibles.getUninterruptibly((Future)var4_4);
                    if (var5_8 != null) ** GOTO lbl16
                }
                catch (Throwable var4_5) {
                    var5_8 = null;
lbl6:
                    // 2 sources

                    while (true) {
                        if (var5_8 == null) {
                            this.statsCounter.recordLoadException(var3_3.elapsedNanos());
                            this.removeLoadingValue(var1_1, var2_2, var3_3);
                        }
                        throw var4_6;
                    }
                }
                try {
                    var6_9 = new StringBuilder();
                    var4_4 = new CacheLoader.InvalidCacheLoadException(var6_9.append("CacheLoader returned null for key ").append(var1_1).append(".").toString());
                    throw var4_4;
lbl16:
                    // 1 sources

                    this.statsCounter.recordLoadSuccess(var3_3.elapsedNanos());
                    this.storeLoadedValue(var1_1, var2_2, var3_3, var5_8);
                    if (var5_8 != null) break block6;
                    this.statsCounter.recordLoadException(var3_3.elapsedNanos());
                    this.removeLoadingValue(var1_1, var2_2, var3_3);
                }
                catch (Throwable var4_7) {
                    ** continue;
                }
            }
            return var5_8;
        }

        Object getLiveValue(ReferenceEntry referenceEntry, long l) {
            if (referenceEntry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            Object object = referenceEntry.getValueReference().get();
            if (object == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.isExpired(referenceEntry, l)) {
                this.tryExpireEntries(l);
                return null;
            }
            return object;
        }

        /*
         * Exception decompiling
         */
        Object put(Object var1_1, int var2_4, Object var3_6, boolean var4_7) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[FORLOOP]], but top level block is 12[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Object refresh(Object object, int n, CacheLoader cacheLoader, boolean bl) {
            LoadingValueReference loadingValueReference = ((Segment)this).insertLoadingValueReference(object, n, bl);
            if (loadingValueReference == null) {
                return null;
            }
            if (!(this = ((Segment)this).loadAsync(object, n, loadingValueReference, cacheLoader)).isDone()) return null;
            try {
                return Uninterruptibles.getUninterruptibly((Future)this);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Object remove(Object object, int n) {
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                int n2;
                this.preWriteCleanup(this.map.ticker.read());
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length();
                int n4 = n2 & n3 + -1;
                ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n4);
                while (referenceEntry2 != null) {
                    Object object2 = referenceEntry2.getKey();
                    int n5 = referenceEntry2.getHash();
                    if (n5 == n2 && object2 != null && (n5 = (int)(this.map.keyEquivalence.equivalent(object, object2) ? 1 : 0)) != 0) {
                        void var1_3;
                        ValueReference valueReference = referenceEntry2.getValueReference();
                        Object object3 = valueReference.get();
                        if (object3 != null) {
                            RemovalCause removalCause = RemovalCause.EXPLICIT;
                        } else {
                            boolean bl = valueReference.isActive();
                            if (!bl) return null;
                            RemovalCause removalCause = RemovalCause.COLLECTED;
                        }
                        ++this.modCount;
                        ReferenceEntry referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, object2, n2, object3, valueReference, (RemovalCause)var1_3);
                        n2 = this.count;
                        atomicReferenceArray.set(n4, referenceEntry3);
                        this.count = --n2;
                        return object3;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Object replace(Object object, int n, Object object2) {
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                int n2;
                long l = this.map.ticker.read();
                this.preWriteCleanup(l);
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length();
                int n4 = n2 & n3 + -1;
                ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n4);
                while (referenceEntry2 != null) {
                    Object object3 = referenceEntry2.getKey();
                    int n5 = referenceEntry2.getHash();
                    if (n5 == n2 && object3 != null && (n5 = (int)(this.map.keyEquivalence.equivalent(object, object3) ? 1 : 0)) != 0) {
                        void var3_5;
                        ValueReference valueReference = referenceEntry2.getValueReference();
                        Object object4 = valueReference.get();
                        if (object4 == null) {
                            boolean bl = valueReference.isActive();
                            if (!bl) return null;
                            ++this.modCount;
                            object = this.removeValueFromChain(referenceEntry, referenceEntry2, object3, n2, object4, valueReference, RemovalCause.COLLECTED);
                            n2 = this.count;
                            atomicReferenceArray.set(n4, object);
                            this.count = --n2;
                            return null;
                        }
                        ++this.modCount;
                        int n6 = valueReference.getWeight();
                        this.enqueueNotification(object, n2, object4, n6, RemovalCause.REPLACED);
                        this.setValue(referenceEntry2, object, var3_5, l);
                        this.evictEntries(referenceEntry2);
                        return object4;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        Object scheduleRefresh(ReferenceEntry referenceEntry, Object object, int n, Object object2, long l, CacheLoader cacheLoader) {
            if (((Segment)this).map.refreshes() && l - referenceEntry.getWriteTime() > ((Segment)this).map.refreshNanos && !referenceEntry.getValueReference().isLoading() && (this = ((Segment)this).refresh(object, n, cacheLoader, true)) != null) {
                return this;
            }
            return object2;
        }

        AtomicReferenceArray newEntryArray(int n) {
            Serializable serializable = new AtomicReferenceArray(n);
            return serializable;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        Segment(LocalCache queue, int n, long l, AbstractCache$StatsCounter abstractCache$StatsCounter) {
            void var2_10;
            void var2_8;
            void var2_6;
            void var2_4;
            void var5_16;
            void var3_15;
            AtomicInteger atomicInteger;
            this.readCount = atomicInteger = new AtomicInteger();
            this.map = queue;
            this.maxSegmentWeight = var3_15;
            this.statsCounter = (AbstractCache$StatsCounter)Preconditions.checkNotNull(var5_16);
            this.initTable(this.newEntryArray(n));
            if (((LocalCache)((Object)queue)).usesKeyReferences()) {
                ReferenceQueue referenceQueue = new ReferenceQueue();
            } else {
                Object var2_14 = null;
            }
            this.keyReferenceQueue = var2_4;
            if (((LocalCache)((Object)queue)).usesValueReferences()) {
                ReferenceQueue referenceQueue = new ReferenceQueue();
            } else {
                Object var2_13 = null;
            }
            this.valueReferenceQueue = var2_6;
            if (((LocalCache)((Object)queue)).usesAccessQueue()) {
                ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
            } else {
                Queue queue2 = LocalCache.discardingQueue();
            }
            this.recencyQueue = var2_8;
            if (((LocalCache)((Object)queue)).usesWriteQueue()) {
                WriteQueue writeQueue = new WriteQueue();
            } else {
                Queue queue3 = LocalCache.discardingQueue();
            }
            this.writeQueue = var2_10;
            if (((LocalCache)((Object)queue)).usesAccessQueue()) {
            } else {
                queue = LocalCache.discardingQueue();
            }
            this.accessQueue = queue;
        }

        void cleanUp() {
            this.runLockedCleanup(this.map.ticker.read());
            this.runUnlockedCleanup();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void clear() {
            int n;
            if (this.count == 0) return;
            this.lock();
            this.preWriteCleanup(this.map.ticker.read());
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = 0;
            while (true) {
                if (n2 >= (n = atomicReferenceArray.length())) break;
                for (ReferenceEntry referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n2); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    boolean bl = referenceEntry.getValueReference().isActive();
                    if (!bl) continue;
                    Object object = referenceEntry.getKey();
                    Object object2 = referenceEntry.getValueReference().get();
                    RemovalCause removalCause = object == null || object2 == null ? RemovalCause.COLLECTED : RemovalCause.EXPLICIT;
                    this.enqueueNotification(object, referenceEntry.getHash(), object2, referenceEntry.getValueReference().getWeight(), removalCause);
                }
                ++n2;
            }
            for (n2 = 0; n2 < (n = atomicReferenceArray.length()); ++n2) {
                atomicReferenceArray.set(n2, null);
            }
            this.clearReferenceQueues();
            this.writeQueue.clear();
            this.accessQueue.clear();
            this.readCount.set(0);
            ++this.modCount;
            this.count = 0;
            return;
        }

        void clearKeyReferenceQueue() {
            while (this.keyReferenceQueue.poll() != null) {
            }
        }

        void clearReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.clearKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.clearValueReferenceQueue();
                return;
            }
        }

        void clearValueReferenceQueue() {
            while (this.valueReferenceQueue.poll() != null) {
            }
        }

        void drainKeyReferenceQueue() {
            Object object;
            int n = 0;
            while ((object = this.keyReferenceQueue.poll()) != null) {
                object = (ReferenceEntry)object;
                this.map.reclaimKey((ReferenceEntry)object);
                if (++n != 16) continue;
            }
        }

        void drainRecencyQueue() {
            ReferenceEntry referenceEntry;
            while ((referenceEntry = (ReferenceEntry)this.recencyQueue.poll()) != null) {
                if (!this.accessQueue.contains(referenceEntry)) continue;
                this.accessQueue.add(referenceEntry);
            }
        }

        void drainReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.drainKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.drainValueReferenceQueue();
                return;
            }
        }

        void drainValueReferenceQueue() {
            Object object;
            int n = 0;
            while ((object = this.valueReferenceQueue.poll()) != null) {
                object = (ValueReference)object;
                this.map.reclaimValue((ValueReference)object);
                if (++n != 16) continue;
            }
        }

        void enqueueNotification(Object object, int n, Object object2, int n2, RemovalCause removalCause) {
            this.totalWeight -= (long)n2;
            if (removalCause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                object = RemovalNotification.create(object, object2, removalCause);
                this.map.removalNotificationQueue.offer(object);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void evictEntries(ReferenceEntry referenceEntry) {
            Object object;
            if (!((Segment)object).map.evictsBySize()) {
                return;
            }
            ((Segment)object).drainRecencyQueue();
            if ((long)referenceEntry.getValueReference().getWeight() > ((Segment)object).maxSegmentWeight && !((Segment)object).removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.SIZE)) {
                object = new AssertionError();
                throw object;
            }
            do {
                if (((Segment)object).totalWeight > ((Segment)object).maxSegmentWeight) continue;
                return;
            } while (((Segment)object).removeEntry(referenceEntry = ((Segment)object).getNextEvictable(), referenceEntry.getHash(), RemovalCause.SIZE));
            object = new AssertionError();
            throw object;
        }

        /*
         * Unable to fully structure code
         */
        void expand() {
            var7_1 = this.table;
            var8_2 = var7_1.length();
            if (var8_2 >= 0x40000000) {
                return;
            }
            var1_3 = this.count;
            var9_4 = this.newEntryArray(var8_2 + var8_2);
            this.threshold = var9_4.length() * 3 / 4;
            var10_5 = var9_4.length() + -1;
            block0: for (var2_6 = 0; var2_6 < var8_2; ++var2_6) {
                block12: {
                    block11: {
                        var11_14 = (ReferenceEntry)var7_1.get(var2_6);
                        if (var11_14 == null) break block11;
                        var4_8 = var11_14.getHash() & var10_5;
                        if (var5_10 != null) break block12;
                        var9_4.set(var4_8, var11_14);
                    }
                    continue block0;
                }
                var3_7 = var11_14;
                block2: for (var5_10 = var11_14.getNext(); var5_10 != null; var5_10 = var5_10.getNext()) {
                    var6_12 = var5_10.getHash() & var10_5;
                    if (var6_12 != var4_8) {
                        var3_7 = var5_10;
lbl24:
                        // 2 sources

                        while (true) {
                            var4_8 = var6_12;
                            continue block2;
                            break;
                        }
                    }
                    var6_12 = var4_8;
                    ** continue;
                }
                var9_4.set(var4_8, var3_7);
                var4_9 = var11_14;
                block4: while (true) {
                    if (var4_9 == var3_7) ** continue;
                    var5_11 = var4_9.getHash() & var10_5;
                    var6_13 = this.copyEntry(var4_9, (ReferenceEntry)var9_4.get(var5_11));
                    if (var6_13 == null) break;
                    var9_4.set(var5_11, var6_13);
lbl37:
                    // 2 sources

                    while (true) {
                        var4_9 = var4_9.getNext();
                        continue block4;
                        break;
                    }
                    break;
                }
                this.removeCollectedEntry(var4_9);
                --var1_3;
                ** continue;
            }
            this.table = var9_4;
            this.count = var1_3;
        }

        /*
         * Enabled aggressive block sorting
         */
        void expireEntries(long l) {
            Object object;
            ReferenceEntry referenceEntry;
            ((Segment)object).drainRecencyQueue();
            while ((referenceEntry = (ReferenceEntry)((Segment)object).writeQueue.peek()) != null && ((Segment)object).map.isExpired(referenceEntry, l)) {
                if (((Segment)object).removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) continue;
                object = new AssertionError();
                throw object;
            }
            while ((referenceEntry = (ReferenceEntry)((Segment)object).accessQueue.peek()) != null && ((Segment)object).map.isExpired(referenceEntry, l)) {
                if (((Segment)object).removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) continue;
                object = new AssertionError();
                throw object;
            }
        }

        void initTable(AtomicReferenceArray atomicReferenceArray) {
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            if (!this.map.customWeigher() && (long)this.threshold == this.maxSegmentWeight) {
                ++this.threshold;
            }
            this.table = atomicReferenceArray;
        }

        /* synthetic */ void lambda$loadAsync$0$com-google-common-cache-LocalCache$Segment(Object object, int n, LoadingValueReference loadingValueReference, ListenableFuture listenableFuture) {
            try {
                this.getAndRecordStats(object, n, loadingValueReference, listenableFuture);
                return;
            }
            catch (Throwable throwable) {
                logger.logp(Level.WARNING, "androidx.test.espresso.web.internal.deps.guava.cache.LocalCache$Segment", "lambda$loadAsync$0", "Exception thrown during refresh", throwable);
                loadingValueReference.setException(throwable);
                return;
            }
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.cleanUp();
                return;
            }
        }

        void postWriteCleanup() {
            this.runUnlockedCleanup();
        }

        void preWriteCleanup(long l) {
            this.runLockedCleanup(l);
        }

        void recordLockedRead(ReferenceEntry referenceEntry, long l) {
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l);
            }
            this.accessQueue.add(referenceEntry);
        }

        void recordRead(ReferenceEntry referenceEntry, long l) {
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l);
            }
            this.recencyQueue.add(referenceEntry);
        }

        void recordWrite(ReferenceEntry referenceEntry, int n, long l) {
            this.drainRecencyQueue();
            this.totalWeight += (long)n;
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l);
            }
            if (this.map.recordsWrite()) {
                referenceEntry.setWriteTime(l);
            }
            this.accessQueue.add(referenceEntry);
            this.writeQueue.add(referenceEntry);
        }

        void removeCollectedEntry(ReferenceEntry referenceEntry) {
            this.enqueueNotification(referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry.getValueReference().get(), referenceEntry.getValueReference().getWeight(), RemovalCause.COLLECTED);
            this.writeQueue.remove(referenceEntry);
            this.accessQueue.remove(referenceEntry);
        }

        void runLockedCleanup(long l) {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    this.expireEntries(l);
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                this.map.processPendingNotifications();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void setValue(ReferenceEntry referenceEntry, Object object, Object object2, long l) {
            ValueReference valueReference = referenceEntry.getValueReference();
            int n = this.map.weigher.weigh(object, object2);
            boolean bl = n >= 0;
            Preconditions.checkState(bl, "Weights must be non-negative");
            referenceEntry.setValueReference(this.map.valueStrength.referenceValue(this, referenceEntry, object2, n));
            this.recordWrite(referenceEntry, n, l);
            valueReference.notifyNewValue(object2);
        }

        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        void tryExpireEntries(long l) {
            if (this.tryLock()) {
                try {
                    this.expireEntries(l);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean containsKey(Object object, int n) {
            block4: {
                boolean bl;
                try {
                    int n2 = this.count;
                    if (n2 == 0) break block4;
                    if ((object = this.getLiveEntry(object, n, this.map.ticker.read())) == null) {
                        this.postReadCleanup();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    this.postReadCleanup();
                    throw throwable;
                }
                {
                    bl = (object = object.getValueReference().get()) != null;
                }
                this.postReadCleanup();
                return bl;
            }
            this.postReadCleanup();
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean reclaimKey(ReferenceEntry object, int n) {
            ReferenceEntry referenceEntry;
            ReferenceEntry referenceEntry2;
            int n2;
            AtomicReferenceArray atomicReferenceArray;
            this.lock();
            try {
                atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length();
                n2 = n & n3 + -1;
                referenceEntry = referenceEntry2 = (ReferenceEntry)atomicReferenceArray.get(n2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
            while (true) {
                if (referenceEntry == null) {
                    this.unlock();
                    this.postWriteCleanup();
                    return false;
                }
                if (referenceEntry == object) {
                    ++this.modCount;
                    object = referenceEntry.getKey();
                    Object object2 = referenceEntry.getValueReference().get();
                    ValueReference valueReference = referenceEntry.getValueReference();
                    object = this.removeValueFromChain(referenceEntry2, referenceEntry, object, n, object2, valueReference, RemovalCause.COLLECTED);
                    n = this.count;
                    atomicReferenceArray.set(n2, object);
                    this.count = --n;
                    return true;
                }
                referenceEntry = referenceEntry.getNext();
                continue;
                break;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean reclaimValue(Object object, int n, ValueReference valueReference) {
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n2 = atomicReferenceArray.length();
                int n3 = n & n2 + -1;
                for (ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    Object object2 = referenceEntry2.getKey();
                    int n4 = referenceEntry2.getHash();
                    if (n4 != n || object2 == null || (n4 = (int)(this.map.keyEquivalence.equivalent(object, object2) ? 1 : 0)) == 0) break block7;
                    object = referenceEntry2.getValueReference();
                    if (object != valueReference) break block8;
                    ++this.modCount;
                    object = valueReference.get();
                    object = this.removeValueFromChain(referenceEntry, referenceEntry2, object2, n, object, valueReference, RemovalCause.COLLECTED);
                    n = this.count;
                    atomicReferenceArray.set(n3, object);
                    this.count = --n;
                }
            }
            catch (Throwable throwable) {
                this.unlock();
                if (this.isHeldByCurrentThread()) {
                    throw throwable;
                }
                this.postWriteCleanup();
                throw throwable;
            }
            {
                block7: {
                    block8: {
                        this.unlock();
                        if (this.isHeldByCurrentThread()) return true;
                        this.postWriteCleanup();
                        return true;
                    }
                    this.unlock();
                    if (this.isHeldByCurrentThread()) return false;
                    this.postWriteCleanup();
                    return false;
                }
                continue;
            }
            this.unlock();
            if (this.isHeldByCurrentThread()) return false;
            this.postWriteCleanup();
            return false;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean remove(Object var1_1, int var2_6, Object var3_8) {
            block9: {
                block10: {
                    block8: {
                        this.lock();
                        try {
                            this.preWriteCleanup(this.map.ticker.read());
                            var5_10 = this.table;
                            var4_11 = var5_10.length();
                            var6_13 = var2_6 & var4_11 + -1;
                            var4_12 = var7_14 = (ReferenceEntry)var5_10.get(var6_13);
lbl9:
                            // 2 sources

                            while (var4_12 != null) {
                                var8_15 = var4_12.getKey();
                                var9_16 = var4_12.getHash();
                                if (var9_16 != var2_6 || var8_15 == null || (var9_16 = (int)this.map.keyEquivalence.equivalent(var1_1, var8_15)) == 0) ** GOTO lbl-1000
                                var9_17 = var4_12.getValueReference();
                                var10_18 = var9_17.get();
                                var1_2 = this.map.valueEquivalence.equivalent(var3_8, var10_18);
                                if (var1_2) {
                                    var1_3 = RemovalCause.EXPLICIT;
                                    break block8;
                                }
                                ** GOTO lbl-1000
                            }
                            break block9;
                        }
                        catch (Throwable var1_5) {
                            this.unlock();
                            this.postWriteCleanup();
                            throw var1_5;
                        }
                    }
lbl26:
                    // 2 sources

                    while (true) {
                        ++this.modCount;
                        var2_7 /* !! */  = this.removeValueFromChain(var7_14, var4_12, var8_15, var2_6, var10_18, var9_17, var1_3);
                        var3_9 = this.count;
                        var5_10.set(var6_13, var2_7 /* !! */ );
                        this.count = --var3_9;
                        var2_7 /* !! */  = RemovalCause.EXPLICIT;
                        var1_4 = var1_3 == var2_7 /* !! */ ;
                        this.unlock();
                        this.postWriteCleanup();
                        return var1_4;
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var10_18 != null || !(var1_2 = var9_17.isActive())) break block10;
                        var1_3 = RemovalCause.COLLECTED;
                        ** continue;
                    }
                }
                this.unlock();
                this.postWriteCleanup();
                return false;
lbl-1000:
                // 1 sources

                {
                    var4_12 = var4_12.getNext();
                    ** GOTO lbl9
                }
            }
            this.unlock();
            this.postWriteCleanup();
            return false;
        }

        boolean removeEntry(ReferenceEntry object, int n, RemovalCause removalCause) {
            ReferenceEntry referenceEntry;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() + -1;
            for (ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                if (referenceEntry2 != object) continue;
                ++this.modCount;
                object = referenceEntry2.getKey();
                Object object2 = referenceEntry2.getValueReference();
                object2 = object2.get();
                ValueReference valueReference = referenceEntry2.getValueReference();
                object = this.removeValueFromChain(referenceEntry, referenceEntry2, object, n, object2, valueReference, removalCause);
                n = this.count;
                atomicReferenceArray.set(n2, object);
                this.count = n + -1;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean removeLoadingValue(Object object, int n, LoadingValueReference loadingValueReference) {
            block9: {
                ReferenceEntry referenceEntry;
                this.lock();
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n2 = atomicReferenceArray.length();
                int n3 = n & n2 + -1;
                for (ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    boolean bl;
                    Object object2 = referenceEntry2.getKey();
                    int n4 = referenceEntry2.getHash();
                    if (n4 != n || object2 == null || !(bl = this.map.keyEquivalence.equivalent(object, object2))) continue;
                    object = referenceEntry2.getValueReference();
                    if (object == loadingValueReference) {
                        boolean bl2 = loadingValueReference.isActive();
                        if (bl2) {
                            referenceEntry2.setValueReference(loadingValueReference.getOldValue());
                            return true;
                        }
                        atomicReferenceArray.set(n3, this.removeEntryFromChain(referenceEntry, referenceEntry2));
                        return true;
                    }
                    break block9;
                }
                this.unlock();
                this.postWriteCleanup();
                return false;
            }
            this.unlock();
            this.postWriteCleanup();
            return false;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean replace(Object object, int n, Object object2, Object object3) {
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                int n2;
                long l = this.map.ticker.read();
                this.preWriteCleanup(l);
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length();
                int n4 = n2 & n3 + -1;
                ReferenceEntry referenceEntry2 = referenceEntry = (ReferenceEntry)atomicReferenceArray.get(n4);
                while (referenceEntry2 != null) {
                    Object object4 = referenceEntry2.getKey();
                    int n5 = referenceEntry2.getHash();
                    if (n5 == n2 && object4 != null && (n5 = (int)(this.map.keyEquivalence.equivalent(object, object4) ? 1 : 0)) != 0) {
                        void var3_5;
                        ValueReference valueReference = referenceEntry2.getValueReference();
                        Object object5 = valueReference.get();
                        if (object5 == null) {
                            boolean bl = valueReference.isActive();
                            if (!bl) return false;
                            ++this.modCount;
                            object = this.removeValueFromChain(referenceEntry, referenceEntry2, object4, n2, object5, valueReference, RemovalCause.COLLECTED);
                            n2 = this.count;
                            atomicReferenceArray.set(n4, object);
                            this.count = --n2;
                            return false;
                        }
                        object2 = this.map.valueEquivalence.equivalent(var3_5, object5);
                        if (object2 != false) {
                            void var4_7;
                            ++this.modCount;
                            object2 = valueReference.getWeight();
                            this.enqueueNotification(object, n2, object5, (int)object2, RemovalCause.REPLACED);
                            this.setValue(referenceEntry2, object, var4_7, l);
                            this.evictEntries(referenceEntry2);
                            return true;
                        }
                        this.recordLockedRead(referenceEntry2, l);
                        return false;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
                return false;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * Exception decompiling
         */
        boolean storeLoadedValue(Object var1_1, int var2_3, LoadingValueReference var3_5, Object var4_6) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[FORLOOP]], but top level block is 14[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static interface ValueReference {
        public int getWeight();

        public ValueReference copyFor(ReferenceQueue var1, Object var2, ReferenceEntry var3);

        public ReferenceEntry getEntry();

        public Object get();

        public void notifyNewValue(Object var1);

        public boolean isActive();

        public boolean isLoading();
    }

    private static final class NullEntry
    extends Enum
    implements ReferenceEntry {
        public static final /* enum */ NullEntry INSTANCE;
        private static final /* synthetic */ NullEntry[] $VALUES;

        @Override
        public int getHash() {
            return 0;
        }

        @Override
        public long getAccessTime() {
            return 0L;
        }

        @Override
        public long getWriteTime() {
            return 0L;
        }

        @Override
        public ValueReference getValueReference() {
            return null;
        }

        @Override
        public ReferenceEntry getNext() {
            return null;
        }

        @Override
        public ReferenceEntry getNextInAccessQueue() {
            return this;
        }

        @Override
        public ReferenceEntry getNextInWriteQueue() {
            return this;
        }

        @Override
        public ReferenceEntry getPreviousInAccessQueue() {
            return this;
        }

        @Override
        public ReferenceEntry getPreviousInWriteQueue() {
            return this;
        }

        @Override
        public Object getKey() {
            return null;
        }

        static {
            NullEntry nullEntry;
            INSTANCE = nullEntry = new NullEntry("INSTANCE", 0);
            $VALUES = nullEntryArray = new NullEntry[]{NullEntry.INSTANCE};
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private NullEntry() {
            void var2_-1;
            void var1_-1;
        }

        @Override
        public void setAccessTime(long l) {
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
        }

        @Override
        public void setValueReference(ValueReference valueReference) {
        }

        @Override
        public void setWriteTime(long l) {
        }

        public static NullEntry[] values() {
            return (NullEntry[])$VALUES.clone();
        }
    }

    final class KeySet
    extends AbstractCacheSet {
        @Override
        public Iterator<K> iterator() {
            KeyIterator keyIterator = new KeyIterator(LocalCache.this);
            return keyIterator;
        }

        KeySet() {
        }

        @Override
        public boolean contains(Object object) {
            return LocalCache.this.containsKey(object);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            if (LocalCache.this.remove(object) == null) return false;
            return true;
        }
    }

    final class Values
    extends AbstractCollection {
        @Override
        public int size() {
            return LocalCache.this.size();
        }

        @Override
        public Iterator<V> iterator() {
            ValueIterator valueIterator = new ValueIterator(LocalCache.this);
            return valueIterator;
        }

        Values() {
        }

        @Override
        public void clear() {
            LocalCache.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return LocalCache.this.containsValue(object);
        }

        @Override
        public boolean isEmpty() {
            return LocalCache.this.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            return LocalCache.toArrayList(this).toArray(EArray);
        }
    }

    final class EntrySet
    extends AbstractCacheSet {
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            EntryIterator entryIterator = new EntryIterator(LocalCache.this);
            return entryIterator;
        }

        EntrySet() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Object k = (object = (Map.Entry)object).getKey();
            if (k == null) {
                return false;
            }
            Object v = LocalCache.this.get(k);
            if (v == null) return false;
            if (!LocalCache.this.valueEquivalence.equivalent(object.getValue(), v)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Object k = (object = (Map.Entry)object).getKey();
            if (k == null) return false;
            if (!LocalCache.this.remove(k, object.getValue())) return false;
            return true;
        }
    }

    static class LocalManualCache<K, V>
    implements Cache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final LocalCache localCache;

        @Override
        public Object getIfPresent(Object object) {
            return this.localCache.getIfPresent(object);
        }

        Object writeReplace() {
            ManualSerializationProxy manualSerializationProxy = new ManualSerializationProxy(this.localCache);
            return manualSerializationProxy;
        }

        LocalManualCache(CacheBuilder cacheBuilder) {
            LocalCache localCache = new LocalCache(cacheBuilder, null);
            this(localCache);
        }

        private LocalManualCache(LocalCache localCache) {
            this.localCache = localCache;
        }

        @Override
        public void invalidateAll() {
            this.localCache.clear();
        }

        @Override
        public void put(Object object, Object object2) {
            this.localCache.put(object, object2);
        }

        private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
            Serializable serializable = new InvalidObjectException("Use ManualSerializationProxy");
            throw serializable;
        }
    }

    static class ManualSerializationProxy<K, V>
    extends ForwardingCache<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence keyEquivalence;
        final Equivalence valueEquivalence;
        final long expireAfterWriteNanos;
        final long expireAfterAccessNanos;
        final long maxWeight;
        final Weigher weigher;
        final int concurrencyLevel;
        final RemovalListener removalListener;
        final Ticker ticker;
        final CacheLoader loader;
        transient Cache delegate;

        @Override
        protected Cache delegate() {
            return this.delegate;
        }

        /*
         * Enabled aggressive block sorting
         */
        CacheBuilder recreateCacheBuilder() {
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).valueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel).removalListener(this.removalListener);
            cacheBuilder.strictParsing = false;
            if (this.expireAfterWriteNanos > 0L) {
                cacheBuilder.expireAfterWrite(this.expireAfterWriteNanos, TimeUnit.NANOSECONDS);
            }
            if (this.expireAfterAccessNanos > 0L) {
                cacheBuilder.expireAfterAccess(this.expireAfterAccessNanos, TimeUnit.NANOSECONDS);
            }
            if (this.weigher != CacheBuilder.OneWeigher.INSTANCE) {
                cacheBuilder.weigher(this.weigher);
                if (this.maxWeight != -1L) {
                    cacheBuilder.maximumWeight(this.maxWeight);
                }
            } else if (this.maxWeight != -1L) {
                cacheBuilder.maximumSize(this.maxWeight);
            }
            if (this.ticker != null) {
                cacheBuilder.ticker(this.ticker);
            }
            return cacheBuilder;
        }

        private Object readResolve() {
            return this.delegate;
        }

        ManualSerializationProxy(LocalCache localCache) {
            this(localCache.keyStrength, localCache.valueStrength, localCache.keyEquivalence, localCache.valueEquivalence, localCache.expireAfterWriteNanos, localCache.expireAfterAccessNanos, localCache.maxWeight, localCache.weigher, localCache.concurrencyLevel, localCache.removalListener, localCache.ticker, localCache.defaultLoader);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private ManualSerializationProxy(Strength object, Strength strength, Equivalence equivalence, Equivalence equivalence2, long l, long l2, long l3, Weigher weigher, int n, RemovalListener removalListener, Ticker ticker, CacheLoader cacheLoader) {
            void var15_15;
            void var1_3;
            void var14_14;
            void var13_13;
            void var12_12;
            void var11_11;
            void var9_10;
            void var7_9;
            void var5_8;
            void var4_7;
            void var3_6;
            void var2_5;
            this.keyStrength = object;
            this.valueStrength = var2_5;
            this.keyEquivalence = var3_6;
            this.valueEquivalence = var4_7;
            this.expireAfterWriteNanos = var5_8;
            this.expireAfterAccessNanos = var7_9;
            this.maxWeight = var9_10;
            this.weigher = var11_11;
            this.concurrencyLevel = var12_12;
            this.removalListener = var13_13;
            if (var14_14 == Ticker.systemTicker() || var14_14 == CacheBuilder.NULL_TICKER) {
                Object var1_2 = null;
            } else {
                void var1_4 = var14_14;
            }
            this.ticker = var1_3;
            this.loader = var15_15;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.delegate = this.recreateCacheBuilder().build();
        }
    }

    abstract class AbstractCacheSet
    extends AbstractSet {
        @Override
        public int size() {
            return LocalCache.this.size();
        }

        AbstractCacheSet() {
        }

        @Override
        public void clear() {
            LocalCache.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return LocalCache.this.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            return LocalCache.toArrayList(this).toArray(EArray);
        }
    }

    final class EntryIterator
    extends HashIterator {
        @Override
        public Map.Entry next() {
            return this.nextEntry();
        }

        EntryIterator(LocalCache localCache) {
        }
    }

    final class WriteThroughEntry
    implements Map.Entry {
        final Object key;
        Object value;

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            LocalCache localCache = LocalCache.this;
            Object object = this.key;
            localCache = localCache.put(object, v);
            this.value = v;
            return localCache;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append(this.getKey()).append("=").append(this.getValue()).toString();
        }

        WriteThroughEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) return false;
            if (!this.key.equals((object = (Map.Entry)object).getKey())) return false;
            if (!this.value.equals(object.getValue())) return false;
            return true;
        }
    }

    final class ValueIterator
    extends HashIterator {
        @Override
        public V next() {
            return this.nextEntry().getValue();
        }

        ValueIterator(LocalCache localCache) {
        }
    }

    final class KeyIterator
    extends HashIterator {
        @Override
        public K next() {
            return this.nextEntry().getKey();
        }

        KeyIterator(LocalCache localCache) {
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        int nextSegmentIndex;
        int nextTableIndex;
        Segment currentSegment;
        AtomicReferenceArray currentTable;
        ReferenceEntry nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        WriteThroughEntry nextEntry() {
            if (((HashIterator)object).nextExternal == null) {
                Object object = new NoSuchElementException();
                throw object;
            }
            ((HashIterator)object).lastReturned = ((HashIterator)object).nextExternal;
            ((HashIterator)object).advance();
            return ((HashIterator)object).lastReturned;
        }

        HashIterator() {
            this.nextSegmentIndex = LocalCache.this.segments.length + -1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (!this.nextInTable()) {
                while (this.nextSegmentIndex >= 0) {
                    Segment[] segmentArray = LocalCache.this;
                    segmentArray = segmentArray.segments;
                    int n = this.nextSegmentIndex;
                    this.nextSegmentIndex = n + -1;
                    this.currentSegment = segmentArray[n];
                    if (this.currentSegment.count == 0) continue;
                    this.currentTable = this.currentSegment.table;
                    this.nextTableIndex = this.currentTable.length() + -1;
                    if (!this.nextInTable()) continue;
                    return;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void remove() {
            boolean bl = this.lastReturned != null;
            Preconditions.checkState(bl);
            LocalCache.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }

        boolean advanceTo(ReferenceEntry object) {
            block4: {
                Object object2 = LocalCache.this;
                object2 = ((LocalCache)object2).ticker;
                long l = ((Ticker)object2).read();
                object2 = object.getKey();
                object = LocalCache.this.getLiveValue((ReferenceEntry)object, l);
                if (object == null) break block4;
                try {
                    WriteThroughEntry writeThroughEntry;
                    this.nextExternal = writeThroughEntry = new WriteThroughEntry(object2, object);
                    return true;
                }
                finally {
                    this.currentSegment.postReadCleanup();
                }
            }
            this.currentSegment.postReadCleanup();
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            if (this.nextExternal == null) return false;
            return true;
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                Object object = this.currentTable;
                int n = this.nextTableIndex;
                this.nextTableIndex = n + -1;
                this.nextEntry = object = (ReferenceEntry)((AtomicReferenceArray)object).get(n);
                if (object == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }
    }

    static final class AccessQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry head;

        @Override
        public int size() {
            int n = 0;
            for (ReferenceEntry referenceEntry = this.head.getNextInAccessQueue(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextInAccessQueue()) {
                ++n;
            }
            return n;
        }

        @Override
        public ReferenceEntry peek() {
            ReferenceEntry referenceEntry = this.head.getNextInAccessQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            return referenceEntry;
        }

        @Override
        public ReferenceEntry poll() {
            ReferenceEntry referenceEntry = this.head.getNextInAccessQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            AbstractSequentialIterator abstractSequentialIterator = new AbstractSequentialIterator(this.peek()){

                protected ReferenceEntry computeNext(ReferenceEntry referenceEntry) {
                    if ((referenceEntry = referenceEntry.getNextInAccessQueue()) == AccessQueue.this.head) {
                        return null;
                    }
                    return referenceEntry;
                }
            };
            return abstractSequentialIterator;
        }

        AccessQueue() {
            AbstractReferenceEntry abstractReferenceEntry = new AbstractReferenceEntry(this){
                ReferenceEntry nextAccess = this;
                ReferenceEntry previousAccess = this;

                @Override
                public long getAccessTime() {
                    return Long.MAX_VALUE;
                }

                @Override
                public ReferenceEntry getNextInAccessQueue() {
                    return this.nextAccess;
                }

                @Override
                public ReferenceEntry getPreviousInAccessQueue() {
                    return this.previousAccess;
                }

                @Override
                public void setAccessTime(long l) {
                }

                @Override
                public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
                    this.nextAccess = referenceEntry;
                }

                @Override
                public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
                    this.previousAccess = referenceEntry;
                }
            };
            this.head = abstractReferenceEntry;
        }

        @Override
        public void clear() {
            ReferenceEntry referenceEntry = this.head.getNextInAccessQueue();
            while (referenceEntry != this.head) {
                ReferenceEntry referenceEntry2 = referenceEntry.getNextInAccessQueue();
                LocalCache.nullifyAccessOrder(referenceEntry);
                referenceEntry = referenceEntry2;
            }
            this.head.setNextInAccessQueue(this.head);
            this.head.setPreviousInAccessQueue(this.head);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (((ReferenceEntry)object).getNextInAccessQueue() == NullEntry.INSTANCE) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEmpty() {
            if (this.head.getNextInAccessQueue() != this.head) return false;
            return true;
        }

        @Override
        public boolean offer(ReferenceEntry referenceEntry) {
            LocalCache.connectAccessOrder(referenceEntry.getPreviousInAccessQueue(), referenceEntry.getNextInAccessQueue());
            LocalCache.connectAccessOrder(this.head.getPreviousInAccessQueue(), referenceEntry);
            LocalCache.connectAccessOrder(referenceEntry, this.head);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            ReferenceEntry referenceEntry = (ReferenceEntry)object;
            object = referenceEntry.getPreviousInAccessQueue();
            ReferenceEntry referenceEntry2 = referenceEntry.getNextInAccessQueue();
            LocalCache.connectAccessOrder((ReferenceEntry)object, referenceEntry2);
            LocalCache.nullifyAccessOrder(referenceEntry);
            if (referenceEntry2 == NullEntry.INSTANCE) return false;
            return true;
        }
    }

    static final class WriteQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry head;

        @Override
        public int size() {
            int n = 0;
            for (ReferenceEntry referenceEntry = this.head.getNextInWriteQueue(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextInWriteQueue()) {
                ++n;
            }
            return n;
        }

        @Override
        public ReferenceEntry peek() {
            ReferenceEntry referenceEntry = this.head.getNextInWriteQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            return referenceEntry;
        }

        @Override
        public ReferenceEntry poll() {
            ReferenceEntry referenceEntry = this.head.getNextInWriteQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            AbstractSequentialIterator abstractSequentialIterator = new AbstractSequentialIterator(this.peek()){

                protected ReferenceEntry computeNext(ReferenceEntry referenceEntry) {
                    if ((referenceEntry = referenceEntry.getNextInWriteQueue()) == WriteQueue.this.head) {
                        return null;
                    }
                    return referenceEntry;
                }
            };
            return abstractSequentialIterator;
        }

        WriteQueue() {
            AbstractReferenceEntry abstractReferenceEntry = new AbstractReferenceEntry(this){
                ReferenceEntry nextWrite = this;
                ReferenceEntry previousWrite = this;

                @Override
                public long getWriteTime() {
                    return Long.MAX_VALUE;
                }

                @Override
                public ReferenceEntry getNextInWriteQueue() {
                    return this.nextWrite;
                }

                @Override
                public ReferenceEntry getPreviousInWriteQueue() {
                    return this.previousWrite;
                }

                @Override
                public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
                    this.nextWrite = referenceEntry;
                }

                @Override
                public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
                    this.previousWrite = referenceEntry;
                }

                @Override
                public void setWriteTime(long l) {
                }
            };
            this.head = abstractReferenceEntry;
        }

        @Override
        public void clear() {
            ReferenceEntry referenceEntry = this.head.getNextInWriteQueue();
            while (referenceEntry != this.head) {
                ReferenceEntry referenceEntry2 = referenceEntry.getNextInWriteQueue();
                LocalCache.nullifyWriteOrder(referenceEntry);
                referenceEntry = referenceEntry2;
            }
            this.head.setNextInWriteQueue(this.head);
            this.head.setPreviousInWriteQueue(this.head);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            if (((ReferenceEntry)object).getNextInWriteQueue() == NullEntry.INSTANCE) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isEmpty() {
            if (this.head.getNextInWriteQueue() != this.head) return false;
            return true;
        }

        @Override
        public boolean offer(ReferenceEntry referenceEntry) {
            LocalCache.connectWriteOrder(referenceEntry.getPreviousInWriteQueue(), referenceEntry.getNextInWriteQueue());
            LocalCache.connectWriteOrder(this.head.getPreviousInWriteQueue(), referenceEntry);
            LocalCache.connectWriteOrder(referenceEntry, this.head);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean remove(Object object) {
            ReferenceEntry referenceEntry = (ReferenceEntry)object;
            object = referenceEntry.getPreviousInWriteQueue();
            ReferenceEntry referenceEntry2 = referenceEntry.getNextInWriteQueue();
            LocalCache.connectWriteOrder((ReferenceEntry)object, referenceEntry2);
            LocalCache.nullifyWriteOrder(referenceEntry);
            if (referenceEntry2 == NullEntry.INSTANCE) return false;
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class LoadingValueReference
    implements ValueReference {
        volatile ValueReference oldValue;
        final SettableFuture futureValue = SettableFuture.create();
        final Stopwatch stopwatch = Stopwatch.createUnstarted();

        @Override
        public int getWeight() {
            return this.oldValue.getWeight();
        }

        public long elapsedNanos() {
            return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        }

        @Override
        public ValueReference copyFor(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            return this;
        }

        public ValueReference getOldValue() {
            return this.oldValue;
        }

        @Override
        public ReferenceEntry getEntry() {
            return null;
        }

        private ListenableFuture fullyFailedFuture(Throwable throwable) {
            return Futures.immediateFailedFuture(throwable);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ListenableFuture loadFuture(Object object, CacheLoader object2) {
            try {
                ((LoadingValueReference)((Object)listenableFuture)).stopwatch.start();
                Object object3 = ((LoadingValueReference)((Object)listenableFuture)).oldValue.get();
                if (object3 == null) {
                    boolean bl = ((LoadingValueReference)((Object)listenableFuture)).set(object = ((CacheLoader)object2).load(object));
                    if (!bl) return Futures.immediateFuture(object);
                    return ((LoadingValueReference)((Object)listenableFuture)).futureValue;
                }
                if ((object = ((CacheLoader)object2).reload(object, object3)) == null) {
                    return Futures.immediateFuture(null);
                }
                object2 = new LocalCache$LoadingValueReference$$ExternalSyntheticLambda0((LoadingValueReference)((Object)listenableFuture));
                return Futures.transform((ListenableFuture)object, (Function)object2, MoreExecutors.directExecutor());
            }
            catch (Throwable throwable) {
                ListenableFuture listenableFuture = ((LoadingValueReference)((Object)listenableFuture)).setException(throwable) ? ((LoadingValueReference)((Object)listenableFuture)).futureValue : ((LoadingValueReference)((Object)listenableFuture)).fullyFailedFuture(throwable);
                if (!(throwable instanceof InterruptedException)) return listenableFuture;
                Thread.currentThread().interrupt();
                return listenableFuture;
            }
        }

        @Override
        public Object get() {
            return this.oldValue.get();
        }

        /* synthetic */ Object lambda$loadFuture$0$com-google-common-cache-LocalCache$LoadingValueReference(Object object) {
            this.set(object);
            return object;
        }

        public LoadingValueReference() {
            this(LocalCache.unset());
        }

        public LoadingValueReference(ValueReference valueReference) {
            this.oldValue = valueReference;
        }

        @Override
        public void notifyNewValue(Object object) {
            if (object != null) {
                this.set(object);
                return;
            }
            this.oldValue = LocalCache.unset();
        }

        @Override
        public boolean isActive() {
            return this.oldValue.isActive();
        }

        @Override
        public boolean isLoading() {
            return true;
        }

        public boolean set(Object object) {
            return this.futureValue.set(object);
        }

        public boolean setException(Throwable throwable) {
            return this.futureValue.setException(throwable);
        }
    }

    static final class WeightedStrongValueReference
    extends StrongValueReference {
        final int weight;

        @Override
        public int getWeight() {
            return this.weight;
        }

        WeightedStrongValueReference(Object object, int n) {
            super(object);
            this.weight = n;
        }
    }

    static final class WeightedSoftValueReference
    extends SoftValueReference {
        final int weight;

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public ValueReference copyFor(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            WeightedSoftValueReference weightedSoftValueReference = new WeightedSoftValueReference(referenceQueue, object, referenceEntry, this.weight);
            return weightedSoftValueReference;
        }

        WeightedSoftValueReference(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry, int n) {
            super(referenceQueue, object, referenceEntry);
            this.weight = n;
        }
    }

    static final class WeightedWeakValueReference
    extends WeakValueReference {
        final int weight;

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public ValueReference copyFor(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            WeightedWeakValueReference weightedWeakValueReference = new WeightedWeakValueReference(referenceQueue, object, referenceEntry, this.weight);
            return weightedWeakValueReference;
        }

        WeightedWeakValueReference(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry, int n) {
            super(referenceQueue, object, referenceEntry);
            this.weight = n;
        }
    }

    static class StrongValueReference
    implements ValueReference {
        final Object referent;

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ValueReference copyFor(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            return this;
        }

        @Override
        public ReferenceEntry getEntry() {
            return null;
        }

        @Override
        public Object get() {
            return this.referent;
        }

        StrongValueReference(Object object) {
            this.referent = object;
        }

        @Override
        public void notifyNewValue(Object object) {
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isLoading() {
            return false;
        }
    }

    static class SoftValueReference
    extends SoftReference
    implements ValueReference {
        final ReferenceEntry entry;

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ValueReference copyFor(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            SoftValueReference softValueReference = new SoftValueReference(referenceQueue, object, referenceEntry);
            return softValueReference;
        }

        @Override
        public ReferenceEntry getEntry() {
            return this.entry;
        }

        SoftValueReference(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            super(object, referenceQueue);
            this.entry = referenceEntry;
        }

        @Override
        public void notifyNewValue(Object object) {
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isLoading() {
            return false;
        }
    }

    static class WeakValueReference
    extends WeakReference
    implements ValueReference {
        final ReferenceEntry entry;

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ValueReference copyFor(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            WeakValueReference weakValueReference = new WeakValueReference(referenceQueue, object, referenceEntry);
            return weakValueReference;
        }

        @Override
        public ReferenceEntry getEntry() {
            return this.entry;
        }

        WeakValueReference(ReferenceQueue referenceQueue, Object object, ReferenceEntry referenceEntry) {
            super(object, referenceQueue);
            this.entry = referenceEntry;
        }

        @Override
        public void notifyNewValue(Object object) {
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isLoading() {
            return false;
        }
    }

    static final class WeakAccessWriteEntry
    extends WeakEntry {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry nextAccess = LocalCache.nullEntry();
        ReferenceEntry previousAccess = LocalCache.nullEntry();
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry nextWrite = LocalCache.nullEntry();
        ReferenceEntry previousWrite = LocalCache.nullEntry();

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public ReferenceEntry getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public ReferenceEntry getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        WeakAccessWriteEntry(ReferenceQueue referenceQueue, Object object, int n, ReferenceEntry referenceEntry) {
            super(referenceQueue, object, n, referenceEntry);
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
            this.previousAccess = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }
    }

    static final class WeakWriteEntry
    extends WeakEntry {
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry nextWrite = LocalCache.nullEntry();
        ReferenceEntry previousWrite = LocalCache.nullEntry();

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public ReferenceEntry getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        WeakWriteEntry(ReferenceQueue referenceQueue, Object object, int n, ReferenceEntry referenceEntry) {
            super(referenceQueue, object, n, referenceEntry);
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }
    }

    static final class WeakAccessEntry
    extends WeakEntry {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry nextAccess = LocalCache.nullEntry();
        ReferenceEntry previousAccess = LocalCache.nullEntry();

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public ReferenceEntry getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        WeakAccessEntry(ReferenceQueue referenceQueue, Object object, int n, ReferenceEntry referenceEntry) {
            super(referenceQueue, object, n, referenceEntry);
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
            this.previousAccess = referenceEntry;
        }
    }

    static class WeakEntry
    extends WeakReference
    implements ReferenceEntry {
        final int hash;
        final ReferenceEntry next;
        volatile ValueReference valueReference = LocalCache.unset();

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public long getAccessTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public long getWriteTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ValueReference getValueReference() {
            return this.valueReference;
        }

        @Override
        public ReferenceEntry getNext() {
            return this.next;
        }

        @Override
        public ReferenceEntry getNextInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getNextInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getPreviousInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getPreviousInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public Object getKey() {
            return this.get();
        }

        WeakEntry(ReferenceQueue referenceQueue, Object object, int n, ReferenceEntry referenceEntry) {
            super(object, referenceQueue);
            this.hash = n;
            this.next = referenceEntry;
        }

        @Override
        public void setAccessTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setValueReference(ValueReference valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void setWriteTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }
    }

    static final class StrongAccessWriteEntry
    extends StrongEntry {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry nextAccess = LocalCache.nullEntry();
        ReferenceEntry previousAccess = LocalCache.nullEntry();
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry nextWrite = LocalCache.nullEntry();
        ReferenceEntry previousWrite = LocalCache.nullEntry();

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public ReferenceEntry getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public ReferenceEntry getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        StrongAccessWriteEntry(Object object, int n, ReferenceEntry referenceEntry) {
            super(object, n, referenceEntry);
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
            this.previousAccess = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }
    }

    static final class StrongWriteEntry
    extends StrongEntry {
        volatile long writeTime = Long.MAX_VALUE;
        ReferenceEntry nextWrite = LocalCache.nullEntry();
        ReferenceEntry previousWrite = LocalCache.nullEntry();

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public ReferenceEntry getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        StrongWriteEntry(Object object, int n, ReferenceEntry referenceEntry) {
            super(object, n, referenceEntry);
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }
    }

    static final class StrongAccessEntry
    extends StrongEntry {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry nextAccess = LocalCache.nullEntry();
        ReferenceEntry previousAccess = LocalCache.nullEntry();

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public ReferenceEntry getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        StrongAccessEntry(Object object, int n, ReferenceEntry referenceEntry) {
            super(object, n, referenceEntry);
        }

        @Override
        public void setAccessTime(long l) {
            this.accessTime = l;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
            this.previousAccess = referenceEntry;
        }
    }

    static class StrongEntry
    extends AbstractReferenceEntry {
        final Object key;
        final int hash;
        final ReferenceEntry next;
        volatile ValueReference valueReference = LocalCache.unset();

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ValueReference getValueReference() {
            return this.valueReference;
        }

        @Override
        public ReferenceEntry getNext() {
            return this.next;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        StrongEntry(Object object, int n, ReferenceEntry referenceEntry) {
            this.key = object;
            this.hash = n;
            this.next = referenceEntry;
        }

        @Override
        public void setValueReference(ValueReference valueReference) {
            this.valueReference = valueReference;
        }
    }

    static abstract class AbstractReferenceEntry
    implements ReferenceEntry {
        @Override
        public int getHash() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public long getAccessTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public long getWriteTime() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ValueReference getValueReference() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getNext() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getNextInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getNextInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getPreviousInAccessQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public ReferenceEntry getPreviousInWriteQueue() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public Object getKey() {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        AbstractReferenceEntry() {
        }

        @Override
        public void setAccessTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry referenceEntry) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setValueReference(ValueReference valueReference) {
            Object object = new UnsupportedOperationException();
            throw object;
        }

        @Override
        public void setWriteTime(long l) {
            Object object = new UnsupportedOperationException();
            throw object;
        }
    }
}

