/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.collect;

import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.base.Predicate;
import androidx.test.espresso.web.internal.deps.guava.collect.FluentIterable;
import androidx.test.espresso.web.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.internal.deps.guava.collect.ObjectArrays;
import java.util.Collection;
import java.util.Iterator;

public final class Iterables {
    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(predicate);
        FluentIterable fluentIterable = new FluentIterable(){

            @Override
            public Iterator iterator() {
                return Iterators.filter(iterable.iterator(), predicate);
            }
        };
        return fluentIterable;
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> iterable, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(function);
        FluentIterable fluentIterable = new FluentIterable(){

            @Override
            public Iterator iterator() {
                return Iterators.transform(iterable.iterator(), function);
            }
        };
        return fluentIterable;
    }

    public static Object getFirst(Iterable iterable, Object object) {
        return Iterators.getNext(iterable.iterator(), object);
    }

    public static Object getOnlyElement(Iterable iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    public static String toString(Iterable iterable) {
        return Iterators.toString(iterable.iterator());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection castOrCopyToCollection(Iterable iterable) {
        if (!(iterable instanceof Collection)) return Lists.newArrayList(iterable.iterator());
        return (Collection)iterable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEmpty(Iterable iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        if (iterable.iterator().hasNext()) return false;
        return true;
    }

    public static Object[] toArray(Iterable iterable, Class clazz) {
        return Iterables.toArray(iterable, ObjectArrays.newArray(clazz, 0));
    }

    static Object[] toArray(Iterable iterable, Object[] objectArray) {
        return Iterables.castOrCopyToCollection(iterable).toArray(objectArray);
    }
}

