/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.collect;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.base.Predicate;
import androidx.test.espresso.web.internal.deps.guava.collect.Cut;
import androidx.test.espresso.web.internal.deps.guava.collect.RangeGwtSerializationDependencies;
import java.io.Serializable;

public final class Range<C extends Comparable>
extends RangeGwtSerializationDependencies
implements Predicate<C>,
Serializable {
    private static final Range ALL;
    private static final long serialVersionUID = 0L;
    final Cut lowerBound;
    final Cut upperBound;

    static int compareOrThrow(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public static Range all() {
        return ALL;
    }

    public static Range closed(Comparable comparable, Comparable comparable2) {
        return Range.create(Cut.belowValue(comparable), Cut.aboveValue(comparable2));
    }

    static Range create(Cut cut, Cut cut2) {
        Range range = new Range(cut, cut2);
        return range;
    }

    Object readResolve() {
        if (this.equals(ALL)) {
            return Range.all();
        }
        return this;
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    private static String toString(Cut cut, Cut cut2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        cut.describeAsLowerBound(stringBuilder);
        stringBuilder.append("..");
        cut2.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    static {
        Range range;
        ALL = range = new Range(Cut.belowAll(), Cut.aboveAll());
    }

    /*
     * WARNING - void declaration
     */
    private Range(Cut cut, Cut cut2) {
        void var2_3;
        void var1_2;
        this.lowerBound = (Cut)Preconditions.checkNotNull(var1_2);
        this.upperBound = (Cut)Preconditions.checkNotNull(var2_3);
        if (var1_2.compareTo((Cut)var2_3) > 0 || var1_2 == Cut.aboveAll() || var2_3 == Cut.belowAll()) {
            StringBuilder stringBuilder = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("Invalid range: ").append(Range.toString((Cut)var1_2, (Cut)var2_3)).toString());
            throw illegalArgumentException;
        }
    }

    @Override
    @Deprecated
    public boolean apply(Comparable comparable) {
        return this.contains(comparable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(Comparable comparable) {
        Preconditions.checkNotNull(comparable);
        if (!this.lowerBound.isLessThan(comparable)) return false;
        if (this.upperBound.isLessThan(comparable)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Range)) return false;
        object = (Range)object;
        if (!this.lowerBound.equals(((Range)object).lowerBound)) return false;
        if (!this.upperBound.equals(((Range)object).upperBound)) return false;
        return true;
    }
}

