/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.collect;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.web.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.web.internal.deps.guava.collect.UnmodifiableIterator;

final class SingletonImmutableSet
extends ImmutableSet {
    final transient Object element;

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        objectArray[n] = this.element;
        return n + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public UnmodifiableIterator iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append('[').append(this.element.toString()).append(']').toString();
    }

    SingletonImmutableSet(Object object) {
        this.element = Preconditions.checkNotNull(object);
    }

    @Override
    public boolean contains(Object object) {
        return this.element.equals(object);
    }
}

