/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.base.Strings;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.DirectExecutor;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.NullnessCasts;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.OverflowAvoidingLockSupport;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.internal.InternalFutureFailureAccess;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.internal.InternalFutures;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public abstract class AbstractFuture<V>
extends InternalFutureFailureAccess
implements ListenableFuture<V> {
    static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger log;
    private static final long SPIN_THRESHOLD_NANOS = 1000L;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile Object value;
    private volatile Listener listeners;
    private volatile Waiter waiters;

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Listener access$702(AbstractFuture x0, Listener x1) {
        void var1_1;
        x0.listeners = var1_1;
        return var1_1;
    }

    private Listener clearListeners(Listener onto) {
        Listener listener;
        Object object = ATOMIC_HELPER.gasListeners((AbstractFuture)object, Listener.TOMBSTONE);
        Object object2 = listener;
        while (object != null) {
            listener = ((Listener)object).next;
            ((Listener)object).next = object2;
            object2 = object;
            object = listener;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Waiter access$802(AbstractFuture x0, Waiter x1) {
        void var1_1;
        x0.waiters = var1_1;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$302(AbstractFuture x0, Object x1) {
        void var1_1;
        x0.value = var1_1;
        return var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        block5: {
            if (Thread.interrupted()) {
                object3 = new InterruptedException();
                throw object3;
            }
            object2 = ((AbstractFuture)object3).value;
            boolean bl3 = object2 != null;
            if (bl3 & (bl2 = !(object2 instanceof SetFuture))) {
                return super.getDoneValue(object2);
            }
            Object object4 = ((AbstractFuture)object3).waiters;
            if (object4 != Waiter.TOMBSTONE) {
                object2 = new Waiter();
                do {
                    ((Waiter)object2).setNext((Waiter)object4);
                    if (ATOMIC_HELPER.casWaiters((AbstractFuture)object3, (Waiter)object4, (Waiter)object2)) break block5;
                } while ((object4 = ((AbstractFuture)object3).waiters) != Waiter.TOMBSTONE);
            }
            object4 = ((AbstractFuture)object3).value;
            object4.getClass();
            return super.getDoneValue(object4);
        }
        do {
            LockSupport.park(object3);
            if (!Thread.interrupted()) continue;
            super.removeWaiter((Waiter)object2);
            object3 = new InterruptedException();
            throw object3;
        } while (!((bl = (object = ((AbstractFuture)object3).value) != null) & (bl2 = !(object instanceof SetFuture))));
        return super.getDoneValue(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        CharSequence charSequence;
        CharSequence charSequence2;
        Object object;
        Object object2;
        block24: {
            Object object3;
            boolean bl;
            long l;
            block23: {
                Object object4;
                block22: {
                    block21: {
                        long l2;
                        long l3;
                        boolean bl2;
                        long l4;
                        block20: {
                            Waiter waiter;
                            long l5;
                            block16: {
                                block18: {
                                    Waiter waiter2;
                                    block19: {
                                        block17: {
                                            long l6;
                                            l5 = unit.toNanos(l4);
                                            if (Thread.interrupted()) {
                                                object2 = new InterruptedException();
                                                throw object2;
                                            }
                                            Object object5 = ((AbstractFuture)object2).value;
                                            boolean bl3 = object5 != null;
                                            if (bl3 & (bl2 = !(object5 instanceof SetFuture))) {
                                                return super.getDoneValue(object5);
                                            }
                                            l3 = l5 > 0L ? (l6 = System.nanoTime() + l5) : 0L;
                                            if (l5 < 1000L) break block17;
                                            waiter2 = ((AbstractFuture)object2).waiters;
                                            if (waiter2 == Waiter.TOMBSTONE) break block18;
                                            break block19;
                                        }
                                        l2 = l5;
                                        break block20;
                                    }
                                    waiter = new Waiter();
                                    Waiter waiter3 = waiter2;
                                    while (true) {
                                        waiter.setNext(waiter3);
                                        if (!ATOMIC_HELPER.casWaiters((AbstractFuture)object2, waiter3, waiter)) {
                                            waiter2 = ((AbstractFuture)object2).waiters;
                                            if (waiter2 == Waiter.TOMBSTONE) break;
                                            waiter3 = waiter2;
                                            continue;
                                        }
                                        break block16;
                                        break;
                                    }
                                }
                                object = ((AbstractFuture)object2).value;
                                object.getClass();
                                return super.getDoneValue(object);
                            }
                            long l7 = l5;
                            while (true) {
                                OverflowAvoidingLockSupport.parkNanos(object2, l7);
                                if (Thread.interrupted()) {
                                    super.removeWaiter(waiter);
                                    object2 = new InterruptedException();
                                    throw object2;
                                }
                                object4 = ((AbstractFuture)object2).value;
                                boolean bl4 = object4 != null;
                                if (bl4 & (bl2 = !(object4 instanceof SetFuture))) {
                                    return super.getDoneValue(object4);
                                }
                                long l8 = l3 - System.nanoTime();
                                if (l8 < 1000L) {
                                    super.removeWaiter(waiter);
                                    l2 = l8;
                                    break;
                                }
                                l7 = l8;
                            }
                        }
                        while (l2 > 0L) {
                            long l9;
                            object4 = ((AbstractFuture)object2).value;
                            boolean bl5 = object4 != null;
                            if (bl5 & (bl2 = !(object4 instanceof SetFuture))) {
                                return super.getDoneValue(object4);
                            }
                            if (Thread.interrupted()) {
                                object2 = new InterruptedException();
                                throw object2;
                            }
                            l2 = l9 = l3 - System.nanoTime();
                        }
                        charSequence2 = ((AbstractFuture)object2).toString();
                        charSequence = ((Enum)object).toString().toLowerCase(Locale.ROOT);
                        object4 = new StringBuilder();
                        object4 = ((StringBuilder)object4).append("Waited ").append(l4).append(" ").append(((Enum)object).toString().toLowerCase(Locale.ROOT)).toString();
                        if (l2 + 1000L >= 0L) break block21;
                        StringBuilder stringBuilder = new StringBuilder();
                        object4 = stringBuilder.append((String)object4).append(" (plus ").toString();
                        l4 = -l2;
                        long l10 = ((TimeUnit)((Object)object)).convert(l4, TimeUnit.NANOSECONDS);
                        l = l4 - ((TimeUnit)((Object)object)).toNanos(l10);
                        bl = l10 == 0L || l > 1000L;
                        if (l10 <= 0L) break block22;
                        stringBuilder = new StringBuilder();
                        charSequence = stringBuilder.append((String)object4).append(l10).append(" ").append((String)charSequence).toString();
                        if (bl) {
                            object4 = new StringBuilder();
                            charSequence = ((StringBuilder)object4).append((String)charSequence).append(",").toString();
                            object3 = charSequence;
                        } else {
                            object3 = charSequence;
                        }
                        charSequence = new StringBuilder();
                        charSequence = ((StringBuilder)charSequence).append((String)object3).append(" ").toString();
                        object3 = charSequence;
                        break block23;
                    }
                    object = object4;
                    break block24;
                }
                object3 = object4;
            }
            if (bl) {
                object = new StringBuilder();
                object = ((StringBuilder)object).append((String)object3).append(l).append(" nanoseconds ").toString();
            } else {
                object = object3;
            }
            charSequence = new StringBuilder();
            object = ((StringBuilder)charSequence).append((String)object).append("delay)").toString();
        }
        if (((AbstractFuture)object2).isDone()) {
            charSequence2 = new StringBuilder();
            object2 = new TimeoutException(((StringBuilder)charSequence2).append((String)object).append(" but future completed as timeout expired").toString());
            throw object2;
        }
        charSequence = new StringBuilder();
        object2 = new TimeoutException(((StringBuilder)charSequence).append((String)object).append(" for ").append((String)charSequence2).toString());
        throw object2;
    }

    /*
     * WARNING - void declaration
     */
    private V getDoneValue(Object obj) throws ExecutionException {
        void var1_1;
        if (obj instanceof Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)var1_1).cause);
        }
        if (var1_1 instanceof Failure) {
            Object object = new ExecutionException(((Failure)var1_1).exception);
            throw object;
        }
        if (var1_1 == NULL) {
            return (V)NullnessCasts.uncheckedNull();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getFutureValue(ListenableFuture<?> future) {
        void var1_5;
        Throwable throwable;
        Object object;
        if (future instanceof Trusted) {
            object = ((AbstractFuture)object).value;
            if (object instanceof Cancellation) {
                Cancellation cancellation = (Cancellation)object;
                if (cancellation.wasInterrupted) {
                    object = cancellation.cause != null ? new Cancellation(false, cancellation.cause) : Cancellation.CAUSELESS_CANCELLED;
                }
            }
            object.getClass();
            return object;
        }
        if (object instanceof InternalFutureFailureAccess && (throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)object)) != null) {
            return new Failure(throwable);
        }
        int n = object.isCancelled();
        if (!GENERATE_CANCELLATION_CAUSES) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        if ((var1_5 & n) != 0) {
            object = Cancellation.CAUSELESS_CANCELLED;
            object.getClass();
            return object;
        }
        try {
            void var1_9;
            Object v = AbstractFuture.getUninterruptibly(object);
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(object).toString());
                return new Cancellation(false, illegalArgumentException);
            }
            if (v != null) return var1_9;
            Object object2 = NULL;
            return var1_9;
        }
        catch (ExecutionException executionException) {
            if (n == 0) return new Failure(executionException.getCause());
            StringBuilder stringBuilder = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(object).toString(), executionException);
            return new Cancellation(false, illegalArgumentException);
        }
        catch (CancellationException cancellationException) {
            if (n != 0) return new Cancellation(false, cancellationException);
            StringBuilder stringBuilder = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() threw CancellationException, despite reporting isCancelled() == false: ").append(object).toString(), cancellationException);
            return new Failure(illegalArgumentException);
        }
        catch (Error | RuntimeException throwable2) {
            return new Failure(throwable2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            V v;
            try {
                Future<V> future2;
                v = future2.get();
                if (!bl) return v;
                Thread.currentThread().interrupt();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    throw throwable;
                }
                Thread.currentThread().interrupt();
                throw throwable;
            }
            return v;
            break;
        }
    }

    protected String pendingToString() {
        if (this instanceof ScheduledFuture) {
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append("remaining delay=[").append(((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS)).append(" ms]").toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getClass().getName().startsWith("androidx.test.espresso.web.internal.deps.guava.util.concurrent.")) {
            stringBuilder.append(this.getClass().getSimpleName());
        } else {
            stringBuilder.append(this.getClass().getName());
        }
        stringBuilder.append('@').append(Integer.toHexString(System.identityHashCode(this))).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
            return stringBuilder.append("]").toString();
        }
        if (this.isDone()) {
            this.addDoneString(stringBuilder);
            return stringBuilder.append("]").toString();
        }
        this.addPendingString(stringBuilder);
        return stringBuilder.append("]").toString();
    }

    @Override
    protected final Throwable tryInternalFastPathGetFailure() {
        if (this instanceof Trusted && (this = ((AbstractFuture)this).value) instanceof Failure) {
            return ((Failure)this).exception;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static CancellationException cancellationExceptionWithCause(String message, Throwable cause) {
        void var1_1;
        String string;
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause((Throwable)var1_1);
        return cancellationException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Class<Waiter> clazz;
        Throwable throwable;
        Object object;
        boolean bl;
        try {
            bl = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        GENERATE_CANCELLATION_CAUSES = bl;
        log = Logger.getLogger(AbstractFuture.class.getName());
        try {
            object = new UnsafeAtomicHelper();
            throwable = null;
            clazz = null;
        }
        catch (Error | RuntimeException throwable2) {
            try {
                clazz = Waiter.class;
                Class<Thread> clazz2 = Thread.class;
                String string = "thread";
                object = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(clazz, clazz2, string), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
                clazz = null;
            }
            catch (Error | RuntimeException throwable3) {
                object = new SynchronizedHelper();
            }
        }
        ATOMIC_HELPER = object;
        if (clazz != null) {
            log.logp(Level.SEVERE, "androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "UnsafeAtomicHelper is broken!", throwable);
            log.logp(Level.SEVERE, "androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "SafeAtomicHelper is broken!", (Throwable)((Object)clazz));
        }
        NULL = object = new Object();
    }

    protected AbstractFuture() {
    }

    /*
     * WARNING - void declaration
     */
    private void addDoneString(StringBuilder builder) {
        void var1_3;
        try {
            V v = AbstractFuture.getUninterruptibly(this);
            var1_3.append("SUCCESS, result=[");
            this.appendResultObject((StringBuilder)var1_3, v);
            var1_3.append("]");
            return;
        }
        catch (ExecutionException executionException) {
            var1_3.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            var1_3.append("CANCELLED");
            return;
        }
        catch (RuntimeException runtimeException) {
            var1_3.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(Runnable listener, Executor executor) {
        void var1_1;
        Listener listener2;
        void var2_2;
        Preconditions.checkNotNull(listener, "Runnable was null.");
        Preconditions.checkNotNull(var2_2, "Executor was null.");
        if (!this.isDone() && (listener2 = this.listeners) != Listener.TOMBSTONE) {
            Listener listener3 = new Listener((Runnable)var1_1, (Executor)var2_2);
            do {
                listener3.next = listener2;
                if (!ATOMIC_HELPER.casListeners(this, listener2, listener3)) continue;
                return;
            } while ((listener2 = this.listeners) != Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener((Runnable)var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addPendingString(StringBuilder builder) {
        void var1_1;
        int n = builder.length();
        var1_1.append("PENDING");
        Object object = this.value;
        if (object instanceof SetFuture) {
            var1_1.append(", setFuture=[");
            this.appendUserObject((StringBuilder)var1_1, ((SetFuture)object).future);
            var1_1.append("]");
        } else {
            try {
                object = Strings.emptyToNull(this.pendingToString());
            }
            catch (RuntimeException | StackOverflowError throwable) {
                StringBuilder stringBuilder = new StringBuilder();
                object = stringBuilder.append("Exception thrown from implementation: ").append(throwable.getClass()).toString();
            }
            if (object != null) {
                var1_1.append(", info=[").append((String)object).append("]");
            }
        }
        if (this.isDone()) {
            var1_1.delete(n, var1_1.length());
            this.addDoneString((StringBuilder)var1_1);
            return;
        }
    }

    protected void afterDone() {
    }

    /*
     * WARNING - void declaration
     */
    private void appendResultObject(StringBuilder builder, Object o) {
        void var2_2;
        void var1_1;
        if (o == null) {
            var1_1.append("null");
            return;
        }
        if (var2_2 == this) {
            var1_1.append("this future");
            return;
        }
        var1_1.append(var2_2.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(var2_2)));
    }

    /*
     * Unable to fully structure code
     */
    private void appendUserObject(StringBuilder builder, Object o) {
        if (o != this) ** GOTO lbl6
        try {
            var1_2.append("this future");
            return;
lbl6:
            // 1 sources

            var1_2.append(var2_3);
            return;
        }
        catch (RuntimeException | StackOverflowError var0_1) {
            var1_2.append("Exception thrown from implementation: ").append(var0_1.getClass());
            return;
        }
    }

    private static void complete(AbstractFuture<?> param) {
        Listener listener = null;
        block0: while (true) {
            Object object;
            super.releaseWaiters();
            ((AbstractFuture)object).afterDone();
            object = super.clearListeners(listener);
            while (object != null) {
                listener = ((Listener)object).next;
                Object object2 = ((Listener)object).task;
                object2.getClass();
                if (object2 instanceof SetFuture) {
                    object = (SetFuture)object2;
                    object2 = ((SetFuture)object).owner;
                    if (((AbstractFuture)object2).value == object) {
                        Object object3 = ((SetFuture)object).future;
                        if (ATOMIC_HELPER.casValue((AbstractFuture)object2, object, object3 = AbstractFuture.getFutureValue(object3))) {
                            object = object2;
                            continue block0;
                        }
                        object = listener;
                        continue;
                    }
                    object = listener;
                    continue;
                }
                object = ((Listener)object).executor;
                object.getClass();
                AbstractFuture.executeListener((Runnable)object2, (Executor)object);
                object = listener;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void executeListener(Runnable runnable, Executor executor) {
        Runnable runnable2;
        try {
            executor.execute(runnable2);
            return;
        }
        catch (RuntimeException runtimeException) {
            void var1_1;
            Logger logger = log;
            Level level = Level.SEVERE;
            StringBuilder stringBuilder = new StringBuilder();
            logger.logp(level, "androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture", "executeListener", stringBuilder.append("RuntimeException while executing runnable ").append(runnable2).append(" with executor ").append(var1_1).toString(), runtimeException);
            return;
        }
    }

    protected void interruptTask() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void maybePropagateCancellationTo(Future<?> related) {
        boolean bl = related != null;
        if (bl & this.isCancelled()) {
            void var1_1;
            var1_1.cancel(this.wasInterrupted());
            return;
        }
    }

    private void releaseWaiters() {
        Object object = ATOMIC_HELPER.gasWaiters((AbstractFuture)object, Waiter.TOMBSTONE);
        while (object != null) {
            ((Waiter)object).unpark();
            object = ((Waiter)object).next;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter node) {
        node.thread = null;
        block0: while ((var2_2 = this.waiters) != Waiter.TOMBSTONE) {
            var1_1 = null;
            block1: while (var2_2 != null) {
                block4: {
                    var3_3 = var2_2.next;
                    if (var2_2.thread != null) {
                        var1_1 = var2_2;
lbl8:
                        // 3 sources

                        while (true) {
                            var2_2 = var3_3;
                            continue block1;
                            break;
                        }
                    }
                    if (var1_1 == null) break block4;
                    var1_1.next = var3_3;
                    if (var1_1.thread != null) ** GOTO lbl8
                    continue block0;
                }
                if (!AbstractFuture.ATOMIC_HELPER.casWaiters(this, var2_2, var3_3)) ** break;
                ** continue;
                continue block0;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Cancellation cancellation;
        void var1_2;
        Object object = ((AbstractFuture)this_).value;
        boolean bl = object == null;
        if (!(bl | object instanceof SetFuture)) {
            return false;
        }
        if (GENERATE_CANCELLATION_CAUSES) {
            CancellationException cancellationException = new CancellationException("Future.cancel() was called.");
            cancellation = new Cancellation((boolean)var1_2, cancellationException);
        } else {
            cancellation = var1_2 != false ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED;
            cancellation.getClass();
        }
        boolean bl2 = false;
        AbstractFuture abstractFuture = this_;
        while (true) {
            if (ATOMIC_HELPER.casValue(abstractFuture, object, cancellation)) {
                if (var1_2 != false) {
                    abstractFuture.interruptTask();
                }
                AbstractFuture.complete(abstractFuture);
                if (!(object instanceof SetFuture)) {
                    return true;
                }
                ListenableFuture<Object> this_ = ((SetFuture)object).future;
                if (!(this_ instanceof Trusted)) {
                    this_.cancel((boolean)var1_2);
                    return true;
                }
                abstractFuture = this_;
                object = abstractFuture.value;
                boolean bl3 = object == null;
                if (!(bl3 | object instanceof SetFuture)) {
                    return true;
                }
                bl2 = true;
                continue;
            }
            object = abstractFuture.value;
            if (!(object instanceof SetFuture)) break;
        }
        return bl2;
    }

    @Override
    public boolean isCancelled() {
        return this.value instanceof Cancellation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isDone() {
        boolean bl;
        Object object = this.value;
        boolean bl2 = object != null;
        if (!(object instanceof SetFuture)) {
            bl = true;
            return bl2 & bl;
        }
        bl = false;
        return bl2 & bl;
    }

    protected boolean set(V value) {
        Object object;
        if (value == null) {
            object = NULL;
        }
        if (ATOMIC_HELPER.casValue(this, null, object)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setException(Throwable throwable) {
        void var1_1;
        Failure failure = new Failure((Throwable)Preconditions.checkNotNull(var1_1));
        if (ATOMIC_HELPER.casValue(this, null, failure)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setFuture(ListenableFuture<? extends V> future) {
        Object object;
        Object object2;
        Preconditions.checkNotNull(future);
        SetFuture setFuture = ((AbstractFuture)object).value;
        if (setFuture == null) {
            if (object2.isDone()) {
                if (!ATOMIC_HELPER.casValue((AbstractFuture)object, null, object2 = AbstractFuture.getFutureValue(object2))) return false;
                AbstractFuture.complete(object);
                return true;
            }
            setFuture = new SetFuture((AbstractFuture)object, (ListenableFuture)object2);
            if (ATOMIC_HELPER.casValue((AbstractFuture)object, null, setFuture)) {
                object2.addListener(setFuture, DirectExecutor.INSTANCE);
                return true;
            }
            object = ((AbstractFuture)object).value;
        } else {
            object = setFuture;
        }
        if (!(object instanceof Cancellation)) return false;
        object2.cancel(((Cancellation)object).wasInterrupted);
        return false;
        catch (Error | RuntimeException throwable) {
            Failure failure;
            try {
                Failure failure2;
                failure = failure2 = new Failure(throwable);
            }
            catch (Error | RuntimeException throwable2) {
                failure = Failure.FALLBACK_INSTANCE;
            }
            ATOMIC_HELPER.casValue((AbstractFuture)object, setFuture, failure);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean wasInterrupted() {
        Object this_ = ((AbstractFuture)this_).value;
        if (!(this_ instanceof Cancellation)) return false;
        if (!((Cancellation)this_).wasInterrupted) return false;
        return true;
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE;
        volatile Thread thread;
        volatile Waiter next;

        static {
            Waiter waiter;
            TOMBSTONE = waiter = new Waiter(false);
        }

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        Waiter(boolean bl) {
        }

        void setNext(Waiter waiter) {
            ATOMIC_HELPER.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
                return;
            }
        }
    }

    private static final class Listener {
        static final Listener TOMBSTONE;
        final Runnable task;
        final Executor executor;
        Listener next;

        static {
            Listener listener;
            TOMBSTONE = listener = new Listener();
        }

        Listener() {
            this.task = null;
            this.executor = null;
        }

        Listener(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }
    }

    private static abstract class AtomicHelper {
        abstract Listener gasListeners(AbstractFuture var1, Listener var2);

        abstract Waiter gasWaiters(AbstractFuture var1, Waiter var2);

        private AtomicHelper() {
        }

        abstract void putNext(Waiter var1, Waiter var2);

        abstract void putThread(Waiter var1, Thread var2);

        abstract boolean casListeners(AbstractFuture var1, Listener var2, Listener var3);

        abstract boolean casValue(AbstractFuture var1, Object var2, Object var3);

        abstract boolean casWaiters(AbstractFuture var1, Waiter var2, Waiter var3);
    }

    private static final class SetFuture<V>
    implements Runnable {
        final AbstractFuture<V> owner;
        final ListenableFuture<? extends V> future;

        SetFuture(AbstractFuture abstractFuture, ListenableFuture listenableFuture) {
            this.owner = abstractFuture;
            this.future = listenableFuture;
        }

        @Override
        public void run() {
            if (((AbstractFuture)this.owner).value != this) {
                return;
            }
            Object object = this.future;
            object = AbstractFuture.getFutureValue(object);
            if (ATOMIC_HELPER.casValue(this.owner, this, object)) {
                AbstractFuture.complete((AbstractFuture)this.owner);
                return;
            }
        }
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_INTERRUPTED;
        static final Cancellation CAUSELESS_CANCELLED;
        final boolean wasInterrupted;
        final Throwable cause;

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                Cancellation cancellation;
                CAUSELESS_CANCELLED = cancellation = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = cancellation = new Cancellation(true, null);
            }
        }

        Cancellation(boolean bl, Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE;
        final Throwable exception;

        static {
            Failure failure;
            Throwable throwable = new Throwable("Failure occurred while trying to finish a future."){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
            FALLBACK_INSTANCE = failure = new Failure(throwable);
        }

        Failure(Throwable throwable) {
            this.exception = (Throwable)Preconditions.checkNotNull(throwable);
        }
    }

    static interface Trusted<V>
    extends ListenableFuture<V> {
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final Unsafe UNSAFE;
        static final long LISTENERS_OFFSET;
        static final long WAITERS_OFFSET;
        static final long VALUE_OFFSET;
        static final long WAITER_THREAD_OFFSET;
        static final long WAITER_NEXT_OFFSET;

        @Override
        Listener gasListeners(AbstractFuture abstractFuture, Listener listener) {
            Listener listener2;
            do {
                if (listener != (listener2 = abstractFuture.listeners)) continue;
                return listener2;
            } while (!this.casListeners(abstractFuture, listener2, listener));
            return listener2;
        }

        @Override
        Waiter gasWaiters(AbstractFuture abstractFuture, Waiter waiter) {
            Waiter waiter2;
            do {
                if (waiter != (waiter2 = abstractFuture.waiters)) continue;
                return waiter2;
            } while (!this.casWaiters(abstractFuture, waiter2, waiter));
            return waiter2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            PrivilegedExceptionAction<Unsafe> privilegedExceptionAction;
            try {
                privilegedExceptionAction = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    privilegedExceptionAction = new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            Field[] fieldArray = clazz.getDeclaredFields();
                            int n = fieldArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 < n) {
                                    Object object = fieldArray[n2];
                                    ((Field)object).setAccessible(true);
                                    object = ((Field)object).get(null);
                                    if (clazz.isInstance(object)) {
                                        return (Unsafe)clazz.cast(object);
                                    }
                                } else {
                                    NoSuchFieldError noSuchFieldError = new NoSuchFieldError("the Unsafe");
                                    throw noSuchFieldError;
                                }
                                ++n2;
                            }
                        }
                    };
                    privilegedExceptionAction = (Unsafe)AccessController.doPrivileged(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    RuntimeException runtimeException = new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                    throw runtimeException;
                }
            }
            try {
                Class<AbstractFuture> clazz = AbstractFuture.class;
                WAITERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("waiters"));
                LISTENERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("listeners"));
                VALUE_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("value"));
                WAITER_THREAD_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("thread"));
                WAITER_NEXT_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("next"));
                UNSAFE = privilegedExceptionAction;
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                RuntimeException runtimeException = new RuntimeException(noSuchFieldException);
                throw runtimeException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }

        private UnsafeAtomicHelper() {
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            UNSAFE.putObject(waiter, WAITER_NEXT_OFFSET, waiter2);
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            UNSAFE.putObject(waiter, WAITER_THREAD_OFFSET, thread);
        }

        @Override
        boolean casListeners(AbstractFuture abstractFuture, Listener listener, Listener listener2) {
            return AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(UNSAFE, abstractFuture, LISTENERS_OFFSET, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture abstractFuture, Object object, Object object2) {
            return AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(UNSAFE, abstractFuture, VALUE_OFFSET, object, object2);
        }

        @Override
        boolean casWaiters(AbstractFuture abstractFuture, Waiter waiter, Waiter waiter2) {
            return AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(UNSAFE, abstractFuture, WAITERS_OFFSET, waiter, waiter2);
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Waiter> waitersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Object> valueUpdater;

        @Override
        Listener gasListeners(AbstractFuture abstractFuture, Listener listener) {
            return this.listenersUpdater.getAndSet(abstractFuture, listener);
        }

        @Override
        Waiter gasWaiters(AbstractFuture abstractFuture, Waiter waiter) {
            return this.waitersUpdater.getAndSet(abstractFuture, waiter);
        }

        SafeAtomicHelper(AtomicReferenceFieldUpdater atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            this.waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            this.waiterThreadUpdater.lazySet(waiter, thread);
        }

        @Override
        boolean casListeners(AbstractFuture abstractFuture, Listener listener, Listener listener2) {
            return AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.listenersUpdater, abstractFuture, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture abstractFuture, Object object, Object object2) {
            return AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.valueUpdater, abstractFuture, object, object2);
        }

        @Override
        boolean casWaiters(AbstractFuture abstractFuture, Waiter waiter, Waiter waiter2) {
            return AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.waitersUpdater, abstractFuture, waiter, waiter2);
        }
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Listener gasListeners(AbstractFuture abstractFuture, Listener listener) {
            synchronized (abstractFuture) {
                Listener listener2 = abstractFuture.listeners;
                if (listener2 == listener) return listener2;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$702(abstractFuture, listener);
                    return listener2;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Waiter gasWaiters(AbstractFuture abstractFuture, Waiter waiter) {
            synchronized (abstractFuture) {
                Waiter waiter2 = abstractFuture.waiters;
                if (waiter2 == waiter) return waiter2;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$802(abstractFuture, waiter);
                    return waiter2;
                }
            }
        }

        private SynchronizedHelper() {
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casListeners(AbstractFuture abstractFuture, Listener listener, Listener listener2) {
            synchronized (abstractFuture) {
                Listener listener3 = abstractFuture.listeners;
                if (listener3 != listener) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$702(abstractFuture, listener2);
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casValue(AbstractFuture abstractFuture, Object object, Object object2) {
            synchronized (abstractFuture) {
                Object object3 = abstractFuture.value;
                if (object3 != object) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$302(abstractFuture, object2);
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casWaiters(AbstractFuture abstractFuture, Waiter waiter, Waiter waiter2) {
            synchronized (abstractFuture) {
                Waiter waiter3 = abstractFuture.waiters;
                if (waiter3 != waiter) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$802(abstractFuture, waiter2);
                    return true;
                }
            }
        }
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V>
    implements Trusted<V> {
        @Override
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l, timeUnit);
        }

        TrustedFuture() {
        }

        @Override
        public final void addListener(Runnable runnable, Executor executor) {
            super.addListener(runnable, executor);
        }

        @Override
        public final boolean cancel(boolean bl) {
            return super.cancel(bl);
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }
    }
}

