/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ExecutionList;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ListenableFutureTask<V>
extends FutureTask<V>
implements ListenableFuture<V> {
    private final ExecutionList executionList;

    public static ListenableFutureTask create(Callable callable) {
        ListenableFutureTask listenableFutureTask = new ListenableFutureTask(callable);
        return listenableFutureTask;
    }

    public static ListenableFutureTask create(Runnable runnable, Object object) {
        ListenableFutureTask listenableFutureTask = new ListenableFutureTask(runnable, object);
        return listenableFutureTask;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws TimeoutException, InterruptedException, ExecutionException {
        long l2 = timeUnit.toNanos(l);
        if (l2 <= 2147483647999999999L) {
            return super.get(l, timeUnit);
        }
        return super.get(Math.min(l2, 2147483647999999999L), TimeUnit.NANOSECONDS);
    }

    ListenableFutureTask(Callable object) {
        super(object);
        this.executionList = object = new ExecutionList();
    }

    ListenableFutureTask(Runnable object, Object object2) {
        super((Runnable)object, object2);
        this.executionList = object = new ExecutionList();
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        this.executionList.add(runnable, executor);
    }

    @Override
    protected void done() {
        this.executionList.execute();
    }
}

