/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Uninterruptibles {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getUninterruptibly(Future future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            try {
                Object v = future.get();
                if (!bl) return v;
                Thread.currentThread().interrupt();
                return v;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    throw throwable;
                }
                Thread.currentThread().interrupt();
                throw throwable;
            }
            break;
        }
    }
}

