/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.matcher;

import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.matcher.AmbiguousElementMatcherException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DomMatchers {
    public static Matcher<Document> containingTextInBody(String text) {
        String string;
        Preconditions.checkNotNull(text);
        return DomMatchers.withBody(DomMatchers.withTextContent((Matcher<String>)Matchers.containsString((String)string)));
    }

    /*
     * WARNING - void declaration
     */
    public static Matcher<Document> elementById(String id, Matcher<Element> elementMatcher) {
        void var1_1;
        String string;
        ElementByIdMatcher elementByIdMatcher = new ElementByIdMatcher(string, (Matcher<Element>)var1_1);
        return elementByIdMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static Matcher<Document> elementByXPath(String xpath, Matcher<Element> elementMatcher) {
        void var1_1;
        String string;
        ElementByXPathMatcher elementByXPathMatcher = new ElementByXPathMatcher(string, (Matcher<Element>)var1_1);
        return elementByXPathMatcher;
    }

    public static Matcher<Document> hasElementWithId(String id) {
        String string;
        HasElementWithIdMatcher hasElementWithIdMatcher = new HasElementWithIdMatcher(string);
        return hasElementWithIdMatcher;
    }

    public static Matcher<Document> hasElementWithXpath(String xpath) {
        String string;
        HasElementWithXPathMatcher hasElementWithXPathMatcher = new HasElementWithXPathMatcher(string);
        return hasElementWithXPathMatcher;
    }

    public static Matcher<Document> withBody(Matcher<Element> bodyMatcher) {
        Matcher<Element> matcher;
        WithBodyMatcher withBodyMatcher = new WithBodyMatcher(matcher);
        return withBodyMatcher;
    }

    public static Matcher<Element> withTextContent(String textContent) {
        return DomMatchers.withTextContent((Matcher<String>)Matchers.is((Object)textContent));
    }

    public static Matcher<Element> withTextContent(Matcher<String> textContentMatcher) {
        Matcher<String> matcher;
        WithTextContentMatcher withTextContentMatcher = new WithTextContentMatcher(matcher);
        return withTextContentMatcher;
    }

    /*
     * WARNING - void declaration
     */
    private static NodeList extractNodeListForXPath(String xpath, Document document) {
        try {
            void var1_1;
            Object object;
            object = XPathFactory.newInstance().newXPath().compile((String)object);
            object = (NodeList)object.evaluate(var1_1, XPathConstants.NODESET);
            return object;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    private DomMatchers() {
    }

    static final class WithBodyMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final Matcher<Element> bodyMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        WithBodyMatcher(Matcher<Element> bodyMatcher) {
            void var1_1;
            this.bodyMatcher = (Matcher)Preconditions.checkNotNull(var1_1, "bodyMatcher cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            description.appendText("with body: ");
            this.bodyMatcher.describeTo((Description)var1_1);
        }

        public boolean matchesSafely(Document document) {
            NodeList nodeList = document.getElementsByTagName("body");
            if (nodeList.getLength() == 0) {
                return false;
            }
            return this.bodyMatcher.matches((Object)nodeList.item(0));
        }
    }

    static final class HasElementWithIdMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String elementId;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        HasElementWithIdMatcher(String elementId) {
            void var1_1;
            this.elementId = (String)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            Object this_ = this_.elementId;
            StringBuilder stringBuilder = new StringBuilder();
            var1_1.appendText(stringBuilder.append("has element with id: ").append((String)this_).toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(Document document) {
            if (document.getElementById(this.elementId) == null) return false;
            return true;
        }
    }

    static final class ElementByIdMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String elementId;
        @RemoteMsgField(order=1)
        private final Matcher<Element> elementMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        ElementByIdMatcher(String elementId, Matcher<Element> elementMatcher) {
            void var2_2;
            void var1_1;
            this.elementId = (String)Preconditions.checkNotNull(var1_1);
            this.elementMatcher = (Matcher)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            Object[] objectArray = new Object[]{this.elementId};
            var1_1.appendText(String.format("element with id '%s' matches: ", objectArray));
            this.elementMatcher.describeTo((Description)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchesSafely(Document document) {
            void var1_1;
            return this.elementMatcher.matches((Object)var1_1.getElementById(this.elementId));
        }
    }

    static final class HasElementWithXPathMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String xpath;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        HasElementWithXPathMatcher(String xpath) {
            void var1_1;
            this.xpath = (String)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            Object this_ = this_.xpath;
            StringBuilder stringBuilder = new StringBuilder();
            var1_1.appendText(stringBuilder.append("has element with xpath: ").append((String)this_).toString());
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(Document document) {
            void var1_2;
            NodeList this_ = DomMatchers.extractNodeListForXPath(((HasElementWithXPathMatcher)((Object)this_)).xpath, (Document)var1_2);
            if (this_ == null) return false;
            if (this_.getLength() == 0) return false;
            return true;
        }
    }

    static final class ElementByXPathMatcher
    extends TypeSafeMatcher<Document> {
        @RemoteMsgField(order=0)
        private final String xpath;
        @RemoteMsgField(order=1)
        private final Matcher<Element> elementMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        ElementByXPathMatcher(String xpath, Matcher<Element> elementMatcher) {
            void var2_2;
            void var1_1;
            this.xpath = (String)Preconditions.checkNotNull(var1_1);
            this.elementMatcher = (Matcher)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            Object[] objectArray = new Object[]{this.xpath};
            var1_1.appendText(String.format("element with xpath '%s' matches: ", objectArray));
            this.elementMatcher.describeTo((Description)var1_1);
        }

        public boolean matchesSafely(Document document) {
            Object object;
            if ((object = DomMatchers.extractNodeListForXPath(this.xpath, (Document)object)) == null || object.getLength() == 0) {
                return false;
            }
            if (object.getLength() > 1) {
                object = new AmbiguousElementMatcherException(this.xpath);
                throw object;
            }
            if (object.item(0).getNodeType() != 1) {
                return false;
            }
            object = object.item(0);
            object = (Element)object;
            return this.elementMatcher.matches(object);
        }
    }

    static final class WithTextContentMatcher
    extends TypeSafeMatcher<Element> {
        @RemoteMsgField(order=0)
        private final Matcher<String> textContentMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        WithTextContentMatcher(Matcher<String> textContentMatcher) {
            void var1_1;
            this.textContentMatcher = (Matcher)Preconditions.checkNotNull(var1_1, "textContentMatcher cannot be null");
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            description.appendText("with text content: ");
            this.textContentMatcher.describeTo((Description)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(Element element) {
            void var1_1;
            return this.textContentMatcher.matches((Object)var1_1.getTextContent());
        }
    }
}

