/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.SimpleAtom;
import androidx.test.espresso.web.model.TransformingAtom;
import java.util.List;

public final class Atoms {
    public static Atom<String> getCurrentUrl() {
        return Atoms.script("function getCurrentUrl() {return document.location.href;}", Atoms.castOrDie(String.class));
    }

    public static Atom<String> getTitle() {
        return Atoms.script("function getTitle() {return document.title;}", Atoms.castOrDie(String.class));
    }

    public static Atom<Evaluation> script(String script) {
        String string;
        ScriptWithArgsSimpleAtom scriptWithArgsSimpleAtom = new ScriptWithArgsSimpleAtom(string, Lists.newArrayList());
        return scriptWithArgsSimpleAtom;
    }

    /*
     * WARNING - void declaration
     */
    public static <O> Atom<O> script(String script, TransformingAtom.Transformer<Evaluation, O> transformer) {
        void var1_1;
        return Atoms.transform(Atoms.script(script), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Atom<Evaluation> scriptWithArgs(String script, List<Object> args) {
        void var1_1;
        String string;
        ScriptWithArgsSimpleAtom scriptWithArgsSimpleAtom = new ScriptWithArgsSimpleAtom(string, (List<Object>)var1_1);
        return scriptWithArgsSimpleAtom;
    }

    /*
     * WARNING - void declaration
     */
    public static <I, O> Atom<O> transform(Atom<I> in, TransformingAtom.Transformer<I, O> transformer) {
        void var1_1;
        Atom<I> atom;
        TransformingAtom transformingAtom = new TransformingAtom(atom, var1_1);
        return transformingAtom;
    }

    public static <E> TransformingAtom.Transformer<Evaluation, E> castOrDie(Class<E> clazz) {
        Class<E> clazz2;
        CastOrDieAtom castOrDieAtom = new CastOrDieAtom((Class)Preconditions.checkNotNull(clazz2));
        return castOrDieAtom;
    }

    private Atoms() {
    }

    static final class CastOrDieAtom<E>
    implements TransformingAtom.Transformer<Evaluation, E> {
        @RemoteMsgField(order=0)
        private final Class<E> clazz;

        /*
         * WARNING - void declaration
         */
        @Override
        public E apply(Evaluation in) {
            void var1_1;
            if (in.getValue() == null) {
                Object object = new RuntimeException("Atom evaluation returned null!");
                throw object;
            }
            if (!((CastOrDieAtom)object).clazz.isInstance(var1_1.getValue())) {
                Object[] objectArray = new Object[]{((CastOrDieAtom)object).clazz.getName(), var1_1.getValue().getClass().getName()};
                RuntimeException runtimeException = new RuntimeException(String.format("%s: is not compatible with Evaluation: %s", objectArray));
                throw runtimeException;
            }
            return ((CastOrDieAtom)object).clazz.cast(var1_1.getValue());
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private CastOrDieAtom(Class<E> clazz) {
            void var1_1;
            this.clazz = var1_1;
        }
    }

    static final class ScriptWithArgsSimpleAtom
    extends SimpleAtom {
        private final String script;
        private final List<Object> args;

        @Override
        public List<Object> getNonContextualArguments() {
            return this.args;
        }

        /*
         * WARNING - void declaration
         */
        public ScriptWithArgsSimpleAtom(String script, List<Object> args) {
            super((String)var1_1);
            void var2_2;
            void var1_1;
            this.script = (String)Preconditions.checkNotNull(var1_1);
            this.args = (List)Preconditions.checkNotNull(var2_2);
        }
    }
}

