/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.test.espresso.web.internal.deps.guava.base.Objects;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.Evaluation-IA;
import androidx.test.espresso.web.model.JSONAble;
import androidx.test.espresso.web.model.ModelCodec;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public final class Evaluation
implements JSONAble,
Parcelable {
    private static final String STATUS_KEY = "status";
    private static final String MESSAGE_KEY = "message";
    private static final String VALUE_KEY = "value";
    static final JSONAble.DeJSONFactory DEJSONIZER;
    public static final Parcelable.Creator<Evaluation> CREATOR;
    private int status;
    private boolean hasMessage;
    private String message;
    private Object value;

    public int describeContents() {
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.status, this.value, this.hasMessage, this.message};
        return Objects.hashCode(objectArray);
    }

    public Object getValue() {
        return this.value;
    }

    public String getMessage() {
        Preconditions.checkState(this.hasMessage);
        return this.message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toJSONString() {
        Object object;
        try {
            Object object2;
            object = new JSONStringer();
            object = object.object().key(STATUS_KEY).value((long)((Evaluation)object3).status).key(VALUE_KEY);
            boolean bl = ((Evaluation)object3).value instanceof String;
            if (bl || (bl = ((Evaluation)object3).value instanceof Number) || (bl = ((Evaluation)object3).value instanceof Boolean) || (object2 = ((Evaluation)object3).value) == null) {
                object.value(((Evaluation)object3).value);
            } else {
                Object object3 = ((Evaluation)object3).value;
                object3 = ModelCodec.encode(object3);
                object2 = new JSONTokener((String)object3);
                object.value(object2.nextValue());
            }
            object.endObject();
            return object.toString();
        }
        catch (JSONException jSONException) {
            object = new RuntimeException(jSONException);
            throw object;
        }
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.status, this.value, this.hasMessage, this.message};
        return String.format("Evaluation: status: %d value: %s hasMessage: %s message: %s", objectArray);
    }

    static {
        Parcelable.Creator<Evaluation> creator = new JSONAble.DeJSONFactory(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            public Object attemptDeJSONize(Map<String, Object> map) {
                void var1_1;
                if (map.size() != 2) return null;
                Object object = var1_1.get(Evaluation.STATUS_KEY);
                if (!(object instanceof Integer)) return null;
                Object v = var1_1.get(Evaluation.VALUE_KEY);
                if (v == null) return null;
                Builder builder = new Builder();
                builder = builder.setStatus((Integer)object);
                object = v == JSONObject.NULL ? null : v;
                object = builder.setValue(object);
                if (!(v instanceof Map)) return ((Builder)object).build();
                Map map2 = (Map)v;
                if (map2.size() != 1) return ((Builder)object).build();
                Object v2 = map2.get(Evaluation.MESSAGE_KEY);
                if (v2 instanceof String) {
                    ((Builder)object).setMessage((String)v2);
                    return ((Builder)object).build();
                }
                if (v2 != JSONObject.NULL) return ((Builder)object).build();
                ((Builder)object).setMessage(null);
                return ((Builder)object).build();
            }
        };
        DEJSONIZER = creator;
        creator = new Parcelable.Creator<Evaluation>(){

            /*
             * WARNING - void declaration
             */
            public Evaluation createFromParcel(Parcel in) {
                void var1_1;
                Object object = new Evaluation((Parcel)var1_1);
                return object;
            }

            public Evaluation[] newArray(int size) {
                return new Evaluation[size];
            }
        };
        CREATOR = creator;
    }

    /*
     * WARNING - void declaration
     */
    protected Evaluation(Parcel in) {
        void var1_1;
        this.readFromParcel((Parcel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Evaluation(Builder b) {
        void var1_1;
        this.status = ((Builder)var1_1).status;
        this.value = ((Builder)var1_1).value;
        this.hasMessage = ((Builder)var1_1).hasMessage;
        this.message = ((Builder)var1_1).message;
    }

    /* synthetic */ Evaluation(Builder builder, Evaluation-IA evaluation-IA) {
        this(builder);
    }

    public void readFromParcel(Parcel in) {
        Evaluation evaluation = ModelCodec.decodeEvaluation(in.readString());
        this.status = evaluation.status;
        this.hasMessage = evaluation.hasMessage;
        this.message = evaluation.message;
        this.value = evaluation.value;
    }

    public void writeToParcel(Parcel dest, int n) {
        dest.writeString(ModelCodec.encode(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Evaluation evaluation;
        if (!(o instanceof Evaluation)) return false;
        evaluation = evaluation;
        if (evaluation.status != this.status) return false;
        if (this.hasMessage != evaluation.hasMessage) return false;
        if (this.hasMessage) {
            return this.message.equals(evaluation.message);
        }
        if (this.value != null) return this.value.equals(evaluation.value);
        if (evaluation.value != null) return false;
        return true;
    }

    public boolean hasMessage() {
        return this.hasMessage;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Builder {
        private Object value;
        private int status;
        private boolean hasMessage;
        private String message;

        /*
         * WARNING - void declaration
         */
        public Builder setMessage(String message) {
            void var1_1;
            this.message = var1_1;
            this.hasMessage = true;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setStatus(int status) {
            void var1_1;
            this.status = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setValue(Object value) {
            void var1_1;
            this.value = var1_1;
            return this;
        }

        public Evaluation build() {
            Evaluation evaluation = new Evaluation(this, null);
            return evaluation;
        }

        Builder() {
        }
    }
}

