/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.model;

import android.os.Build;
import android.util.JsonReader;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.internal.deps.guava.collect.Maps;
import androidx.test.espresso.web.internal.deps.guava.collect.UnmodifiableIterator;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.JSONAble;
import androidx.test.espresso.web.model.WindowReference;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public final class ModelCodec {
    private static final String TAG = "JS_CODEC";
    private static final ImmutableSet<Class<?>> VALUEABLE_CLASSES = ImmutableSet.of(Boolean.class, Number.class, String.class, JSONObject.class, JSONArray.class);
    private static final ImmutableSet<Class<?>> TOP_LEVEL_CLASSES = ImmutableSet.of(JSONObject.class, JSONArray.class, Iterable.class, Object[].class, Map.class, JSONAble.class, new Class[0]);
    private static final CopyOnWriteArrayList<JSONAble.DeJSONFactory> DEJSONIZERS;

    public static Evaluation decodeEvaluation(String json) {
        Object object = ModelCodec.decode(json);
        if (!(object instanceof Evaluation)) {
            String string;
            Object[] objectArray = new Object[]{string, object};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Document: \"%s\" did not decode to an evaluation. Instead: \"%s\"", objectArray));
            throw illegalArgumentException;
        }
        return (Evaluation)object;
    }

    private static Number decodeNumber(String value) {
        try {
            Integer n = Integer.valueOf(value);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            try {
                Long l = Long.valueOf(string);
                return l;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Double d = Double.valueOf(string);
                    return d;
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        BigInteger bigInteger = new BigInteger(string);
                        return bigInteger;
                    }
                    catch (NumberFormatException numberFormatException4) {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        return bigDecimal;
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object decode(String json) {
        String string;
        Preconditions.checkNotNull(json);
        int n = !"".equals(string) ? 1 : 0;
        Preconditions.checkArgument(n != 0, "Empty docs not supported.");
        try {
            n = Build.VERSION.SDK_INT;
            if (n >= 13) return ModelCodec.decodeViaJSONReader(string);
            return ModelCodec.decodeViaJSONObject(string);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string};
            RuntimeException runtimeException = new RuntimeException(String.format("Could not parse: %s", objectArray), iOException);
            throw runtimeException;
        }
        catch (JSONException jSONException) {
            Object[] objectArray = new Object[]{string};
            RuntimeException runtimeException = new RuntimeException(String.format("Could not parse: %s", objectArray), jSONException);
            throw runtimeException;
        }
    }

    /*
     * Exception decompiling
     */
    private static Object decodeObject(JsonReader reader) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object decodeObject(JSONObject jsonObject) throws JSONException {
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        Iterator iterator = object.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (object.isNull(string)) {
                arrayList.add(string);
                hashMap.put(string, JSONObject.NULL);
                continue;
            }
            Object object2 = object.get(string);
            if (object2 instanceof JSONObject) {
                hashMap.put(string, ModelCodec.decodeObject((JSONObject)object2));
                continue;
            }
            if (object2 instanceof JSONArray) {
                hashMap.put(string, ModelCodec.decodeArray((JSONArray)object2));
                continue;
            }
            hashMap.put(string, object2);
        }
        object = ModelCodec.maybeReplaceMap(hashMap);
        if (object != null) {
            return object;
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            hashMap.remove((String)object.next());
        }
        return hashMap;
    }

    private static Object decodeViaJSONObject(String json) throws JSONException {
        String string;
        Object object = new JSONTokener(string);
        if ((object = object.nextValue()) instanceof JSONArray) {
            return ModelCodec.decodeArray((JSONArray)object);
        }
        if (!(object instanceof JSONObject)) {
            StringBuilder stringBuilder = new StringBuilder();
            object = new IllegalArgumentException(stringBuilder.append("No top level object or array: ").append(string).toString());
            throw object;
        }
        return ModelCodec.decodeObject((JSONObject)object);
    }

    /*
     * Exception decompiling
     */
    private static Object decodeViaJSONReader(String json) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object maybeReplaceMap(Map<String, Object> obj) {
        Iterator<JSONAble.DeJSONFactory> iterator = DEJSONIZERS.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> map;
            Object object = iterator.next().attemptDeJSONize(map);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encode(Object javaObject) {
        Object object;
        Preconditions.checkNotNull(javaObject);
        try {
            boolean bl = object instanceof JSONObject;
            if (bl) {
                return object.toString();
            }
            bl = object instanceof JSONArray;
            if (bl) {
                return object.toString();
            }
            bl = object instanceof JSONAble;
            if (bl) {
                Object object2 = new JSONObject(((JSONAble)object).toJSONString());
                return object2.toString();
            }
            bl = object instanceof Iterable;
            if (bl || (bl = object instanceof Map) || (bl = object instanceof Object[])) {
                Object object3 = new JSONStringer();
                return ModelCodec.encodeHelper(object, object3).toString();
            }
        }
        catch (JSONException jSONException) {
            object = String.valueOf(object);
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeException runtimeException = new RuntimeException(stringBuilder.append("Encode failed: ").append((String)object).toString(), jSONException);
            throw runtimeException;
        }
        {
            String string = "%s: not a valid top level class. Want one of: %s";
            Object[] objectArray = new Object[]{object.getClass(), TOP_LEVEL_CLASSES};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format(string, objectArray));
            throw illegalArgumentException;
        }
    }

    private static List<Object> decodeArray(JsonReader reader) throws IOException {
        JsonReader jsonReader;
        Serializable serializable = Lists.newArrayList();
        jsonReader.beginArray();
        block8: while (jsonReader.hasNext()) {
            switch (1.$SwitchMap$android$util$JsonToken[jsonReader.peek().ordinal()]) {
                case 6: {
                    serializable.add(ModelCodec.decodeNumber(jsonReader.nextString()));
                    continue block8;
                }
                case 5: {
                    serializable.add(jsonReader.nextBoolean());
                    continue block8;
                }
                case 4: {
                    serializable.add(jsonReader.nextString());
                    continue block8;
                }
                case 3: {
                    jsonReader.nextNull();
                    serializable.add(null);
                    continue block8;
                }
                case 2: {
                    serializable.add(ModelCodec.decodeArray(jsonReader));
                    continue block8;
                }
                case 1: {
                    serializable.add(ModelCodec.decodeObject(jsonReader));
                    continue block8;
                }
            }
            Object[] objectArray = new Object[]{jsonReader.peek()};
            serializable = new IllegalStateException(String.format("%s: bogus token", objectArray));
            throw serializable;
        }
        jsonReader.endArray();
        return serializable;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<Object> decodeArray(JSONArray array) throws JSONException {
        ArrayList arrayList = Lists.newArrayList();
        int n = 0;
        JSONArray jSONArray;
        while (n < jSONArray.length()) {
            if (jSONArray.isNull(n)) {
                arrayList.add(null);
            } else {
                Object object = jSONArray.get(n);
                if (object instanceof JSONObject) {
                    arrayList.add(ModelCodec.decodeObject((JSONObject)object));
                } else if (object instanceof JSONArray) {
                    arrayList.add(ModelCodec.decodeArray((JSONArray)object));
                } else {
                    arrayList.add(object);
                }
            }
            ++n;
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JSONStringer encodeHelper(Object javaObject, JSONStringer stringer) throws JSONException {
        Iterator iterator;
        void var1_2;
        if (javaObject == null) {
            var1_2.value((Object)iterator);
            return var1_2;
        }
        if (iterator instanceof Map) {
            var1_2.object();
            for (Map.Entry entry : ((Map)((Object)iterator)).entrySet()) {
                var1_2.key(entry.getKey().toString());
                ModelCodec.encodeHelper(entry.getValue(), (JSONStringer)var1_2);
            }
            var1_2.endObject();
            return var1_2;
        }
        if (iterator instanceof Iterable) {
            var1_2.array();
            iterator = ((Iterable)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                ModelCodec.encodeHelper(iterator.next(), (JSONStringer)var1_2);
            }
            var1_2.endArray();
            return var1_2;
        }
        if (iterator instanceof Object[]) {
            var1_2.array();
            Object[] objectArray = (Object[])iterator;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ModelCodec.encodeHelper(objectArray[i], (JSONStringer)var1_2);
            }
            var1_2.endArray();
            return var1_2;
        }
        if (iterator instanceof JSONAble) {
            JSONObject jSONObject = new JSONObject(((JSONAble)((Object)iterator)).toJSONString());
            var1_2.value((Object)jSONObject);
            return var1_2;
        }
        UnmodifiableIterator unmodifiableIterator = VALUEABLE_CLASSES.iterator();
        boolean bl = false;
        while (unmodifiableIterator.hasNext()) {
            if (!((Class)unmodifiableIterator.next()).isAssignableFrom(iterator.getClass())) continue;
            var1_2.value(iterator);
            bl = true;
        }
        Preconditions.checkState(bl, "%s: not encodable. Want one of: %s", iterator.getClass(), VALUEABLE_CLASSES);
        return var1_2;
    }

    static {
        Object[] objectArray = new JSONAble.DeJSONFactory[]{Evaluation.DEJSONIZER, WindowReference.DEJSONIZER, ElementReference.DEJSONIZER};
        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList(Lists.newArrayList(objectArray));
        DEJSONIZERS = copyOnWriteArrayList;
    }

    private ModelCodec() {
    }

    public static void addDeJSONFactory(JSONAble.DeJSONFactory dejson) {
        JSONAble.DeJSONFactory deJSONFactory;
        DEJSONIZERS.add((JSONAble.DeJSONFactory)Preconditions.checkNotNull(deJSONFactory));
    }

    public static void removeDeJSONFactory(JSONAble.DeJSONFactory dejson) {
        JSONAble.DeJSONFactory deJSONFactory;
        DEJSONIZERS.remove(deJSONFactory);
    }
}

