/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.sugar;

import android.view.View;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.action.AtomAction;
import androidx.test.espresso.web.action.EnableJavascriptAction;
import androidx.test.espresso.web.assertion.WebAssertion;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.internal.platform.util.TestOutputEmitter;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class Web {
    public static WebInteraction<Void> onWebView() {
        return Web.onWebView((Matcher<View>)ViewMatchers.isJavascriptEnabled());
    }

    public static WebInteraction<Void> onWebView(Matcher<View> viewMatcher) {
        Matcher<View> matcher;
        WebInteraction<Void> webInteraction = new WebInteraction<Void>(matcher);
        return webInteraction;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Espresso-Web", "1");
        TestOutputEmitter.addOutputProperties(hashMap);
    }

    public static class WebInteraction<R> {
        private final Matcher<View> viewMatcher;
        private final boolean brandNew;
        private final R result;
        private final WindowReference window;
        private final ElementReference element;
        private final Timeout timeout;

        public <E> WebInteraction<E> check(WebAssertion<E> assertion) {
            WebInteraction webInteraction;
            Object e = this.doEval(((WebAssertion)((Object)webInteraction)).getAtom(), this.window, this.element);
            Espresso.onView(this.viewMatcher).check(((WebAssertion)((Object)webInteraction)).toViewAssertion(e));
            webInteraction = new WebInteraction(this.viewMatcher, e, this.window, this.element, false, this.timeout);
            return webInteraction;
        }

        public WebInteraction<R> forceJavascriptEnabled() {
            ViewInteraction viewInteraction = this.viewMatcher;
            viewInteraction = Espresso.onView(viewInteraction);
            ViewAction[] viewActionArray = new ViewAction[1];
            EnableJavascriptAction enableJavascriptAction = new EnableJavascriptAction();
            viewActionArray[0] = enableJavascriptAction;
            viewInteraction.perform(viewActionArray);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public WebInteraction<R> inWindow(Atom<WindowReference> windowPicker) {
            void var1_1;
            WebInteraction<R> webInteraction = new WebInteraction<R>(this.viewMatcher, this.result, (WindowReference)this.doEval((Atom)var1_1, null, null), this.element, this.brandNew, this.timeout);
            return webInteraction;
        }

        /*
         * WARNING - void declaration
         */
        public WebInteraction<R> inWindow(WindowReference window) {
            void var1_1;
            WebInteraction<R> webInteraction = new WebInteraction<R>(this.viewMatcher, this.result, (WindowReference)var1_1, this.element, this.brandNew, this.timeout);
            return webInteraction;
        }

        public <E> WebInteraction<E> perform(Atom<E> atom) {
            E e;
            WebInteraction<E> webInteraction = this.window;
            ElementReference elementReference = this.element;
            e = this.doEval((Atom<E>)e, (WindowReference)((Object)webInteraction), elementReference);
            webInteraction = new WebInteraction<E>(this.viewMatcher, e, this.window, this.element, false, this.timeout);
            return webInteraction;
        }

        public WebInteraction<R> reset() {
            WebInteraction<R> webInteraction = new WebInteraction<R>(this.viewMatcher, this.result, null, null, this.brandNew, this.timeout);
            return webInteraction;
        }

        /*
         * WARNING - void declaration
         */
        public WebInteraction<R> withContextualElement(Atom<ElementReference> elementPicker) {
            void var1_1;
            WebInteraction<R> webInteraction = new WebInteraction<R>(this.viewMatcher, this.result, this.window, (ElementReference)this.doEval((Atom)var1_1, this.window, this.element), this.brandNew, this.timeout);
            return webInteraction;
        }

        /*
         * WARNING - void declaration
         */
        public WebInteraction<R> withElement(Atom<ElementReference> elementPicker) {
            void var1_1;
            WebInteraction<R> webInteraction = new WebInteraction<R>(this.viewMatcher, this.result, this.window, (ElementReference)this.doEval((Atom)var1_1, this.window, null), this.brandNew, this.timeout);
            return webInteraction;
        }

        /*
         * WARNING - void declaration
         */
        public WebInteraction<R> withElement(ElementReference element) {
            void var1_1;
            WebInteraction<R> webInteraction = new WebInteraction<R>(this.viewMatcher, this.result, this.window, (ElementReference)var1_1, this.brandNew, this.timeout);
            return webInteraction;
        }

        public WebInteraction<R> withNoTimeout() {
            WebInteraction<R> webInteraction = new WebInteraction<R>(this.viewMatcher, this.result, this.window, this.element, this.brandNew, Timeout.NONE);
            return webInteraction;
        }

        /*
         * WARNING - void declaration
         */
        public WebInteraction<R> withTimeout(long amount, TimeUnit unit) {
            void var3_3;
            void var1_2;
            Matcher<View> matcher = this.viewMatcher;
            R r = this.result;
            WindowReference windowReference = this.window;
            ElementReference elementReference = this.element;
            boolean bl = this.brandNew;
            Timeout timeout = new Timeout((long)var1_2, (TimeUnit)var3_3, true);
            WebInteraction<R> webInteraction = new WebInteraction<R>(matcher, r, windowReference, elementReference, bl, timeout);
            return webInteraction;
        }

        private <E> E doEval(Atom<E> atom, WindowReference window, ElementReference elem) {
            ViewInteraction viewInteraction;
            AtomAction atomAction;
            ExceptionPropagator exceptionPropagator;
            Object object;
            Object object2;
            block7: {
                Preconditions.checkNotNull(atom, "Need an atom!");
                atomAction = new AtomAction(object2, (WindowReference)object, (ElementReference)((Object)exceptionPropagator));
                object2 = viewInteraction.viewMatcher;
                object2 = Espresso.onView(object2);
                object = new ViewAction[]{atomAction};
                object2.perform(object);
                object2 = viewInteraction.timeout;
                object = Timeout.NONE;
                if (object2 != object) break block7;
                object2 = atomAction.get();
                return (E)object2;
            }
            try {
                object2 = atomAction.get(viewInteraction.timeout.timeout, viewInteraction.timeout.unit);
            }
            catch (ExecutionException executionException) {
                viewInteraction = viewInteraction.viewMatcher;
                viewInteraction = Espresso.onView(viewInteraction);
                object = new ViewAction[1];
                exceptionPropagator = new ExceptionPropagator(executionException.getCause());
                object[0] = exceptionPropagator;
                viewInteraction.perform(object);
                return null;
            }
            catch (InterruptedException interruptedException) {
                viewInteraction = viewInteraction.viewMatcher;
                viewInteraction = Espresso.onView(viewInteraction);
                object = new ViewAction[1];
                exceptionPropagator = new ExceptionPropagator(interruptedException);
                object[0] = exceptionPropagator;
                viewInteraction.perform(object);
                return null;
            }
            catch (TimeoutException timeoutException) {
                viewInteraction = viewInteraction.viewMatcher;
                viewInteraction = Espresso.onView(viewInteraction);
                object = new ViewAction[1];
                exceptionPropagator = new ExceptionPropagator(timeoutException);
                object[0] = exceptionPropagator;
                viewInteraction.perform(object);
                return null;
            }
            catch (RuntimeException runtimeException) {
                viewInteraction = viewInteraction.viewMatcher;
                viewInteraction = Espresso.onView(viewInteraction);
                object = new ViewAction[1];
                exceptionPropagator = new ExceptionPropagator(runtimeException);
                object[0] = exceptionPropagator;
                viewInteraction.perform(object);
                return null;
            }
            return (E)object2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public R get() {
            boolean bl = !this.brandNew;
            Preconditions.checkState(bl, "Perform or Check never called on this WebInteraction!");
            return this.result;
        }

        /*
         * WARNING - void declaration
         */
        private WebInteraction(Matcher<View> viewMatcher) {
            void var1_1;
            Timeout timeout = new Timeout(10L, TimeUnit.SECONDS, true);
            this((Matcher<View>)var1_1, null, null, null, true, timeout);
        }

        /*
         * WARNING - void declaration
         */
        private WebInteraction(Matcher<View> viewMatcher, R result, WindowReference window, ElementReference element, boolean brandNew, Timeout timeout) {
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.viewMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
            this.result = var2_2;
            this.window = var3_3;
            this.element = var4_4;
            this.brandNew = var5_5;
            this.timeout = var6_6;
        }

        static class ExceptionPropagator
        implements ViewAction {
            @RemoteMsgField(order=0)
            private final RuntimeException error;

            public String getDescription() {
                Object this_ = ((ExceptionPropagator)this_).error;
                this_ = String.valueOf(this_);
                StringBuilder stringBuilder = new StringBuilder();
                return stringBuilder.append("Propagate: ").append((String)this_).toString();
            }

            public Matcher<View> getConstraints() {
                return Matchers.any(View.class);
            }

            /*
             * WARNING - void declaration
             */
            @RemoteMsgConstructor
            public ExceptionPropagator(RuntimeException error) {
                void var1_1;
                this.error = (RuntimeException)Preconditions.checkNotNull(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public ExceptionPropagator(Throwable t) {
                void var1_1;
                RuntimeException runtimeException = new RuntimeException((Throwable)var1_1);
                this(runtimeException);
            }

            public void perform(UiController uiController, View view) {
                throw this.error;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Timeout {
        static final Timeout NONE;
        private final long timeout;
        private final TimeUnit unit;

        static {
            Timeout timeout;
            NONE = timeout = new Timeout(-1L, TimeUnit.MILLISECONDS, false);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private Timeout(long timeout, TimeUnit unit, boolean check) {
            void var4_4;
            void var3_3;
            void var1_2;
            this.timeout = var1_2;
            this.unit = var3_3;
            if (var4_4 == false) {
                return;
            }
            boolean bl = var1_2 > 0L;
            Preconditions.checkArgument(bl);
            Preconditions.checkNotNull(var3_3);
        }
    }
}

