/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.webdriver;

import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.internal.deps.guava.collect.Maps;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Atoms;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.SimpleAtom;
import androidx.test.espresso.web.model.TransformingAtom;
import androidx.test.espresso.web.model.WindowReference;
import androidx.test.espresso.web.webdriver.Locator;
import androidx.test.espresso.web.webdriver.WebDriverAtomScripts;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DriverAtoms {
    public static Atom<Evaluation> clearElement() {
        ClearElementSimpleAtom clearElementSimpleAtom = new ClearElementSimpleAtom();
        return clearElementSimpleAtom;
    }

    /*
     * WARNING - void declaration
     */
    public static Atom<ElementReference> findElement(Locator locator, String value) {
        void var1_1;
        Locator locator2;
        FindElementSimpleAtom findElementSimpleAtom = new FindElementSimpleAtom(locator2.getType(), (String)var1_1);
        FindElementTransformingAtom findElementTransformingAtom = new FindElementTransformingAtom(findElementSimpleAtom, Atoms.castOrDie(ElementReference.class));
        return findElementTransformingAtom;
    }

    /*
     * WARNING - void declaration
     */
    public static Atom<List<ElementReference>> findMultipleElements(Locator locator, String value) {
        void var1_1;
        Object object;
        FindElementsScriptSimpleAtom findElementsScriptSimpleAtom = new FindElementsScriptSimpleAtom(object.getType(), (String)var1_1);
        ElementReferenceListAtom elementReferenceListAtom = new ElementReferenceListAtom(object.getType(), (String)var1_1);
        object = new FindMultipleElementsTransformingAtom(findElementsScriptSimpleAtom, elementReferenceListAtom);
        return object;
    }

    public static Atom<String> getText() {
        GetVisibleTextSimpleAtom getVisibleTextSimpleAtom = new GetVisibleTextSimpleAtom();
        GetTextTransformingAtom getTextTransformingAtom = new GetTextTransformingAtom(getVisibleTextSimpleAtom, Atoms.castOrDie(String.class));
        return getTextTransformingAtom;
    }

    public static Atom<ElementReference> selectActiveElement() {
        ActiveElementSimpleAtom activeElementSimpleAtom = new ActiveElementSimpleAtom();
        SelectActiveElementTransformingAtom selectActiveElementTransformingAtom = new SelectActiveElementTransformingAtom(activeElementSimpleAtom, Atoms.castOrDie(ElementReference.class));
        return selectActiveElementTransformingAtom;
    }

    public static Atom<WindowReference> selectFrameByIdOrName(String idOrName) {
        String string;
        FrameByIdOrNameSimpleAtom frameByIdOrNameSimpleAtom = new FrameByIdOrNameSimpleAtom((String)Preconditions.checkNotNull(string));
        SelectFrameByIdOrNameTransformingAtom selectFrameByIdOrNameTransformingAtom = new SelectFrameByIdOrNameTransformingAtom(frameByIdOrNameSimpleAtom, Atoms.castOrDie(WindowReference.class));
        return selectFrameByIdOrNameTransformingAtom;
    }

    /*
     * WARNING - void declaration
     */
    public static Atom<WindowReference> selectFrameByIdOrName(String idOrName, WindowReference root) {
        void var1_1;
        String string;
        FrameByIdOrNameWithRootSimpleAtom frameByIdOrNameWithRootSimpleAtom = new FrameByIdOrNameWithRootSimpleAtom((String)Preconditions.checkNotNull(string), (WindowReference)Preconditions.checkNotNull(var1_1));
        SelectFrameByIdOrNameTransformingAtom selectFrameByIdOrNameTransformingAtom = new SelectFrameByIdOrNameTransformingAtom(frameByIdOrNameWithRootSimpleAtom, Atoms.castOrDie(WindowReference.class));
        return selectFrameByIdOrNameTransformingAtom;
    }

    public static Atom<WindowReference> selectFrameByIndex(int index) {
        int n;
        FrameByIndexSimpleAtom frameByIndexSimpleAtom = new FrameByIndexSimpleAtom(n);
        SelectFrameByIndexTransformingAtom selectFrameByIndexTransformingAtom = new SelectFrameByIndexTransformingAtom(frameByIndexSimpleAtom, Atoms.castOrDie(WindowReference.class));
        return selectFrameByIndexTransformingAtom;
    }

    /*
     * WARNING - void declaration
     */
    public static Atom<WindowReference> selectFrameByIndex(int index, WindowReference root) {
        void var1_1;
        int n;
        FrameByIndexWithRootSimpleAtom frameByIndexWithRootSimpleAtom = new FrameByIndexWithRootSimpleAtom(n, (WindowReference)Preconditions.checkNotNull(var1_1));
        SelectFrameByIndexTransformingAtom selectFrameByIndexTransformingAtom = new SelectFrameByIndexTransformingAtom(frameByIndexWithRootSimpleAtom, Atoms.castOrDie(WindowReference.class));
        return selectFrameByIndexTransformingAtom;
    }

    public static Atom<Evaluation> webClick() {
        WebClickSimpleAtom webClickSimpleAtom = new WebClickSimpleAtom();
        return webClickSimpleAtom;
    }

    public static Atom<Evaluation> webKeys(String text) {
        String string;
        WebKeysSimpleAtom webKeysSimpleAtom = new WebKeysSimpleAtom((String)Preconditions.checkNotNull(string));
        return webKeysSimpleAtom;
    }

    public static Atom<Boolean> webScrollIntoView() {
        WebScrollIntoViewSimpleAtom webScrollIntoViewSimpleAtom = new WebScrollIntoViewSimpleAtom();
        WebScrollIntoViewAtom webScrollIntoViewAtom = new WebScrollIntoViewAtom(webScrollIntoViewSimpleAtom, Atoms.castOrDie(Boolean.class));
        return webScrollIntoViewAtom;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> makeLocatorJSON(Locator locator, String value) {
        Locator locator2;
        void var1_1;
        Preconditions.checkNotNull((Object)locator);
        Preconditions.checkNotNull(var1_1);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(locator2.getType(), var1_1);
        return hashMap;
    }

    private DriverAtoms() {
    }

    static final class WebClickSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private WebClickSimpleAtom() {
            super(WebDriverAtomScripts.CLICK_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            Object object = new RuntimeException("webClick: Need an element to click on!");
            throw object;
        }
    }

    static final class ClearElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private ClearElementSimpleAtom() {
            super(WebDriverAtomScripts.CLEAR_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            Object object = new RuntimeException("clearElement: Need an element to clear!");
            throw object;
        }
    }

    static final class WebKeysSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String text;

        @Override
        public List<Object> getNonContextualArguments() {
            Object[] objectArray = new Object[]{this.text};
            return Lists.newArrayList(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WebKeysSimpleAtom(String text) {
            super(WebDriverAtomScripts.SEND_KEYS_ANDROID);
            void var1_1;
            this.text = var1_1;
        }

        @Override
        public void handleNoElementReference() {
            Object object = new RuntimeException("webKeys: Need an element to type on!");
            throw object;
        }
    }

    static final class FindElementTransformingAtom
    extends TransformingAtom<Evaluation, ElementReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> findElementSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private FindElementTransformingAtom(Atom<Evaluation> findElementSimpleAtom, TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
            this.findElementSimpleAtom = var1_1;
            this.castOrDieAtom = var2_2;
        }
    }

    static final class FindElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @Override
        protected List<Object> getNonContextualArguments() {
            Object[] objectArray = ((FindElementSimpleAtom)this_).locatorType;
            objectArray = Locator.forType((String)objectArray);
            Object this_ = ((FindElementSimpleAtom)this_).value;
            this_ = DriverAtoms.makeLocatorJSON((Locator)objectArray, (String)this_);
            objectArray = new Object[]{this_};
            return Lists.newArrayList(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        FindElementSimpleAtom(String locatorType, String value) {
            super(WebDriverAtomScripts.FIND_ELEMENT_ANDROID, SimpleAtom.ElementReferencePlacement.LAST);
            void var2_2;
            void var1_1;
            this.locatorType = var1_1;
            this.value = var2_2;
        }
    }

    static final class SelectActiveElementTransformingAtom
    extends TransformingAtom<Evaluation, ElementReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> selectActiveElementSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private SelectActiveElementTransformingAtom(Atom<Evaluation> selectActiveElementSimpleAtom, TransformingAtom.Transformer<Evaluation, ElementReference> castOrDieAtom) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
            this.selectActiveElementSimpleAtom = var1_1;
            this.castOrDieAtom = var2_2;
        }
    }

    static final class ActiveElementSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private ActiveElementSimpleAtom() {
            super(WebDriverAtomScripts.ACTIVE_ELEMENT_ANDROID);
        }
    }

    static final class SelectFrameByIndexTransformingAtom
    extends TransformingAtom<Evaluation, WindowReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> frameByIndexSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private SelectFrameByIndexTransformingAtom(Atom<Evaluation> selectActiveElementSimpleAtom, TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
            this.frameByIndexSimpleAtom = var1_1;
            this.castOrDieAtom = var2_2;
        }
    }

    static final class FrameByIndexSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final int index;

        @Override
        public List<Object> getNonContextualArguments() {
            Object[] objectArray = new Object[]{this.index};
            return Lists.newArrayList(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private FrameByIndexSimpleAtom(int index) {
            super(WebDriverAtomScripts.FRAME_BY_INDEX_ANDROID);
            void var1_1;
            this.index = var1_1;
        }
    }

    static final class FrameByIndexWithRootSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final int index;
        @RemoteMsgField(order=1)
        private final WindowReference root;

        @Override
        public List<Object> getNonContextualArguments() {
            Object object = new Object[]{this.index};
            object = Lists.newArrayList((Object[])object);
            object.add(this.root);
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private FrameByIndexWithRootSimpleAtom(int index, WindowReference root) {
            super(WebDriverAtomScripts.FRAME_BY_INDEX_ANDROID);
            void var2_2;
            void var1_1;
            this.index = var1_1;
            this.root = var2_2;
        }
    }

    static final class SelectFrameByIdOrNameTransformingAtom
    extends TransformingAtom<Evaluation, WindowReference> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> frameByIndexOrNameSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private SelectFrameByIdOrNameTransformingAtom(Atom<Evaluation> selectActiveElementSimpleAtom, TransformingAtom.Transformer<Evaluation, WindowReference> castOrDieAtom) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
            this.frameByIndexOrNameSimpleAtom = var1_1;
            this.castOrDieAtom = var2_2;
        }
    }

    static final class FrameByIdOrNameWithRootSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String idOrName;
        @RemoteMsgField(order=1)
        private final WindowReference root;

        @Override
        public List<Object> getNonContextualArguments() {
            Object object = new Object[]{this.idOrName};
            object = Lists.newArrayList((Object[])object);
            object.add(this.root);
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private FrameByIdOrNameWithRootSimpleAtom(String idOrName, WindowReference root) {
            super(WebDriverAtomScripts.FRAME_BY_ID_OR_NAME_ANDROID);
            void var2_2;
            void var1_1;
            this.idOrName = var1_1;
            this.root = var2_2;
        }
    }

    static final class FrameByIdOrNameSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        private final String idOrName;

        @Override
        public List<Object> getNonContextualArguments() {
            Object[] objectArray = new Object[]{this.idOrName};
            return Lists.newArrayList(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private FrameByIdOrNameSimpleAtom(String idOrName) {
            super(WebDriverAtomScripts.FRAME_BY_ID_OR_NAME_ANDROID);
            void var1_1;
            this.idOrName = var1_1;
        }
    }

    static final class GetTextTransformingAtom
    extends TransformingAtom<Evaluation, String> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> getTextSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, String> castOrDieAtom;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private GetTextTransformingAtom(Atom<Evaluation> findElementSimpleAtom, TransformingAtom.Transformer<Evaluation, String> castOrDieAtom) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
            this.getTextSimpleAtom = var1_1;
            this.castOrDieAtom = var2_2;
        }
    }

    static final class GetVisibleTextSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private GetVisibleTextSimpleAtom() {
            super(WebDriverAtomScripts.GET_VISIBLE_TEXT_ANDROID);
        }
    }

    static final class WebScrollIntoViewAtom
    extends TransformingAtom<Evaluation, Boolean> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> scrollIntoViewSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, Boolean> castOrDieAtom;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WebScrollIntoViewAtom(Atom<Evaluation> scrollIntoViewSimpleAtom, TransformingAtom.Transformer<Evaluation, Boolean> castOrDieAtom) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
            this.scrollIntoViewSimpleAtom = var1_1;
            this.castOrDieAtom = var2_2;
        }
    }

    static final class WebScrollIntoViewSimpleAtom
    extends SimpleAtom {
        @RemoteMsgConstructor
        private WebScrollIntoViewSimpleAtom() {
            super(WebDriverAtomScripts.SCROLL_INTO_VIEW_ANDROID);
        }

        @Override
        public void handleNoElementReference() {
            Object object = new RuntimeException("scrollIntoView: need an element to scroll to");
            throw object;
        }
    }

    static final class FindElementsScriptSimpleAtom
    extends SimpleAtom {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        @Override
        public List<Object> getNonContextualArguments() {
            Object[] objectArray = new Object[]{DriverAtoms.makeLocatorJSON(Locator.forType(this.locatorType), this.value)};
            return Lists.newArrayList(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private FindElementsScriptSimpleAtom(String locatorType, String value) {
            super(WebDriverAtomScripts.FIND_ELEMENTS_ANDROID);
            void var2_2;
            void var1_1;
            this.locatorType = var1_1;
            this.value = var2_2;
        }
    }

    static final class ElementReferenceListAtom
    implements TransformingAtom.Transformer<Evaluation, List<ElementReference>> {
        @RemoteMsgField(order=0)
        final String locatorType;
        @RemoteMsgField(order=1)
        final String value;

        /*
         * WARNING - void declaration
         */
        @Override
        public List<ElementReference> apply(Evaluation e) {
            void var1_1;
            Object[] objectArray;
            Iterator iterator = e.getValue();
            if (iterator == null) {
                return Lists.newArrayList();
            }
            if (iterator instanceof Iterable) {
                objectArray = Lists.newArrayList();
                iterator = ((Iterable)((Object)iterator)).iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (t instanceof ElementReference) {
                        objectArray.add((ElementReference)t);
                        continue;
                    }
                    objectArray = new Object[]{Locator.forType(this.locatorType).name(), this.value, t, var1_1};
                    iterator = new RuntimeException(String.format("Unexpected non-elementReference in findMultipleElements(%s, %s): (%s) all: %s ", objectArray));
                    throw iterator;
                }
            } else {
                Object[] objectArray2 = new Object[]{Locator.forType(this.locatorType).name(), this.value, var1_1};
                iterator = new RuntimeException(String.format("Unexpected non-iterableType in findMultipleElements(%s, %s): return evaluation: %s ", objectArray2));
                throw iterator;
            }
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private ElementReferenceListAtom(String locatorType, String value) {
            void var2_2;
            void var1_1;
            this.locatorType = var1_1;
            this.value = var2_2;
        }
    }

    static final class FindMultipleElementsTransformingAtom
    extends TransformingAtom<Evaluation, List<ElementReference>> {
        @RemoteMsgField(order=0)
        private final Atom<Evaluation> findElementsScriptSimpleAtom;
        @RemoteMsgField(order=1)
        private final TransformingAtom.Transformer<Evaluation, List<ElementReference>> elementReferenceListAtom;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private FindMultipleElementsTransformingAtom(Atom<Evaluation> findElementsScriptSimpleAtom, TransformingAtom.Transformer<Evaluation, List<ElementReference>> elementReferenceListAtom) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
            this.findElementsScriptSimpleAtom = var1_1;
            this.elementReferenceListAtom = var2_2;
        }
    }
}

