/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.platform;

import android.os.StrictMode;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class ServiceLoaderWrapper {
    private ServiceLoaderWrapper() {
    }

    public static <T> List<T> loadService(Class<T> serviceClass) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        ArrayList<T> services = new ArrayList<T>();
        for (T element : ServiceLoader.load(serviceClass)) {
            services.add(element);
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        return services;
    }

    public static <T> T loadSingleService(Class<T> serviceClass, Factory<T> defaultImplFactory) {
        List<T> impls = ServiceLoaderWrapper.loadService(serviceClass);
        if (impls.isEmpty()) {
            return defaultImplFactory.create();
        }
        if (impls.size() == 1) {
            return impls.get(0);
        }
        String string = String.valueOf(serviceClass.getName());
        throw new IllegalStateException(string.length() != 0 ? "Found more than one implementation for ".concat(string) : new String("Found more than one implementation for "));
    }

    public static interface Factory<T> {
        public T create();
    }
}

