/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.UserHandle;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.test.InstrumentationRegistry;
import androidx.test.internal.platform.app.ActivityLifecycleTimeout;
import androidx.test.internal.runner.InstrumentationConnection;
import androidx.test.internal.runner.hidden.ExposedInstrumentationApi;
import androidx.test.internal.runner.intent.IntentMonitorImpl;
import androidx.test.internal.runner.intercepting.DefaultInterceptingActivityFactory;
import androidx.test.internal.runner.lifecycle.ActivityLifecycleMonitorImpl;
import androidx.test.internal.runner.lifecycle.ApplicationLifecycleMonitorImpl;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.ProcSummary;
import androidx.test.runner.intent.IntentMonitorRegistry;
import androidx.test.runner.intent.IntentStubberRegistry;
import androidx.test.runner.intercepting.InterceptingActivityFactory;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.ApplicationLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.ApplicationStage;
import androidx.test.runner.lifecycle.Stage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MonitoringInstrumentation
extends ExposedInstrumentationApi {
    private static final String TAG = "MonitoringInstr";
    private static final long MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP = TimeUnit.SECONDS.toMillis(2L);
    private static final long MILLIS_TO_POLL_FOR_ACTIVITY_STOP = MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP / 40L;
    private ActivityLifecycleMonitorImpl lifecycleMonitor = new ActivityLifecycleMonitorImpl();
    private ApplicationLifecycleMonitorImpl applicationMonitor = new ApplicationLifecycleMonitorImpl();
    private IntentMonitorImpl intentMonitor = new IntentMonitorImpl();
    private ExecutorService executorService;
    private Handler handlerForMainLooper;
    private AtomicBoolean anActivityHasBeenLaunched = new AtomicBoolean(false);
    private AtomicLong lastIdleTime = new AtomicLong(0L);
    private AtomicInteger startedActivityCounter = new AtomicInteger(0);
    private String jsBridgeClassName;
    private AtomicBoolean isJsBridgeLoaded = new AtomicBoolean(false);
    private volatile Boolean isOriginalInstr = null;
    private ThreadLocal<Boolean> isDexmakerClassLoaderInitialized = new ThreadLocal();
    private MessageQueue.IdleHandler idleHandler = new MessageQueue.IdleHandler(){

        public boolean queueIdle() {
            MonitoringInstrumentation.this.lastIdleTime.set(System.currentTimeMillis());
            return true;
        }
    };
    private volatile boolean finished = false;
    private volatile InterceptingActivityFactory interceptingActivityFactory;
    private Thread.UncaughtExceptionHandler standardHandler;

    public void onCreate(Bundle arguments) {
        Log.i((String)TAG, (String)"Instrumentation started!");
        this.logUncaughtExceptions();
        this.installMultidex();
        androidx.test.platform.app.InstrumentationRegistry.registerInstance(this, arguments);
        InstrumentationRegistry.registerInstance(this, arguments);
        ActivityLifecycleMonitorRegistry.registerInstance(this.lifecycleMonitor);
        ApplicationLifecycleMonitorRegistry.registerInstance(this.applicationMonitor);
        IntentMonitorRegistry.registerInstance(this.intentMonitor);
        this.handlerForMainLooper = new Handler(Looper.getMainLooper());
        boolean corePoolSize = false;
        long keepAliveTime = 0L;
        this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(this){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName(MonitoringInstrumentation.class.getSimpleName());
                return thread;
            }
        });
        Looper.myQueue().addIdleHandler(this.idleHandler);
        super.onCreate(arguments);
        this.specifyDexMakerCacheProperty();
        this.setupDexmakerClassloader();
        this.useDefaultInterceptingActivityFactory();
    }

    protected void installMultidex() {
        if (Build.VERSION.SDK_INT < 21) {
            try {
                Class<?> multidex = Class.forName("androidx.multidex.MultiDex");
                try {
                    Method installInstrumentation = multidex.getDeclaredMethod("installInstrumentation", Context.class, Context.class);
                    installInstrumentation.invoke(null, this.getContext(), this.getTargetContext());
                }
                catch (NoSuchMethodException nsme) {
                    this.installOldMultiDex(multidex);
                }
            }
            catch (ClassNotFoundException ignored) {
                Log.i((String)TAG, (String)"No multidex.");
            }
            catch (NoSuchMethodException nsme) {
                Log.i((String)TAG, (String)"No multidex.", (Throwable)nsme);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException("multidex is available at runtime, but calling it failed.", ite);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("multidex is available at runtime, but calling it failed.", iae);
            }
        }
    }

    protected void installOldMultiDex(Class<?> multidexClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method install = multidexClass.getDeclaredMethod("install", Context.class);
        install.invoke(null, this.getTargetContext());
    }

    protected void specifyDexMakerCacheProperty() {
        File dexCache = this.getTargetContext().getDir("dxmaker_cache", 0);
        System.getProperties().put("dexmaker.dexcache", dexCache.getAbsolutePath());
    }

    protected final void setJsBridgeClassName(String className) {
        if (null == className) {
            throw new NullPointerException("JsBridge class name cannot be null!");
        }
        if (this.isJsBridgeLoaded.get()) {
            throw new IllegalStateException("JsBridge is already loaded!");
        }
        this.jsBridgeClassName = className;
    }

    private void setupDexmakerClassloader() {
        ClassLoader newClassLoader;
        if (Boolean.TRUE.equals(this.isDexmakerClassLoaderInitialized.get())) {
            return;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (originalClassLoader != (newClassLoader = this.getTargetContext().getClassLoader())) {
            Log.i((String)TAG, (String)String.format("Setting context classloader to '%s', Original: '%s'", newClassLoader, originalClassLoader));
            Thread.currentThread().setContextClassLoader(newClassLoader);
        }
        this.isDexmakerClassLoaderInitialized.set(Boolean.TRUE);
    }

    private void logUncaughtExceptions() {
        this.standardHandler = Thread.currentThread().getUncaughtExceptionHandler();
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                MonitoringInstrumentation.this.onException(t, e);
                if (null != MonitoringInstrumentation.this.standardHandler) {
                    Log.w((String)MonitoringInstrumentation.TAG, (String)String.format("Invoking uncaught exception handler %s (a %s)", MonitoringInstrumentation.this.standardHandler, MonitoringInstrumentation.this.standardHandler.getClass()));
                    MonitoringInstrumentation.this.standardHandler.uncaughtException(t, e);
                } else {
                    String string = String.valueOf(t.getName());
                    Log.w((String)MonitoringInstrumentation.TAG, (String)(string.length() != 0 ? "Invoking uncaught exception handler for thread: ".concat(string) : new String("Invoking uncaught exception handler for thread: ")));
                    t.getThreadGroup().uncaughtException(t, e);
                }
                if (!"robolectric".equals(Build.FINGERPRINT) && Looper.getMainLooper().getThread().equals(t)) {
                    Log.e((String)MonitoringInstrumentation.TAG, (String)"The main thread has died and the handlers didn't care, exiting");
                    System.exit(-10);
                }
            }
        });
    }

    protected void restoreUncaughtExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(this.standardHandler);
    }

    public void onStart() {
        super.onStart();
        if (this.jsBridgeClassName != null) {
            this.tryLoadingJsBridge(this.jsBridgeClassName);
        }
        this.waitForIdleSync();
        this.setupDexmakerClassloader();
        InstrumentationConnection.getInstance().init(this, new ActivityFinisher());
    }

    public void finish(int resultCode, Bundle results) {
        if (this.finished) {
            Log.w((String)TAG, (String)"finish called 2x!");
            return;
        }
        this.finished = true;
        if (this.shouldWaitForActivitiesToComplete()) {
            this.handlerForMainLooper.post((Runnable)new ActivityFinisher());
            long startTime = System.currentTimeMillis();
            this.waitForActivitiesToComplete();
            long endTime = System.currentTimeMillis();
            Log.i((String)TAG, (String)String.format("waitForActivitiesToComplete() took: %sms", endTime - startTime));
        }
        ActivityLifecycleMonitorRegistry.registerInstance(null);
        this.restoreUncaughtExceptionHandler();
        super.finish(resultCode, results);
    }

    protected boolean shouldWaitForActivitiesToComplete() {
        return Boolean.parseBoolean(androidx.test.platform.app.InstrumentationRegistry.getArguments().getString("waitForActivitiesToComplete", "true"));
    }

    protected void waitForActivitiesToComplete() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IllegalStateException("Cannot be called from main thread!");
        }
        long endTime = System.currentTimeMillis() + MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP;
        int currentActivityCount = this.startedActivityCounter.get();
        while (currentActivityCount > 0 && System.currentTimeMillis() < endTime) {
            try {
                int n = currentActivityCount;
                Log.i((String)TAG, (String)new StringBuilder(37).append("Unstopped activity count: ").append(n).toString());
                Thread.sleep(MILLIS_TO_POLL_FOR_ACTIVITY_STOP);
                currentActivityCount = this.startedActivityCounter.get();
            }
            catch (InterruptedException ie) {
                Log.i((String)TAG, (String)"Abandoning activity wait due to interruption.", (Throwable)ie);
                break;
            }
        }
        if (currentActivityCount > 0) {
            this.dumpThreadStateToOutputs("ThreadState-unstopped.txt");
            Log.w((String)TAG, (String)String.format("Still %s activities active after waiting %s ms.", currentActivityCount, MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP));
        }
    }

    public void onDestroy() {
        Log.i((String)TAG, (String)"Instrumentation Finished!");
        Looper.myQueue().removeIdleHandler(this.idleHandler);
        InstrumentationConnection.getInstance().terminate();
        super.onDestroy();
    }

    public void callApplicationOnCreate(Application app) {
        this.applicationMonitor.signalLifecycleChange(app, ApplicationStage.PRE_ON_CREATE);
        super.callApplicationOnCreate(app);
        this.applicationMonitor.signalLifecycleChange(app, ApplicationStage.CREATED);
    }

    public void runOnMainSync(Runnable runnable) {
        FutureTask<Object> wrapped = new FutureTask<Object>(runnable, null);
        super.runOnMainSync(wrapped);
        try {
            wrapped.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Activity startActivitySync(final Intent intent) {
        Checks.checkNotMainThread();
        long lastIdleTimeBeforeLaunch = this.lastIdleTime.get();
        if (this.anActivityHasBeenLaunched.compareAndSet(false, true)) {
            intent.addFlags(0x4000000);
        }
        Future<Activity> startedActivity = this.executorService.submit(new Callable<Activity>(){

            @Override
            public Activity call() {
                return MonitoringInstrumentation.super.startActivitySync(intent);
            }
        });
        try {
            return startedActivity.get(ActivityLifecycleTimeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            this.dumpThreadStateToOutputs("ThreadState-startActivityTimeout.txt");
            startedActivity.cancel(true);
            throw new RuntimeException(String.format("Could not launch intent %s within %s milliseconds. Perhaps the main thread has not gone idle within a reasonable amount of time? There could be an animation or something constantly repainting the screen. Or the activity is doing network calls on creation? See the threaddump logs. For your reference the last time the event queue was idle before your activity launch request was %s and now the last time the queue went idle was: %s. If these numbers are the same your activity might be hogging the event queue.", intent, ActivityLifecycleTimeout.getMillis(), lastIdleTimeBeforeLaunch, this.lastIdleTime.get()));
        }
        catch (ExecutionException ee) {
            throw new RuntimeException("Could not launch activity", ee.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", ie);
        }
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode) {
        this.intentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        this.intentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        this.intentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options, UserHandle user) {
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options, user);
    }

    public void execStartActivities(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options) {
        Log.d((String)TAG, (String)"execStartActivities(context, ibinder, ibinder, activity, intent[], bundle)");
        int requestCode = -1;
        for (Intent intent : intents) {
            this.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
        }
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode, Bundle options) {
        Log.d((String)TAG, (String)"execStartActivity(context, IBinder, IBinder, Fragment, Intent, int, Bundle)");
        this.intentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    private Instrumentation.ActivityResult stubResultFor(Intent intent) {
        if (IntentStubberRegistry.isLoaded()) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                FutureTask<Instrumentation.ActivityResult> task = new FutureTask<Instrumentation.ActivityResult>(new StubResultCallable(intent));
                this.runOnMainSync(task);
                try {
                    return task.get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(String.format("Could not retrieve stub result for intent %s", intent), e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            return IntentStubberRegistry.getInstance().getActivityResultForIntent(intent);
        }
        return null;
    }

    public boolean onException(Object obj, Throwable e) {
        String error = String.format("Exception encountered by: %s. Dumping thread state to outputs and pining for the fjords.", obj);
        Log.e((String)TAG, (String)error, (Throwable)e);
        this.dumpThreadStateToOutputs("ThreadState-onException.txt");
        Log.e((String)TAG, (String)"Dying now...");
        return super.onException(obj, e);
    }

    protected void dumpThreadStateToOutputs(String outputFileName) {
        String threadState = this.getThreadState();
        Log.e((String)"THREAD_STATE", (String)threadState);
    }

    protected String getThreadState() {
        Set<Map.Entry<Thread, StackTraceElement[]>> threads = Thread.getAllStackTraces().entrySet();
        StringBuilder threadState = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> threadAndStack : threads) {
            StringBuilder threadMessage = new StringBuilder("  ").append(threadAndStack.getKey());
            threadMessage.append("\n");
            for (StackTraceElement ste : threadAndStack.getValue()) {
                threadMessage.append("    ");
                threadMessage.append(ste.toString());
                threadMessage.append("\n");
            }
            threadMessage.append("\n");
            threadState.append(threadMessage.toString());
        }
        return threadState.toString();
    }

    public void callActivityOnDestroy(Activity activity) {
        super.callActivityOnDestroy(activity);
        this.lifecycleMonitor.signalLifecycleChange(Stage.DESTROYED, activity);
    }

    public void callActivityOnRestart(Activity activity) {
        super.callActivityOnRestart(activity);
        this.lifecycleMonitor.signalLifecycleChange(Stage.RESTARTED, activity);
    }

    public void callActivityOnCreate(Activity activity, Bundle bundle) {
        this.lifecycleMonitor.signalLifecycleChange(Stage.PRE_ON_CREATE, activity);
        super.callActivityOnCreate(activity, bundle);
        this.lifecycleMonitor.signalLifecycleChange(Stage.CREATED, activity);
    }

    public void callActivityOnStart(Activity activity) {
        this.startedActivityCounter.incrementAndGet();
        try {
            super.callActivityOnStart(activity);
            this.lifecycleMonitor.signalLifecycleChange(Stage.STARTED, activity);
        }
        catch (RuntimeException re) {
            this.startedActivityCounter.decrementAndGet();
            throw re;
        }
    }

    public void callActivityOnStop(Activity activity) {
        try {
            super.callActivityOnStop(activity);
            this.lifecycleMonitor.signalLifecycleChange(Stage.STOPPED, activity);
        }
        finally {
            this.startedActivityCounter.decrementAndGet();
        }
    }

    public void callActivityOnResume(Activity activity) {
        super.callActivityOnResume(activity);
        this.lifecycleMonitor.signalLifecycleChange(Stage.RESUMED, activity);
    }

    public void callActivityOnPause(Activity activity) {
        super.callActivityOnPause(activity);
        this.lifecycleMonitor.signalLifecycleChange(Stage.PAUSED, activity);
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        ComponentName intentComponentName;
        String activityClassPackageName = clazz.getPackage().getName();
        String contextPackageName = context.getPackageName();
        if (!contextPackageName.equals((intentComponentName = intent.getComponent()).getPackageName()) && activityClassPackageName.equals(intentComponentName.getPackageName())) {
            intent.setComponent(new ComponentName(contextPackageName, intentComponentName.getClassName()));
        }
        return super.newActivity(clazz, context, token, application, intent, info, title, parent, id, lastNonConfigurationInstance);
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.interceptingActivityFactory.shouldIntercept(cl, className, intent) ? this.interceptingActivityFactory.create(cl, className, intent) : super.newActivity(cl, className, intent);
    }

    public void interceptActivityUsing(InterceptingActivityFactory interceptingActivityFactory) {
        Checks.checkNotNull(interceptingActivityFactory);
        this.interceptingActivityFactory = interceptingActivityFactory;
    }

    public void useDefaultInterceptingActivityFactory() {
        this.interceptingActivityFactory = new DefaultInterceptingActivityFactory();
    }

    private void tryLoadingJsBridge(final String className) {
        if (null == className) {
            throw new NullPointerException("JsBridge class name cannot be null!");
        }
        this.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> jsBridge = Class.forName(className);
                    Method install = jsBridge.getDeclaredMethod("installBridge", new Class[0]);
                    install.invoke(null, new Object[0]);
                    MonitoringInstrumentation.this.isJsBridgeLoaded.set(true);
                }
                catch (ClassNotFoundException | NoSuchMethodException ignored) {
                    Log.i((String)MonitoringInstrumentation.TAG, (String)"No JSBridge.");
                }
                catch (IllegalAccessException | InvocationTargetException ite) {
                    throw new RuntimeException("JSbridge is available at runtime, but calling it failed.", ite);
                }
            }
        });
    }

    @Deprecated
    protected boolean isPrimaryInstrProcess(@Nullable String argsProcessName) {
        return this.isPrimaryInstrProcess();
    }

    protected final boolean isPrimaryInstrProcess() {
        return this.isOriginalInstrumentationProcess();
    }

    private boolean isHostingProcess(String wantName, ProcSummary ps) {
        int cmdLen;
        int wantLen = wantName.length();
        if (wantLen == (cmdLen = ps.cmdline.length())) {
            return wantName.equals(ps.cmdline);
        }
        if (wantLen < cmdLen) {
            return false;
        }
        if (wantName.startsWith(ps.cmdline) && wantName.endsWith(ps.name)) {
            String string = String.valueOf(ps);
            Log.w((String)TAG, (String)new StringBuilder(165 + String.valueOf(string).length() + String.valueOf(wantName).length()).append("Use smaller processNames in AndroidManifest.xml. Long names are truncated. This process's cmdline is a prefix of the processName and suffix of comm - assuming: ").append(string).append(" is: ").append(wantName).toString());
            return true;
        }
        return false;
    }

    private boolean isOriginalInstrumentationProcess() {
        Boolean isOriginal = this.isOriginalInstr;
        if (isOriginal == null) {
            this.isOriginalInstr = isOriginal = Boolean.valueOf(this.isOriginalUncached());
        }
        return isOriginal;
    }

    private List<String> getTargetProcessValues() {
        if (Build.VERSION.SDK_INT < 26) {
            return Collections.emptyList();
        }
        String tpVal = null;
        try {
            tpVal = this.getContext().getPackageManager().getInstrumentationInfo((ComponentName)this.getComponentName(), (int)0).targetProcesses;
            if (tpVal == null) {
                tpVal = "";
            }
            tpVal = tpVal.trim();
        }
        catch (PackageManager.NameNotFoundException unpossible) {
            String string = String.valueOf(this.getComponentName());
            Log.wtf((String)TAG, (String)new StringBuilder(25 + String.valueOf(string).length()).append("Cannot locate ourselves: ").append(string).toString(), (Throwable)unpossible);
            string = String.valueOf(this.getComponentName());
            throw new IllegalStateException(new StringBuilder(25 + String.valueOf(string).length()).append("Cannot locate ourselves: ").append(string).toString(), unpossible);
        }
        if (tpVal.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> tps = new ArrayList<String>();
        for (String tp : tpVal.split(",", -1)) {
            if ((tp = tp.trim()).length() <= 0) continue;
            tps.add(tp);
        }
        return tps;
    }

    private boolean isOriginalUncached() {
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        List<String> targetProcesses = this.getTargetProcessValues();
        if (targetProcesses.isEmpty()) {
            return true;
        }
        boolean isWildcard = "*".equals(targetProcesses.get(0));
        if (targetProcesses.size() == 1 && !isWildcard) {
            return true;
        }
        ProcSummary me = null;
        try {
            me = ProcSummary.summarize("self");
        }
        catch (ProcSummary.SummaryException se) {
            Log.w((String)TAG, (String)"Could not list apps for this user, running in sandbox? Assuming primary", (Throwable)se);
            return false;
        }
        if (isWildcard) {
            String appDefProcessName = this.getTargetContext().getApplicationInfo().processName;
            if (appDefProcessName == null) {
                appDefProcessName = this.getTargetContext().getPackageName();
            }
            return this.isHostingProcess(appDefProcessName, me);
        }
        return this.isHostingProcess(targetProcesses.get(0), me);
    }

    public class ActivityFinisher
    implements Runnable {
        @Override
        public void run() {
            ArrayList<Activity> activities = new ArrayList<Activity>();
            for (Stage s : EnumSet.range(Stage.CREATED, Stage.STOPPED)) {
                activities.addAll(MonitoringInstrumentation.this.lifecycleMonitor.getActivitiesInStage(s));
            }
            if (activities.size() > 0) {
                int n = activities.size();
                Log.i((String)MonitoringInstrumentation.TAG, (String)new StringBuilder(60).append("Activities that are still in CREATED to STOPPED: ").append(n).toString());
            }
            for (Activity activity : activities) {
                if (activity.isFinishing()) continue;
                try {
                    String string = String.valueOf(activity);
                    Log.i((String)MonitoringInstrumentation.TAG, (String)new StringBuilder(20 + String.valueOf(string).length()).append("Finishing activity: ").append(string).toString());
                    activity.finish();
                }
                catch (RuntimeException e) {
                    Log.e((String)MonitoringInstrumentation.TAG, (String)"Failed to finish activity.", (Throwable)e);
                }
            }
        }
    }

    private static class StubResultCallable
    implements Callable<Instrumentation.ActivityResult> {
        private final Intent intent;

        StubResultCallable(Intent intent) {
            this.intent = intent;
        }

        @Override
        public Instrumentation.ActivityResult call() {
            return IntentStubberRegistry.getInstance().getActivityResultForIntent(this.intent);
        }
    }
}

