/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.tracing;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.platform.tracing.Tracer;
import androidx.tracing.Trace;
import java.util.ArrayDeque;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class AndroidXTracer
implements Tracer {
    private static final String TAG = AndroidXTracer.class.getSimpleName();
    private static final int MAX_SECTION_NAME_LEN = 127;

    @Override
    @NonNull
    public Tracer.Span beginSpan(@NonNull String name) {
        Trace.beginSection((String)AndroidXTracer.sanitizeSpanName(name));
        return new AndroidXTracerSpan();
    }

    @NonNull
    private static String sanitizeSpanName(@NonNull String name) {
        if (name.length() > 127) {
            String string = name;
            Log.w((String)TAG, (String)("Span name exceeds limits: " + string));
            name = name.substring(0, 127);
        }
        return name;
    }

    AndroidXTracer() {
    }

    private static class AndroidXTracerSpan
    implements Tracer.Span {
        private final ArrayDeque<AndroidXTracerSpan> nestedSpans = new ArrayDeque();

        @Override
        @NonNull
        public Tracer.Span beginChildSpan(@NonNull String name) {
            Trace.beginSection((String)AndroidXTracer.sanitizeSpanName(name));
            AndroidXTracerSpan span = new AndroidXTracerSpan();
            this.nestedSpans.add(span);
            return span;
        }

        private AndroidXTracerSpan() {
        }

        @Override
        public void close() {
            AndroidXTracerSpan span;
            while ((span = this.nestedSpans.pollLast()) != null) {
                span.close();
            }
            Trace.endSection();
        }
    }
}

