/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.intent;

import android.os.Looper;
import androidx.test.internal.util.Checks;
import androidx.test.runner.intent.IntentStubber;
import java.util.concurrent.atomic.AtomicBoolean;

public final class IntentStubberRegistry {
    private static IntentStubber instance;
    private static AtomicBoolean isLoaded;

    public static IntentStubber getInstance() {
        IntentStubberRegistry.checkMain();
        Checks.checkState(null != instance, "No intent monitor registered! Are you running under an Instrumentation which registers intent monitors?");
        return instance;
    }

    static {
        isLoaded = new AtomicBoolean();
    }

    private IntentStubberRegistry() {
    }

    private static void checkMain() {
        Checks.checkState(Looper.myLooper() == Looper.getMainLooper(), "Must be called on main thread.");
    }

    public static void load(IntentStubber intentStubber) {
        Checks.checkNotNull(intentStubber, "IntentStubber cannot be null!");
        Checks.checkState(!isLoaded.getAndSet(true), "Intent stubber already registered! Multiple stubbers are notallowedAre you running under an ");
        instance = intentStubber;
    }

    public static synchronized void reset() {
        instance = null;
        isLoaded.set(false);
    }

    public static boolean isLoaded() {
        return isLoaded.get();
    }
}

