/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.platform.io;

import android.os.Bundle;
import android.util.Log;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.platform.io.OutputDirCalculator;
import androidx.test.platform.io.PlatformTestStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@ExperimentalTestApi
public final class FileTestStorage
implements PlatformTestStorage {
    private static final String TAG = FileTestStorage.class.getSimpleName();
    private final OutputDirCalculator outputDirCalculator = new OutputDirCalculator();

    @Override
    public InputStream openInputFile(String pathname) throws IOException {
        File inputFile = new File(pathname);
        if (inputFile.isAbsolute()) {
            return new FileInputStream(inputFile);
        }
        return InstrumentationRegistry.getInstrumentation().getContext().getAssets().open(pathname);
    }

    @Override
    public InputStream openInternalInputFile(String pathname) throws IOException {
        return this.openInputFile(pathname);
    }

    @Override
    public OutputStream openInternalOutputFile(String pathname) throws IOException {
        return this.openOutputFile(pathname);
    }

    @Override
    public OutputStream openOutputFile(String pathname) throws IOException {
        File outputFile = new File(pathname);
        if (!outputFile.isAbsolute()) {
            outputFile = new File(this.outputDirCalculator.getOutputDir(), pathname);
        }
        return new FileOutputStream(outputFile);
    }

    @Override
    public OutputStream openOutputFile(String pathname, boolean append) throws IOException {
        File outputFile = new File(pathname);
        if (!outputFile.isAbsolute()) {
            outputFile = new File(this.outputDirCalculator.getOutputDir(), pathname);
        }
        return new FileOutputStream(outputFile, append);
    }

    @Override
    public String getInputArg(String argName) {
        return InstrumentationRegistry.getArguments().getString(argName);
    }

    @Override
    public Map<String, String> getInputArgs() {
        HashMap<String, String> argMap = new HashMap<String, String>();
        Bundle bundle = InstrumentationRegistry.getArguments();
        for (String key : bundle.keySet()) {
            argMap.put(key, bundle.getString(key));
        }
        return argMap;
    }

    @Override
    public Map<String, Serializable> getOutputProperties() {
        Log.w((String)TAG, (String)"Output properties is not supported.");
        return Collections.emptyMap();
    }

    @Override
    public void addOutputProperties(Map<String, Serializable> properties) {
        Log.w((String)TAG, (String)"Output properties is not supported.");
    }
}

