/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.platform.reflect;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.platform.reflect.ReflectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ReflectiveMethod<T> {
    private final String className;
    private final String methodName;
    private final Class<?>[] paramTypes;
    private final Class<?> clazz;
    private boolean initialized = false;
    private Method method;

    public ReflectiveMethod(String className, String methodName, Class<?> ... paramTypes) {
        this.className = className;
        this.clazz = null;
        this.paramTypes = paramTypes;
        this.methodName = methodName;
    }

    public ReflectiveMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        this.className = null;
        this.clazz = clazz;
        this.paramTypes = paramTypes;
        this.methodName = methodName;
    }

    public T invoke(Object object, Object ... paramValues) throws ReflectionException {
        try {
            this.initIfNecessary();
            return (T)this.method.invoke(object, paramValues);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public T invokeStatic(Object ... paramValues) throws ReflectionException {
        return this.invoke(null, paramValues);
    }

    private synchronized void initIfNecessary() throws ClassNotFoundException, NoSuchMethodException {
        if (this.initialized) {
            return;
        }
        this.method = this.getClazz().getDeclaredMethod(this.methodName, this.paramTypes);
        this.method.setAccessible(true);
        this.initialized = true;
    }

    @NonNull
    private Class<?> getClazz() throws ClassNotFoundException {
        if (this.clazz == null) {
            return Class.forName(this.className);
        }
        return this.clazz;
    }
}

