/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import androidx.test.internal.runner.junit3.AndroidJUnit3Builder;
import androidx.test.internal.runner.junit3.AndroidSuiteBuilder;
import androidx.test.internal.runner.junit4.AndroidAnnotatedBuilder;
import androidx.test.internal.runner.junit4.AndroidJUnit4Builder;
import androidx.test.internal.util.AndroidRunnerParams;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.IgnoredBuilder;
import org.junit.internal.builders.JUnit3Builder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class AndroidRunnerBuilder
extends AllDefaultPossibilitiesBuilder {
    private final AndroidJUnit3Builder mAndroidJUnit3Builder;
    private final AndroidJUnit4Builder mAndroidJUnit4Builder;
    private final AndroidSuiteBuilder mAndroidSuiteBuilder;
    private final AndroidAnnotatedBuilder mAndroidAnnotatedBuilder;
    private final IgnoredBuilder mIgnoredBuilder;
    private final List<RunnerBuilder> mCustomRunnerBuilders;

    public AndroidRunnerBuilder(AndroidRunnerParams runnerParams) {
        this(null, runnerParams, false, Collections.emptyList());
    }

    AndroidRunnerBuilder(AndroidRunnerParams runnerParams, boolean scanningPath, List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        this(null, runnerParams, scanningPath, customRunnerBuilderClasses);
    }

    AndroidRunnerBuilder(RunnerBuilder suiteBuilder, AndroidRunnerParams runnerParams, boolean scanningPath, List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        super(true);
        this.mAndroidJUnit3Builder = new AndroidJUnit3Builder(runnerParams, scanningPath);
        this.mAndroidJUnit4Builder = new AndroidJUnit4Builder(runnerParams, scanningPath);
        this.mAndroidSuiteBuilder = new AndroidSuiteBuilder(runnerParams);
        this.mAndroidAnnotatedBuilder = new AndroidAnnotatedBuilder((RunnerBuilder)(suiteBuilder == null ? this : suiteBuilder), runnerParams);
        this.mIgnoredBuilder = new IgnoredBuilder();
        this.mCustomRunnerBuilders = this.instantiateRunnerBuilders(customRunnerBuilderClasses);
    }

    private List<RunnerBuilder> instantiateRunnerBuilders(List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        ArrayList<RunnerBuilder> runnerBuilders = new ArrayList<RunnerBuilder>();
        for (Class<? extends RunnerBuilder> customRunnerBuilderClass : customRunnerBuilderClasses) {
            try {
                RunnerBuilder runnerBuilder = customRunnerBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                runnerBuilders.add(runnerBuilder);
            }
            catch (InstantiationException e) {
                String string = String.valueOf(customRunnerBuilderClass);
                throw new IllegalStateException(new StringBuilder(113 + String.valueOf(string).length()).append("Could not create instance of ").append(string).append(", make sure that it is a public concrete class with a public no-argument constructor").toString(), e);
            }
            catch (IllegalAccessException e) {
                String string = String.valueOf(customRunnerBuilderClass);
                throw new IllegalStateException(new StringBuilder(113 + String.valueOf(string).length()).append("Could not create instance of ").append(string).append(", make sure that it is a public concrete class with a public no-argument constructor").toString(), e);
            }
            catch (NoSuchMethodException e) {
                String string = String.valueOf(customRunnerBuilderClass);
                throw new IllegalStateException(new StringBuilder(113 + String.valueOf(string).length()).append("Could not create instance of ").append(string).append(", make sure that it is a public concrete class with a public no-argument constructor").toString(), e);
            }
            catch (InvocationTargetException e) {
                String string = String.valueOf(customRunnerBuilderClass);
                throw new IllegalStateException(new StringBuilder(74 + String.valueOf(string).length()).append("Could not create instance of ").append(string).append(", the constructor must not throw an exception").toString(), e);
            }
        }
        return runnerBuilders;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        for (RunnerBuilder customRunnerBuilder : this.mCustomRunnerBuilders) {
            Runner runner = customRunnerBuilder.safeRunnerForClass(testClass);
            if (runner == null) continue;
            return runner;
        }
        return super.runnerForClass(testClass);
    }

    protected JUnit4Builder junit4Builder() {
        return this.mAndroidJUnit4Builder;
    }

    protected JUnit3Builder junit3Builder() {
        return this.mAndroidJUnit3Builder;
    }

    protected AnnotatedBuilder annotatedBuilder() {
        return this.mAndroidAnnotatedBuilder;
    }

    protected IgnoredBuilder ignoredBuilder() {
        return this.mIgnoredBuilder;
    }

    protected RunnerBuilder suiteMethodBuilder() {
        return this.mAndroidSuiteBuilder;
    }
}

