/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4.statement;

import android.os.Looper;
import android.test.UiThreadTest;
import android.util.Log;
import androidx.test.InstrumentationRegistry;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class UiThreadStatement
extends Statement {
    private static final String TAG = "UiThreadStatement";
    private final Statement mBase;
    private final boolean mRunOnUiThread;

    public UiThreadStatement(Statement base, boolean runOnUiThread) {
        this.mBase = base;
        this.mRunOnUiThread = runOnUiThread;
    }

    public boolean isRunOnUiThread() {
        return this.mRunOnUiThread;
    }

    public void evaluate() throws Throwable {
        if (this.mRunOnUiThread) {
            final AtomicReference exceptionRef = new AtomicReference();
            UiThreadStatement.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        UiThreadStatement.this.mBase.evaluate();
                    }
                    catch (Throwable throwable) {
                        exceptionRef.set(throwable);
                    }
                }
            });
            Throwable throwable = (Throwable)exceptionRef.get();
            if (throwable != null) {
                throw throwable;
            }
        } else {
            this.mBase.evaluate();
        }
    }

    public static boolean shouldRunOnUiThread(FrameworkMethod method) {
        Class<UiThreadTest> deprecatedUiThreadTestClass = UiThreadTest.class;
        if (method.getAnnotation(deprecatedUiThreadTestClass) != null) {
            return true;
        }
        try {
            Class<?> UiThreadTestClass = Class.forName("androidx.test.annotation.UiThreadTest");
            if (method.getAnnotation(deprecatedUiThreadTestClass) != null || method.getAnnotation(UiThreadTestClass) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static void runOnUiThread(Runnable runnable) throws Throwable {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Log.w((String)TAG, (String)"Already on the UI thread, this method should not be called from the main application thread");
            runnable.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(runnable, null);
            InstrumentationRegistry.getInstrumentation().runOnMainSync(task);
            try {
                task.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }
}

