/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import androidx.annotation.VisibleForTesting;
import dalvik.system.DexFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@VisibleForTesting(otherwise=3)
public class ClassPathScanner {
    private final Set<String> classPath = new HashSet<String>();

    public ClassPathScanner(String ... paths) {
        this(Arrays.asList(paths));
    }

    public ClassPathScanner(Collection<String> paths) {
        this.classPath.addAll(paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntriesFromPath(Set<String> entryNames, String path, ClassNameFilter filter) throws IOException {
        try (DexFile dexFile = null;){
            dexFile = new DexFile(path);
            Enumeration<String> classNames = this.getDexEntries(dexFile);
            while (classNames.hasMoreElements()) {
                String className = classNames.nextElement();
                if (!filter.accept(className)) continue;
                entryNames.add(className);
            }
        }
    }

    @VisibleForTesting
    Enumeration<String> getDexEntries(DexFile dexFile) {
        return dexFile.entries();
    }

    public Set<String> getClassPathEntries(ClassNameFilter filter) throws IOException {
        LinkedHashSet<String> entryNames = new LinkedHashSet<String>();
        for (String path : this.classPath) {
            this.addEntriesFromPath(entryNames, path, filter);
        }
        return entryNames;
    }

    static class ExcludeClassNamesFilter
    implements ClassNameFilter {
        private Set<String> excludedClassNames;

        public ExcludeClassNamesFilter(Set<String> excludedClassNames) {
            this.excludedClassNames = excludedClassNames;
        }

        @Override
        public boolean accept(String className) {
            return !this.excludedClassNames.contains(className);
        }
    }

    public static class ExcludePackageNameFilter
    implements ClassNameFilter {
        private final String pkgName;

        ExcludePackageNameFilter(String pkgName) {
            this.pkgName = !pkgName.endsWith(".") ? String.format("%s.", pkgName) : pkgName;
        }

        @Override
        public boolean accept(String pathName) {
            return !pathName.startsWith(this.pkgName);
        }
    }

    public static class InclusivePackageNamesFilter
    implements ClassNameFilter {
        private final Collection<String> pkgNames;

        InclusivePackageNamesFilter(Collection<String> pkgNames) {
            this.pkgNames = new ArrayList<String>(pkgNames.size());
            for (String packageName : pkgNames) {
                if (!packageName.endsWith(".")) {
                    this.pkgNames.add(String.format("%s.", packageName));
                    continue;
                }
                this.pkgNames.add(packageName);
            }
        }

        @Override
        public boolean accept(String pathName) {
            for (String packageName : this.pkgNames) {
                if (!pathName.startsWith(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ExternalClassNameFilter
    implements ClassNameFilter {
        @Override
        public boolean accept(String pathName) {
            return !pathName.contains("$");
        }
    }

    public static class ChainedClassNameFilter
    implements ClassNameFilter {
        private final List<ClassNameFilter> filters = new ArrayList<ClassNameFilter>();

        public void add(ClassNameFilter filter) {
            this.filters.add(filter);
        }

        public void addAll(ClassNameFilter ... filters) {
            this.filters.addAll(Arrays.asList(filters));
        }

        @Override
        public boolean accept(String className) {
            for (ClassNameFilter filter : this.filters) {
                if (filter.accept(className)) continue;
                return false;
            }
            return true;
        }
    }

    public static class AcceptAllFilter
    implements ClassNameFilter {
        @Override
        public boolean accept(String className) {
            return true;
        }
    }

    public static interface ClassNameFilter {
        public boolean accept(String var1);
    }
}

