/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.os.ConditionVariable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.internal.events.client.TestRunEventService;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.FailureInfo;
import androidx.test.services.events.ParcelableConverter;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.TestEventException;
import androidx.test.services.events.run.TestAssumptionFailureEvent;
import androidx.test.services.events.run.TestFailureEvent;
import androidx.test.services.events.run.TestFinishedEvent;
import androidx.test.services.events.run.TestIgnoredEvent;
import androidx.test.services.events.run.TestRunFinishedEvent;
import androidx.test.services.events.run.TestRunStartedEvent;
import androidx.test.services.events.run.TestStartedEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class OrchestratedInstrumentationListener
extends RunListener {
    private static final String TAG = "OrchestrationListener";
    private final TestRunEventService notificationService;
    private final ConditionVariable testFinishedCondition = new ConditionVariable();
    private final AtomicBoolean isTestFailed = new AtomicBoolean(false);
    private Description description = Description.EMPTY;

    public OrchestratedInstrumentationListener(@NonNull TestRunEventService notificationService) {
        Checks.checkNotNull((Object)notificationService, (Object)"notificationService cannot be null");
        this.notificationService = notificationService;
    }

    public void testRunStarted(Description description) {
        try {
            this.notificationService.send(new TestRunStartedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunStartedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testRunFinished(Result result) {
        List<FailureInfo> failures = Collections.emptyList();
        try {
            failures = ParcelableConverter.getFailuresFromList(result.getFailures());
        }
        catch (TestEventException e) {
            Log.w((String)TAG, (String)"Failure event doesn't contain a test case", (Throwable)e);
        }
        try {
            this.notificationService.send(new TestRunFinishedEvent(result.getRunCount(), result.getIgnoreCount(), result.getRunTime(), failures));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunFinishedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testStarted(Description description) {
        this.description = description;
        try {
            this.notificationService.send(new TestStartedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestStartedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testFinished(Description description) {
        try {
            this.notificationService.send(new TestFinishedEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestFinishedEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testFailure(Failure failure) {
        if (this.isTestFailed.compareAndSet(false, true)) {
            TestFailureEvent event;
            block5: {
                String string = failure.getException().getMessage();
                Log.d((String)TAG, (String)new StringBuilder(28 + String.valueOf(string).length()).append("Sending TestFailure event [").append(string).append("]").toString());
                try {
                    event = new TestFailureEvent(ParcelableConverter.getTestCaseFromDescription(failure.getDescription()), ParcelableConverter.getFailure(failure));
                }
                catch (TestEventException e) {
                    String string2 = String.valueOf(failure);
                    Log.d((String)TAG, (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Unable to determine test case from failure [").append(string2).append("]").toString(), (Throwable)e);
                    event = this.getTestFailureEventFromCachedDescription(failure);
                    if (event != null) break block5;
                    return;
                }
            }
            try {
                this.notificationService.send(event);
            }
            catch (TestEventException e) {
                throw new IllegalStateException("Unable to send TestFailureEvent, terminating", e);
            }
        }
    }

    @Nullable
    private TestFailureEvent getTestFailureEventFromCachedDescription(@NonNull Failure failure) {
        TestCaseInfo testCase;
        Checks.checkNotNull((Object)failure, (Object)"failure cannot be null");
        try {
            testCase = ParcelableConverter.getTestCaseFromDescription(this.description);
        }
        catch (TestEventException ex) {
            String string = String.valueOf(this.description);
            Log.e((String)TAG, (String)new StringBuilder(49 + String.valueOf(string).length()).append("Unable to determine test case from description [").append(string).append("]").toString(), (Throwable)ex);
            return null;
        }
        return new TestFailureEvent(testCase, new FailureInfo(failure.getMessage(), failure.getTestHeader(), failure.getTrace(), testCase));
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            this.notificationService.send(new TestAssumptionFailureEvent(ParcelableConverter.getTestCaseFromDescription(failure.getDescription()), ParcelableConverter.getFailure(failure)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestAssumptionFailureEvent to Orchestrator", (Throwable)e);
        }
    }

    public void testIgnored(Description description) {
        try {
            this.notificationService.send(new TestIgnoredEvent(ParcelableConverter.getTestCaseFromDescription(description)));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestIgnoredEvent to Orchestrator", (Throwable)e);
        }
    }

    public void reportProcessCrash(Throwable t, long timeoutMillis) {
        this.waitUntilTestFinished(timeoutMillis);
        if (!this.isTestFailed.get()) {
            Log.i((String)TAG, (String)"No test failure has been reported. Report the process crash.");
            this.reportProcessCrash(t);
        }
    }

    private void reportProcessCrash(Throwable t) {
        this.testFailure(new Failure(this.description, t));
        this.testFinished(this.description);
    }

    private void waitUntilTestFinished(long timeoutMillis) {
        if (!this.testFinishedCondition.block(timeoutMillis)) {
            Log.w((String)TAG, (String)"Timeout waiting for the test to finish");
        }
    }
}

