/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.app.Instrumentation;
import android.os.Bundle;
import android.util.Log;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import androidx.test.internal.util.Checks;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class TestExecutor {
    private static final String LOG_TAG = "TestExecutor";
    private final List<RunListener> listeners;
    private final Instrumentation instr;

    private TestExecutor(Builder builder) {
        this.listeners = (List)Checks.checkNotNull((Object)builder.listeners);
        this.instr = builder.instr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle execute(Request request) {
        ByteArrayOutputStream summaryStream;
        Bundle resultBundle = new Bundle();
        Result junitResults = new Result();
        try {
            JUnitCore testRunner = new JUnitCore();
            this.setUpListeners(testRunner);
            junitResults = testRunner.run(request);
            summaryStream = new ByteArrayOutputStream();
            PrintStream summaryWriter = new PrintStream(summaryStream);
            this.reportRunEnded(this.listeners, summaryWriter, resultBundle, junitResults);
            summaryWriter.close();
        }
        catch (Throwable t) {
            ByteArrayOutputStream summaryStream2;
            try {
                String msg = "Fatal exception when running tests";
                Log.e((String)LOG_TAG, (String)"Fatal exception when running tests", (Throwable)t);
                junitResults.getFailures().add(new Failure(Description.createSuiteDescription((String)"Fatal exception when running tests", (Annotation[])new Annotation[0]), t));
                summaryStream2 = new ByteArrayOutputStream();
                PrintStream summaryWriter = new PrintStream(summaryStream2);
                this.reportRunEnded(this.listeners, summaryWriter, resultBundle, junitResults);
                summaryWriter.close();
            }
            catch (Throwable throwable) {
                ByteArrayOutputStream summaryStream3 = new ByteArrayOutputStream();
                PrintStream summaryWriter = new PrintStream(summaryStream3);
                this.reportRunEnded(this.listeners, summaryWriter, resultBundle, junitResults);
                summaryWriter.close();
                resultBundle.putString("stream", String.format("\n%s", summaryStream3.toString()));
                throw throwable;
            }
            resultBundle.putString("stream", String.format("\n%s", summaryStream2.toString()));
        }
        resultBundle.putString("stream", String.format("\n%s", summaryStream.toString()));
        return resultBundle;
    }

    private void setUpListeners(JUnitCore testRunner) {
        for (RunListener listener : this.listeners) {
            String string = String.valueOf(listener.getClass().getName());
            Log.d((String)LOG_TAG, (String)(string.length() != 0 ? "Adding listener ".concat(string) : new String("Adding listener ")));
            testRunner.addListener(listener);
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).setInstrumentation(this.instr);
        }
    }

    private void reportRunEnded(List<RunListener> listeners, PrintStream summaryWriter, Bundle resultBundle, Result jUnitResults) {
        for (RunListener listener : listeners) {
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).instrumentationRunFinished(summaryWriter, resultBundle, jUnitResults);
        }
    }

    public static class Builder {
        private final List<RunListener> listeners = new ArrayList<RunListener>();
        private final Instrumentation instr;

        public Builder(Instrumentation instr) {
            this.instr = instr;
        }

        public Builder addRunListener(RunListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public TestExecutor build() {
            return new TestExecutor(this);
        }
    }
}

