/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.internal.events.client.JUnitValidator;
import androidx.test.internal.events.client.TestDiscoveryEventService;
import androidx.test.internal.events.client.TestEventClientException;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.ParcelableConverter;
import androidx.test.services.events.TestEventException;
import androidx.test.services.events.discovery.TestDiscoveryFinishedEvent;
import androidx.test.services.events.discovery.TestDiscoveryStartedEvent;
import androidx.test.services.events.discovery.TestFoundEvent;
import org.junit.runner.Description;

public final class TestDiscovery {
    private static final String TAG = "TestDiscovery";
    private final TestDiscoveryEventService testDiscoveryEventService;

    public TestDiscovery(@NonNull TestDiscoveryEventService testDiscoveryEventService) {
        this.testDiscoveryEventService = (TestDiscoveryEventService)Checks.checkNotNull((Object)testDiscoveryEventService, (Object)"testDiscoveryEventService can't be null");
    }

    public void addTests(@NonNull Description description) throws TestEventClientException {
        Checks.checkNotNull((Object)description, (Object)"description cannot be null");
        this.testDiscoveryEventService.send(new TestDiscoveryStartedEvent());
        this.addTest(description);
        this.testDiscoveryEventService.send(new TestDiscoveryFinishedEvent());
    }

    private void addTest(@NonNull Description description) {
        if (description.isEmpty()) {
            Log.d((String)TAG, (String)"addTest called with an empty test description");
            return;
        }
        if (description.isTest()) {
            if (!JUnitValidator.validateDescription(description)) {
                String string = description.getClassName();
                String string2 = description.getMethodName();
                Log.w((String)TAG, (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("JUnit reported ").append(string).append("#").append(string2).append("; discarding as bogus.").toString());
                return;
            }
            try {
                this.testDiscoveryEventService.send(new TestFoundEvent(ParcelableConverter.getTestCaseFromDescription(description)));
            }
            catch (TestEventException e) {
                Log.e((String)TAG, (String)"Failed to get test description", (Throwable)e);
            }
        } else {
            for (Description child : description.getChildren()) {
                this.addTest(child);
            }
        }
    }
}

