/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import androidx.test.internal.runner.AndroidRunnerBuilder;
import androidx.test.internal.runner.NonExecutingRunner;
import androidx.test.internal.runner.junit3.JUnit38ClassRunner;
import androidx.test.internal.runner.junit3.NonExecutingTestSuite;
import androidx.test.internal.util.AndroidRunnerBuilderUtil;
import androidx.test.internal.util.AndroidRunnerParams;
import androidx.test.internal.util.Checks;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class AndroidLogOnlyBuilder
extends RunnerBuilder {
    private final AndroidRunnerBuilder builder;
    private final AndroidRunnerParams runnerParams;
    private final boolean scanningPath;
    private int runnerCount = 0;

    AndroidLogOnlyBuilder(AndroidRunnerParams runnerParams, boolean scanningPath, List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        this.runnerParams = (AndroidRunnerParams)Checks.checkNotNull((Object)runnerParams, (Object)"runnerParams cannot be null!");
        this.scanningPath = scanningPath;
        this.builder = new AndroidRunnerBuilder(this, runnerParams, scanningPath, customRunnerBuilderClasses);
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        ++this.runnerCount;
        if (AndroidRunnerBuilderUtil.isJUnit3Test(testClass)) {
            if (this.scanningPath && !AndroidRunnerBuilderUtil.hasJUnit3TestMethod(testClass)) {
                return null;
            }
            return new JUnit38ClassRunner((Test)new NonExecutingTestSuite(testClass));
        }
        if (AndroidRunnerBuilderUtil.hasSuiteMethod(testClass)) {
            if (this.runnerParams.isIgnoreSuiteMethods()) {
                return null;
            }
            Test test = SuiteMethod.testFromSuiteMethod(testClass);
            if (!(test instanceof TestSuite)) {
                throw new IllegalArgumentException(String.valueOf(testClass.getName()).concat("#suite() did not return a TestSuite"));
            }
            return new JUnit38ClassRunner((Test)new NonExecutingTestSuite((TestSuite)test));
        }
        int oldRunnerCount = this.runnerCount;
        Runner runner = this.builder.runnerForClass(testClass);
        if (null == runner) {
            return null;
        }
        if (runner instanceof ErrorReportingRunner) {
            return runner;
        }
        if (this.runnerCount > oldRunnerCount) {
            return runner;
        }
        return new NonExecutingRunner(runner);
    }
}

