/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.app.Instrumentation;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.util.Log;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassPathScanner {
    private static final String TAG = "ClassPathScanner";
    private final Set<String> classPath = new HashSet<String>();

    public ClassPathScanner(String ... paths) {
        this(Arrays.asList(paths));
    }

    public ClassPathScanner(Collection<String> paths) {
        this.classPath.addAll(paths);
    }

    public static Collection<String> getDefaultClasspaths(Instrumentation instrumentation) {
        ArrayList<String> classPaths = new ArrayList<String>();
        classPaths.add(instrumentation.getContext().getPackageCodePath());
        if (Build.VERSION.SDK_INT <= 20) {
            ApplicationInfo applicationInfo;
            Pattern extractedSecondaryName = Pattern.compile(".*\\.classes\\d+\\.zip");
            try {
                applicationInfo = instrumentation.getTargetContext().getApplicationInfo();
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Failed to retrieve ApplicationInfo, no additional .dex files add for app under test", (Throwable)re);
                return Collections.emptyList();
            }
            File root = new File(applicationInfo.dataDir);
            ArrayDeque<File> directoriesToScan = new ArrayDeque<File>();
            directoriesToScan.add(root);
            while (!directoriesToScan.isEmpty()) {
                File directory = (File)directoriesToScan.pop();
                for (File element : directory.listFiles()) {
                    if (element.isDirectory()) {
                        directoriesToScan.add(element);
                        continue;
                    }
                    if (!element.isFile() || !extractedSecondaryName.matcher(element.getName()).matches()) continue;
                    classPaths.add(element.getPath());
                }
            }
        }
        return classPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntriesFromPath(Set<String> entryNames, String path, ClassNameFilter filter) throws IOException {
        try (DexFile dexFile = null;){
            try {
                dexFile = new DexFile(path);
            }
            catch (IOException ioe) {
                if (path.endsWith(".zip")) {
                    dexFile = DexFile.loadDex((String)path, (String)String.valueOf(path.substring(0, path.length() - 3)).concat("dex"), (int)0);
                }
                throw ioe;
            }
            Enumeration classNames = dexFile.entries();
            while (classNames.hasMoreElements()) {
                String className = (String)classNames.nextElement();
                if (!filter.accept(className)) continue;
                entryNames.add(className);
            }
        }
    }

    public Set<String> getClassPathEntries(ClassNameFilter filter) throws IOException {
        LinkedHashSet<String> entryNames = new LinkedHashSet<String>();
        for (String path : this.classPath) {
            this.addEntriesFromPath(entryNames, path, filter);
        }
        return entryNames;
    }

    static class ExcludeClassNamesFilter
    implements ClassNameFilter {
        private final Set<String> excludedClassNames;

        public ExcludeClassNamesFilter(Set<String> excludedClassNames) {
            this.excludedClassNames = excludedClassNames;
        }

        @Override
        public boolean accept(String className) {
            return !this.excludedClassNames.contains(className);
        }
    }

    public static class ExcludePackageNameFilter
    implements ClassNameFilter {
        private final String pkgName;

        ExcludePackageNameFilter(String pkgName) {
            this.pkgName = !pkgName.endsWith(".") ? String.format("%s.", pkgName) : pkgName;
        }

        @Override
        public boolean accept(String pathName) {
            return !pathName.startsWith(this.pkgName);
        }
    }

    public static class InclusivePackageNamesFilter
    implements ClassNameFilter {
        private final Collection<String> pkgNames;

        InclusivePackageNamesFilter(Collection<String> pkgNames) {
            this.pkgNames = new ArrayList<String>(pkgNames.size());
            for (String packageName : pkgNames) {
                if (!packageName.endsWith(".")) {
                    this.pkgNames.add(String.format("%s.", packageName));
                    continue;
                }
                this.pkgNames.add(packageName);
            }
        }

        @Override
        public boolean accept(String pathName) {
            for (String packageName : this.pkgNames) {
                if (!pathName.startsWith(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ExternalClassNameFilter
    implements ClassNameFilter {
        @Override
        public boolean accept(String pathName) {
            return !pathName.contains("$");
        }
    }

    public static class ChainedClassNameFilter
    implements ClassNameFilter {
        private final List<ClassNameFilter> filters = new ArrayList<ClassNameFilter>();

        public void add(ClassNameFilter filter) {
            this.filters.add(filter);
        }

        public void addAll(ClassNameFilter ... filters) {
            this.filters.addAll(Arrays.asList(filters));
        }

        @Override
        public boolean accept(String className) {
            for (ClassNameFilter filter : this.filters) {
                if (filter.accept(className)) continue;
                return false;
            }
            return true;
        }
    }

    public static class AcceptAllFilter
    implements ClassNameFilter {
        @Override
        public boolean accept(String className) {
            return true;
        }
    }

    public static interface ClassNameFilter {
        public boolean accept(String var1);
    }
}

