/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.internal.events.client.TestEventClientArgs-IA;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.events.client.TestEventServiceConnection;

public final class TestEventClientArgs {
    public final boolean isOrchestrated;
    public final boolean isPrimaryInstrProcess;
    public final boolean isTestDiscoveryRequested;
    public final boolean isTestRunEventsRequested;
    public final int orchestratorVersion;
    @Nullable
    public final String testDiscoveryService;
    @Nullable
    public final String testRunEventService;
    @Nullable
    public final ConnectionFactory connectionFactory;
    public final boolean testPlatformMigration;

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    private TestEventClientArgs(boolean isOrchestrated, int orchestratorVersion, @NonNull Builder builder) {
        this.isOrchestrated = isOrchestrated;
        this.isPrimaryInstrProcess = builder.isPrimaryInstProcess;
        this.isTestDiscoveryRequested = builder.testDiscoveryRequested;
        this.isTestRunEventsRequested = builder.testRunEventsRequested;
        this.testDiscoveryService = builder.testDiscoveryService;
        this.testRunEventService = builder.testRunEventService;
        this.connectionFactory = builder.connectionFactory;
        this.orchestratorVersion = orchestratorVersion;
        this.testPlatformMigration = builder.testPlatformMigration;
    }

    /* synthetic */ TestEventClientArgs(boolean bl, int n, Builder builder, TestEventClientArgs-IA testEventClientArgs-IA) {
        this(bl, n, builder);
    }

    public static interface ConnectionFactory {
        @NonNull
        public TestEventServiceConnection create(@NonNull TestEventClientConnectListener var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private static final String TAG = "TestEventClient";
        boolean isPrimaryInstProcess = true;
        boolean testDiscoveryRequested = false;
        boolean testRunEventsRequested = false;
        boolean testPlatformMigration = false;
        @Nullable
        private ConnectionFactory connectionFactory;
        @Nullable
        private String orchestratorService;
        @Nullable
        private String testDiscoveryService;
        @Nullable
        private String testRunEventService;

        @NonNull
        public Builder setConnectionFactory(@Nullable ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        @NonNull
        public Builder setOrchestratorService(@Nullable String orchestratorService) {
            this.orchestratorService = orchestratorService;
            return this;
        }

        @NonNull
        public Builder setPrimaryInstProcess(boolean isPrimaryInstProcess) {
            this.isPrimaryInstProcess = isPrimaryInstProcess;
            return this;
        }

        @NonNull
        public Builder setTestDiscoveryRequested(boolean discoveryRequested) {
            this.testDiscoveryRequested = discoveryRequested;
            return this;
        }

        @NonNull
        public Builder setTestDiscoveryService(@Nullable String testDiscoveryService) {
            this.testDiscoveryService = testDiscoveryService;
            return this;
        }

        @NonNull
        public Builder setTestPlatformMigration(boolean testPlatformMigration) {
            this.testPlatformMigration = testPlatformMigration;
            return this;
        }

        @NonNull
        public Builder setTestRunEventService(@Nullable String testRunEventService) {
            this.testRunEventService = testRunEventService;
            return this;
        }

        @NonNull
        public Builder setTestRunEventsRequested(boolean runEventsRequested) {
            this.testRunEventsRequested = runEventsRequested;
            return this;
        }

        @NonNull
        public TestEventClientArgs build() {
            int version = 0;
            if (this.testDiscoveryService != null && !this.testDiscoveryService.isEmpty()) {
                version = 2;
                this.testDiscoveryRequested = true;
                this.testRunEventsRequested = false;
            } else if (this.testRunEventService != null && !this.testRunEventService.isEmpty()) {
                version = 2;
                this.testRunEventsRequested = true;
                this.testDiscoveryRequested = false;
            } else if (this.orchestratorService != null) {
                String string;
                if (this.connectionFactory == null) {
                    string = this.orchestratorService;
                    Log.w((String)TAG, (String)("Orchestrator service [" + string + "] argument given, but no connectionFactory was provided for the v1 service"));
                } else if (this.testDiscoveryRequested || this.testRunEventsRequested) {
                    version = 1;
                } else {
                    string = this.orchestratorService;
                    Log.w((String)TAG, (String)("Orchestrator service [" + string + "] argument given, but neither test discovery nor run event services was requested"));
                }
            } else {
                Log.v((String)TAG, (String)"No service name argument was given (testDiscoveryService, testRunEventService or orchestratorService)");
                this.testDiscoveryRequested = false;
                this.testRunEventsRequested = false;
            }
            if (this.testDiscoveryRequested && this.testRunEventsRequested) {
                Log.w((String)TAG, (String)"Can't use both the test discovery and run event services simultaneously");
                this.testRunEventsRequested = false;
            }
            if (version > 0) {
                int n = version;
                Log.v((String)TAG, (String)("Connecting to Orchestrator v" + n));
            }
            return new TestEventClientArgs(version > 0, version, this, null);
        }
    }
}

