/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.test.internal.events.client.JUnitDescriptionParser;
import androidx.test.internal.events.client.TestPlatformEventService;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.ErrorInfo;
import androidx.test.services.events.ParcelableConverter;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.TestEventException;
import androidx.test.services.events.TestRunInfo;
import androidx.test.services.events.TestStatus;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.platform.TestCaseErrorEvent;
import androidx.test.services.events.platform.TestCaseFinishedEvent;
import androidx.test.services.events.platform.TestCaseStartedEvent;
import androidx.test.services.events.platform.TestPlatformEvent;
import androidx.test.services.events.platform.TestRunErrorEvent;
import androidx.test.services.events.platform.TestRunFinishedEvent;
import androidx.test.services.events.platform.TestRunStartedEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public final class TestPlatformListener
extends RunListener {
    private static final String TAG = "TestPlatformListener";
    private static final String INIT_ERROR = "initializationError";
    private final TestPlatformEventService notificationService;
    private Map<Description, TestStatus.Status> testCaseToStatus;
    private Set<Description> foundTestCases;
    private Set<Description> finishedTestCases;
    private Set<Description> startedTestCases;
    private Description testRunDescription = Description.EMPTY;
    private final AtomicReference<Description> currentTestCase = new AtomicReference<Description>(Description.EMPTY);
    private TestRunInfo memoizedTestRun;
    private final AtomicBoolean processCrashed = new AtomicBoolean(false);
    private final AtomicReference<Result> ongoingResult = new AtomicReference<Result>(new Result());
    private final AtomicReference<RunListener> ongoingResultListener = new AtomicReference<RunListener>(this.ongoingResult.get().createListener());

    private static TestCaseInfo convertToTestCase(Description testCase) throws TestEventException {
        return ParcelableConverter.getTestCaseFromDescription(testCase);
    }

    private static TestRunInfo convertToTestRun(Description testRun) throws TestEventException {
        ArrayList<TestCaseInfo> testCases = new ArrayList<TestCaseInfo>();
        for (Description testCase : JUnitDescriptionParser.getAllTestCaseDescriptions(testRun)) {
            testCases.add(TestPlatformListener.convertToTestCase(testCase));
        }
        return new TestRunInfo(testRun.getDisplayName(), testCases);
    }

    private TestPlatformEvent createErrorEvent(Failure failure, TimeStamp timeStamp) throws TestEventException {
        Description descriptionToUse = failure.getDescription();
        if (!descriptionToUse.isTest() || TestPlatformListener.isInitError(descriptionToUse)) {
            descriptionToUse = this.testRunDescription;
        }
        ErrorInfo errorInfo = ErrorInfo.createFromFailure(failure);
        if (!descriptionToUse.equals((Object)this.testRunDescription)) {
            try {
                return new TestCaseErrorEvent(TestPlatformListener.convertToTestCase(descriptionToUse), errorInfo, timeStamp);
            }
            catch (TestEventException e) {
                Log.e((String)TAG, (String)"Unable to create TestCaseErrorEvent", (Throwable)e);
            }
        }
        if (this.memoizedTestRun == null) {
            Log.d((String)TAG, (String)"No test run info. Reporting an error before test run has ever started.");
            this.memoizedTestRun = TestPlatformListener.convertToTestRun(Description.EMPTY);
        }
        return new TestRunErrorEvent(this.memoizedTestRun, errorInfo, timeStamp);
    }

    public TestPlatformListener(@NonNull TestPlatformEventService notificationService) {
        this.initListener();
        this.notificationService = (TestPlatformEventService)Checks.checkNotNull((Object)notificationService, (Object)"notificationService cannot be null");
    }

    private void initListener() {
        this.finishedTestCases = new HashSet<Description>();
        this.foundTestCases = new HashSet<Description>();
        this.startedTestCases = new HashSet<Description>();
        this.testCaseToStatus = new HashMap<Description, TestStatus.Status>();
        this.currentTestCase.set(Description.EMPTY);
        this.testRunDescription = Description.EMPTY;
        this.memoizedTestRun = null;
        this.processCrashed.set(false);
        this.ongoingResult.set(new Result());
        this.ongoingResultListener.set(this.ongoingResult.get().createListener());
    }

    private void setRunDescription(Description description) {
        this.testRunDescription = description;
        while (this.testRunDescription.getDisplayName().equals("null") && this.testRunDescription.getChildren().size() == 1) {
            this.testRunDescription = (Description)this.testRunDescription.getChildren().get(0);
        }
    }

    public void testAssumptionFailure(Failure failure) {
        this.ongoingResultListener.get().testAssumptionFailure(failure);
        if (failure.getDescription().isTest()) {
            this.testCaseToStatus.put(failure.getDescription(), TestStatus.Status.SKIPPED);
        }
        try {
            TestPlatformEvent event = this.createErrorEvent(failure, TimeStamp.now());
            this.notificationService.send(event);
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestAssumptionFailureEvent to Test Platform", (Throwable)e);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        Description description = failure.getDescription();
        this.ongoingResultListener.get().testFailure(failure);
        if (description.isTest() && !TestPlatformListener.isInitError(description)) {
            this.testCaseToStatus.put(description, TestStatus.Status.FAILED);
        }
        try {
            TestPlatformEvent event = this.createErrorEvent(failure, TimeStamp.now());
            this.notificationService.send(event);
        }
        catch (TestEventException e) {
            throw new IllegalStateException("Unable to send error event", e);
        }
    }

    public void testFinished(Description description) throws Exception {
        this.testFinishedInternal(description, TimeStamp.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFinishedInternal(Description description, TimeStamp timeStamp) throws Exception {
        if (TestPlatformListener.isInitError(description)) {
            return;
        }
        this.ongoingResultListener.get().testFinished(description);
        this.finishedTestCases.add(description);
        try {
            this.notificationService.send(new TestCaseFinishedEvent(TestPlatformListener.convertToTestCase(description), new TestStatus(this.testCaseToStatus.get(description)), timeStamp));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestFinishedEvent to Test Platform", (Throwable)e);
        }
        finally {
            this.currentTestCase.set(Description.EMPTY);
        }
    }

    public void testIgnored(Description description) throws Exception {
        this.ongoingResultListener.get().testIgnored(description);
        String string = description.getMethodName();
        String string2 = description.getClassName();
        String string3 = description.getDisplayName();
        Log.i((String)TAG, (String)("TestIgnoredEvent(" + string3 + "): " + string2 + "#" + string));
        this.testCaseToStatus.put(description, TestStatus.Status.IGNORED);
        this.testFinishedInternal(description, TimeStamp.now());
    }

    public void testRunFinished(Result result) throws Exception {
        this.ongoingResultListener.get().testRunFinished(result);
        TestStatus.Status status = result.wasSuccessful() ? TestStatus.Status.PASSED : TestStatus.Status.FAILED;
        TestStatus.Status status2 = status = this.processCrashed.get() ? TestStatus.Status.FAILED : status;
        if (this.foundTestCases.size() > this.finishedTestCases.size()) {
            status = status.equals((Object)TestStatus.Status.PASSED) ? TestStatus.Status.ABORTED : status;
            for (Description test : JUnitDescriptionParser.getAllTestCaseDescriptions(this.testRunDescription)) {
                if (this.finishedTestCases.contains(test)) continue;
                if (this.startedTestCases.contains(test)) {
                    this.testCaseToStatus.put(test, TestStatus.Status.ABORTED);
                } else {
                    this.testCaseToStatus.put(test, TestStatus.Status.CANCELLED);
                }
                this.testFinishedInternal(test, TimeStamp.now());
            }
        }
        try {
            this.notificationService.send(new TestRunFinishedEvent(this.memoizedTestRun, new TestStatus(status), TimeStamp.now()));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunFinishedEvent to Test Platform", (Throwable)e);
        }
    }

    public void testRunStarted(Description description) throws Exception {
        this.initListener();
        this.ongoingResultListener.get().testRunStarted(description);
        this.setRunDescription(description);
        List<Description> testCases = JUnitDescriptionParser.getAllTestCaseDescriptions(this.testRunDescription);
        for (Description testCase : testCases) {
            this.foundTestCases.add(testCase);
            this.testCaseToStatus.put(testCase, TestStatus.Status.PASSED);
        }
        try {
            this.memoizedTestRun = TestPlatformListener.convertToTestRun(this.testRunDescription);
            this.notificationService.send(new TestRunStartedEvent(this.memoizedTestRun, TimeStamp.now()));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestRunStartedEvent to Test Platform", (Throwable)e);
        }
    }

    public void testStarted(Description description) throws Exception {
        if (TestPlatformListener.isInitError(description)) {
            return;
        }
        this.ongoingResultListener.get().testStarted(description);
        this.startedTestCases.add(description);
        this.currentTestCase.set(description);
        try {
            this.notificationService.send(new TestCaseStartedEvent(TestPlatformListener.convertToTestCase(description), TimeStamp.now()));
        }
        catch (TestEventException e) {
            Log.e((String)TAG, (String)"Unable to send TestStartedEvent to Test Platform", (Throwable)e);
        }
    }

    private static boolean isInitError(Description description) {
        return description.getMethodName() != null && description.getMethodName().equals(INIT_ERROR);
    }

    public boolean reportProcessCrash(Throwable t) {
        this.processCrashed.set(true);
        boolean isTestCase = true;
        Description failingDescription = this.currentTestCase.get();
        if (failingDescription.equals((Object)Description.EMPTY)) {
            isTestCase = false;
            failingDescription = this.testRunDescription;
        }
        try {
            Log.e((String)TAG, (String)"reporting crash as testfailure", (Throwable)t);
            this.testFailure(new Failure(failingDescription, t));
            if (isTestCase) {
                this.testFinished(failingDescription);
            }
            this.testRunFinished(this.ongoingResult.get());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"An exception was encountered while reporting the process crash", (Throwable)e);
            return false;
        }
        return true;
    }
}

