/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.screenshot;

import android.app.Activity;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.InstrumentationRegistry;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.internal.util.Checks;
import androidx.test.runner.screenshot.ScreenCapture;
import androidx.test.runner.screenshot.ScreenCaptureProcessor;
import androidx.test.runner.screenshot.TakeScreenshotCallable;
import androidx.test.runner.screenshot.UiAutomationWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

@ExperimentalTestApi
public final class Screenshot {
    private static int androidRuntimeVersion = Build.VERSION.SDK_INT;
    private static UiAutomationWrapper uiWrapper = new UiAutomationWrapper();
    private static Set<ScreenCaptureProcessor> screenCaptureProcessorSet = new HashSet<ScreenCaptureProcessor>();
    private static TakeScreenshotCallable.Factory takeScreenshotCallableFactory = new TakeScreenshotCallable.Factory();

    private static Bitmap captureUiAutomatorImpl() {
        return uiWrapper.takeScreenshot();
    }

    private static Bitmap captureViewBasedImpl(@NonNull View view) throws InterruptedException, ExecutionException {
        Checks.checkNotNull((Object)view, (Object)"Taking view based screenshot requires using either takeScreenshot(view) or takeScreenshot(activity) where view and activity are non-null.");
        Callable<Bitmap> takeScreenshotCallable = takeScreenshotCallableFactory.create(view);
        FutureTask<Bitmap> task = new FutureTask<Bitmap>(takeScreenshotCallable);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            task.run();
        } else {
            InstrumentationRegistry.getInstrumentation().runOnMainSync(task);
        }
        return task.get();
    }

    public static ScreenCapture capture() throws ScreenShotException {
        try {
            return Screenshot.captureImpl(null);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ScreenShotException(e);
        }
        catch (InterruptedException e) {
            throw new ScreenShotException(e);
        }
        catch (ExecutionException e) {
            throw new ScreenShotException(e);
        }
    }

    public static ScreenCapture capture(@NonNull Activity activity) throws ScreenShotException {
        Checks.checkNotNull((Object)activity, (Object)"activity cannot be null!");
        try {
            return Screenshot.captureImpl(activity.getWindow().getDecorView().getRootView());
        }
        catch (IOException e) {
            throw new ScreenShotException(e);
        }
        catch (InterruptedException e) {
            throw new ScreenShotException(e);
        }
        catch (ExecutionException e) {
            throw new ScreenShotException(e);
        }
    }

    public static ScreenCapture capture(@NonNull View view) throws ScreenShotException {
        Checks.checkNotNull((Object)view, (Object)"view cannot be null!");
        try {
            return Screenshot.captureImpl(view);
        }
        catch (IOException e) {
            throw new ScreenShotException(e);
        }
        catch (InterruptedException e) {
            throw new ScreenShotException(e);
        }
        catch (ExecutionException e) {
            throw new ScreenShotException(e);
        }
    }

    private static ScreenCapture captureImpl(View targetView) throws IOException, InterruptedException, ExecutionException {
        Bitmap bitmap = targetView == null && androidRuntimeVersion >= 18 ? Screenshot.captureUiAutomatorImpl() : Screenshot.captureViewBasedImpl(targetView);
        return new ScreenCapture(bitmap).setProcessors(screenCaptureProcessorSet);
    }

    public static void addScreenCaptureProcessors(Set<ScreenCaptureProcessor> screenCaptureProcessors) {
        screenCaptureProcessorSet.addAll(screenCaptureProcessors);
    }

    @VisibleForTesting
    static void setAndroidRuntimeVersion(int sdkInt) {
        androidRuntimeVersion = sdkInt;
    }

    public static void setScreenshotProcessors(Set<ScreenCaptureProcessor> screenCaptureProcessors) {
        screenCaptureProcessorSet = screenCaptureProcessors;
    }

    @VisibleForTesting
    static void setTakeScreenshotCallableFactory(TakeScreenshotCallable.Factory factory) {
        takeScreenshotCallableFactory = factory;
    }

    @VisibleForTesting
    static void setUiAutomationWrapper(UiAutomationWrapper wrapper) {
        uiWrapper = wrapper;
    }

    @ExperimentalTestApi
    public static final class ScreenShotException
    extends RuntimeException {
        ScreenShotException(Throwable cause) {
            super(cause);
        }
    }
}

