/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.platform;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.TestCaseInfo;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.platform.TestPlatformEvent;

public final class TestCaseStartedEvent
extends TestPlatformEvent {
    @NonNull
    public final TestCaseInfo testCase;
    @NonNull
    public final TimeStamp timeStamp;

    @Override
    public TestPlatformEvent.EventType instanceType() {
        return TestPlatformEvent.EventType.TEST_CASE_STARTED;
    }

    public TestCaseStartedEvent(Parcel source) {
        this.testCase = new TestCaseInfo(source);
        this.timeStamp = new TimeStamp(source);
    }

    public TestCaseStartedEvent(@NonNull TestCaseInfo testCase, @NonNull TimeStamp timeStamp) {
        this.testCase = (TestCaseInfo)Checks.checkNotNull((Object)testCase, (Object)"testCase cannot be null");
        this.timeStamp = (TimeStamp)Checks.checkNotNull((Object)timeStamp, (Object)"timeStamp cannot be null");
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        this.testCase.writeToParcel(parcel, i);
        this.timeStamp.writeToParcel(parcel, i);
    }
}

