/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.app.Instrumentation;
import android.os.Bundle;
import android.util.Log;
import androidx.test.internal.runner.TestExecutor$$ExternalSyntheticBackport0;
import androidx.test.internal.runner.TestExecutor-IA;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import androidx.test.internal.util.Checks;
import androidx.tracing.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public final class TestExecutor {
    private static final String LOG_TAG = "TestExecutor";
    private final List<RunListener> listeners;
    private final Instrumentation instr;

    public Bundle execute(Request request) throws UnsupportedEncodingException {
        Trace.beginSection((String)"execute tests");
        try {
            Bundle bundle = this.execute(new JUnitCore(), request);
            return bundle;
        }
        finally {
            Trace.endSection();
        }
    }

    Bundle execute(JUnitCore junitRunner, Request request) throws UnsupportedEncodingException {
        Bundle resultBundle = new Bundle();
        this.setUpListeners(junitRunner);
        Result junitResults = junitRunner.run(request);
        ByteArrayOutputStream summaryStream = new ByteArrayOutputStream();
        PrintStream summaryWriter = new PrintStream(summaryStream);
        try {
            this.reportRunEnded(this.listeners, summaryWriter, resultBundle, junitResults);
            summaryWriter.close();
        }
        catch (Throwable throwable) {
            try {
                summaryWriter.close();
            }
            catch (Throwable throwable2) {
                TestExecutor$$ExternalSyntheticBackport0.m(throwable, throwable2);
            }
            throw throwable;
        }
        resultBundle.putString("stream", String.format("\n%s", summaryStream.toString("UTF_8")));
        return resultBundle;
    }

    private TestExecutor(Builder builder) {
        this.listeners = (List)Checks.checkNotNull((Object)builder.listeners);
        this.instr = builder.instr;
    }

    /* synthetic */ TestExecutor(Builder builder, TestExecutor-IA testExecutor-IA) {
        this(builder);
    }

    private void reportRunEnded(List<RunListener> listeners, PrintStream summaryWriter, Bundle resultBundle, Result jUnitResults) {
        for (RunListener listener : listeners) {
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).instrumentationRunFinished(summaryWriter, resultBundle, jUnitResults);
        }
    }

    private void setUpListeners(JUnitCore testRunner) {
        for (RunListener listener : this.listeners) {
            String string = listener.getClass().getName();
            Log.d((String)LOG_TAG, (String)("Adding listener " + string));
            testRunner.addListener(listener);
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).setInstrumentation(this.instr);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private final List<RunListener> listeners = new ArrayList<RunListener>();
        private final Instrumentation instr;

        public Builder addRunListener(RunListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public TestExecutor build() {
            return new TestExecutor(this, null);
        }

        public Builder(Instrumentation instr) {
            this.instr = instr;
        }
    }
}

