/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit3;

import android.app.Instrumentation;
import android.os.Bundle;
import android.test.AndroidTestCase;
import android.test.InstrumentationTestCase;
import androidx.test.internal.runner.junit3.DelegatingTestResult;
import java.util.concurrent.TimeoutException;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

class AndroidTestResult
extends DelegatingTestResult {
    private final Instrumentation instr;
    private final Bundle bundle;
    private long timeout;

    AndroidTestResult(Bundle bundle, Instrumentation instr, TestResult result) {
        super(result);
        this.bundle = bundle;
        this.instr = instr;
    }

    protected void run(TestCase test) {
        if (test instanceof AndroidTestCase) {
            ((AndroidTestCase)test).setContext(this.instr.getTargetContext());
        }
        if (test instanceof InstrumentationTestCase) {
            ((InstrumentationTestCase)test).injectInstrumentation(this.instr);
        }
        super.run(test);
    }

    @Override
    public void runProtected(Test test, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e) {
            super.addFailure(test, e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (InterruptedException e) {
            super.addError(test, new TimeoutException(String.format("Test timed out after %d milliseconds", this.timeout)));
        }
        catch (Throwable e) {
            super.addError(test, e);
        }
    }

    void setCurrentTimeout(long timeout) {
        this.timeout = timeout;
    }
}

