/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.filters;

import androidx.test.filters.CustomFilter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public abstract class AbstractFilter
extends Filter {
    protected List<Annotation> getClassAnnotations(Description description) {
        ArrayList<Annotation> testAnnotations = new ArrayList<Annotation>();
        for (Annotation c : description.getTestClass().getAnnotations()) {
            CustomFilter customFilterAnnotation = c.annotationType().getAnnotation(CustomFilter.class);
            if (customFilterAnnotation == null || !customFilterAnnotation.filterClass().isInstance((Object)this)) continue;
            testAnnotations.add(c);
        }
        return testAnnotations;
    }

    protected List<Annotation> getMethodAnnotations(Description description) {
        ArrayList<Annotation> testAnnotations = new ArrayList<Annotation>();
        for (Annotation annotation : description.getAnnotations()) {
            CustomFilter customFilterAnnotation = annotation.annotationType().getAnnotation(CustomFilter.class);
            if (customFilterAnnotation == null || !customFilterAnnotation.filterClass().isInstance((Object)this)) continue;
            testAnnotations.add(annotation);
        }
        return testAnnotations;
    }

    protected abstract boolean evaluateTest(Description var1);

    public boolean shouldRun(Description description) {
        if (description.isTest()) {
            return this.evaluateTest(description);
        }
        for (Description each : description.getChildren()) {
            if (!this.shouldRun(each)) continue;
            return true;
        }
        return false;
    }
}

