/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.events.client;

import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.events.client.TestEventClientException;
import androidx.test.internal.events.client.TestEventServiceConnectionBase;
import androidx.test.internal.events.client.TestRunEventService;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.run.ITestRunEvent;
import androidx.test.services.events.run.TestRunEvent;

public class TestRunEventServiceConnection
extends TestEventServiceConnectionBase<ITestRunEvent>
implements TestRunEventService {
    TestRunEventServiceConnection(@NonNull String serviceName, @NonNull TestEventClientConnectListener listener) {
        super(serviceName, ITestRunEvent.Stub::asInterface, listener);
    }

    @Override
    public void send(@NonNull TestRunEvent testRunEvent) throws TestEventClientException {
        Checks.checkNotNull((Object)testRunEvent, (Object)"testRunEvent cannot be null");
        if (this.service == null) {
            throw new TestEventClientException("Can't send test run event, service not connected");
        }
        try {
            ((ITestRunEvent)this.service).send(testRunEvent);
        }
        catch (RemoteException e) {
            throw new TestEventClientException("Failed to send test run event", e);
        }
    }
}

