/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import android.app.UiAutomation;
import android.content.Context;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.test.internal.platform.content.PermissionGranter;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=28)
public class UiAutomationPermissionGranter
implements PermissionGranter {
    private static final String TAG = "UiAutomationPermGranter";
    private final Set<String> permissionsToGrant = new LinkedHashSet<String>();

    public void addPermissions(String ... permissions) {
        Collections.addAll(this.permissionsToGrant, permissions);
    }

    public void requestPermissions() {
        Context targetContext = InstrumentationRegistry.getInstrumentation().getTargetContext();
        UiAutomation uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        for (String permission : this.permissionsToGrant) {
            if (!this.isPermissionGranted(targetContext, permission)) {
                Log.i((String)TAG, (String)String.format("Attempting to grant %s to %s", permission, targetContext.getPackageName()));
                uiAutomation.grantRuntimePermission(targetContext.getPackageName(), permission);
                continue;
            }
            Log.i((String)TAG, (String)("Permission: " + permission + " is already granted!"));
        }
    }

    private boolean isPermissionGranted(Context targetContext, String permission) {
        return targetContext.checkCallingOrSelfPermission(permission) == 0;
    }
}

